/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.CouponInfoActivity;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.views.adapters.ActiveCouponAdapter;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class ActiveCouponsActivity
extends Activity
implements View.OnClickListener {
    private ImageView mIvBack;
    private RecyclerView mRecyclerCoupons;
    private ActiveCouponAdapter mAdapterCoupons;
    private CouponList mCouponList = new CouponList();
    private TextView mTvEmptyCoupons;
    private boolean mCouponsPressed = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_active_coupons);
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_coupons_close);
        this.mTvEmptyCoupons = (TextView)this.findViewById(R.id.tv_no_coupons);
        this.mRecyclerCoupons = (RecyclerView)this.findViewById(R.id.rv_active_coupons);
        this.initViews();
    }

    public void onStart() {
        super.onStart();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void onStop() {
        super.onStop();
        EventBus.getDefault().unregister((Object)this);
    }

    @Subscribe
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getCouponsChanged() != null) {
            Handler mUIHandler = new Handler(Looper.getMainLooper());
            mUIHandler.post(this::filterItems);
        }
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "ActiveCouponsScreen");
        this.mCouponsPressed = false;
        this.filterItems();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_coupons_close) {
            this.onBackPressed();
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
    }

    private void filterItems() {
        CouponList cpnlist = new CouponList();
        for (Coupon cpn : WarplyManagerHelper.getCouponList()) {
            if (cpn.getStatus() != 1) continue;
            SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
            Date newDate = new Date();
            try {
                newDate = simpleDateFormat.parse(cpn.getExpiration());
            }
            catch (ParseException e) {
                e.printStackTrace();
            }
            cpn.setExpirationDate(newDate);
            cpnlist.add(cpn);
        }
        Collections.sort(cpnlist, (coupon1, coupon2) -> coupon1.getExpirationDate().compareTo(coupon2.getExpirationDate()));
        this.mCouponList.clear();
        this.mCouponList.addAll(cpnlist);
        if (this.mCouponList != null && this.mCouponList.size() > 0) {
            this.mRecyclerCoupons.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
            this.mAdapterCoupons = new ActiveCouponAdapter((Context)this, this.mCouponList);
            this.mRecyclerCoupons.setAdapter((RecyclerView.Adapter)this.mAdapterCoupons);
            this.mAdapterCoupons.getPositionClicks().doOnNext(coupon -> {
                if (!this.mCouponsPressed) {
                    this.mCouponsPressed = true;
                    WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Coupon".concat(":").concat(coupon.getName()));
                    Intent intent = new Intent((Context)this, CouponInfoActivity.class);
                    intent.putExtra("coupon", coupon.getCoupon());
                    intent.putExtra("isFromWallet", true);
                    this.startActivity(intent);
                }
            }).doOnError(error -> {}).subscribe();
        } else {
            this.mRecyclerCoupons.setVisibility(8);
            this.mTvEmptyCoupons.setVisibility(0);
        }
    }
}

