/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import java.util.ArrayList;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.CouponInfoActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.MergedActiveGifts;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.views.adapters.MergedActiveGiftsAdapter;

public class ActiveGiftsActivity
extends Activity
implements View.OnClickListener {
    private ImageView mIvBack;
    private ArrayList<MergedActiveGifts> mData = new ArrayList();
    private RecyclerView mRecyclerMergedActiveGifts;
    private MergedActiveGiftsAdapter mAdapterMergedActiveGifts;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_active_gifts);
        this.mergeDatasets(null, WarplyManagerHelper.getCouponList());
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_list_close);
        this.mRecyclerMergedActiveGifts = (RecyclerView)this.findViewById(R.id.rv_merged_active_gifts);
        this.initViews();
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "ActiveGiftsScreen");
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_list_close) {
            this.onBackPressed();
            return;
        }
    }

    private void initViews() {
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        if (this.mData != null && this.mData.size() > 0) {
            this.mRecyclerMergedActiveGifts.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
            this.mAdapterMergedActiveGifts = new MergedActiveGiftsAdapter((Context)this, this.mData);
            this.mRecyclerMergedActiveGifts.setAdapter((RecyclerView.Adapter)this.mAdapterMergedActiveGifts);
            this.mAdapterMergedActiveGifts.getPositionClicks().doOnNext(dataItem -> {
                if (dataItem.getDataType() == 1) {
                    if (!WarplyManagerHelper.noInternetDialog((Context)this, true)) {
                        WarplyManagerHelper.noInternetDialog(this);
                        return;
                    }
                    this.startActivity(WarpViewActivity.createIntentFromURL((Context)this, WarplyManagerHelper.constructCampaignUrl(dataItem.getCampaign())));
                } else if (dataItem.getDataType() == 2) {
                    Intent intent = new Intent((Context)this, CouponInfoActivity.class);
                    intent.putExtra("coupon", dataItem.getCoupon().getCoupon());
                    this.startActivity(intent);
                }
            }).doOnError(error -> {}).subscribe();
        }
    }

    private ArrayList<MergedActiveGifts> mergeDatasets(CampaignList campaignList, CouponList couponsList) {
        MergedActiveGifts data;
        if (campaignList != null && campaignList.size() > 0) {
            for (Campaign campaign : campaignList) {
                data = new MergedActiveGifts();
                data.setCampaign(campaign);
                data.setCoupon(null);
                data.setDataType(1);
                this.mData.add(data);
            }
        }
        if (couponsList.size() > 0) {
            for (Coupon coupon : couponsList) {
                data = new MergedActiveGifts();
                data.setCampaign(null);
                data.setCoupon(coupon);
                data.setDataType(2);
                this.mData.add(data);
            }
        }
        return this.mData;
    }
}

