/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.view.View;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.UnifiedCouponInfoActivity;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.MarketCouponAdapter;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class ActiveUnifiedCouponsActivity
extends Activity
implements View.OnClickListener {
    private ImageView mIvBack;
    private RecyclerView mRecyclerUnifiedCoupons;
    private MarketCouponAdapter mAdapterUnifiedCoupons;
    private TextView mTvEmptyUnifiedCoupons;
    private boolean mUnifiedPressed = false;
    private final CallbackReceiver<ArrayList<UnifiedCoupon>> mUnifiedCallback = new CallbackReceiver<ArrayList<UnifiedCoupon>>(){

        @Override
        public void onSuccess(ArrayList<UnifiedCoupon> result) {
            Handler mUIHandler = new Handler(Looper.getMainLooper());
            mUIHandler.post(() -> ActiveUnifiedCouponsActivity.this.filterItems());
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_active_unified_coupons);
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_coupons_close);
        this.mTvEmptyUnifiedCoupons = (TextView)this.findViewById(R.id.tv_no_unified_coupons);
        this.mRecyclerUnifiedCoupons = (RecyclerView)this.findViewById(R.id.rv_active_unified_coupons);
        this.initViews();
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "ActiveUnifiedCouponsScreen");
        this.mUnifiedPressed = false;
        this.filterItems();
    }

    public void onStart() {
        super.onStart();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        EventBus.getDefault().unregister((Object)this);
    }

    @Subscribe
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getRefreshUnifiedCouponsAdded() != null) {
            WarplyManager.getUnifiedCouponsDeals(this.mUnifiedCallback);
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_coupons_close) {
            this.onBackPressed();
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
    }

    private void filterItems() {
        if (WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() > 0) {
            ArrayList<UnifiedCoupon> unilist = new ArrayList<UnifiedCoupon>();
            for (UnifiedCoupon unicpn : WarplyManagerHelper.getMarketCouponsList()) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss");
                Date newDate = new Date();
                try {
                    newDate = simpleDateFormat.parse(unicpn.getCreated());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                unicpn.setExpirationDate(newDate);
                unilist.add(unicpn);
            }
            Collections.sort(unilist, (coupon1, coupon2) -> coupon2.getExpirationDate().compareTo(coupon1.getExpirationDate()));
            this.mRecyclerUnifiedCoupons.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
            this.mAdapterUnifiedCoupons = new MarketCouponAdapter((Context)this, unilist);
            this.mRecyclerUnifiedCoupons.setAdapter((RecyclerView.Adapter)this.mAdapterUnifiedCoupons);
            this.mAdapterUnifiedCoupons.getPositionClicks().doOnNext(coupon -> {
                if (!this.mUnifiedPressed) {
                    this.mUnifiedPressed = true;
                    WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "UnifiedCoupon".concat(":").concat(coupon.getBarcode()));
                    Intent intent = new Intent((Context)this, UnifiedCouponInfoActivity.class);
                    intent.putExtra("coupon", (Serializable)coupon);
                    this.startActivity(intent);
                }
            }).doOnError(error -> {}).subscribe();
        } else {
            this.mRecyclerUnifiedCoupons.setVisibility(8);
            this.mTvEmptyUnifiedCoupons.setVisibility(0);
        }
    }
}

