/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.app.ActivityManager;
import android.content.ComponentName;
import android.content.SharedPreferences;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageInfo;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.util.Log;
import java.util.List;

public abstract class ApplicationSessionActivity
extends Activity {
    private static final String TAG = "AppSessionActivity";
    private static final String KEY_APP_IN_BACKGROUND = "AppInBackground";
    private static final String KEY_APP_SESSION_ACTIVE = "AppSessionActive";
    private static final String KEY_MAIN_ACTIVITY_NAME = "MainActivityName";
    private SharedPreferences prefs;
    private static SessionStartedListener sessionStartedListener;
    private static SessionStoppedListener sessionStoppedListener;

    protected static void setOnSessionStartedListener(SessionStartedListener sessionStartedListener) {
        ApplicationSessionActivity.sessionStartedListener = sessionStartedListener;
    }

    protected static void setOnSessionStoppedListener(SessionStoppedListener sessionStoppedListener) {
        ApplicationSessionActivity.sessionStoppedListener = sessionStoppedListener;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.prefs = this.getSharedPreferences(TAG, 0);
        if (this.isCurrentActivityMainActivity(this)) {
            this.prefs.edit().putBoolean(KEY_APP_IN_BACKGROUND, true).commit();
        }
    }

    protected void onStart() {
        super.onStart();
        this.startSession();
    }

    protected void onStop() {
        super.onStop();
        if (ApplicationSessionActivity.isApplicationBroughtToBackground(this)) {
            this.prefs.edit().putBoolean(KEY_APP_IN_BACKGROUND, true).commit();
            this.endSession();
        }
    }

    protected void onDestroy() {
        super.onDestroy();
        if (this.isCurrentActivityMainActivity(this)) {
            this.endSession();
            sessionStartedListener = null;
            sessionStoppedListener = null;
        }
    }

    private void startSession() {
        boolean comingFromBackground = this.prefs.getBoolean(KEY_APP_IN_BACKGROUND, true);
        if (comingFromBackground) {
            boolean activeSession = this.prefs.getBoolean(KEY_APP_SESSION_ACTIVE, false);
            if (!activeSession) {
                if (sessionStartedListener != null) {
                    sessionStartedListener.onSessionStarted();
                }
            } else {
                Log.e((String)TAG, (String)"Error: Starting session, but a session is already active.");
            }
            this.prefs.edit().putBoolean(KEY_APP_SESSION_ACTIVE, true).putBoolean(KEY_APP_IN_BACKGROUND, false).commit();
        }
    }

    private void endSession() {
        boolean activeSession = this.prefs.getBoolean(KEY_APP_SESSION_ACTIVE, false);
        if (activeSession) {
            if (sessionStoppedListener != null) {
                sessionStoppedListener.onSessionStopped();
            }
        } else {
            Log.e((String)TAG, (String)"Error: Ending session, but no session is active.");
        }
        this.prefs.edit().putBoolean(KEY_APP_SESSION_ACTIVE, false).commit();
    }

    private static boolean isApplicationBroughtToBackground(Activity activity) {
        List tasks;
        ActivityManager activityManager = (ActivityManager)activity.getSystemService("activity");
        try {
            tasks = activityManager.getRunningTasks(1);
        }
        catch (SecurityException e) {
            Log.e((String)TAG, (String)"Missing required permission: \"android.permission.GET_TASKS\".", (Throwable)e);
            return false;
        }
        if (tasks != null && !tasks.isEmpty()) {
            ComponentName topActivity = ((ActivityManager.RunningTaskInfo)tasks.get((int)0)).topActivity;
            try {
                PackageInfo pi = activity.getPackageManager().getPackageInfo(activity.getPackageName(), 1);
                for (ActivityInfo activityInfo : pi.activities) {
                    if (!topActivity.getClassName().equals(activityInfo.name)) continue;
                    return false;
                }
            }
            catch (PackageManager.NameNotFoundException e) {
                Log.e((String)TAG, (String)("Package name not found: " + activity.getPackageName()));
                return false;
            }
        }
        return true;
    }

    private boolean isCurrentActivityMainActivity(Activity currentActivity) {
        String currentActivityName = currentActivity.getComponentName().getClassName();
        String mainActivityName = this.prefs.getString(KEY_MAIN_ACTIVITY_NAME, null);
        if (mainActivityName == null) {
            mainActivityName = currentActivityName;
            this.prefs.edit().putString(KEY_MAIN_ACTIVITY_NAME, mainActivityName).commit();
        }
        return currentActivityName != null && currentActivityName.equals(mainActivityName);
    }

    public static interface SessionStartedListener {
        public void onSessionStarted();
    }

    public static interface SessionStoppedListener {
        public void onSessionStopped();
    }
}

