/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.content.Context;
import android.os.Bundle;
import android.view.MenuItem;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.fragment.app.Fragment;
import androidx.fragment.app.FragmentActivity;
import com.google.android.material.bottomnavigation.BottomNavigationView;
import com.google.android.material.navigation.NavigationBarView;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.util.ArrayList;
import ly.warp.sdk.R;
import ly.warp.sdk.fragments.HomeFragment;
import ly.warp.sdk.fragments.LoyaltyFragment;
import ly.warp.sdk.fragments.MyRewardsFragment;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.utils.managers.WarplyManager;

public class BaseFragmentActivity
extends FragmentActivity
implements NavigationBarView.OnItemSelectedListener {
    private BottomNavigationView mBottomNavigationView;
    private Fragment mFragmentToSet = null;
    private final CallbackReceiver<ArrayList<Campaign>> mCampaignsCallback = new CallbackReceiver<ArrayList<Campaign>>(){

        @Override
        public void onSuccess(ArrayList<Campaign> result) {
            Toast.makeText((Context)BaseFragmentActivity.this, (CharSequence)("Campaigns Success " + String.valueOf(result.size())), (int)0).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText((Context)BaseFragmentActivity.this, (CharSequence)"Campaigns Error", (int)0).show();
        }
    };
    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>(){

        @Override
        public void onSuccess(CouponList result) {
            Toast.makeText((Context)BaseFragmentActivity.this, (CharSequence)("Coupons Success " + String.valueOf(result.size())), (int)0).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText((Context)BaseFragmentActivity.this, (CharSequence)"Coupons Error", (int)0).show();
        }
    };
    private final CallbackReceiver<ArrayList<UnifiedCoupon>> mUnifiedCallback = new CallbackReceiver<ArrayList<UnifiedCoupon>>(){

        @Override
        public void onSuccess(ArrayList<UnifiedCoupon> result) {
            Toast.makeText((Context)BaseFragmentActivity.this, (CharSequence)("Unified Coupons Success " + String.valueOf(result.size())), (int)0).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText((Context)BaseFragmentActivity.this, (CharSequence)"Unified Coupons Error", (int)0).show();
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_base_fragment);
        this.mBottomNavigationView = (BottomNavigationView)this.findViewById(R.id.bt_tabs);
        WarplyManager.getUserCouponsWithCouponsets(this.mUserCouponsReceiver);
        WarplyManager.getCampaigns(this.mCampaignsCallback);
        WarplyManager.getUnifiedCouponsDeals(this.mUnifiedCallback);
    }

    protected void onStart() {
        super.onStart();
    }

    protected void onStop() {
        super.onStop();
    }

    protected void onResume() {
        super.onResume();
        this.initViews();
    }

    public boolean onNavigationItemSelected(@NonNull MenuItem item) {
        int itemId = item.getItemId();
        if (itemId == R.id.menu_loyalty) {
            this.mFragmentToSet = LoyaltyFragment.newInstance();
            this.getSupportFragmentManager().beginTransaction().replace(R.id.fl_fragment, this.mFragmentToSet).addToBackStack(null).commit();
            return true;
        }
        if (itemId == R.id.menu_home) {
            this.mFragmentToSet = HomeFragment.newInstance();
            this.getSupportFragmentManager().beginTransaction().replace(R.id.fl_fragment, this.mFragmentToSet).addToBackStack(null).commit();
            return true;
        }
        if (itemId == R.id.menu_profile) {
            this.mFragmentToSet = MyRewardsFragment.newInstance();
            this.getSupportFragmentManager().beginTransaction().replace(R.id.fl_fragment, this.mFragmentToSet).addToBackStack(null).commit();
            return true;
        }
        return false;
    }

    public void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        this.mBottomNavigationView.setOnItemSelectedListener((NavigationBarView.OnItemSelectedListener)this);
        this.mFragmentToSet = HomeFragment.newInstance();
        this.getSupportFragmentManager().beginTransaction().add(R.id.fl_fragment, this.mFragmentToSet).commit();
        this.mBottomNavigationView.setSelectedItemId(R.id.menu_home);
    }
}

