/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import java.util.ArrayList;
import ly.warp.sdk.R;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.Consumer;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.WarplyCCMSEnabledModel;
import ly.warp.sdk.io.models.WarplyCouponsChangedEventModel;
import ly.warp.sdk.io.request.CosmoteSubmitOrderRequest;
import ly.warp.sdk.services.EventCampaignService;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONObject;

public class ContextualActivity
extends Activity
implements View.OnClickListener {
    private final String MSISDN_LIST = "msisdnList";
    private ImageView mIvBack;
    private ImageView mIvCampaignPhoto;
    private ImageView mIvTermsArrow;
    private TextView mTvCampaignTitle;
    private TextView mTvCampaignSubtitle;
    private TextView mTvTerms;
    private TextView mTvTermsValue;
    private LoyaltyContextualOfferModel mCCMS = new LoyaltyContextualOfferModel();
    private LinearLayout mLlActivateOffer;
    private LinearLayout mLlTerms;
    private Consumer mConsumer;
    private boolean mIsTermsPressed = false;
    private String mSender = "";
    private AlertDialog mAlertDialogAskActivate;
    private AlertDialog mAlertDialogErrorActivating;
    private AlertDialog mAlertDialogSuccessActivating;
    private final CallbackReceiver<Consumer> mConsumerCallback = new CallbackReceiver<Consumer>(){

        @Override
        public void onSuccess(Consumer result) {
            ContextualActivity.this.mConsumer = result;
        }

        @Override
        public void onFailure(int errorCode) {
            Log.v((String)"TELCO_ACTIVITY", (String)String.valueOf(errorCode));
        }
    };
    private CallbackReceiver<JSONObject> mSubmitCallback = new CallbackReceiver<JSONObject>(){

        @Override
        public void onSuccess(JSONObject result) {
            int status = result.optInt("status", 2);
            if (status == 1) {
                ContextualActivity.this.successActivatingDialog();
                WarplyManager.getUserCouponsWithCouponsets(ContextualActivity.this.mUserCouponsReceiver);
                WarplyManager.getCampaigns(ContextualActivity.this.mCampaignsCallback);
            } else {
                ContextualActivity.this.errorActivatingDialog();
            }
        }

        @Override
        public void onFailure(int errorCode) {
            ContextualActivity.this.errorActivatingDialog();
        }
    };
    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>(){

        @Override
        public void onSuccess(CouponList result) {
            WarplyCouponsChangedEventModel couponsChanged = new WarplyCouponsChangedEventModel();
            couponsChanged.setChanged(true);
            EventBus.getDefault().post((Object)new WarplyEventBusManager(couponsChanged));
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };
    private CallbackReceiver<ArrayList<Campaign>> mCampaignsCallback = new CallbackReceiver<ArrayList<Campaign>>(){

        @Override
        public void onSuccess(ArrayList<Campaign> result) {
            OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
            WorkManager.getInstance((Context)ContextualActivity.this).enqueue((WorkRequest)mywork);
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_contextual);
        this.mCCMS = (LoyaltyContextualOfferModel)this.getIntent().getSerializableExtra("ccms");
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_contextual_back);
        this.mTvCampaignTitle = (TextView)this.findViewById(R.id.textView13);
        this.mIvCampaignPhoto = (ImageView)this.findViewById(R.id.imageView6);
        this.mTvCampaignSubtitle = (TextView)this.findViewById(R.id.textView14);
        this.mLlActivateOffer = (LinearLayout)this.findViewById(R.id.ll_activate_button);
        this.mTvTerms = (TextView)this.findViewById(R.id.tv_terms);
        this.mLlTerms = (LinearLayout)this.findViewById(R.id.ll_terms_inner);
        this.mIvTermsArrow = (ImageView)this.findViewById(R.id.iv_terms_arrow);
        this.mTvTermsValue = (TextView)this.findViewById(R.id.tv_terms_value);
        this.initViews();
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "ContextualScreen");
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_contextual_back) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_activate_button) {
            this.showActivationDialog();
            return;
        }
        if (view.getId() == R.id.ll_terms_inner) {
            if (this.mIsTermsPressed) {
                this.mIsTermsPressed = false;
                this.mTvTermsValue.setVisibility(8);
                this.mIvTermsArrow.setImageDrawable(this.getDrawable(R.drawable.ic_down_dark_new));
            } else {
                this.mIsTermsPressed = true;
                this.mTvTermsValue.setVisibility(0);
                this.mIvTermsArrow.setImageDrawable(this.getDrawable(R.drawable.ic_up_dark_new));
            }
        }
    }

    private void initViews() {
        this.mTvCampaignTitle.setText((CharSequence)this.mCCMS.getTitleOffer());
        this.mTvCampaignSubtitle.setText((CharSequence)this.mCCMS.getDescription());
        this.mLlTerms.setOnClickListener((View.OnClickListener)this);
        this.mTvTermsValue.setText((CharSequence)this.mCCMS.getTermsAndConditions());
        if (!TextUtils.isEmpty((CharSequence)this.mCCMS.getImageUrl())) {
            ((RequestBuilder)Glide.with((Activity)this).load(this.mCCMS.getImageUrl()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(this.mIvCampaignPhoto);
        } else {
            Glide.with((Activity)this).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(this.mIvCampaignPhoto);
        }
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mLlActivateOffer.setOnClickListener((View.OnClickListener)this);
    }

    private void showActivationDialog() {
        BottomSheetDialog bottomSheetDialog = new BottomSheetDialog((Context)this);
        bottomSheetDialog.setContentView(R.layout.dl_share);
        TextView tvHeader = (TextView)bottomSheetDialog.findViewById(R.id.tv_sender_value);
        tvHeader.setText(R.string.cos_coupon_share_telco);
        LinearLayout parent = (LinearLayout)bottomSheetDialog.findViewById(R.id.ll_share_dialog_view_inner);
        ImageView dialogClose = (ImageView)bottomSheetDialog.findViewById(R.id.iv_sender_list_close);
        dialogClose.setOnClickListener(view -> bottomSheetDialog.dismiss());
        if (this.mCCMS.getEligibleAssets() != null && this.mCCMS.getEligibleAssets().size() > 0) {
            for (int i = 0; i < this.mCCMS.getEligibleAssets().size(); ++i) {
                LayoutInflater vi = (LayoutInflater)this.getApplicationContext().getSystemService("layout_inflater");
                LinearLayout v = (LinearLayout)vi.inflate(R.layout.item_share, null);
                TextView textView = (TextView)v.findViewById(R.id.tv_phone_share);
                textView.setText((CharSequence)this.mCCMS.getEligibleAssets().get(i));
                textView.setOnClickListener(view -> {
                    TextView tv = (TextView)view;
                    this.mSender = tv.getText().toString();
                    bottomSheetDialog.dismiss();
                    this.askActivateDialog();
                });
                parent.addView((View)v, 0, new ViewGroup.LayoutParams(-1, -2));
            }
        }
        bottomSheetDialog.show();
    }

    private void activateGift() {
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "ActivateContextual".concat(":").concat(this.mCCMS.getSessionId()));
        WarplyManager.submitOrder(new CosmoteSubmitOrderRequest().setCommunicationUuid("").setUserMsisdn(this.mSender).setSessionId(this.mCCMS.getSessionId()).setBusinessService(this.mCCMS.getBusinessService()).setNotificationMessage(this.mCCMS.getNotificationMessage()).setOfferName(this.mCCMS.getOfferName()).setProductType(this.mCCMS.getProductType()).setProvDuration(this.mCCMS.getProvDuration()).setNoOfRecurrance(this.mCCMS.getNoOfRecurrance()).setPrice(this.mCCMS.getPrice()).setDiscount(this.mCCMS.getDiscount()).setVoiceCategory(this.mCCMS.getVoiceCategory()).setDataCategory(this.mCCMS.getDataCategory()).setMinsValue(this.mCCMS.getMinsValue()).setDataValue(this.mCCMS.getDataValue()).setProvStepValueMins(this.mCCMS.getProvStepValueMins()).setOfferAudienceLevel(this.mCCMS.getOfferAudienceLevel()).setUACIOfferTrackingCode(this.mCCMS.getUACIOfferTrackingCode()).setOfferCode1(this.mCCMS.getOfferCode1()).setScore(this.mCCMS.getScore()).setZone(this.mCCMS.getZone()).setWave(this.mCCMS.getWave()).setValidity(this.mCCMS.getValidity()).setTreatmentCode(this.mCCMS.getTreatmentCode()), this.mSubmitCallback);
    }

    private void askActivateDialog() {
        if (!this.isFinishing()) {
            this.mAlertDialogAskActivate = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_activate_telco_title).setMessage(R.string.cos_dlg_activate_telco_subtitle).setPositiveButton(R.string.cos_dlg_positive_button, (dialogPositive, whichPositive) -> this.activateGift()).setNegativeButton(R.string.cos_dlg_negative_button2, (dialogNegative, whichNegative) -> dialogNegative.dismiss()).show();
        }
    }

    private void errorActivatingDialog() {
        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
        analyticsEvent.setEventName("loyalty_offer_activated");
        analyticsEvent.setParameter("name", this.mCCMS.getTitle());
        analyticsEvent.setParameter("type", "gift");
        analyticsEvent.setParameter("successful", "false");
        EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
        if (!this.isFinishing()) {
            this.mAlertDialogErrorActivating = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_error_title).setMessage(R.string.cos_dlg_error_subtitle).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    private void successActivatingDialog() {
        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
        analyticsEvent.setEventName("loyalty_offer_activated");
        analyticsEvent.setParameter("name", this.mCCMS.getTitle());
        analyticsEvent.setParameter("type", "gift");
        analyticsEvent.setParameter("successful", "true");
        EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
        WarplyCCMSEnabledModel ccmsEnabled = new WarplyCCMSEnabledModel();
        ccmsEnabled.setActivated(true);
        EventBus.getDefault().post((Object)new WarplyEventBusManager(ccmsEnabled));
        if (!this.isFinishing()) {
            this.mAlertDialogSuccessActivating = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_activate_success_title).setMessage(R.string.cos_dlg_activate_success_subtitle).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                dialogPositive.dismiss();
                this.onBackPressed();
            }).show();
        }
    }
}

