/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.core.content.ContextCompat;
import androidx.core.text.HtmlCompat;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Writer;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.CouponShareActivity;
import ly.warp.sdk.activities.ShopsActivity;
import ly.warp.sdk.activities.ShopsHuaweiActivity;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.services.EventCouponsService;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;

public class CouponInfoActivity
extends Activity
implements View.OnClickListener {
    private ImageView mIvBack;
    private ImageView mIvCouponPhoto;
    private ImageView mIvBarcode;
    private TextView mTvTerms;
    private TextView mTvCouponCode;
    private TextView mTvCouponTitle;
    private TextView mTvCouponSubtitle;
    private TextView mTvCouponDate;
    private TextView mTvTermsValue;
    private TextView mTvFullBarcode;
    private TextView mTvDescription;
    private TextView mTvCouponCodeTitle;
    private LinearLayout mLlGiftIt;
    private LinearLayout mLlShops;
    private LinearLayout mLlBarcodeShown;
    private LinearLayout mLlBarcodeContainer;
    private LinearLayout mLlTerms;
    private LinearLayout mLlWebsite;
    private Coupon mCoupon;
    private boolean mIsBarcodeShown = false;
    private boolean mIsTermsShown = false;
    private boolean mIsFromWallet = false;
    private boolean mShopsPressed = false;
    private boolean mGiftPressed = false;
    private boolean mEshopPressed = false;
    private boolean mIsUnified = false;

    public void onCreate(Bundle savedInstanceState) {
        block5: {
            super.onCreate(savedInstanceState);
            this.setContentView(R.layout.activity_coupon_info);
            String couponCode = this.getIntent().getStringExtra("coupon");
            this.mIsFromWallet = this.getIntent().getBooleanExtra("isFromWallet", false);
            this.mIsUnified = this.getIntent().getBooleanExtra("isUnified", false);
            if (this.mIsUnified) {
                String couponUnifiedCode = this.getIntent().getStringExtra("unifiedCoupon");
                for (UnifiedCoupon couponItem : WarplyManagerHelper.getMarketCoupons()) {
                    if (!couponItem.getBarcode().equals(couponUnifiedCode)) continue;
                    for (Coupon cpn : couponItem.getCoupons()) {
                        if (!cpn.getCoupon().equals(couponCode)) continue;
                        this.mCoupon = cpn;
                        break block5;
                    }
                    break;
                }
            } else {
                for (Coupon cpn : WarplyManagerHelper.getCouponList()) {
                    if (!cpn.getCoupon().equals(couponCode)) continue;
                    this.mCoupon = cpn;
                    break;
                }
            }
        }
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_coupon_info_back);
        this.mTvTerms = (TextView)this.findViewById(R.id.tv_terms);
        this.mLlGiftIt = (LinearLayout)this.findViewById(R.id.ll_gift_it);
        this.mTvCouponCode = (TextView)this.findViewById(R.id.textView16);
        this.mTvCouponTitle = (TextView)this.findViewById(R.id.textView13);
        this.mTvCouponSubtitle = (TextView)this.findViewById(R.id.textView14);
        this.mTvCouponDate = (TextView)this.findViewById(R.id.textView17);
        this.mIvCouponPhoto = (ImageView)this.findViewById(R.id.imageView6);
        this.mIvBarcode = (ImageView)this.findViewById(R.id.iv_barcode);
        this.mLlShops = (LinearLayout)this.findViewById(R.id.ll_shops);
        this.mLlWebsite = (LinearLayout)this.findViewById(R.id.ll_website);
        this.mLlBarcodeShown = (LinearLayout)this.findViewById(R.id.ll_show_barcode);
        this.mLlBarcodeContainer = (LinearLayout)this.findViewById(R.id.ll_barcode_container_items);
        this.mLlTerms = (LinearLayout)this.findViewById(R.id.ll_terms_inner);
        this.mTvTermsValue = (TextView)this.findViewById(R.id.tv_terms_value);
        this.mTvFullBarcode = (TextView)this.findViewById(R.id.tv_full_barcode);
        this.mTvDescription = (TextView)this.findViewById(R.id.tv_clickable_link);
        this.mTvCouponCodeTitle = (TextView)this.findViewById(R.id.textView15);
        this.initViews();
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "CouponScreen");
        this.mShopsPressed = false;
        this.mGiftPressed = false;
        this.mEshopPressed = false;
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1001 && resultCode == -1) {
            OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventCouponsService.class).build();
            WorkManager.getInstance((Context)this).enqueue((WorkRequest)mywork);
            this.onBackPressed();
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_coupon_info_back) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_gift_it) {
            if (!this.mGiftPressed) {
                this.mGiftPressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "ShareCoupon".concat(":").concat(this.mCoupon != null ? this.mCoupon.getName() : ""));
                Intent intent = new Intent((Context)this, CouponShareActivity.class);
                intent.putExtra("coupon", this.mCoupon != null ? this.mCoupon.getCoupon() : "");
                intent.putExtra("isFromWallet", this.mIsFromWallet);
                if (!this.mIsFromWallet) {
                    this.startActivity(intent);
                } else {
                    this.startActivityForResult(intent, 1001);
                }
            }
            return;
        }
        if (view.getId() == R.id.ll_shops && !this.mShopsPressed) {
            this.mShopsPressed = true;
            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "SeeShops");
            if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable((Context)this) == 0) {
                Intent intent = new Intent((Context)this, ShopsActivity.class);
                intent.putExtra("coupon", this.mCoupon != null ? this.mCoupon.getCoupon() : "");
                this.startActivity(intent);
                return;
            }
            Intent intent = new Intent((Context)this, ShopsHuaweiActivity.class);
            intent.putExtra("coupon", this.mCoupon != null ? this.mCoupon.getCoupon() : "");
            this.startActivity(intent);
            return;
        }
        if (view.getId() == R.id.ll_website) {
            if (!this.mEshopPressed) {
                this.mEshopPressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "SeeShopWebsite");
                if (this.mCoupon != null && this.mCoupon.getMerchantDetails() != null && !TextUtils.isEmpty((CharSequence)this.mCoupon.getMerchantDetails().getWebsite())) {
                    Intent intent = new Intent("android.intent.action.VIEW");
                    intent.setData(Uri.parse((String)this.mCoupon.getMerchantDetails().getWebsite()));
                    this.startActivity(intent);
                }
            }
            return;
        }
        if (view.getId() == R.id.ll_show_barcode) {
            if (this.mIsBarcodeShown) {
                this.mLlBarcodeContainer.setVisibility(8);
                TextView barcodeButtonTitle = (TextView)this.mLlBarcodeShown.findViewById(R.id.tv_barcode);
                ImageView barcodeButtonArrow = (ImageView)this.mLlBarcodeShown.findViewById(R.id.iv_barcode_arrow);
                barcodeButtonTitle.setText((CharSequence)this.getString(R.string.cos_show_barcode));
                barcodeButtonArrow.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_down_dark_new));
                this.mIsBarcodeShown = false;
            } else {
                this.mLlBarcodeContainer.setVisibility(0);
                TextView barcodeButtonTitle = (TextView)this.mLlBarcodeShown.findViewById(R.id.tv_barcode);
                ImageView barcodeButtonArrow = (ImageView)this.mLlBarcodeShown.findViewById(R.id.iv_barcode_arrow);
                barcodeButtonTitle.setText((CharSequence)this.getString(R.string.cos_hide_barcode));
                barcodeButtonArrow.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_up_dark_new));
                this.mIsBarcodeShown = true;
            }
            return;
        }
        if (view.getId() == R.id.ll_terms_inner) {
            if (this.mIsTermsShown) {
                this.mTvTermsValue.setVisibility(8);
                ImageView termsButtonArrow = (ImageView)this.mLlTerms.findViewById(R.id.iv_terms_arrow);
                termsButtonArrow.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_down_dark_new));
                this.mIsTermsShown = false;
            } else {
                this.mTvTermsValue.setVisibility(0);
                ImageView termsButtonArrow = (ImageView)this.mLlTerms.findViewById(R.id.iv_terms_arrow);
                termsButtonArrow.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_up_dark_new));
                this.mIsTermsShown = true;
            }
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        int i;
        if (this.mIsUnified) {
            this.mTvCouponCodeTitle.setVisibility(8);
            this.mTvCouponCode.setVisibility(8);
            this.mLlGiftIt.setVisibility(8);
        }
        this.mLlBarcodeShown.setVisibility(8);
        this.mLlBarcodeContainer.setVisibility(8);
        this.mIvBarcode.setVisibility(8);
        if (this.mCoupon != null) {
            if (this.mIsUnified) {
                this.mTvCouponTitle.setText((CharSequence)HtmlCompat.fromHtml((String)this.mCoupon.getName(), (int)63));
            } else {
                this.mTvCouponCode.setText((CharSequence)this.mCoupon.getCoupon());
                this.mTvCouponTitle.setText((CharSequence)this.mCoupon.getCouponsetDetails().getName());
            }
        }
        if (this.mCoupon != null) {
            if (this.mIsFromWallet) {
                if (this.mCoupon.getMerchantDetails() != null) {
                    this.mTvDescription.setVisibility(8);
                    this.mLlShops.setVisibility(0);
                }
                if (this.mIsUnified) {
                    this.mTvCouponSubtitle.setText((CharSequence)HtmlCompat.fromHtml((String)this.mCoupon.getDescription(), (int)63));
                } else {
                    this.mTvCouponSubtitle.setText((CharSequence)this.mCoupon.getCouponsetDetails().getShortDescription());
                }
                this.mTvTermsValue.setText((CharSequence)HtmlCompat.fromHtml((String)this.mCoupon.getCouponsetDetails().getTerms(), (int)63));
                this.mTvTermsValue.setMovementMethod(LinkMovementMethod.getInstance());
            } else {
                if (this.mCoupon.getMerchantDetails() != null) {
                    if (this.mCoupon.getMerchantDetails() != null && !TextUtils.isEmpty((CharSequence)this.mCoupon.getMerchantDetails().getBody()) && !this.mCoupon.getMerchantDetails().getBody().equals("null")) {
                        this.mTvDescription.setText((CharSequence)HtmlCompat.fromHtml((String)this.mCoupon.getMerchantDetails().getBody(), (int)63));
                        this.mTvDescription.setMovementMethod(LinkMovementMethod.getInstance());
                    } else {
                        this.mTvDescription.setVisibility(8);
                    }
                    this.mLlShops.setVisibility(0);
                }
                this.mTvCouponSubtitle.setText((CharSequence)this.mCoupon.getCouponsetDetails().getShortDescription());
                this.mTvTermsValue.setText((CharSequence)HtmlCompat.fromHtml((String)this.mCoupon.getCouponsetDetails().getTerms(), (int)63));
                this.mTvTermsValue.setMovementMethod(LinkMovementMethod.getInstance());
            }
        }
        SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
        Date newDate = new Date();
        try {
            newDate = simpleDateFormat.parse(this.mCoupon.getExpiration());
        }
        catch (ParseException e) {
            e.printStackTrace();
        }
        simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
        this.mTvCouponDate.setText((CharSequence)String.format(this.getResources().getString(R.string.cos_mycoupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
        if (this.mIsUnified) {
            this.mIvCouponPhoto.setScaleType(ImageView.ScaleType.CENTER_INSIDE);
            if (this.mCoupon != null) {
                if (!TextUtils.isEmpty((CharSequence)this.mCoupon.getImage())) {
                    ((RequestBuilder)Glide.with((Activity)this).load(this.mCoupon.getImage()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(this.mIvCouponPhoto);
                } else {
                    Glide.with((Activity)this).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(this.mIvCouponPhoto);
                }
            } else {
                Glide.with((Activity)this).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(this.mIvCouponPhoto);
            }
        } else {
            this.mIvCouponPhoto.setScaleType(ImageView.ScaleType.CENTER_CROP);
            if (this.mCoupon != null) {
                if (!TextUtils.isEmpty((CharSequence)this.mCoupon.getCouponsetDetails().getImgPreview())) {
                    ((RequestBuilder)Glide.with((Activity)this).load(this.mCoupon.getCouponsetDetails().getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(this.mIvCouponPhoto);
                } else {
                    Glide.with((Activity)this).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(this.mIvCouponPhoto);
                }
            } else {
                Glide.with((Activity)this).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(this.mIvCouponPhoto);
            }
        }
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mLlGiftIt.setOnClickListener((View.OnClickListener)this);
        this.mLlShops.setOnClickListener((View.OnClickListener)this);
        this.mLlWebsite.setOnClickListener((View.OnClickListener)this);
        this.mLlBarcodeShown.setOnClickListener((View.OnClickListener)this);
        this.mLlTerms.setOnClickListener((View.OnClickListener)this);
        String tempCoupon = "";
        int result = 0;
        try {
            tempCoupon = this.mCoupon.getCoupon();
            for (i = 0; i < 12 - this.mCoupon.getCoupon().length(); ++i) {
                tempCoupon = tempCoupon + "0";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (i = this.mCoupon.getCoupon().length() - 1; i >= 0; --i) {
                result += Integer.parseInt(String.valueOf(this.mCoupon.getCoupon().charAt(i))) * (1 + 2 * (i % 2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tempCoupon = tempCoupon + (10 - result % 10) % 10;
        this.createBarcodeBitmap(tempCoupon);
    }

    private void createBarcodeBitmap(String barcodeString) {
        EAN13Writer writer = new EAN13Writer();
        try {
            BitMatrix bitMatrix = writer.encode(barcodeString, BarcodeFormat.EAN_13, 1024, 512);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    bmp.setPixel(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
                }
            }
            this.mIvBarcode.setImageBitmap(bmp);
            this.mTvFullBarcode.setText((CharSequence)barcodeString);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mLlBarcodeShown.setVisibility(8);
            this.mLlBarcodeContainer.setVisibility(8);
            this.mIvBarcode.setVisibility(8);
        }
    }
}

