/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.util.ArrayList;
import ly.warp.sdk.R;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Consumer;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.WarplyCouponsChangedEventModel;
import ly.warp.sdk.io.request.CosmoteCouponSharingRequest;
import ly.warp.sdk.io.request.WarplyConsumerRequest;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class CouponShareActivity
extends Activity
implements View.OnClickListener {
    private final String MSISDN_LIST = "msisdnList";
    private ImageView mIvBack;
    private ImageView mIvCouponPhoto;
    private TextView mTvCouponTitle;
    private TextView mTvPhoneHeader;
    private Coupon mCoupon;
    private Consumer mConsumer;
    private RelativeLayout mRlSenderView;
    private LinearLayout mLlShareButton;
    private String mSender = "";
    private EditText mEdtReceiver;
    private AlertDialog mAlertDialogSuccessSharing;
    private AlertDialog mAlertDialogErrorSharing;
    private AlertDialog mAlertDialogCouponAskSharing;
    private AlertDialog mAlertDialogWrongNumberSharing;
    private AlertDialog mAlertDialogNoAssets;
    private boolean mIsFromWallet = false;
    private final CallbackReceiver<Consumer> mConsumerCallback = new CallbackReceiver<Consumer>(){

        @Override
        public void onSuccess(Consumer result) {
            CouponShareActivity.this.mConsumer = result;
        }

        @Override
        public void onFailure(int errorCode) {
            Log.v((String)"COUPON_SHARE_ACTIVITY", (String)String.valueOf(errorCode));
        }
    };
    private final CallbackReceiver<JSONObject> mCouponSharingCallback = new CallbackReceiver<JSONObject>(){

        @Override
        public void onSuccess(JSONObject result) {
            int status = result.optInt("status", 2);
            String message = result.optString("msg", "");
            if (status == 1) {
                WarplyManager.getUserCouponsWithCouponsets(CouponShareActivity.this.mUserCouponsReceiver);
            }
            CouponShareActivity.this.runOnUiThread(() -> {
                if (status == 1) {
                    CouponShareActivity.this.acceptSharingDialog();
                } else if (status == 4) {
                    CouponShareActivity.this.wrongNumberDialog(message);
                } else {
                    CouponShareActivity.this.errorSharingDialog();
                }
            });
        }

        @Override
        public void onFailure(int errorCode) {
            Log.v((String)"COUPON_SHARE", (String)String.valueOf(errorCode));
            CouponShareActivity.this.runOnUiThread(() -> CouponShareActivity.this.errorSharingDialog());
        }
    };
    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>(){

        @Override
        public void onSuccess(CouponList result) {
            WarplyCouponsChangedEventModel couponsChanged = new WarplyCouponsChangedEventModel();
            couponsChanged.setChanged(true);
            EventBus.getDefault().post((Object)new WarplyEventBusManager(couponsChanged));
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_coupon_share);
        String couponCode = this.getIntent().getStringExtra("coupon");
        this.mIsFromWallet = this.getIntent().getBooleanExtra("isFromWallet", false);
        for (Coupon cpn : WarplyManagerHelper.getCouponList()) {
            if (!cpn.getCoupon().equals(couponCode)) continue;
            this.mCoupon = cpn;
            break;
        }
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_coupon_share_back);
        this.mTvCouponTitle = (TextView)this.findViewById(R.id.textView13);
        this.mIvCouponPhoto = (ImageView)this.findViewById(R.id.imageView6);
        this.mRlSenderView = (RelativeLayout)this.findViewById(R.id.ll_share_view);
        this.mLlShareButton = (LinearLayout)this.findViewById(R.id.ll_share_button);
        this.mTvPhoneHeader = (TextView)this.findViewById(R.id.tv_phone);
        this.mEdtReceiver = (EditText)this.findViewById(R.id.et_phone);
        this.initViews();
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "CouponShareScreen");
        WarplyManager.getConsumer(new WarplyConsumerRequest(), this.mConsumerCallback);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_coupon_share_back) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_share_view) {
            if (this.mConsumer == null) {
                return;
            }
            try {
                JSONObject profMeta = new JSONObject(this.mConsumer.getProfileMetadata());
                if (profMeta != null) {
                    JSONArray msisdnList = new JSONArray();
                    msisdnList = profMeta.optJSONArray("msisdnList");
                    ArrayList<String> listdata = new ArrayList<String>();
                    if (msisdnList != null) {
                        for (int i = 0; i < msisdnList.length(); ++i) {
                            if (TextUtils.isEmpty((CharSequence)msisdnList.optString(i).trim())) continue;
                            listdata.add(msisdnList.optString(i).trim());
                        }
                    }
                    if (listdata == null || listdata.size() == 0) {
                        this.showNoAssetsDialog();
                        return;
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            this.showSharingDialog();
            return;
        }
        if (view.getId() == R.id.ll_share_button) {
            if (!(TextUtils.isEmpty((CharSequence)this.mSender) || this.mTvPhoneHeader.getText().toString().equals(R.string.cos_coupon_share_sender) || TextUtils.isEmpty((CharSequence)this.mEdtReceiver.getText().toString()))) {
                this.askSharingDialog();
            } else {
                this.errorSharingDialog2();
            }
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        this.mTvCouponTitle.setText((CharSequence)this.mCoupon.getCouponsetDetails().getName());
        if (!TextUtils.isEmpty((CharSequence)this.mCoupon.getCouponsetDetails().getImgPreview())) {
            ((RequestBuilder)Glide.with((Activity)this).load(this.mCoupon.getCouponsetDetails().getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(this.mIvCouponPhoto);
        } else {
            Glide.with((Activity)this).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(this.mIvCouponPhoto);
        }
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mRlSenderView.setOnClickListener((View.OnClickListener)this);
        this.mLlShareButton.setOnClickListener((View.OnClickListener)this);
    }

    private void showSharingDialog() {
        BottomSheetDialog bottomSheetDialog = new BottomSheetDialog((Context)this);
        bottomSheetDialog.setContentView(R.layout.dl_share);
        LinearLayout parent = (LinearLayout)bottomSheetDialog.findViewById(R.id.ll_share_dialog_view_inner);
        ImageView dialogClose = (ImageView)bottomSheetDialog.findViewById(R.id.iv_sender_list_close);
        dialogClose.setOnClickListener(view -> bottomSheetDialog.dismiss());
        if (this.mConsumer != null) {
            try {
                JSONObject profMeta = new JSONObject(this.mConsumer.getProfileMetadata());
                if (profMeta != null) {
                    JSONArray msisdnList = new JSONArray();
                    msisdnList = profMeta.optJSONArray("msisdnList");
                    if (msisdnList != null && msisdnList.length() > 0) {
                        for (int i = 0; i < msisdnList.length(); ++i) {
                            LayoutInflater vi = (LayoutInflater)this.getApplicationContext().getSystemService("layout_inflater");
                            LinearLayout v = (LinearLayout)vi.inflate(R.layout.item_share, null);
                            TextView textView = (TextView)v.findViewById(R.id.tv_phone_share);
                            textView.setText((CharSequence)msisdnList.optString(i));
                            textView.setOnClickListener(view -> {
                                TextView tv = (TextView)view;
                                this.mTvPhoneHeader.setText((CharSequence)tv.getText().toString());
                                this.mSender = tv.getText().toString();
                                bottomSheetDialog.dismiss();
                            });
                            parent.addView((View)v, 0, new ViewGroup.LayoutParams(-1, -2));
                        }
                    }
                }
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
        }
        bottomSheetDialog.show();
    }

    private void acceptSharingDialog() {
        if (!this.isFinishing()) {
            this.mAlertDialogSuccessSharing = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_success_title).setMessage(R.string.cos_dlg_positive_coupon_text).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                dialogPositive.dismiss();
                if (this.mIsFromWallet) {
                    this.setResult(-1, new Intent());
                    this.onBackPressed();
                }
            }).show();
        }
    }

    private void errorSharingDialog() {
        if (!this.isFinishing()) {
            this.mAlertDialogErrorSharing = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_error_title).setMessage(R.string.cos_dlg_error_subtitle).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    private void wrongNumberDialog(String message) {
        if (!this.isFinishing()) {
            this.mAlertDialogWrongNumberSharing = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_error_title).setMessage((CharSequence)message).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    private void errorSharingDialog2() {
        if (!this.isFinishing()) {
            this.mAlertDialogErrorSharing = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_error_title2).setMessage(R.string.cos_dlg_error_subtitle2).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
        }
    }

    private void showNoAssetsDialog() {
        if (!this.isFinishing()) {
            this.mAlertDialogNoAssets = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_coupon_gift).setMessage(R.string.cos_share_no_assets).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                dialogPositive.dismiss();
                this.onBackPressed();
            }).show();
        }
    }

    private void askSharingDialog() {
        if (!this.isFinishing()) {
            this.mAlertDialogCouponAskSharing = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_positive_coupon_title).setMessage(R.string.cos_dlg_positive_coupon_subtitle).setPositiveButton(R.string.cos_dlg_negative_button3, (dialogPositive, whichPositive) -> {
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "ShareCoupon".concat(":").concat(this.mCoupon.getCouponsetDetails().getName()));
                new Thread(() -> {
                    if (!Thread.currentThread().isInterrupted()) {
                        WarplyManager.cosmoteCouponSharing(new CosmoteCouponSharingRequest().setCoupon(this.mCoupon.getCoupon()).setSender(this.mSender).setReceiver(this.mEdtReceiver.getText().toString()), this.mCouponSharingCallback);
                    }
                    Thread.currentThread().interrupt();
                }).start();
            }).setNegativeButton(R.string.cos_dlg_negative_button2, (dialogNegative, whichNegative) -> dialogNegative.dismiss()).show();
        }
    }
}

