/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.text.TextUtils;
import android.text.method.LinkMovementMethod;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ProgressBar;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.core.text.HtmlCompat;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.util.ArrayList;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.ActiveCouponsActivity;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.WarplyCCMSEnabledModel;
import ly.warp.sdk.io.models.WarplyCouponsChangedEventModel;
import ly.warp.sdk.io.request.WarplyRedeemCouponRequest;
import ly.warp.sdk.services.EventCampaignService;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import org.greenrobot.eventbus.EventBus;
import org.json.JSONObject;

public class CouponsetInfoActivity
extends Activity
implements View.OnClickListener {
    private ImageView mIvBack;
    private ImageView mIvCouponsetPhoto;
    private ImageView mIvTermsArrow;
    private TextView mTvTerms;
    private TextView mTvCouponsetTitle;
    private TextView mTvCouponsetSubtitle;
    private TextView mTvTermsValue;
    private Couponset mCouponset;
    private LinearLayout mLlRedeem;
    private LinearLayout mLlTerms;
    private ProgressBar mPbLoading;
    private Coupon mCoupon;
    private boolean mIsTermsPressed = false;
    private boolean mIsGiftPressed = false;
    private AlertDialog mAlertDialogCouponset;
    private Campaign mLoyalty;
    private LoyaltyContextualOfferModel mCcms = null;
    private AlertDialog mAlertDialogNonTelco;
    private final CallbackReceiver<JSONObject> mRedeemCouponCallback = new CallbackReceiver<JSONObject>(){

        @Override
        public void onSuccess(JSONObject result) {
            CouponsetInfoActivity.this.mPbLoading.setVisibility(8);
            int status = result.optInt("status");
            if (status == 1) {
                if (CouponsetInfoActivity.this.mCcms != null) {
                    WarplyCCMSEnabledModel ccmsEnabled = new WarplyCCMSEnabledModel();
                    ccmsEnabled.setActivated(true);
                    EventBus.getDefault().post((Object)new WarplyEventBusManager(ccmsEnabled));
                }
                CouponsetInfoActivity.this.mCoupon = new Coupon(result.optJSONObject("result"));
                if (CouponsetInfoActivity.this.mCouponset != null) {
                    CouponsetInfoActivity.this.mCoupon.setDescription(CouponsetInfoActivity.this.mCouponset.getShortDescription());
                    CouponsetInfoActivity.this.mCoupon.setImage(CouponsetInfoActivity.this.mCouponset.getImgPreview());
                    CouponsetInfoActivity.this.mCoupon.setName(CouponsetInfoActivity.this.mCouponset.getName());
                }
                CouponsetInfoActivity.this.showDialog(true, 1);
                WarplyManager.getUserCouponsWithCouponsets(CouponsetInfoActivity.this.mUserCouponsReceiver);
                WarplyManager.getCampaigns(CouponsetInfoActivity.this.mCampaignsCallback);
            } else {
                CouponsetInfoActivity.this.showDialog(false, status);
            }
            CouponsetInfoActivity.this.mLlRedeem.setEnabled(true);
        }

        @Override
        public void onFailure(int errorCode) {
            CouponsetInfoActivity.this.mPbLoading.setVisibility(8);
            CouponsetInfoActivity.this.showDialog(false, errorCode);
            CouponsetInfoActivity.this.mLlRedeem.setEnabled(true);
        }
    };
    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>(){

        @Override
        public void onSuccess(CouponList result) {
            WarplyCouponsChangedEventModel couponsChanged = new WarplyCouponsChangedEventModel();
            couponsChanged.setChanged(true);
            EventBus.getDefault().post((Object)new WarplyEventBusManager(couponsChanged));
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };
    private CallbackReceiver<ArrayList<Campaign>> mCampaignsCallback = new CallbackReceiver<ArrayList<Campaign>>(){

        @Override
        public void onSuccess(ArrayList<Campaign> result) {
            OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
            WorkManager.getInstance((Context)CouponsetInfoActivity.this).enqueue((WorkRequest)mywork);
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_couponset_info);
        String couponsetCode = this.getIntent().getStringExtra("couponset");
        String campaignCode = this.getIntent().getStringExtra("loyalty");
        this.mCcms = (LoyaltyContextualOfferModel)this.getIntent().getSerializableExtra("ccms");
        for (Couponset cpnst : WarplyManagerHelper.getCouponsets()) {
            if (!cpnst.getUuid().equals(couponsetCode)) continue;
            this.mCouponset = cpnst;
            break;
        }
        for (Campaign cmp : WarplyManagerHelper.getCampaignList()) {
            if (!cmp.getSessionUUID().equals(campaignCode)) continue;
            this.mLoyalty = cmp;
            break;
        }
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_couponset_info_back);
        this.mTvTerms = (TextView)this.findViewById(R.id.tv_terms);
        this.mTvCouponsetTitle = (TextView)this.findViewById(R.id.textView13);
        this.mTvCouponsetSubtitle = (TextView)this.findViewById(R.id.textView14);
        this.mIvCouponsetPhoto = (ImageView)this.findViewById(R.id.imageView6);
        this.mLlRedeem = (LinearLayout)this.findViewById(R.id.ll_get_gift);
        this.mPbLoading = (ProgressBar)this.findViewById(R.id.pb_loading);
        this.mLlTerms = (LinearLayout)this.findViewById(R.id.ll_terms_inner);
        this.mTvTermsValue = (TextView)this.findViewById(R.id.tv_terms_value);
        this.mIvTermsArrow = (ImageView)this.findViewById(R.id.iv_terms_arrow);
        this.initViews();
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "CouponsetScreen");
        this.mIsGiftPressed = false;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_couponset_info_back) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_get_gift && !this.mIsGiftPressed) {
            this.mIsGiftPressed = true;
            this.mLlRedeem.setEnabled(false);
            this.mPbLoading.setVisibility(0);
            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "RetrieveCoupon".concat(":").concat(this.mCouponset != null ? this.mCouponset.getUuid() : ""));
            if (this.mCcms == null) {
                WarplyManager.redeemCoupon(new WarplyRedeemCouponRequest().setCouponsetUuid(this.mCouponset != null ? this.mCouponset.getUuid() : "").setCommunicationUuid(this.mLoyalty.getSessionUUID()), this.mRedeemCouponCallback);
            } else {
                WarplyManager.redeemCoupon(new WarplyRedeemCouponRequest().setCouponsetUuid(this.mCouponset != null ? this.mCouponset.getUuid() : "").setCommunicationUuid(this.mLoyalty.getSessionUUID()).setHasContextualOffer(true).setSessionId(this.mCcms.getSessionId()).setUserMsisdn(WarplyManagerHelper.getConsumer().getMsisdn()).setBusinessService(this.mCcms.getBusinessService()).setOfferName(this.mCcms.getOfferName()).setProductType(this.mCcms.getProductType()).setProvDuration(this.mCcms.getProvDuration()).setNoOfRecurrance(this.mCcms.getNoOfRecurrance()).setPrice(this.mCcms.getPrice()).setDiscount(this.mCcms.getDiscount()).setVoiceCategory(this.mCcms.getVoiceCategory()).setDataCategory(this.mCcms.getDataCategory()).setMinsValue(this.mCcms.getMinsValue()).setDataValue(this.mCcms.getDataValue()).setProvStepValueMins(this.mCcms.getProvStepValueMins()).setOfferAudienceLevel(this.mCcms.getOfferAudienceLevel()).setUACIOfferTrackingCode(this.mCcms.getUACIOfferTrackingCode()).setOfferCode1(this.mCcms.getOfferCode1()).setScore(this.mCcms.getScore()).setZone(this.mCcms.getZone()).setWave(this.mCcms.getWave()).setValidity(this.mCcms.getValidity()).setTreatmentCode(this.mCcms.getTreatmentCode()), this.mRedeemCouponCallback);
            }
            return;
        }
        if (view.getId() == R.id.ll_terms_inner) {
            if (this.mIsTermsPressed) {
                this.mIsTermsPressed = false;
                this.mTvTermsValue.setVisibility(8);
                this.mIvTermsArrow.setImageDrawable(this.getDrawable(R.drawable.ic_down_dark_new));
            } else {
                this.mIsTermsPressed = true;
                this.mTvTermsValue.setVisibility(0);
                this.mIvTermsArrow.setImageDrawable(this.getDrawable(R.drawable.ic_up_dark_new));
            }
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        if (WarpUtils.getUserNonTelco((Context)this)) {
            this.nonTelcoDialog();
        }
        if (this.mCouponset != null) {
            this.mTvCouponsetTitle.setText((CharSequence)this.mCouponset.getName());
            this.mTvCouponsetSubtitle.setText((CharSequence)HtmlCompat.fromHtml((String)this.mCouponset.getDescription(), (int)63));
            this.mTvCouponsetSubtitle.setMovementMethod(LinkMovementMethod.getInstance());
            this.mTvTermsValue.setText((CharSequence)HtmlCompat.fromHtml((String)this.mCouponset.getTerms(), (int)63));
            this.mTvTermsValue.setMovementMethod(LinkMovementMethod.getInstance());
            if (!TextUtils.isEmpty((CharSequence)this.mCouponset.getImgPreview())) {
                ((RequestBuilder)Glide.with((Activity)this).load(this.mCouponset.getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(this.mIvCouponsetPhoto);
            } else {
                Glide.with((Activity)this).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(this.mIvCouponsetPhoto);
            }
        } else {
            Glide.with((Activity)this).load(Integer.valueOf(R.drawable.ic_cosmote_logo_horizontal_grey)).into(this.mIvCouponsetPhoto);
        }
        this.mLlTerms.setOnClickListener((View.OnClickListener)this);
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mLlRedeem.setOnClickListener((View.OnClickListener)this);
    }

    private void showDialog(boolean success, int status) {
        if (success) {
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("loyalty_offer_activated");
            analyticsEvent.setParameter("name", this.mLoyalty.getTitle());
            analyticsEvent.setParameter("type", "coupon");
            analyticsEvent.setParameter("successful", "true");
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
            if (!this.isFinishing()) {
                this.mAlertDialogCouponset = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_success_couponset_title).setMessage(R.string.cos_dlg_success_couponset_subtitle).setPositiveButton(R.string.cos_dlg_positive_button4, (dialogPositive, whichPositive) -> {
                    dialogPositive.dismiss();
                    if (success) {
                        this.onBackPressed();
                        Intent intent = new Intent((Context)this, ActiveCouponsActivity.class);
                        this.startActivity(intent);
                    }
                }).setNegativeButton(R.string.cos_dlg_negative_button6, (dialogNegative, whichNegative) -> {
                    dialogNegative.dismiss();
                    if (success) {
                        this.onBackPressed();
                    }
                }).setCancelable(false).show();
            }
        } else {
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("loyalty_offer_activated");
            analyticsEvent.setParameter("name", this.mLoyalty.getTitle());
            analyticsEvent.setParameter("type", "coupon");
            analyticsEvent.setParameter("successful", "false");
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
            if (status == 3) {
                if (!this.isFinishing()) {
                    this.mAlertDialogCouponset = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_error_title).setMessage(R.string.cos_dlg_error_subtitle_non_buyable).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
                }
            } else if (status == 5) {
                if (!this.isFinishing()) {
                    this.mAlertDialogCouponset = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_error_title).setMessage(R.string.cos_dlg_error_subtitle_no_points).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
                }
            } else if (status == 6) {
                if (!this.isFinishing()) {
                    this.mAlertDialogCouponset = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_coupon_depleted_title).setMessage(R.string.cos_dlg_coupon_depleted_message).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
                }
            } else if (!this.isFinishing()) {
                this.mAlertDialogCouponset = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_error_title).setMessage(R.string.cos_dlg_error_subtitle).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).show();
            }
        }
    }

    private void nonTelcoDialog() {
        if (!this.isFinishing()) {
            this.mAlertDialogNonTelco = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_non_telco_title).setMessage(R.string.cos_dlg_non_telco).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                dialogPositive.dismiss();
                this.onBackPressed();
            }).setCancelable(false).show();
        }
    }
}

