/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AppCompatActivity;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedHashSet;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.ContextualActivity;
import ly.warp.sdk.activities.CouponsetInfoActivity;
import ly.warp.sdk.activities.TelcoActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.LoyaltyGiftsForYouOfferClickEvent;
import ly.warp.sdk.io.models.LoyaltyGiftsForYouPackage;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.MergedGifts;
import ly.warp.sdk.services.EventCampaignService;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.MergedGiftsAdapter;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class GiftsForYouActivity
extends AppCompatActivity
implements View.OnClickListener {
    private ImageView mIvBack;
    private ImageView mIvPopupClose;
    private TextView mTvTitle;
    private LinearLayout mLlGiftsPopup;
    private ArrayList<MergedGifts> mData = new ArrayList();
    private RecyclerView mRecyclerMergedGifts;
    private MergedGiftsAdapter mAdapterMergedGifts;
    private ArrayList<Campaign> mValuesList = new ArrayList();
    private ArrayList<LoyaltyGiftsForYouPackage> mSeasonalList = new ArrayList();
    private HashSet<LoyaltyGiftsForYouPackage> mHashSetSeasonalList = new HashSet();
    private ArrayList<LoyaltyContextualOfferModel> mContextualList = new ArrayList();
    private int mTimer = 0;
    private Handler mSecondsHandler;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_gifts_for_you);
        this.mSecondsHandler = new Handler();
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_list_close);
        this.mTvTitle = (TextView)this.findViewById(R.id.textView3);
        this.mIvPopupClose = (ImageView)this.findViewById(R.id.iv_popup_gifts_close);
        this.mLlGiftsPopup = (LinearLayout)this.findViewById(R.id.ll_gifts_popup);
        this.mRecyclerMergedGifts = (RecyclerView)this.findViewById(R.id.rv_merged_gifts);
        this.filterItems();
        this.mergeDatasets();
        this.initViews();
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "GiftsForYouScreen");
        this.mTimer = 0;
        this.mSecondsHandler.post(new Runnable(){

            @Override
            public void run() {
                GiftsForYouActivity.this.mTimer++;
                GiftsForYouActivity.this.mSecondsHandler.postDelayed((Runnable)this, 1000L);
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onPause() {
        super.onPause();
        if (this.mSecondsHandler != null) {
            this.mSecondsHandler.removeCallbacksAndMessages(null);
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
            analyticsEvent.setParameter("name", "GiftsForYou");
            analyticsEvent.setParameter("seconds", String.valueOf(this.mTimer));
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
        }
    }

    protected void onStart() {
        super.onStart();
        EventBus.getDefault().register((Object)this);
    }

    protected void onStop() {
        super.onStop();
        EventBus.getDefault().unregister((Object)this);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_list_close) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.iv_popup_gifts_close) {
            this.mLlGiftsPopup.setVisibility(8);
            WarpUtils.setGiftsPopup((Context)this, false);
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 1004) {
            OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
            WorkManager.getInstance((Context)this).enqueue((WorkRequest)mywork);
        }
    }

    @Subscribe
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getCcmsAdded() != null || event.getCampaignsAdded() != null) {
            this.filterItems();
            this.mergeDatasets();
            this.runOnUiThread(this::initViews2);
        }
    }

    private void initViews() {
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mIvPopupClose.setOnClickListener((View.OnClickListener)this);
        if (this.mData != null && this.mData.size() > 0) {
            this.mRecyclerMergedGifts.setNestedScrollingEnabled(false);
            this.mRecyclerMergedGifts.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
            this.mAdapterMergedGifts = new MergedGiftsAdapter((Context)this, this.mData);
            this.mRecyclerMergedGifts.setAdapter((RecyclerView.Adapter)this.mAdapterMergedGifts);
            this.mAdapterMergedGifts.getPositionClicks().doOnNext(this::handleGiftItemClick).doOnError(error -> {}).subscribe();
        }
    }

    private void initViews2() {
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mIvPopupClose.setOnClickListener((View.OnClickListener)this);
        if (this.mData != null && this.mData.size() > 0) {
            this.mAdapterMergedGifts.updateData(this.mData);
        }
    }

    private void handleGiftItemClick(MergedGifts dataItem) {
        block30: {
            if (dataItem.getDataType() == 1) {
                WarpUtils.log("GFY_CLICK " + dataItem.getCampaign().toString());
                EventBus.getDefault().post((Object)new WarplyEventBusManager(new LoyaltyGiftsForYouOfferClickEvent()));
                if (dataItem.getCampaign().getType().equals("coupon")) {
                    block29: {
                        if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() != null && WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() > 0) {
                            LoyaltyContextualOfferModel ccmsItem = null;
                            for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                                if (!ccms.getLoyaltyCampaignId().equals(dataItem.getCampaign().getSessionUUID())) continue;
                                ccmsItem = ccms;
                                break;
                            }
                            if (ccmsItem != null) {
                                block28: {
                                    try {
                                        JSONObject campaignSettings = WarpJSONParser.getJSONFromString(dataItem.getCampaign().getCampaignTypeSettings());
                                        if (campaignSettings == null) break block28;
                                        if (campaignSettings.has("couponset")) {
                                            String cpnUuid = campaignSettings.optString("couponset");
                                            for (Couponset cpns : WarplyManagerHelper.getCouponsets()) {
                                                if (!cpns.getUuid().equals(cpnUuid)) continue;
                                                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                                                analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                                                analyticsEvent.setParameter("name", dataItem.getCampaign().getTitle());
                                                analyticsEvent.setParameter("type", "coupon");
                                                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                                                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Loyalty".concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                                                WarplyManager.getSingleCampaign(dataItem.getCampaign().getSessionUUID());
                                                Intent intent = new Intent((Context)this, CouponsetInfoActivity.class);
                                                intent.putExtra("couponset", cpns.getUuid());
                                                intent.putExtra("loyalty", dataItem.getCampaign().getSessionUUID());
                                                intent.putExtra("ccms", (Serializable)ccmsItem);
                                                this.startActivityForResult(intent, 1004);
                                                break block28;
                                            }
                                            break block28;
                                        }
                                        if (!WarplyManagerHelper.noInternetDialog((Context)this, true)) {
                                            WarplyManagerHelper.noInternetDialog((Activity)this);
                                            return;
                                        }
                                        WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Loyalty".concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                                        this.startActivityForResult(WarpViewActivity.createIntentFromURL((Context)this, WarplyManagerHelper.constructCampaignUrl(dataItem.getCampaign())), 1004);
                                    }
                                    catch (Exception exception) {
                                        exception.printStackTrace();
                                    }
                                }
                                return;
                            }
                        }
                        try {
                            JSONObject campaignSettings = WarpJSONParser.getJSONFromString(dataItem.getCampaign().getCampaignTypeSettings());
                            if (campaignSettings == null) break block29;
                            if (campaignSettings.has("couponset")) {
                                String cpnUuid = campaignSettings.optString("couponset");
                                for (Couponset cpns : WarplyManagerHelper.getCouponsets()) {
                                    if (!cpns.getUuid().equals(cpnUuid)) continue;
                                    LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                                    analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                                    analyticsEvent.setParameter("name", dataItem.getCampaign().getTitle());
                                    analyticsEvent.setParameter("type", "coupon");
                                    EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                                    WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Loyalty".concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                                    WarplyManager.getSingleCampaign(dataItem.getCampaign().getSessionUUID());
                                    Intent intent = new Intent((Context)this, CouponsetInfoActivity.class);
                                    intent.putExtra("couponset", cpns.getUuid());
                                    intent.putExtra("loyalty", dataItem.getCampaign().getSessionUUID());
                                    this.startActivityForResult(intent, 1004);
                                    break block29;
                                }
                                break block29;
                            }
                            if (!WarplyManagerHelper.noInternetDialog((Context)this, true)) {
                                WarplyManagerHelper.noInternetDialog((Activity)this);
                                return;
                            }
                            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Loyalty".concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                            this.startActivityForResult(WarpViewActivity.createIntentFromURL((Context)this, WarplyManagerHelper.constructCampaignUrl(dataItem.getCampaign())), 1004);
                        }
                        catch (Exception exception) {
                            exception.printStackTrace();
                        }
                    }
                    return;
                }
                try {
                    JSONObject extraFields = WarpJSONParser.getJSONFromString(dataItem.getCampaign().getExtraFields());
                    if (extraFields == null) break block30;
                    if (extraFields.has("type") && extraFields.optString("type").equals("telco")) {
                        for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                            if (!ccms.getLoyaltyCampaignId().equals(dataItem.getCampaign().getSessionUUID())) continue;
                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                            analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                            analyticsEvent.setParameter("name", ccms.getTitle());
                            analyticsEvent.setParameter("type", "gift");
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Telco".concat(":").concat(ccms.getSessionId()));
                            WarplyManager.getSingleCampaign(dataItem.getCampaign().getSessionUUID());
                            Intent intent = new Intent((Context)this, TelcoActivity.class);
                            intent.putExtra("ccms", (Serializable)ccms);
                            intent.putExtra("loyalty", dataItem.getCampaign().getSessionUUID());
                            this.startActivityForResult(intent, 1004);
                            break;
                        }
                        return;
                    }
                    if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                        for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                            if (!ccms.getLoyaltyCampaignId().equals(dataItem.getCampaign().getSessionUUID())) continue;
                            if (!WarplyManagerHelper.noInternetDialog((Context)this, true)) {
                                WarplyManagerHelper.noInternetDialog((Activity)this);
                                return;
                            }
                            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Contextual".concat(":").concat(ccms.getSessionId()));
                            this.startActivityForResult(WarpViewActivity.createIntentFromURL((Context)this, WarplyManagerHelper.constructCcmsUrl(dataItem.getCampaign(), ccms)), 1004);
                            break block30;
                        }
                        break block30;
                    }
                    if (!WarplyManagerHelper.noInternetDialog((Context)this, true)) {
                        WarplyManagerHelper.noInternetDialog((Activity)this);
                        return;
                    }
                    WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Loyalty".concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                    this.startActivityForResult(WarpViewActivity.createIntentFromURL((Context)this, WarplyManagerHelper.constructCampaignUrl(dataItem.getCampaign())), 1004);
                }
                catch (Exception exception) {
                    if (!WarplyManagerHelper.noInternetDialog((Context)this, true)) {
                        WarplyManagerHelper.noInternetDialog((Activity)this);
                        return;
                    }
                    WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Loyalty".concat(":").concat(dataItem.getCampaign().getSessionUUID()));
                    this.startActivityForResult(WarpViewActivity.createIntentFromURL((Context)this, WarplyManagerHelper.constructCampaignUrl(dataItem.getCampaign())), 1004);
                }
            } else if (dataItem.getDataType() == 2) {
                LoyaltyGiftsForYouOfferClickEvent seasonalCLick = new LoyaltyGiftsForYouOfferClickEvent();
                seasonalCLick.setTitle(dataItem.getSeasonalList().getTitle());
                seasonalCLick.setLoyaltyPackageId(dataItem.getSeasonalList().getLoyaltyPackageId());
                seasonalCLick.setImageUrl(dataItem.getSeasonalList().getImageUrl());
                seasonalCLick.setContext((Context)this);
                EventBus.getDefault().post((Object)new WarplyEventBusManager(seasonalCLick));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                analyticsEvent.setParameter("name", dataItem.getSeasonalList().getTitle());
                analyticsEvent.setParameter("type", "seasonal");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
            } else if (dataItem.getDataType() == 3) {
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                analyticsEvent.setParameter("name", dataItem.getCCMS().getTitle());
                analyticsEvent.setParameter("type", "gift");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Contextual".concat(":").concat(dataItem.getCCMS().getSessionId()));
                Intent intent = new Intent((Context)this, ContextualActivity.class);
                intent.putExtra("ccms", (Serializable)dataItem.getCCMS());
                this.startActivity(intent);
            }
        }
    }

    private void mergeDatasets() {
        MergedGifts data;
        this.mData.clear();
        if (this.mSeasonalList != null && this.mSeasonalList.size() > 0) {
            Log.v((String)"SEASONAL", (String)String.valueOf(this.mSeasonalList.size()));
            for (LoyaltyGiftsForYouPackage seasonal : this.mSeasonalList) {
                data = new MergedGifts();
                data.setCampaign(null);
                data.setSeasonalList(seasonal);
                data.setCCMS(null);
                data.setDataType(2);
                this.mData.add(data);
            }
        }
        if (this.mContextualList != null && this.mContextualList.size() > 0) {
            Log.v((String)"CCMS", (String)String.valueOf(this.mContextualList.size()));
            for (LoyaltyContextualOfferModel ccmsItem : this.mContextualList) {
                data = new MergedGifts();
                data.setCampaign(null);
                data.setSeasonalList(null);
                data.setCCMS(ccmsItem);
                data.setDataType(3);
                this.mData.add(data);
            }
        }
        if (this.mValuesList != null && this.mValuesList.size() > 0) {
            Log.v((String)"GIFTS_FOR_YOU", (String)String.valueOf(this.mValuesList.size()));
            for (Campaign campaign : this.mValuesList) {
                data = new MergedGifts();
                data.setCampaign(campaign);
                data.setSeasonalList(null);
                data.setCCMS(null);
                data.setDataType(1);
                this.mData.add(data);
            }
        }
        LinkedHashSet<MergedGifts> set = new LinkedHashSet<MergedGifts>(this.mData);
        this.mData.clear();
        this.mData.addAll(set);
    }

    private void filterItems() {
        if (WarplyManagerHelper.getSeasonalList() != null && WarplyManagerHelper.getSeasonalList().size() > 0) {
            this.mHashSetSeasonalList.clear();
            this.mHashSetSeasonalList.addAll(WarplyManagerHelper.getSeasonalList());
            this.mSeasonalList.clear();
            this.mSeasonalList.addAll(this.mHashSetSeasonalList);
        }
        if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() != null && WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() > 0) {
            this.mContextualList.clear();
            for (LoyaltyContextualOfferModel ccmsItem : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                if (!TextUtils.isEmpty((CharSequence)ccmsItem.getLoyaltyCampaignId()) && !ccmsItem.getLoyaltyCampaignId().equals("NA") || !ccmsItem.getZone().equals("COSMOTE_APP_GIFTS4U")) continue;
                this.mContextualList.add(ccmsItem);
            }
        }
        this.mValuesList.clear();
        ArrayList<Campaign> gfyList = new ArrayList<Campaign>();
        if (WarplyManagerHelper.getCampaignListAll() != null && WarplyManagerHelper.getCampaignListAll().size() > 0) {
            if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() == null || WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() == 0) {
                for (Campaign camp : WarplyManagerHelper.getCampaignListAll()) {
                    if (!camp.getOfferCategory().equals("gifts_for_you")) continue;
                    try {
                        JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                        if (extraFields == null || extraFields.length() != 0 && (extraFields.has("ccms_offer") || extraFields.has("type"))) continue;
                        gfyList.add(camp);
                    }
                    catch (Exception exception) {
                        gfyList.add(camp);
                    }
                }
            } else {
                block6: for (Campaign camp : WarplyManagerHelper.getCampaignListAll()) {
                    if (!camp.getOfferCategory().equals("gifts_for_you")) continue;
                    try {
                        JSONObject extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                        if (extraFields == null) continue;
                        if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                            for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                                if (!ccms.getLoyaltyCampaignId().equals(camp.getSessionUUID())) continue;
                                gfyList.add(camp);
                                continue block6;
                            }
                            continue;
                        }
                        gfyList.add(camp);
                    }
                    catch (Exception exception) {
                        gfyList.add(camp);
                    }
                }
            }
            WarpUtils.log("GFY_FILTER_LIST_COUNT: " + String.valueOf(gfyList.size()));
            WarpUtils.log("GFY_FILTER_LIST_JSON: " + String.valueOf(gfyList.toString()));
            this.mValuesList.clear();
            this.mValuesList.addAll(gfyList);
            WarpUtils.log("GFY_VAR_LIST_COUNT: " + String.valueOf(this.mValuesList.size()));
            WarpUtils.log("GFY_VAR_LIST_JSON: " + String.valueOf(this.mValuesList.toString()));
        }
    }
}

