/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.content.res.AssetManager;
import android.os.Bundle;
import android.os.Handler;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.widget.ImageView;
import android.widget.RelativeLayout;
import android.widget.TextView;
import io.github.inflationx.calligraphy3.CalligraphyTypefaceSpan;
import io.github.inflationx.calligraphy3.TypefaceUtils;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.util.Locale;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.LoyaltyAnalysisActivity;
import ly.warp.sdk.activities.LoyaltyMarketAnalysisActivity;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.WarplyBoxAnalysisEventModel;
import ly.warp.sdk.io.models.WarplyDealsAnalysisEventModel;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class LoyaltyHistoryActivity
extends Activity
implements View.OnClickListener {
    private ImageView mIvBack;
    private int mTimer = 0;
    private Handler mSecondsHandler;
    private TextView mTvFavValue;
    private TextView mTvDealsValue;
    private TextView mTvGiftsValue;
    private TextView mTvMarketValue;
    private TextView mTvDealsValueAll;
    private TextView mTvGiftsValueAll;
    private TextView mTvMarketAll;
    private TextView mTvBoxValue;
    private TextView mTvBoxValueAll;
    private float mFavValue = 0.0f;
    private float countValue = 0.0f;
    private RelativeLayout mRlDealsBanner;
    private RelativeLayout mRlGiftsBanner;
    private RelativeLayout mRlUnifiedBanner;
    private RelativeLayout mRlBoxBanner;
    private boolean mDealsBannerPressed = false;
    private boolean mHistoryPressed = false;
    private boolean mHistoryMarketPressed = false;
    private boolean mBoxBannerPressed = false;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_loyalty_history);
        this.mSecondsHandler = new Handler();
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_loyalty_history_close);
        this.mTvFavValue = (TextView)this.findViewById(R.id.tv_exp_value);
        this.mTvDealsValue = (TextView)this.findViewById(R.id.tv_deals_value);
        this.mTvBoxValue = (TextView)this.findViewById(R.id.tv_box_value);
        this.mTvGiftsValue = (TextView)this.findViewById(R.id.tv_gifts_value);
        this.mTvMarketValue = (TextView)this.findViewById(R.id.tv_market_value);
        this.mTvDealsValueAll = (TextView)this.findViewById(R.id.tv_deals_value_all);
        this.mTvBoxValueAll = (TextView)this.findViewById(R.id.tv_box_value_all);
        this.mTvGiftsValueAll = (TextView)this.findViewById(R.id.tv_gifts_value_all);
        this.mTvMarketAll = (TextView)this.findViewById(R.id.tv_market_value_all);
        this.mRlDealsBanner = (RelativeLayout)this.findViewById(R.id.rl_first_banner);
        this.mRlBoxBanner = (RelativeLayout)this.findViewById(R.id.rl_fourth_banner);
        this.mRlGiftsBanner = (RelativeLayout)this.findViewById(R.id.rl_third_banner);
        this.mRlUnifiedBanner = (RelativeLayout)this.findViewById(R.id.rl_second_banner);
        this.initViews();
    }

    public void onStart() {
        super.onStart();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void onDestroy() {
        super.onDestroy();
        EventBus.getDefault().unregister((Object)this);
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "HistoryScreen");
        this.mTimer = 0;
        this.mSecondsHandler.post(new Runnable(){

            @Override
            public void run() {
                LoyaltyHistoryActivity.this.mTimer++;
                LoyaltyHistoryActivity.this.mSecondsHandler.postDelayed((Runnable)this, 1000L);
            }
        });
        this.mDealsBannerPressed = false;
        this.mHistoryPressed = false;
        this.mHistoryMarketPressed = false;
        this.mBoxBannerPressed = false;
    }

    public void onPause() {
        super.onPause();
        if (this.mSecondsHandler != null) {
            this.mSecondsHandler.removeCallbacksAndMessages(null);
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
            analyticsEvent.setParameter("name", "HistoryScreen");
            analyticsEvent.setParameter("seconds", String.valueOf(this.mTimer));
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
        }
    }

    @Subscribe
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getNavigateBackEventModel() != null) {
            this.onBackPressed();
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_loyalty_history_close) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.rl_first_banner) {
            if (!this.mDealsBannerPressed) {
                this.mDealsBannerPressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyHistoryScreen".concat(":").concat("DealsBanner"));
                WarplyDealsAnalysisEventModel warplyDealsAnalysisEventModel = new WarplyDealsAnalysisEventModel();
                warplyDealsAnalysisEventModel.setPressed(true);
                EventBus.getDefault().post((Object)new WarplyEventBusManager(warplyDealsAnalysisEventModel));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_deals_for_you_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
            }
            return;
        }
        if (view.getId() == R.id.rl_third_banner) {
            if (!this.mHistoryPressed) {
                this.mHistoryPressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyHistoryScreen".concat(":").concat("LoyaltyBanner"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_gifts_for_you_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent((Context)this, LoyaltyAnalysisActivity.class);
                this.startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.rl_second_banner) {
            if (!this.mHistoryMarketPressed) {
                this.mHistoryMarketPressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyHistoryScreen".concat(":").concat("MarketBanner"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_market_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent((Context)this, LoyaltyMarketAnalysisActivity.class);
                this.startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.rl_fourth_banner && !this.mBoxBannerPressed) {
            this.mBoxBannerPressed = true;
            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyHistoryScreen".concat(":").concat("BoxBanner"));
            WarplyBoxAnalysisEventModel warplyBoxAnalysisEventModel = new WarplyBoxAnalysisEventModel();
            warplyBoxAnalysisEventModel.setPressed(true);
            warplyBoxAnalysisEventModel.setActivity(this);
            EventBus.getDefault().post((Object)new WarplyEventBusManager(warplyBoxAnalysisEventModel));
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("did_tap_box_badge");
            analyticsEvent.setParameter("screen", "Loyalty Wallet");
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        CalligraphyTypefaceSpan typefaceBoldSpanThird;
        SpannableStringBuilder sBuilderThird;
        String badgeValue;
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mRlDealsBanner.setOnClickListener((View.OnClickListener)this);
        this.mRlGiftsBanner.setOnClickListener((View.OnClickListener)this);
        this.mRlUnifiedBanner.setOnClickListener((View.OnClickListener)this);
        this.mRlBoxBanner.setOnClickListener((View.OnClickListener)this);
        String badgeValueFirst = String.format(Locale.GERMAN, "%.02f", Float.valueOf(WarplyManagerHelper.getDealsCouponsSum()));
        this.mTvDealsValue.setText((CharSequence)String.format(this.getString(R.string.cos_value), badgeValueFirst));
        if (String.valueOf(WarplyManagerHelper.getDealsCouponsSum()).length() >= 3) {
            this.mTvDealsValue.setTextSize(12.0f);
        } else {
            this.mTvDealsValue.setTextSize(14.0f);
        }
        SpannableStringBuilder sBuilder = new SpannableStringBuilder();
        sBuilder.append((CharSequence)String.format(this.getString(R.string.cos_deals_win_title_cos), badgeValueFirst));
        CalligraphyTypefaceSpan typefaceBoldSpanFirst = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-Bold.ttf"));
        sBuilder.setSpan((Object)typefaceBoldSpanFirst, 24, 24 + badgeValueFirst.length() + 1, 33);
        this.mTvDealsValueAll.setText((CharSequence)sBuilder, TextView.BufferType.SPANNABLE);
        this.mFavValue += WarplyManagerHelper.getDealsCouponsSum();
        if (WarplyManagerHelper.getMarketCoupons() != null && WarplyManagerHelper.getMarketCoupons().size() > 0) {
            this.countValue = 0.0f;
            if (WarplyManagerHelper.getCouponRedeemedList().size() > 0) {
                for (Coupon cou : WarplyManagerHelper.getCouponRedeemedList()) {
                    if (!cou.getCouponsetDetails().getCouponsetType().equals("supermarket")) continue;
                    this.countValue += Float.parseFloat(cou.getDiscount());
                    cou.setDescription(cou.getCouponsetDetails().getShortDescription());
                    cou.setImage(cou.getCouponsetDetails().getImgPreview());
                    cou.setName(cou.getCouponsetDetails().getName());
                    cou.setMerchantUuid(cou.getCouponsetDetails().getMerchantUuid());
                    cou.setInnerText(cou.getCouponsetDetails().getInnerText());
                    cou.setDiscount_type(cou.getCouponsetDetails().getDiscount_type());
                    cou.setFinal_price(cou.getCouponsetDetails().getFinal_price());
                }
            }
            this.mFavValue += this.countValue;
            badgeValue = String.format(Locale.GERMAN, "%.02f", Float.valueOf(this.countValue));
            this.mTvMarketValue.setText((CharSequence)String.format(this.getString(R.string.cos_value), badgeValue));
            if (String.valueOf(this.countValue).length() >= 3) {
                this.mTvMarketValue.setTextSize(12.0f);
            } else {
                this.mTvMarketValue.setTextSize(14.0f);
            }
            sBuilderThird = new SpannableStringBuilder();
            sBuilderThird.append((CharSequence)String.format(this.getString(R.string.cos_supermarket_win), badgeValue));
            typefaceBoldSpanThird = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-Bold.ttf"));
            sBuilderThird.setSpan((Object)typefaceBoldSpanThird, 24, 24 + badgeValue.length() + 1, 33);
            this.mTvMarketAll.setText((CharSequence)sBuilderThird, TextView.BufferType.SPANNABLE);
        } else {
            badgeValue = String.format(Locale.GERMAN, "%.02f", Float.valueOf(0.0f));
            this.mTvMarketValue.setText((CharSequence)String.format(this.getString(R.string.cos_value), badgeValue));
            sBuilderThird = new SpannableStringBuilder();
            sBuilderThird.append((CharSequence)String.format(this.getString(R.string.cos_supermarket_win), badgeValue));
            typefaceBoldSpanThird = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-Bold.ttf"));
            sBuilderThird.setSpan((Object)typefaceBoldSpanThird, 24, 24 + badgeValue.length() + 1, 33);
            this.mTvMarketAll.setText((CharSequence)sBuilderThird, TextView.BufferType.SPANNABLE);
        }
        if (WarplyManagerHelper.getLoyaltyBadge() != null && (WarplyManagerHelper.getLoyaltyBadge().getCouponCount() > 0 || WarplyManagerHelper.getLoyaltyBadge().getCouponCount() == 0)) {
            badgeValue = String.format(Locale.GERMAN, "%.02f", Float.valueOf(WarplyManagerHelper.getLoyaltyBadge().getValue()));
            this.mTvGiftsValue.setText((CharSequence)String.format(this.getString(R.string.cos_value), badgeValue));
            if (String.valueOf(WarplyManagerHelper.getLoyaltyBadge().getValue()).length() >= 3) {
                this.mTvGiftsValue.setTextSize(12.0f);
            } else {
                this.mTvGiftsValue.setTextSize(14.0f);
            }
            SpannableStringBuilder sBuilderSecond = new SpannableStringBuilder();
            sBuilderSecond.append((CharSequence)String.format(this.getString(R.string.cos_deals_win_title), badgeValue));
            CalligraphyTypefaceSpan typefaceBoldSpanSecond = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-Bold.ttf"));
            sBuilderSecond.setSpan((Object)typefaceBoldSpanSecond, 24, 24 + badgeValue.length() + 1, 33);
            this.mTvGiftsValueAll.setText((CharSequence)sBuilderSecond, TextView.BufferType.SPANNABLE);
            this.mFavValue += WarplyManagerHelper.getLoyaltyBadge().getValue();
        }
        String badgeValueFourth = String.format(Locale.GERMAN, "%.02f", Float.valueOf(WarplyManagerHelper.getBoxCouponsSum()));
        this.mTvBoxValue.setText((CharSequence)String.format(this.getString(R.string.cos_value), badgeValueFourth));
        if (String.valueOf(WarplyManagerHelper.getBoxCouponsSum()).length() >= 3) {
            this.mTvBoxValue.setTextSize(12.0f);
        } else {
            this.mTvBoxValue.setTextSize(14.0f);
        }
        SpannableStringBuilder sBuilderFourth = new SpannableStringBuilder();
        sBuilderFourth.append((CharSequence)String.format(this.getString(R.string.cos_box_win_title_cos), badgeValueFourth));
        CalligraphyTypefaceSpan typefaceBoldSpanFourth = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-Bold.ttf"));
        sBuilderFourth.setSpan((Object)typefaceBoldSpanFourth, 24, 24 + badgeValueFourth.length() + 1, 33);
        this.mTvBoxValueAll.setText((CharSequence)sBuilderFourth, TextView.BufferType.SPANNABLE);
        this.mFavValue += WarplyManagerHelper.getBoxCouponsSum();
        String allValue = String.format(Locale.GERMAN, "%.02f", Float.valueOf(this.mFavValue));
        this.mTvFavValue.setText((CharSequence)String.format(this.getString(R.string.cos_value), allValue));
    }
}

