/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.res.AssetManager;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.SpannableStringBuilder;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import io.github.inflationx.calligraphy3.CalligraphyTypefaceSpan;
import io.github.inflationx.calligraphy3.TypefaceUtils;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.util.ArrayList;
import java.util.Collections;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import ly.warp.sdk.R;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.SharingCoupon;
import ly.warp.sdk.io.models.SharingList;
import ly.warp.sdk.io.request.WarplySharingHistoryRequest;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.ExpiredCouponAdapter;
import ly.warp.sdk.views.adapters.SharedCouponAdapter;
import org.greenrobot.eventbus.EventBus;

public class LoyaltyMarketAnalysisActivity
extends Activity
implements View.OnClickListener {
    private ImageView mIvBack;
    private TextView mTvCouponsValueAll;
    private TextView mTvSharedEmpty;
    private TextView mTvExpiredEmpty;
    private RecyclerView mRvExpiredCoupons;
    private RecyclerView mRvSharedCoupons;
    private ExpiredCouponAdapter mAdapterExpiredCoupons;
    private SharedCouponAdapter mAdapterSharedCoupons;
    private LinearLayout mLlExpiredTab;
    private LinearLayout mLlSharedTab;
    private LinearLayout mLlShowMoreExpired;
    private LinearLayout mLlShowMoreShared;
    private RelativeLayout mRlExpiredView;
    private CardView mRlSharedView;
    private CardView mCvExpiredInfoView;
    private SharingList mSharedCoupons = new SharingList();
    private int mTimer = 0;
    private Handler mSecondsHandler;
    private ArrayList<Coupon> mExpiredMarketCoupons = new ArrayList();
    private float countValue = 0.0f;
    private CallbackReceiver<SharingList> mSharingHistoryCallback = new CallbackReceiver<SharingList>(){

        @Override
        public void onSuccess(SharingList result) {
            if (result != null && result.size() > 0 && WarplyManagerHelper.getCouponsetsDeals() != null && WarplyManagerHelper.getCouponsetsDeals().size() > 0) {
                block0: for (SharingCoupon shCoupon : result) {
                    for (Couponset cpnset : WarplyManagerHelper.getCouponsetsDeals()) {
                        if (!shCoupon.getCouponsetUuid().equals(cpnset.getUuid())) continue;
                        SharingCoupon newShCoupon = new SharingCoupon();
                        newShCoupon = shCoupon;
                        newShCoupon.setName(cpnset.getName());
                        newShCoupon.setFinal_price(cpnset.getFinal_price());
                        LoyaltyMarketAnalysisActivity.this.mSharedCoupons.add(newShCoupon);
                        continue block0;
                    }
                }
            }
            LoyaltyMarketAnalysisActivity.this.runOnUiThread(() -> {
                if (LoyaltyMarketAnalysisActivity.this.mSharedCoupons != null && LoyaltyMarketAnalysisActivity.this.mSharedCoupons.size() > 0) {
                    if (LoyaltyMarketAnalysisActivity.this.mSharedCoupons.size() > 3) {
                        ArrayList<SharingCoupon> tempList = new ArrayList<SharingCoupon>(LoyaltyMarketAnalysisActivity.this.mSharedCoupons.subList(0, 3));
                        LoyaltyMarketAnalysisActivity.this.mRvSharedCoupons.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)LoyaltyMarketAnalysisActivity.this, 1, false));
                        LoyaltyMarketAnalysisActivity.this.mAdapterSharedCoupons = new SharedCouponAdapter((Context)LoyaltyMarketAnalysisActivity.this, tempList);
                        LoyaltyMarketAnalysisActivity.this.mRvSharedCoupons.setAdapter((RecyclerView.Adapter)LoyaltyMarketAnalysisActivity.this.mAdapterSharedCoupons);
                        LoyaltyMarketAnalysisActivity.this.mLlShowMoreShared.setVisibility(0);
                        return;
                    }
                    LoyaltyMarketAnalysisActivity.this.mRvSharedCoupons.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)LoyaltyMarketAnalysisActivity.this, 1, false));
                    LoyaltyMarketAnalysisActivity.this.mAdapterSharedCoupons = new SharedCouponAdapter((Context)LoyaltyMarketAnalysisActivity.this, LoyaltyMarketAnalysisActivity.this.mSharedCoupons);
                    LoyaltyMarketAnalysisActivity.this.mRvSharedCoupons.setAdapter((RecyclerView.Adapter)LoyaltyMarketAnalysisActivity.this.mAdapterSharedCoupons);
                } else {
                    LoyaltyMarketAnalysisActivity.this.mTvSharedEmpty.setVisibility(0);
                }
            });
        }

        @Override
        public void onFailure(int errorCode) {
            WarpUtils.log("SHARED_COUPONS_ERROR " + String.valueOf(errorCode));
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_loyalty_market_analysis);
        this.mSecondsHandler = new Handler();
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_loyalty_analysis_close);
        this.mTvCouponsValueAll = (TextView)this.findViewById(R.id.tv_expired_coupons_title);
        this.mRvExpiredCoupons = (RecyclerView)this.findViewById(R.id.rv_expired_coupons);
        this.mLlExpiredTab = (LinearLayout)this.findViewById(R.id.cl_tab_coupon_analysis).findViewById(R.id.ll_tab_expired);
        this.mLlSharedTab = (LinearLayout)this.findViewById(R.id.cl_tab_coupon_analysis).findViewById(R.id.ll_tab_shared);
        this.mRlExpiredView = (RelativeLayout)this.findViewById(R.id.rl_expired_view);
        this.mRlSharedView = (CardView)this.findViewById(R.id.rl_shared_view);
        this.mRvSharedCoupons = (RecyclerView)this.findViewById(R.id.rv_shared_coupons);
        this.mTvSharedEmpty = (TextView)this.findViewById(R.id.tv_shared_empty);
        this.mTvExpiredEmpty = (TextView)this.findViewById(R.id.tv_expired_empty);
        this.mLlShowMoreExpired = (LinearLayout)this.findViewById(R.id.ll_show_more_expired);
        this.mLlShowMoreShared = (LinearLayout)this.findViewById(R.id.ll_show_more_shared);
        this.mCvExpiredInfoView = (CardView)this.findViewById(R.id.cv_expired_coupons_inner_title);
        if (WarplyManagerHelper.getMarketCoupons() != null && WarplyManagerHelper.getMarketCoupons().size() > 0) {
            ExecutorService executor = Executors.newFixedThreadPool(1);
            executor.submit(() -> {
                if (WarplyManagerHelper.getCouponRedeemedList().size() > 0) {
                    for (Coupon cou : WarplyManagerHelper.getCouponRedeemedList()) {
                        if (!cou.getCouponsetDetails().getCouponsetType().equals("supermarket")) continue;
                        this.countValue += Float.valueOf(cou.getDiscount()).floatValue();
                        this.mExpiredMarketCoupons.add(cou);
                    }
                }
                Collections.sort(this.mExpiredMarketCoupons, (coupon1, coupon2) -> coupon2.getChangesDates().optString("redeemed").compareTo(coupon1.getChangesDates().optString("redeemed")));
                new Handler(Looper.getMainLooper()).post(this::initViews);
                executor.shutdownNow();
            });
        } else {
            this.initViews();
        }
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "LoyaltyMarketHistoryScreen");
        this.mTimer = 0;
        this.mSecondsHandler.post(new Runnable(){

            @Override
            public void run() {
                LoyaltyMarketAnalysisActivity.this.mTimer++;
                LoyaltyMarketAnalysisActivity.this.mSecondsHandler.postDelayed((Runnable)this, 1000L);
            }
        });
        this.mSharedCoupons.clear();
        new Thread(() -> {
            if (!Thread.currentThread().isInterrupted()) {
                WarplyManager.getSharingHistory(new WarplySharingHistoryRequest().setType("supermarket"), this.mSharingHistoryCallback);
            }
            Thread.currentThread().interrupt();
        }).start();
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onPause() {
        super.onPause();
        if (this.mSecondsHandler != null) {
            this.mSecondsHandler.removeCallbacksAndMessages(null);
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
            analyticsEvent.setParameter("name", "MarketCalculator");
            analyticsEvent.setParameter("seconds", String.valueOf(this.mTimer));
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_loyalty_analysis_close) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_tab_expired) {
            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyHistoryScreen".concat(":").concat("TabExpired"));
            this.mLlExpiredTab.setBackgroundResource(R.drawable.bottom_border_light_blue);
            TextView expiredTab = (TextView)this.findViewById(R.id.tv_expired_tab);
            expiredTab.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.cos_light_black));
            CalligraphyTypefaceSpan typefaceBoldSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-Bold.ttf"));
            SpannableStringBuilder sBuilderExpired = new SpannableStringBuilder();
            sBuilderExpired.append((CharSequence)this.getString(R.string.cos_redeemed_coupons_tab));
            sBuilderExpired.setSpan((Object)typefaceBoldSpan, 0, this.getString(R.string.cos_redeemed_coupons_tab).length(), 33);
            expiredTab.setText((CharSequence)sBuilderExpired, TextView.BufferType.SPANNABLE);
            this.mLlSharedTab.setBackgroundResource(R.drawable.bottom_border_transparent);
            TextView sharedTab = (TextView)this.findViewById(R.id.tv_shared_tab);
            sharedTab.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.cos_dark_grey));
            CalligraphyTypefaceSpan typefaceRegularSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-SemiBold.ttf"));
            SpannableStringBuilder sBuilderShared = new SpannableStringBuilder();
            sBuilderShared.append((CharSequence)this.getString(R.string.cos_shared_gifts_tab));
            sBuilderShared.setSpan((Object)typefaceRegularSpan, 0, this.getString(R.string.cos_shared_gifts_tab).length(), 33);
            sharedTab.setText((CharSequence)sBuilderShared, TextView.BufferType.SPANNABLE);
            this.mRlSharedView.setVisibility(8);
            this.mRlExpiredView.setVisibility(0);
            return;
        }
        if (view.getId() == R.id.ll_tab_shared) {
            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyHistoryScreen".concat(":").concat("TabShared"));
            this.mLlSharedTab.setBackgroundResource(R.drawable.bottom_border_light_blue);
            TextView sharedTab = (TextView)this.findViewById(R.id.tv_shared_tab);
            sharedTab.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.cos_light_black));
            CalligraphyTypefaceSpan typefaceBoldSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-Bold.ttf"));
            SpannableStringBuilder sBuilderShared = new SpannableStringBuilder();
            sBuilderShared.append((CharSequence)this.getString(R.string.cos_shared_gifts_tab));
            sBuilderShared.setSpan((Object)typefaceBoldSpan, 0, this.getString(R.string.cos_shared_gifts_tab).length(), 33);
            sharedTab.setText((CharSequence)sBuilderShared, TextView.BufferType.SPANNABLE);
            this.mLlExpiredTab.setBackgroundResource(R.drawable.bottom_border_transparent);
            TextView expiredTab = (TextView)this.findViewById(R.id.tv_expired_tab);
            expiredTab.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.cos_dark_grey));
            CalligraphyTypefaceSpan typefaceRegularSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-SemiBold.ttf"));
            SpannableStringBuilder sBuilderExpired = new SpannableStringBuilder();
            sBuilderExpired.append((CharSequence)this.getString(R.string.cos_redeemed_coupons_tab));
            sBuilderExpired.setSpan((Object)typefaceRegularSpan, 0, this.getString(R.string.cos_redeemed_coupons_tab).length(), 33);
            expiredTab.setText((CharSequence)sBuilderExpired, TextView.BufferType.SPANNABLE);
            this.mRlExpiredView.setVisibility(8);
            this.mRlSharedView.setVisibility(0);
            return;
        }
        if (view.getId() == R.id.ll_show_more_expired) {
            this.mLlShowMoreExpired.setVisibility(8);
            this.mAdapterExpiredCoupons = new ExpiredCouponAdapter((Context)this, this.mExpiredMarketCoupons, true);
            this.mRvExpiredCoupons.setAdapter((RecyclerView.Adapter)this.mAdapterExpiredCoupons);
            this.mAdapterExpiredCoupons.notifyDataSetChanged();
            return;
        }
        if (view.getId() == R.id.ll_show_more_shared) {
            this.mLlShowMoreShared.setVisibility(8);
            this.mAdapterSharedCoupons = new SharedCouponAdapter((Context)this, this.mSharedCoupons);
            this.mRvSharedCoupons.setAdapter((RecyclerView.Adapter)this.mAdapterSharedCoupons);
            this.mAdapterSharedCoupons.notifyDataSetChanged();
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mLlExpiredTab.setOnClickListener((View.OnClickListener)this);
        this.mLlSharedTab.setOnClickListener((View.OnClickListener)this);
        this.mLlShowMoreExpired.setOnClickListener((View.OnClickListener)this);
        this.mLlShowMoreShared.setOnClickListener((View.OnClickListener)this);
        this.mLlExpiredTab.setBackgroundResource(R.drawable.bottom_border_light_blue);
        TextView expiredTab = (TextView)this.findViewById(R.id.tv_expired_tab);
        expiredTab.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.cos_light_black));
        CalligraphyTypefaceSpan typefaceBoldExpiredSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-Bold.ttf"));
        SpannableStringBuilder sBuilderExpired = new SpannableStringBuilder();
        sBuilderExpired.append((CharSequence)this.getString(R.string.cos_redeemed_coupons_tab));
        sBuilderExpired.setSpan((Object)typefaceBoldExpiredSpan, 0, this.getString(R.string.cos_redeemed_coupons_tab).length(), 33);
        expiredTab.setText((CharSequence)sBuilderExpired, TextView.BufferType.SPANNABLE);
        this.mLlSharedTab.setBackgroundResource(R.drawable.bottom_border_transparent);
        TextView sharedTab = (TextView)this.findViewById(R.id.tv_shared_tab);
        sharedTab.setTextColor(ContextCompat.getColor((Context)this, (int)R.color.cos_dark_grey));
        CalligraphyTypefaceSpan typefaceRegularSharedSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-SemiBold.ttf"));
        SpannableStringBuilder sBuilderShared = new SpannableStringBuilder();
        sBuilderShared.append((CharSequence)this.getString(R.string.cos_shared_gifts_tab));
        sBuilderShared.setSpan((Object)typefaceRegularSharedSpan, 0, this.getString(R.string.cos_shared_gifts_tab).length(), 33);
        sharedTab.setText((CharSequence)sBuilderShared, TextView.BufferType.SPANNABLE);
        String badgeValue = String.format("%.02f", Float.valueOf(this.countValue));
        SpannableStringBuilder sBuilder = new SpannableStringBuilder();
        sBuilder.append((CharSequence)String.format(this.getString(R.string.cos_supermarket_history), badgeValue, String.valueOf(this.mExpiredMarketCoupons.size())));
        CalligraphyTypefaceSpan typefaceBoldSpan = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-Bold.ttf"));
        CalligraphyTypefaceSpan typefaceBoldSpan2 = new CalligraphyTypefaceSpan(TypefaceUtils.load((AssetManager)this.getAssets(), (String)"fonts/PeridotPE-Bold.ttf"));
        sBuilder.setSpan((Object)typefaceBoldSpan, 26, 26 + badgeValue.length() + 1, 33);
        sBuilder.setSpan((Object)typefaceBoldSpan2, 26 + badgeValue.length() + 1 + 18, 26 + badgeValue.length() + 1 + 18 + String.valueOf(this.mExpiredMarketCoupons.size()).length(), 33);
        this.mTvCouponsValueAll.setText((CharSequence)sBuilder, TextView.BufferType.SPANNABLE);
        if (this.mExpiredMarketCoupons != null && this.mExpiredMarketCoupons.size() > 0) {
            if (this.mExpiredMarketCoupons.size() > 3) {
                ArrayList<Coupon> tempList = new ArrayList<Coupon>(this.mExpiredMarketCoupons.subList(0, 3));
                this.mRvExpiredCoupons.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
                this.mAdapterExpiredCoupons = new ExpiredCouponAdapter((Context)this, tempList, true);
                this.mRvExpiredCoupons.setAdapter((RecyclerView.Adapter)this.mAdapterExpiredCoupons);
                this.mLlShowMoreExpired.setVisibility(0);
                return;
            }
            this.mRvExpiredCoupons.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
            this.mAdapterExpiredCoupons = new ExpiredCouponAdapter((Context)this, this.mExpiredMarketCoupons, true);
            this.mRvExpiredCoupons.setAdapter((RecyclerView.Adapter)this.mAdapterExpiredCoupons);
        } else {
            this.mCvExpiredInfoView.setVisibility(8);
            this.mTvExpiredEmpty.setVisibility(0);
        }
    }
}

