/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.ScrollView;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.core.content.ContextCompat;
import androidx.core.widget.NestedScrollView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.util.ArrayList;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.ActiveCouponsActivity;
import ly.warp.sdk.activities.ActiveUnifiedCouponsActivity;
import ly.warp.sdk.activities.LoyaltyAnalysisActivity;
import ly.warp.sdk.activities.LoyaltyHistoryActivity;
import ly.warp.sdk.activities.LoyaltyMarketAnalysisActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.ActiveDFYCouponEventModel;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.io.models.VouchersActivityEventModel;
import ly.warp.sdk.io.models.WarplyDealsAnalysisEventModel;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.views.adapters.ActiveCouponAdapter;
import ly.warp.sdk.views.adapters.MarketCouponAdapter;
import net.cachapa.expandablelayout.ExpandableLayout;
import org.apmem.tools.layouts.FlowLayout;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class LoyaltyWallet
extends Activity
implements View.OnClickListener,
View.OnScrollChangeListener {
    private ImageView mIvBack;
    private ImageView mIvDealsLogo;
    private ImageView mIvProfilePhoto;
    private ImageView mIvExpArrow;
    private TextView mTvUsername;
    private TextView mTvDealsValue;
    private TextView mTvDealsValueAll;
    private TextView mTvUserBadge;
    private TextView mTvGiftsValue;
    private TextView mTvGiftsValueAll;
    private TextView mTvActiveCode;
    private TextView mTvActiveDate;
    private TextView mTvActiveTitle;
    private TextView mTvActiveCouponsHeader;
    private TextView mTvMarketValue;
    private TextView mTvMarketAll;
    private TextView mTvFavValue;
    private TextView mTvFavValueAll;
    private TextView mTvDealsCountBadge;
    private TextView mTvUnifiedCountBadge;
    private TextView mTvGiftsCountBadge;
    private TextView mTvVouchersDisabledTitle;
    private TextView mTvVouchersDisabledSubtitle;
    private TextView mTvVouchersTitle;
    private TextView mTvVouchersSubtitle;
    private ConstraintLayout mClDealsBanner;
    private ConstraintLayout mClDealsView;
    private ConstraintLayout mClGiftsBanner;
    private ConstraintLayout mClToolbar;
    private ConstraintLayout mClMarket;
    private LinearLayout mLlQuestionnaire;
    private LinearLayout mLlUserBadge;
    private LinearLayout mLlEmptyWallet;
    private LinearLayout mLlDeals;
    private LinearLayout mLlGifts;
    private LinearLayout mLlMarketView;
    private LinearLayout mLlHistory;
    private LinearLayout mLlBannerInfo;
    private LinearLayout mLlVouchers;
    private LinearLayout mLlVouchersSpinner;
    private LinearLayout mLlVouchersDisabled;
    private FlowLayout mLlActiveCodesView;
    private float couponDfyValue = 0.0f;
    private float mFavValue = 0.0f;
    private RecyclerView mRecyclerCoupons;
    private RecyclerView mRvMarketCoupons;
    private ActiveCouponAdapter mAdapterCoupons;
    private AlertDialog mAlertDialogNonTelco;
    private AlertDialog mAlertDialogVouchersService;
    private ScrollView mScActiveCodes;
    private NestedScrollView mSvLoyaltyWallet;
    private int mTimer = 0;
    private Handler mSecondsHandler;
    private ArrayList<UnifiedCoupon> mUnifiedCoupons = new ArrayList();
    private float countValue = 0.0f;
    private MarketCouponAdapter mAdapterMarketCoupons;
    private ExpandableLayout mElGifts;
    private boolean mIsStayCollapsed = true;
    private CardView mClExp;
    private CardView mCvVouchers;
    private CardView mCvVouchersDisabled;
    private boolean mDfyPressed = false;
    private boolean mDealsBannerPressed = false;
    private boolean mQuestionnairePressed = false;
    private boolean mHistoryPressed = false;
    private boolean mHistoryMarketPressed = false;
    private boolean mUnifiedPressed = false;
    private boolean mCouponPressed = false;
    private boolean mHistoryBadgePressed = false;
    private boolean mUnifiedCountPressed = false;
    private boolean mGiftsCountPressed = false;
    private RelativeLayout mRlDeals;
    private RelativeLayout mRlUnified;
    private RelativeLayout mRlGifts;
    private View mSeparator;
    private View mSeparatorDisabled;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_loyalty_wallet);
        this.mSecondsHandler = new Handler();
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_back);
        this.mTvUsername = (TextView)this.findViewById(R.id.tv_profile_name);
        this.mLlQuestionnaire = (LinearLayout)this.findViewById(R.id.ll_user_questionnaire);
        this.mLlUserBadge = (LinearLayout)this.findViewById(R.id.ll_user_badge);
        this.mTvUserBadge = (TextView)this.findViewById(R.id.tv_type);
        this.mTvGiftsValue = (TextView)this.findViewById(R.id.tv_gifts_value);
        this.mTvGiftsValueAll = (TextView)this.findViewById(R.id.tv_gifts_value_all);
        this.mClDealsBanner = (ConstraintLayout)this.findViewById(R.id.cl_deals_win_inner_cos);
        this.mClGiftsBanner = (ConstraintLayout)this.findViewById(R.id.cl_deals_win_inner);
        this.mTvDealsValue = (TextView)this.findViewById(R.id.tv_deals_value);
        this.mTvDealsValueAll = (TextView)this.findViewById(R.id.tv_deals_value_all);
        this.mTvActiveCode = (TextView)this.findViewById(R.id.tv_active_deals_text);
        this.mTvActiveDate = (TextView)this.findViewById(R.id.tv_active_deals_date_text);
        this.mIvDealsLogo = (ImageView)this.findViewById(R.id.dfy_logo);
        this.mClDealsView = (ConstraintLayout)this.findViewById(R.id.cl_mygifts);
        this.mLlDeals = (LinearLayout)this.findViewById(R.id.ll_mygifts);
        this.mIvProfilePhoto = (ImageView)this.findViewById(R.id.iv_profile_photo);
        this.mTvActiveTitle = (TextView)this.findViewById(R.id.tv_active_gifts);
        this.mTvActiveCouponsHeader = (TextView)this.findViewById(R.id.tv_active_coupons_header);
        this.mLlEmptyWallet = (LinearLayout)this.findViewById(R.id.ll_empty_wallet);
        this.mLlActiveCodesView = (FlowLayout)this.findViewById(R.id.ll_active_deals_codes_view);
        this.mScActiveCodes = (ScrollView)this.findViewById(R.id.sv_active_deals_codes_view);
        this.mSvLoyaltyWallet = (NestedScrollView)this.findViewById(R.id.sv_loyalty_wallet);
        this.mClToolbar = (ConstraintLayout)this.findViewById(R.id.cl_loyalty_wallet_header);
        this.mLlGifts = (LinearLayout)this.findViewById(R.id.ll_gifts_view);
        this.mLlMarketView = (LinearLayout)this.findViewById(R.id.ll_market_view);
        this.mRvMarketCoupons = (RecyclerView)this.findViewById(R.id.rv_market_coupons);
        this.mRvMarketCoupons.setNestedScrollingEnabled(false);
        this.mRvMarketCoupons.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
        this.mElGifts = (ExpandableLayout)this.findViewById(R.id.el_exp);
        this.mClExp = (CardView)this.findViewById(R.id.cl_exp);
        this.mIvExpArrow = (ImageView)this.findViewById(R.id.iv_exp_arrow);
        this.mTvMarketValue = (TextView)this.findViewById(R.id.tv_market_value);
        this.mTvMarketAll = (TextView)this.findViewById(R.id.tv_market_value_all);
        this.mClMarket = (ConstraintLayout)this.findViewById(R.id.cl_market_inner);
        this.mTvFavValue = (TextView)this.findViewById(R.id.tv_exp_value);
        this.mTvFavValueAll = (TextView)this.findViewById(R.id.tv_exp_value_all);
        this.mLlHistory = (LinearLayout)this.findViewById(R.id.ll_loyalty_history);
        this.mTvDealsCountBadge = (TextView)this.findViewById(R.id.tv_deals_count);
        this.mTvUnifiedCountBadge = (TextView)this.findViewById(R.id.tv_sm_count);
        this.mTvGiftsCountBadge = (TextView)this.findViewById(R.id.tv_gifts_count);
        this.mLlBannerInfo = (LinearLayout)this.findViewById(R.id.ll_banner_info_new);
        this.mRlDeals = (RelativeLayout)this.findViewById(R.id.rv_deals_count);
        this.mRlUnified = (RelativeLayout)this.findViewById(R.id.rv_sm_count);
        this.mRlGifts = (RelativeLayout)this.findViewById(R.id.rv_gifts_count);
        this.mRecyclerCoupons = (RecyclerView)this.findViewById(R.id.rv_active_coupons);
        this.mCvVouchers = (CardView)this.findViewById(R.id.cv_vouchers);
        this.mCvVouchersDisabled = (CardView)this.findViewById(R.id.cv_vouchers_disabled);
        this.mLlVouchers = (LinearLayout)this.findViewById(R.id.ll_vouchers);
        this.mLlVouchersDisabled = (LinearLayout)this.findViewById(R.id.ll_vouchers_disabled);
        this.mLlVouchersSpinner = (LinearLayout)this.findViewById(R.id.ll_vouchers_spinner);
        this.mSeparator = this.findViewById(R.id.v_separator_vouchers);
        this.mSeparatorDisabled = this.findViewById(R.id.v_separator_vouchers_disabled);
        this.mTvVouchersDisabledTitle = (TextView)this.findViewById(R.id.tv_vouchers_title_disabled);
        this.mTvVouchersDisabledSubtitle = (TextView)this.findViewById(R.id.tv_vouchers_info_title_disabled);
        this.mTvVouchersTitle = (TextView)this.findViewById(R.id.tv_vouchers_title);
        this.mTvVouchersSubtitle = (TextView)this.findViewById(R.id.tv_vouchers_info_title);
    }

    protected void onStart() {
        super.onStart();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    protected void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        WarplyManagerHelper.clearShowVouchersBanner();
        EventBus.getDefault().unregister((Object)this);
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "LoyaltyWalletScreen");
        this.mTimer = 0;
        this.mSecondsHandler.post(new Runnable(){

            @Override
            public void run() {
                LoyaltyWallet.this.mTimer++;
                LoyaltyWallet.this.mSecondsHandler.postDelayed((Runnable)this, 1000L);
            }
        });
        this.mDfyPressed = false;
        this.mDealsBannerPressed = false;
        this.mQuestionnairePressed = false;
        this.mHistoryPressed = false;
        this.mHistoryMarketPressed = false;
        this.mUnifiedPressed = false;
        this.mCouponPressed = false;
        this.mHistoryBadgePressed = false;
        this.mGiftsCountPressed = false;
        this.mUnifiedCountPressed = false;
        this.initViews();
    }

    public void onPause() {
        super.onPause();
        if (this.mSecondsHandler != null) {
            this.mSecondsHandler.removeCallbacksAndMessages(null);
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
            analyticsEvent.setParameter("name", "MyRewards");
            analyticsEvent.setParameter("seconds", String.valueOf(this.mTimer));
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_back) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_user_questionnaire || view.getId() == R.id.ll_user_badge) {
            if (!WarplyManagerHelper.noInternetDialog((Context)this, true)) {
                WarplyManagerHelper.noInternetDialog(this);
                return;
            }
            if (!this.mQuestionnairePressed) {
                this.mQuestionnairePressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyWalletScreen".concat(":").concat("Questionnaire"));
                this.startActivityForResult(WarpViewActivity.createIntentFromURL((Context)this, WarplyManagerHelper.openQuestionnaire()), 1000);
            }
            return;
        }
        if (view.getId() == R.id.cl_deals_win_inner_cos) {
            if (!this.mDealsBannerPressed) {
                this.mDealsBannerPressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyWalletScreen".concat(":").concat("DealsBanner"));
                WarplyDealsAnalysisEventModel warplyDealsAnalysisEventModel = new WarplyDealsAnalysisEventModel();
                warplyDealsAnalysisEventModel.setPressed(true);
                EventBus.getDefault().post((Object)new WarplyEventBusManager(warplyDealsAnalysisEventModel));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_deals_for_you_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
            }
            return;
        }
        if (view.getId() == R.id.rv_sm_count) {
            if (!this.mUnifiedCountPressed) {
                this.mUnifiedCountPressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyWalletScreen".concat(":").concat("ActiveMarketBanner"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_market_active_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent((Context)this, ActiveUnifiedCouponsActivity.class);
                this.startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.rv_gifts_count) {
            if (!this.mGiftsCountPressed) {
                this.mGiftsCountPressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyWalletScreen".concat(":").concat("ActiveLoyaltyBanner"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_gifts_for_you_active_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent((Context)this, ActiveCouponsActivity.class);
                this.startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.cl_deals_win_inner) {
            if (!this.mHistoryPressed) {
                this.mHistoryPressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyWalletScreen".concat(":").concat("LoyaltyBanner"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_gifts_for_you_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent((Context)this, LoyaltyAnalysisActivity.class);
                this.startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.cl_exp) {
            if (!this.mIsStayCollapsed) {
                this.mElGifts.toggle(true);
                if (this.mElGifts.isExpanded()) {
                    this.mIvExpArrow.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_up_dark_new));
                } else {
                    this.mIvExpArrow.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_down_dark_new));
                }
            }
            return;
        }
        if (view.getId() == R.id.cl_market_inner) {
            if (!this.mHistoryMarketPressed) {
                this.mHistoryMarketPressed = true;
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyWalletScreen".concat(":").concat("MarketBanner"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_market_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent((Context)this, LoyaltyMarketAnalysisActivity.class);
                this.startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.ll_loyalty_history) {
            if (!this.mHistoryBadgePressed) {
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyWalletScreen".concat(":").concat("LoyaltyHistoryBadge"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_history_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent((Context)this, LoyaltyHistoryActivity.class);
                this.startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.cv_vouchers || view.getId() == R.id.cv_vouchers_disabled) {
            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyWalletScreen".concat(":").concat("VouchersBadge"));
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("did_tap_vouchers_badge");
            analyticsEvent.setParameter("screen", "Loyalty Wallet");
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
            VouchersActivityEventModel vouchersActivity = new VouchersActivityEventModel();
            EventBus.getDefault().post((Object)new WarplyEventBusManager(vouchersActivity));
            return;
        }
        if (!(view.getId() != R.id.cl_mygifts && view.getId() != R.id.rv_deals_count || this.mDfyPressed)) {
            this.mDfyPressed = true;
            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "LoyaltyWalletScreen".concat(":").concat("ActiveDealsBanner"));
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("did_tap_deals_for_you_active_badge");
            analyticsEvent.setParameter("screen", "Loyalty Wallet");
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
            ActiveDFYCouponEventModel activeCouponEventModel = new ActiveDFYCouponEventModel();
            activeCouponEventModel.setPressed(true);
            EventBus.getDefault().post((Object)new WarplyEventBusManager(activeCouponEventModel));
        }
    }

    public void onScrollChange(View view, int scrollX, int scrollY, int oldScrollX, int oldScrollY) {
        if (scrollY > oldScrollY) {
            this.mClToolbar.setElevation(14.0f);
        }
        if (scrollY < oldScrollY) {
            this.mClToolbar.setElevation(14.0f);
        }
        if (scrollY == 0) {
            this.mClToolbar.setElevation(0.0f);
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1000 && resultCode == -1) {
            if (!TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getUserTag((Context)this))) {
                this.mTvUserBadge.setText((CharSequence)WarplyManagerHelper.getUserTag((Context)this));
                this.mLlQuestionnaire.setVisibility(8);
                this.mLlUserBadge.setVisibility(0);
            } else {
                this.mLlUserBadge.setVisibility(8);
                this.mLlQuestionnaire.setVisibility(0);
            }
        }
    }

    @Subscribe
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getVouchersServiceUnavailableEventModel() != null) {
            this.runOnUiThread(this::vouchersServiceUnavailableDialog);
            return;
        }
        if (event.getVouchersFetched() != null) {
            this.runOnUiThread(this::checkForEmpty);
            return;
        }
        if (event.getUnifiedCouponsAdded() != null) {
            this.runOnUiThread(() -> {
                if (WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() > 0) {
                    this.mTvUnifiedCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getMarketCouponsList().size()));
                } else {
                    this.mTvUnifiedCountBadge.setText((CharSequence)"0");
                }
                this.checkForEmpty();
            });
            return;
        }
        if (event.getCouponsAdded() != null) {
            this.runOnUiThread(() -> {
                if (WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() > 0) {
                    this.mTvGiftsCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getCouponList().size()));
                } else {
                    this.mTvGiftsCountBadge.setText((CharSequence)"0");
                }
                this.checkForEmpty();
            });
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        if (WarpUtils.getUserNonTelco((Context)this)) {
            this.nonTelcoDialog();
        }
        if (WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() > 0) {
            this.mTvUnifiedCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getMarketCouponsList().size()));
        } else {
            this.mTvUnifiedCountBadge.setText((CharSequence)"0");
        }
        if (WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() > 0) {
            this.mTvGiftsCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getCouponList().size()));
        } else {
            this.mTvGiftsCountBadge.setText((CharSequence)"0");
        }
        if (WarplyManagerHelper.getActiveDFYCoupons() != null) {
            this.mTvDealsCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getActiveDFYCoupons().size()));
        } else {
            this.mTvDealsCountBadge.setText((CharSequence)"0");
        }
        if (WarplyManagerHelper.getConsumer() != null) {
            this.mTvUsername.setText((CharSequence)String.format(this.getResources().getString(R.string.cos_profile_loyalty_name), WarplyManagerHelper.getConsumer().getFirstName(), WarplyManagerHelper.getConsumer().getLastName()));
            if (!TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getConsumer().getImageUrl()) && !WarplyManagerHelper.getConsumer().getImageUrl().equals("null")) {
                ((RequestBuilder)Glide.with((Activity)this).load(WarplyManagerHelper.getConsumer().getImageUrl()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(this.mIvProfilePhoto);
            } else {
                Glide.with((Activity)this).load(Integer.valueOf(R.drawable.ic_default_photo)).into(this.mIvProfilePhoto);
            }
            if (!TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getUserTag((Context)this))) {
                this.mTvUserBadge.setText((CharSequence)WarplyManagerHelper.getUserTag((Context)this));
                this.mLlQuestionnaire.setVisibility(8);
                this.mLlUserBadge.setVisibility(0);
            } else {
                this.mLlUserBadge.setVisibility(8);
                this.mLlQuestionnaire.setVisibility(0);
            }
        }
        this.checkForEmpty();
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mLlQuestionnaire.setOnClickListener((View.OnClickListener)this);
        this.mLlUserBadge.setOnClickListener((View.OnClickListener)this);
        this.mClDealsBanner.setOnClickListener((View.OnClickListener)this);
        this.mClGiftsBanner.setOnClickListener((View.OnClickListener)this);
        this.mClDealsView.setOnClickListener((View.OnClickListener)this);
        this.mSvLoyaltyWallet.setOnScrollChangeListener((View.OnScrollChangeListener)this);
        this.mClExp.setOnClickListener((View.OnClickListener)this);
        this.mClMarket.setOnClickListener((View.OnClickListener)this);
        this.mLlHistory.setOnClickListener((View.OnClickListener)this);
        this.mRlDeals.setOnClickListener((View.OnClickListener)this);
        this.mRlUnified.setOnClickListener((View.OnClickListener)this);
        this.mRlGifts.setOnClickListener((View.OnClickListener)this);
        this.mCvVouchers.setOnClickListener((View.OnClickListener)this);
        this.mCvVouchersDisabled.setOnClickListener((View.OnClickListener)this);
    }

    private void nonTelcoDialog() {
        if (!this.isFinishing()) {
            this.mAlertDialogNonTelco = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_non_telco_title).setMessage(R.string.cos_dlg_non_telco).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                dialogPositive.dismiss();
                this.onBackPressed();
            }).setCancelable(false).show();
        }
    }

    private void vouchersServiceUnavailableDialog() {
        if (!this.isFinishing()) {
            this.mLlVouchersSpinner.setVisibility(8);
            this.mAlertDialogVouchersService = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_try_again).setMessage(R.string.cos_dlg_service_unavailable).setPositiveButton(R.string.cos_dlg_return, (dialogPositive, whichPositive) -> {
                dialogPositive.dismiss();
                this.onBackPressed();
            }).setCancelable(false).show();
        }
    }

    private void checkForEmpty() {
        if (TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getShowVouchersBanner()) || !TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getShowVouchersBanner()) && WarplyManagerHelper.getShowVouchersBanner().equals("null")) {
            this.mLlVouchers.setVisibility(8);
            this.mSeparator.setVisibility(0);
            if (TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getShowVouchersBanner())) {
                this.mLlVouchersSpinner.setVisibility(0);
            }
            if (!TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getShowVouchersBanner()) && WarplyManagerHelper.getShowVouchersBanner().equals("null")) {
                this.mLlVouchersSpinner.setVisibility(8);
            }
            if (WarplyManagerHelper.getActiveDFYCoupons() != null && WarplyManagerHelper.getActiveDFYCoupons().size() == 0 && WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() == 0 && WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() == 0) {
                this.mLlVouchers.setVisibility(8);
                this.mLlVouchersSpinner.setVisibility(8);
                this.mSeparator.setVisibility(0);
                this.mLlEmptyWallet.setVisibility(0);
            } else {
                this.mLlEmptyWallet.setVisibility(8);
                this.mLlBannerInfo.setVisibility(0);
            }
        } else if (WarplyManagerHelper.getShowVouchersBanner().equals("true")) {
            this.mLlVouchersSpinner.setVisibility(8);
            this.mLlEmptyWallet.setVisibility(8);
            if (TextUtils.isEmpty((CharSequence)WarpUtils.getLanguage((Context)this)) || WarpUtils.getLanguage((Context)this).equals("el")) {
                this.mTvVouchersTitle.setText((CharSequence)this.getString(R.string.cos_vouchers_title));
                this.mTvVouchersSubtitle.setText((CharSequence)this.getString(R.string.cos_vouchers_info_title));
            } else {
                this.mTvVouchersTitle.setText((CharSequence)this.getString(R.string.cos_vouchers_title_en));
                this.mTvVouchersSubtitle.setText((CharSequence)this.getString(R.string.cos_vouchers_info_title_en));
            }
            this.mLlVouchers.setVisibility(0);
            this.mLlVouchersDisabled.setVisibility(8);
            this.mSeparatorDisabled.setVisibility(0);
            if (WarplyManagerHelper.getActiveDFYCoupons() != null && WarplyManagerHelper.getActiveDFYCoupons().size() == 0 && WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() == 0 && WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() == 0) {
                this.mSeparator.setVisibility(8);
                this.mLlBannerInfo.setVisibility(8);
            } else {
                this.mSeparator.setVisibility(0);
                this.mLlBannerInfo.setVisibility(0);
            }
        } else if (WarplyManagerHelper.getShowVouchersBanner().equals("false")) {
            this.mLlVouchersSpinner.setVisibility(8);
            this.mLlEmptyWallet.setVisibility(8);
            this.mLlVouchers.setVisibility(8);
            this.mSeparator.setVisibility(0);
            if (TextUtils.isEmpty((CharSequence)WarpUtils.getLanguage((Context)this)) || WarpUtils.getLanguage((Context)this).equals("el")) {
                this.mTvVouchersDisabledTitle.setText((CharSequence)this.getString(R.string.cos_vouchers_title));
                this.mTvVouchersDisabledSubtitle.setText((CharSequence)this.getString(R.string.cos_vouchers_info_title_disabled));
            } else {
                this.mTvVouchersDisabledTitle.setText((CharSequence)this.getString(R.string.cos_vouchers_title_en));
                this.mTvVouchersDisabledSubtitle.setText((CharSequence)this.getString(R.string.cos_vouchers_info_title_disabled_en));
            }
            this.mLlVouchersDisabled.setVisibility(0);
            this.mSeparatorDisabled.setVisibility(0);
            if (WarplyManagerHelper.getActiveDFYCoupons() != null && WarplyManagerHelper.getActiveDFYCoupons().size() == 0 && WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() == 0 && WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() == 0) {
                this.mLlBannerInfo.setVisibility(8);
                this.mLlEmptyWallet.setVisibility(8);
                this.mSeparatorDisabled.setVisibility(8);
            } else {
                this.mLlBannerInfo.setVisibility(0);
                this.mSeparatorDisabled.setVisibility(0);
            }
        }
    }
}

