/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeMap;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.ContextualActivity;
import ly.warp.sdk.activities.TelcoActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.io.models.LoyaltyContextualOfferModel;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.MergedMore;
import ly.warp.sdk.services.EventCampaignService;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.MoreCampaignAdapter;
import ly.warp.sdk.views.adapters.MoreContextualAdapter;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONObject;

public class MoreForYouActivity
extends Activity
implements View.OnClickListener {
    private ImageView mIvBack;
    private ImageView mIvPopupClose;
    private RecyclerView mRecyclerMore;
    private TextView mTvTitle;
    private LinearLayout mLlMorePopup;
    private ArrayList<Campaign> mValuesList = new ArrayList();
    private ArrayList<LoyaltyContextualOfferModel> mContextualList = new ArrayList();
    private ArrayList<MergedMore> mData = new ArrayList();
    private Map<String, ArrayList<Campaign>> mUniqueSectionList = new HashMap<String, ArrayList<Campaign>>();
    private RecyclerView mResearchItems;
    private TextView mTvResearchSection;
    private LinearLayout mLlResearchItems;
    private RecyclerView mExclusiveItems;
    private TextView mTvExclusiveSection;
    private LinearLayout mLlExclusiveItems;
    private RecyclerView mContestItems;
    private TextView mTvContestSection;
    private LinearLayout mLlContestItems;
    private MoreCampaignAdapter mAdapterResearch;
    private MoreCampaignAdapter mAdapterExclusive;
    private MoreCampaignAdapter mAdapterContest;
    private RecyclerView mContextualItems;
    private TextView mTvContextualSection;
    private LinearLayout mLlContextualItems;
    private MoreContextualAdapter mAdapterContextual;
    private int mTimer = 0;
    private Handler mSecondsHandler;

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_more_for_you);
        this.mSecondsHandler = new Handler();
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_list_close);
        this.mTvTitle = (TextView)this.findViewById(R.id.textView3);
        this.mIvPopupClose = (ImageView)this.findViewById(R.id.iv_popup_more_close);
        this.mLlMorePopup = (LinearLayout)this.findViewById(R.id.ll_more_popup);
        this.mRecyclerMore = (RecyclerView)this.findViewById(R.id.rv_more_items);
        this.mTvResearchSection = (TextView)this.findViewById(R.id.tv_research_section);
        this.mLlResearchItems = (LinearLayout)this.findViewById(R.id.ll_research_items);
        this.mResearchItems = (RecyclerView)this.findViewById(R.id.rv_research_items);
        this.mTvExclusiveSection = (TextView)this.findViewById(R.id.tv_exclusive_section);
        this.mLlExclusiveItems = (LinearLayout)this.findViewById(R.id.ll_exclusive_items);
        this.mExclusiveItems = (RecyclerView)this.findViewById(R.id.rv_exclusive_items);
        this.mTvContestSection = (TextView)this.findViewById(R.id.tv_contest_section);
        this.mLlContestItems = (LinearLayout)this.findViewById(R.id.ll_contest_items);
        this.mContestItems = (RecyclerView)this.findViewById(R.id.rv_contest_items);
        this.mTvContextualSection = (TextView)this.findViewById(R.id.tv_contextual_section);
        this.mLlContextualItems = (LinearLayout)this.findViewById(R.id.ll_contextual_items);
        this.mContextualItems = (RecyclerView)this.findViewById(R.id.rv_contextual_items);
        this.filterItemsNew();
        if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() != null && WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() > 0) {
            this.mContextualList.clear();
            for (LoyaltyContextualOfferModel ccmsItem : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                if (!TextUtils.isEmpty((CharSequence)ccmsItem.getLoyaltyCampaignId()) && !ccmsItem.getLoyaltyCampaignId().equals("NA") || !ccmsItem.getZone().equals("COSMOTE_APP_MORE4U")) continue;
                this.mContextualList.add(ccmsItem);
            }
        }
        this.initViewsNew();
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "MoreForYouScreen");
        this.mTimer = 0;
        this.mSecondsHandler.post(new Runnable(){

            @Override
            public void run() {
                MoreForYouActivity.this.mTimer++;
                MoreForYouActivity.this.mSecondsHandler.postDelayed((Runnable)this, 1000L);
            }
        });
    }

    public void onDestroy() {
        super.onDestroy();
    }

    public void onPause() {
        super.onPause();
        if (this.mSecondsHandler != null) {
            this.mSecondsHandler.removeCallbacksAndMessages(null);
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
            analyticsEvent.setParameter("name", "MoreForYou");
            analyticsEvent.setParameter("seconds", String.valueOf(this.mTimer));
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
        }
    }

    protected void onStart() {
        super.onStart();
        EventBus.getDefault().register((Object)this);
    }

    protected void onStop() {
        super.onStop();
        EventBus.getDefault().unregister((Object)this);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_list_close) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.iv_popup_more_close) {
            this.mLlMorePopup.setVisibility(8);
            WarpUtils.setMorePopup((Context)this, false);
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1003) {
            OneTimeWorkRequest mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventCampaignService.class).build();
            WorkManager.getInstance((Context)this).enqueue((WorkRequest)mywork);
        }
    }

    @Subscribe
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getCcmsAdded() != null || event.getCampaignsAdded() != null) {
            this.filterItemsNew();
            if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() != null && WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() > 0) {
                this.mContextualList.clear();
                for (LoyaltyContextualOfferModel ccmsItem : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                    if (!TextUtils.isEmpty((CharSequence)ccmsItem.getLoyaltyCampaignId()) && !ccmsItem.getLoyaltyCampaignId().equals("NA") || !ccmsItem.getZone().equals("COSMOTE_APP_MORE4U")) continue;
                    this.mContextualList.add(ccmsItem);
                }
            }
            this.runOnUiThread(this::initViewsNew2);
        }
    }

    private void initViewsNew() {
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mIvPopupClose.setOnClickListener((View.OnClickListener)this);
        if (this.mUniqueSectionList != null && this.mUniqueSectionList.size() > 0) {
            ArrayList<Campaign> itemValue;
            String itemKey;
            for (Map.Entry<String, ArrayList<Campaign>> set : this.mUniqueSectionList.entrySet()) {
                itemKey = set.getKey();
                itemValue = set.getValue();
                if (!itemKey.contains("1")) continue;
                this.mTvResearchSection.setText((CharSequence)itemKey.substring(1));
                this.mResearchItems.setNestedScrollingEnabled(false);
                this.mResearchItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
                this.mAdapterResearch = new MoreCampaignAdapter((Context)this, itemValue);
                this.mResearchItems.setAdapter((RecyclerView.Adapter)this.mAdapterResearch);
                this.mAdapterResearch.getPositionClicks().doOnNext(this::handleMoreItemClick).doOnError(error -> {}).subscribe();
                this.mLlResearchItems.setVisibility(0);
            }
            for (Map.Entry<String, ArrayList<Campaign>> set : this.mUniqueSectionList.entrySet()) {
                itemKey = set.getKey();
                itemValue = set.getValue();
                if (!itemKey.contains("2")) continue;
                this.mTvExclusiveSection.setText((CharSequence)itemKey.substring(1));
                this.mExclusiveItems.setNestedScrollingEnabled(false);
                this.mExclusiveItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
                this.mAdapterExclusive = new MoreCampaignAdapter((Context)this, itemValue);
                this.mExclusiveItems.setAdapter((RecyclerView.Adapter)this.mAdapterExclusive);
                this.mAdapterExclusive.getPositionClicks().doOnNext(this::handleMoreItemClick).doOnError(error -> {}).subscribe();
                this.mLlExclusiveItems.setVisibility(0);
            }
            for (Map.Entry<String, ArrayList<Campaign>> set : this.mUniqueSectionList.entrySet()) {
                itemKey = set.getKey();
                itemValue = set.getValue();
                if (!itemKey.contains("3")) continue;
                this.mTvContestSection.setText((CharSequence)itemKey.substring(1));
                this.mContestItems.setNestedScrollingEnabled(false);
                this.mContestItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
                this.mAdapterContest = new MoreCampaignAdapter((Context)this, itemValue);
                this.mContestItems.setAdapter((RecyclerView.Adapter)this.mAdapterContest);
                this.mAdapterContest.getPositionClicks().doOnNext(this::handleMoreItemClick).doOnError(error -> {}).subscribe();
                this.mLlContestItems.setVisibility(0);
            }
            if (this.mContextualList != null && this.mContextualList.size() > 0) {
                this.mTvContextualSection.setText((CharSequence)this.getString(R.string.cos_mfy_other));
                this.mContextualItems.setNestedScrollingEnabled(false);
                this.mContextualItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
                this.mAdapterContextual = new MoreContextualAdapter((Context)this, this.mContextualList);
                this.mContextualItems.setAdapter((RecyclerView.Adapter)this.mAdapterContextual);
                this.mAdapterContextual.getPositionClicks().doOnNext(this::handleMoreContextualItemClick).doOnError(error -> {}).subscribe();
                this.mLlContextualItems.setVisibility(0);
            }
        }
    }

    private void initViewsNew2() {
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mIvPopupClose.setOnClickListener((View.OnClickListener)this);
        this.runOnUiThread(() -> {
            if (this.mUniqueSectionList != null && this.mUniqueSectionList.size() > 0) {
                ArrayList<Campaign> itemValue;
                String itemKey;
                for (Map.Entry<String, ArrayList<Campaign>> set : this.mUniqueSectionList.entrySet()) {
                    itemKey = set.getKey();
                    itemValue = set.getValue();
                    if (!itemKey.contains("1")) continue;
                    this.mTvResearchSection.setText((CharSequence)itemKey.substring(1));
                    this.mResearchItems.setNestedScrollingEnabled(false);
                    this.mResearchItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
                    this.mAdapterResearch = new MoreCampaignAdapter((Context)this, itemValue);
                    this.mResearchItems.setAdapter((RecyclerView.Adapter)this.mAdapterResearch);
                    this.mAdapterResearch.getPositionClicks().doOnNext(this::handleMoreItemClick).doOnError(error -> {}).subscribe();
                    this.mAdapterResearch.notifyDataSetChanged();
                    this.mLlResearchItems.setVisibility(0);
                }
                for (Map.Entry<String, ArrayList<Campaign>> set : this.mUniqueSectionList.entrySet()) {
                    itemKey = set.getKey();
                    itemValue = set.getValue();
                    if (!itemKey.contains("2")) continue;
                    this.mTvExclusiveSection.setText((CharSequence)itemKey.substring(1));
                    this.mExclusiveItems.setNestedScrollingEnabled(false);
                    this.mExclusiveItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
                    this.mAdapterExclusive = new MoreCampaignAdapter((Context)this, itemValue);
                    this.mExclusiveItems.setAdapter((RecyclerView.Adapter)this.mAdapterExclusive);
                    this.mAdapterExclusive.getPositionClicks().doOnNext(this::handleMoreItemClick).doOnError(error -> {}).subscribe();
                    this.mAdapterExclusive.notifyDataSetChanged();
                    this.mLlExclusiveItems.setVisibility(0);
                }
                for (Map.Entry<String, ArrayList<Campaign>> set : this.mUniqueSectionList.entrySet()) {
                    itemKey = set.getKey();
                    itemValue = set.getValue();
                    if (!itemKey.contains("3")) continue;
                    this.mTvContestSection.setText((CharSequence)itemKey.substring(1));
                    this.mContestItems.setNestedScrollingEnabled(false);
                    this.mContestItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
                    this.mAdapterContest = new MoreCampaignAdapter((Context)this, itemValue);
                    this.mContestItems.setAdapter((RecyclerView.Adapter)this.mAdapterContest);
                    this.mAdapterContest.getPositionClicks().doOnNext(this::handleMoreItemClick).doOnError(error -> {}).subscribe();
                    this.mAdapterContest.notifyDataSetChanged();
                    this.mLlContestItems.setVisibility(0);
                }
                if (this.mContextualList != null && this.mContextualList.size() > 0) {
                    this.mTvContextualSection.setText((CharSequence)this.getString(R.string.cos_mfy_other));
                    this.mContextualItems.setNestedScrollingEnabled(false);
                    this.mContextualItems.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
                    this.mAdapterContextual = new MoreContextualAdapter((Context)this, this.mContextualList);
                    this.mContextualItems.setAdapter((RecyclerView.Adapter)this.mAdapterContextual);
                    this.mAdapterContextual.getPositionClicks().doOnNext(this::handleMoreContextualItemClick).doOnError(error -> {}).subscribe();
                    this.mAdapterContextual.notifyDataSetChanged();
                    this.mLlContextualItems.setVisibility(0);
                }
            }
        });
    }

    private void handleMoreItemClick(Campaign moreItem) {
        block9: {
            try {
                JSONObject extraFields = WarpJSONParser.getJSONFromString(moreItem.getExtraFields());
                if (extraFields == null) break block9;
                if (extraFields.has("type") && extraFields.optString("type").equals("telco")) {
                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                        if (!ccms.getLoyaltyCampaignId().equals(moreItem.getSessionUUID())) continue;
                        WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Telco".concat(":").concat(ccms.getSessionId()));
                        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                        analyticsEvent.setEventName("loyalty_sdk_offer_selected");
                        analyticsEvent.setParameter("name", ccms.getTitle());
                        analyticsEvent.setParameter("type", "gift");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                        WarplyManager.getSingleCampaign(moreItem.getSessionUUID());
                        Intent intent = new Intent((Context)this, TelcoActivity.class);
                        intent.putExtra("ccms", (Serializable)ccms);
                        intent.putExtra("loyalty", moreItem.getSessionUUID());
                        this.startActivityForResult(intent, 1003);
                        break;
                    }
                    return;
                }
                if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                    for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                        if (!ccms.getLoyaltyCampaignId().equals(moreItem.getSessionUUID())) continue;
                        if (!WarplyManagerHelper.noInternetDialog((Context)this, true)) {
                            WarplyManagerHelper.noInternetDialog(this);
                            return;
                        }
                        WarpUtils.log("CCMS_CLICK " + ccms.toString());
                        WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Contextual".concat(":").concat(ccms.getSessionId()));
                        this.startActivityForResult(WarpViewActivity.createIntentFromURL((Context)this, WarplyManagerHelper.constructCcmsUrl(moreItem, ccms)), 1003);
                        break block9;
                    }
                    break block9;
                }
                if (!WarplyManagerHelper.noInternetDialog((Context)this, true)) {
                    WarplyManagerHelper.noInternetDialog(this);
                    return;
                }
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Loyalty".concat(":").concat(moreItem.getSessionUUID()));
                this.startActivityForResult(WarpViewActivity.createIntentFromURL((Context)this, WarplyManagerHelper.constructCampaignUrl(moreItem)), 1003);
            }
            catch (Exception exception) {
                if (!WarplyManagerHelper.noInternetDialog((Context)this, true)) {
                    WarplyManagerHelper.noInternetDialog(this);
                    return;
                }
                WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Loyalty".concat(":").concat(moreItem.getSessionUUID()));
                this.startActivityForResult(WarpViewActivity.createIntentFromURL((Context)this, WarplyManagerHelper.constructCampaignUrl(moreItem)), 1003);
            }
        }
    }

    private void handleMoreContextualItemClick(LoyaltyContextualOfferModel ccmsItem) {
        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
        analyticsEvent.setEventName("loyalty_sdk_offer_selected");
        analyticsEvent.setParameter("name", ccmsItem.getTitle());
        analyticsEvent.setParameter("type", "gift");
        EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "Contextual".concat(":").concat(ccmsItem.getSessionId()));
        Intent intent = new Intent((Context)this, ContextualActivity.class);
        intent.putExtra("ccms", (Serializable)ccmsItem);
        this.startActivity(intent);
    }

    private void filterItemsNew() {
        this.mUniqueSectionList.clear();
        ArrayList<Campaign> mfyList = new ArrayList<Campaign>();
        if (WarplyManagerHelper.getCampaignListAll() != null && WarplyManagerHelper.getCampaignListAll().size() > 0) {
            JSONObject extraFields;
            ArrayList<Campaign> customs = new ArrayList<Campaign>();
            for (Campaign campaignItem : WarplyManagerHelper.getCampaignListAll()) {
                if (customs.contains(campaignItem)) continue;
                customs.add(campaignItem);
            }
            if (WarplyManagerHelper.getCCMSLoyaltyCampaigns() == null || WarplyManagerHelper.getCCMSLoyaltyCampaigns().size() == 0) {
                for (Campaign camp : customs) {
                    if (!camp.getOfferCategory().equals("more_for_you")) continue;
                    try {
                        extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                        if (extraFields == null || extraFields.length() != 0 && (extraFields.has("ccms_offer") || extraFields.has("type"))) continue;
                        mfyList.add(camp);
                    }
                    catch (Exception exception) {
                        mfyList.add(camp);
                    }
                }
            } else {
                block6: for (Campaign camp : customs) {
                    if (!camp.getOfferCategory().equals("more_for_you")) continue;
                    try {
                        extraFields = WarpJSONParser.getJSONFromString(camp.getExtraFields());
                        if (extraFields == null) continue;
                        if (extraFields.has("ccms_offer") && extraFields.optString("ccms_offer").equals("true")) {
                            for (LoyaltyContextualOfferModel ccms : WarplyManagerHelper.getCCMSLoyaltyCampaigns()) {
                                if (!ccms.getLoyaltyCampaignId().equals(camp.getSessionUUID())) continue;
                                mfyList.add(camp);
                                continue block6;
                            }
                            continue;
                        }
                        mfyList.add(camp);
                    }
                    catch (Exception exception) {
                        mfyList.add(camp);
                    }
                }
            }
            if (mfyList != null && mfyList.size() > 0) {
                for (Campaign campaignItem : mfyList) {
                    CampaignList tempCampaignList;
                    extraFields = WarpJSONParser.getJSONFromString(campaignItem.getExtraFields());
                    if (extraFields == null || !extraFields.has("category_title")) continue;
                    String categoryTitle = extraFields.optString("category_title");
                    if (this.mUniqueSectionList.containsKey(categoryTitle.trim())) {
                        tempCampaignList = (CampaignList)this.mUniqueSectionList.get(categoryTitle.trim());
                        tempCampaignList.add(campaignItem);
                        this.mUniqueSectionList.put(categoryTitle.trim(), tempCampaignList);
                        continue;
                    }
                    tempCampaignList = new CampaignList();
                    tempCampaignList.add(campaignItem);
                    this.mUniqueSectionList.put(categoryTitle.trim(), tempCampaignList);
                }
            }
            TreeMap<String, ArrayList<Campaign>> treeMap = new TreeMap<String, ArrayList<Campaign>>(this.mUniqueSectionList);
            this.mUniqueSectionList.clear();
            this.mUniqueSectionList = treeMap;
        }
    }
}

