/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.content.ActivityNotFoundException;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import android.util.Log;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.annotation.Nullable;
import androidx.appcompat.app.AlertDialog;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import androidx.fragment.app.FragmentActivity;
import com.bumptech.glide.Glide;
import com.bumptech.glide.RequestBuilder;
import com.bumptech.glide.load.engine.DiskCacheStrategy;
import com.bumptech.glide.request.target.CustomTarget;
import com.bumptech.glide.request.target.Target;
import com.bumptech.glide.request.transition.Transition;
import com.google.android.gms.maps.CameraUpdate;
import com.google.android.gms.maps.CameraUpdateFactory;
import com.google.android.gms.maps.GoogleMap;
import com.google.android.gms.maps.OnMapReadyCallback;
import com.google.android.gms.maps.SupportMapFragment;
import com.google.android.gms.maps.model.BitmapDescriptorFactory;
import com.google.android.gms.maps.model.LatLng;
import com.google.android.gms.maps.model.LatLngBounds;
import com.google.android.gms.maps.model.Marker;
import com.google.android.gms.maps.model.MarkerOptions;
import com.google.android.material.bottomsheet.BottomSheetDialog;
import com.google.maps.android.clustering.Cluster;
import com.google.maps.android.clustering.ClusterManager;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.util.ArrayList;
import ly.warp.sdk.R;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.Merchant;
import ly.warp.sdk.io.models.MerchantList;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyManager;

public class ShopsActivity
extends FragmentActivity
implements View.OnClickListener,
OnMapReadyCallback,
GoogleMap.OnMapLoadedCallback,
ClusterManager.OnClusterClickListener<Merchant>,
GoogleMap.OnMarkerClickListener {
    public static final float DEFAULT_LOCATION_ZOOM = 6.2f;
    private ImageView mIvBack;
    private Coupon mCoupon;
    private GoogleMap mMap;
    private ClusterManager<Merchant> mClusterManager;
    private SupportMapFragment mMapView;
    private MerchantList mMerchantList = new MerchantList();
    private AlertDialog mAlertDialogNoShopsAvailable;
    private Merchant mMerchant;
    private Merchant mMerchantParent;
    private ArrayList<Merchant> mMerchantParentList = new ArrayList();
    private final CallbackReceiver<MerchantList> mMerchantsCallback = new CallbackReceiver<MerchantList>(){

        @Override
        public void onSuccess(MerchantList result) {
            if (result.size() == 0) {
                ShopsActivity.this.showNoShopsAvailableDialog();
                return;
            }
            ShopsActivity.this.mMerchantList.clear();
            ShopsActivity.this.mMerchantList.addAll(result);
            int nonNullCoords = 0;
            for (Merchant merchCoords : result) {
                if (merchCoords.getLatitude() != 0.0 && merchCoords.getLongitude() != 0.0) {
                    ++nonNullCoords;
                    continue;
                }
                ShopsActivity.this.mMerchantParentList.add(merchCoords);
            }
            if (nonNullCoords == 0) {
                ShopsActivity.this.showNoShopsAvailableDialog();
                return;
            }
            for (final Merchant merch : result) {
                if (!TextUtils.isEmpty((CharSequence)merch.getImgPreview())) {
                    Glide.with((FragmentActivity)ShopsActivity.this).asBitmap().load(Integer.valueOf(R.drawable.map_pin)).into((Target)new CustomTarget<Bitmap>(){

                        public void onResourceReady(final @NonNull Bitmap staticImage, @Nullable Transition<? super Bitmap> transition) {
                            Glide.with((FragmentActivity)ShopsActivity.this).asBitmap().load(merch.getImgPreview()).into((Target)new CustomTarget<Bitmap>(){

                                public void onResourceReady(@NonNull Bitmap poiImage, @Nullable Transition<? super Bitmap> transition) {
                                    Bitmap combinedBitmap = ShopsActivity.this.overlayBitmaps(staticImage, poiImage, 48, 48, 0.2f);
                                    ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)combinedBitmap)).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                }

                                public void onLoadCleared(@Nullable Drawable placeholder) {
                                    ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                }

                                public void onLoadFailed(@Nullable Drawable errorDrawable) {
                                    ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                }
                            });
                        }

                        public void onLoadCleared(@Nullable Drawable placeholder) {
                            ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                        }

                        public void onLoadFailed(@Nullable Drawable errorDrawable) {
                            ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                        }
                    });
                    continue;
                }
                ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
            }
        }

        @Override
        public void onFailure(int errorCode) {
            Log.v((String)"SHOPS_ACTIVITY", (String)String.valueOf(errorCode));
        }
    };
    private final CallbackReceiver<MerchantList> mMerchantsDealsCallback = new CallbackReceiver<MerchantList>(){

        @Override
        public void onSuccess(MerchantList result) {
            if (result.size() == 0) {
                ShopsActivity.this.showNoShopsAvailableDialog();
                return;
            }
            ShopsActivity.this.mMerchantList.clear();
            ShopsActivity.this.mMerchantList.addAll(result);
            int nonNullCoords = 0;
            for (Merchant merchCoords : result) {
                if (merchCoords.getLatitude() != 0.0 && merchCoords.getLongitude() != 0.0) {
                    ++nonNullCoords;
                    continue;
                }
                ShopsActivity.this.mMerchantParentList.add(merchCoords);
            }
            if (nonNullCoords == 0) {
                ShopsActivity.this.showNoShopsAvailableDialog();
                return;
            }
            if (ShopsActivity.this.mMerchantParentList != null && ShopsActivity.this.mMerchantParentList.size() > 0) {
                for (Merchant parentMerch : ShopsActivity.this.mMerchantParentList) {
                    for (final Merchant merch : result) {
                        if (!parentMerch.getUuid().equals(merch.getParent())) continue;
                        merch.setImg_preview(parentMerch.getImgPreview());
                        if (merch.getLatitude() == 0.0 || merch.getLongitude() == 0.0) continue;
                        if (!TextUtils.isEmpty((CharSequence)merch.getImgPreview())) {
                            Glide.with((FragmentActivity)ShopsActivity.this).asBitmap().load(Integer.valueOf(R.drawable.map_pin)).into((Target)new CustomTarget<Bitmap>(){

                                public void onResourceReady(final @NonNull Bitmap staticImage, @Nullable Transition<? super Bitmap> transition) {
                                    Glide.with((FragmentActivity)ShopsActivity.this).asBitmap().load(merch.getImgPreview()).into((Target)new CustomTarget<Bitmap>(){

                                        public void onResourceReady(@NonNull Bitmap poiImage, @Nullable Transition<? super Bitmap> transition) {
                                            Bitmap combinedBitmap = ShopsActivity.this.overlayBitmaps(staticImage, poiImage, 48, 48, 0.2f);
                                            ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)combinedBitmap)).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                        }

                                        public void onLoadCleared(@Nullable Drawable placeholder) {
                                            ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                        }

                                        public void onLoadFailed(@Nullable Drawable errorDrawable) {
                                            ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                        }
                                    });
                                }

                                public void onLoadCleared(@Nullable Drawable placeholder) {
                                    ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                }

                                public void onLoadFailed(@Nullable Drawable errorDrawable) {
                                    ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                }
                            });
                            continue;
                        }
                        ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                    }
                }
            } else {
                for (final Merchant merch : result) {
                    if (merch.getLatitude() == 0.0 || merch.getLongitude() == 0.0) continue;
                    if (!TextUtils.isEmpty((CharSequence)merch.getImgPreview())) {
                        Glide.with((FragmentActivity)ShopsActivity.this).asBitmap().load(Integer.valueOf(R.drawable.map_pin)).into((Target)new CustomTarget<Bitmap>(){

                            public void onResourceReady(final @NonNull Bitmap staticImage, @Nullable Transition<? super Bitmap> transition) {
                                Glide.with((FragmentActivity)ShopsActivity.this).asBitmap().load(merch.getImgPreview()).into((Target)new CustomTarget<Bitmap>(){

                                    public void onResourceReady(@NonNull Bitmap poiImage, @Nullable Transition<? super Bitmap> transition) {
                                        Bitmap combinedBitmap = ShopsActivity.this.overlayBitmaps(staticImage, poiImage, 48, 48, 0.2f);
                                        ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).icon(BitmapDescriptorFactory.fromBitmap((Bitmap)combinedBitmap)).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                    }

                                    public void onLoadCleared(@Nullable Drawable placeholder) {
                                        ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                    }

                                    public void onLoadFailed(@Nullable Drawable errorDrawable) {
                                        ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                                    }
                                });
                            }

                            public void onLoadCleared(@Nullable Drawable placeholder) {
                                ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                            }

                            public void onLoadFailed(@Nullable Drawable errorDrawable) {
                                ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                            }
                        });
                        continue;
                    }
                    ShopsActivity.this.mMap.addMarker(new MarkerOptions().position(new LatLng(merch.getLatitude(), merch.getLongitude())).anchor(0.5f, 0.5f).title(merch.getTitle()).snippet(merch.getUuid()));
                }
            }
        }

        @Override
        public void onFailure(int errorCode) {
            Log.v((String)"SHOPS_ACTIVITY", (String)String.valueOf(errorCode));
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_shops);
        String couponCode = this.getIntent().getStringExtra("coupon");
        for (Coupon cpn : WarplyManagerHelper.getCouponList()) {
            if (!cpn.getCoupon().equals(couponCode)) continue;
            this.mCoupon = cpn;
            this.mMerchant = cpn.getMerchantDetails();
            break;
        }
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_shops_back);
        this.mMapView = (SupportMapFragment)this.getSupportFragmentManager().findFragmentById(R.id.mv_shops);
        this.mMapView.getMapAsync((OnMapReadyCallback)this);
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "ShopsScreen");
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_shops_back) {
            this.onBackPressed();
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    public void onMapReady(@NonNull GoogleMap googleMap) {
        this.mMap = googleMap;
        if (ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") == 0 && ActivityCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_COARSE_LOCATION") == 0) {
            if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") == 0) {
                this.mMap.setMyLocationEnabled(true);
            }
        } else {
            this.mMap.setMyLocationEnabled(false);
        }
        this.mMap.setMapType(1);
        this.mMap.setMinZoomPreference(6.2f);
        this.mMap.setLatLngBoundsForCameraTarget(WarpConstants.GREECE_BOUNDS);
        this.mMap.getUiSettings().setZoomControlsEnabled(true);
        this.mMap.getUiSettings().setZoomGesturesEnabled(true);
        this.mMap.getUiSettings().setCompassEnabled(false);
        this.mMap.getUiSettings().setMyLocationButtonEnabled(false);
        this.mMap.getUiSettings().setMapToolbarEnabled(false);
        this.mMap.getUiSettings().setTiltGesturesEnabled(false);
        this.mMap.getUiSettings().setRotateGesturesEnabled(false);
        this.mMap.setOnMapLoadedCallback((GoogleMap.OnMapLoadedCallback)this);
        this.mMap.setOnMarkerClickListener((GoogleMap.OnMarkerClickListener)this);
    }

    public void onMapLoaded() {
        if (this.mMap != null) {
            CameraUpdate camUpdate = CameraUpdateFactory.newLatLngBounds((LatLngBounds)WarpConstants.GREECE_BOUNDS, (int)48);
            this.mMap.animateCamera(camUpdate);
        }
        if (this.mCoupon != null) {
            ArrayList<String> uuids = new ArrayList<String>();
            uuids.add(this.mCoupon.getMerchantUuid());
            WarplyManager.getMerchantsMultilingual(true, uuids, this.mMerchantsCallback);
        } else {
            ArrayList<String> catuuids = new ArrayList<String>();
            catuuids.add(WarplyProperty.getAppUuid((Context)this).equals("0086a2088301440792091b9f814c2267") ? "2a6adade35f1484994a3d4c8f006b909" : "adcace6cab6049c7b7271bc85bc2b26d");
            WarplyManager.getMerchantsMultilingual(catuuids, this.mMerchantsDealsCallback);
        }
    }

    public boolean onClusterClick(Cluster<Merchant> cluster) {
        if (this.mMap != null) {
            this.mMap.animateCamera(CameraUpdateFactory.newLatLngZoom((LatLng)cluster.getPosition(), (float)((float)Math.floor(this.mMap.getCameraPosition().zoom + 1.0f))), 300, null);
        }
        return true;
    }

    public boolean onMarkerClick(@NonNull Marker marker) {
        for (Merchant merch : this.mMerchantList) {
            if (!merch.getUuid().equals(marker.getSnippet())) continue;
            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "ShopsScreenMarker".concat(":").concat(marker.getSnippet()));
            BottomSheetDialog bottomSheetDialog = new BottomSheetDialog((Context)this);
            bottomSheetDialog.setContentView(R.layout.dl_map_pin);
            ImageView dialogClose = (ImageView)bottomSheetDialog.findViewById(R.id.iv_map_pin_close);
            dialogClose.setOnClickListener(view -> bottomSheetDialog.dismiss());
            TextView pinTitle = (TextView)bottomSheetDialog.findViewById(R.id.tv_pin_title);
            if (this.mMerchantParentList != null && this.mMerchantParentList.size() > 0) {
                for (Merchant parentMerch : this.mMerchantParentList) {
                    if (!parentMerch.getUuid().equals(merch.getParent())) continue;
                    pinTitle.setText((CharSequence)parentMerch.getAdminName());
                    break;
                }
            }
            ImageView pinLogo = (ImageView)bottomSheetDialog.findViewById(R.id.iv_pin_logo);
            if (!TextUtils.isEmpty((CharSequence)merch.getImgPreview())) {
                ((RequestBuilder)Glide.with((FragmentActivity)this).load(merch.getImgPreview()).diskCacheStrategy(DiskCacheStrategy.DATA)).into(pinLogo);
            }
            TextView pinName = (TextView)bottomSheetDialog.findViewById(R.id.tv_pin_name);
            pinName.setText((CharSequence)merch.getName());
            TextView pinDays = (TextView)bottomSheetDialog.findViewById(R.id.tv_pin_days);
            pinDays.setText((CharSequence)merch.getSnippet());
            TextView pinTel = (TextView)bottomSheetDialog.findViewById(R.id.tv_pin_tel);
            pinTel.setText((CharSequence)merch.getTelephone());
            TextView pinAddress = (TextView)bottomSheetDialog.findViewById(R.id.tv_pin_address);
            pinAddress.setText((CharSequence)merch.getAddress());
            LinearLayout pinDirections = (LinearLayout)bottomSheetDialog.findViewById(R.id.ll_directions);
            pinDirections.setOnClickListener(view -> {
                Uri gmmIntentUri = Uri.parse((String)("google.navigation:q=" + merch.getLatitude() + "," + merch.getLongitude()));
                Intent mapIntent = new Intent("android.intent.action.VIEW", gmmIntentUri);
                mapIntent.setPackage("com.google.android.apps.maps");
                this.startActivity(mapIntent);
            });
            bottomSheetDialog.show();
            return false;
        }
        return false;
    }

    private void showNoShopsAvailableDialog() {
        if (!this.isFinishing()) {
            this.mAlertDialogNoShopsAvailable = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_no_shops_title).setMessage(R.string.cos_dlg_no_shops).setCancelable(false).setPositiveButton(R.string.cos_dlg_no_shops_positive, (dialogPositive, whichPositive) -> {
                dialogPositive.dismiss();
                this.openWebsite();
            }).setNegativeButton(R.string.cos_dlg_negative_button2, (dialogNegative, whichNegative) -> {
                dialogNegative.dismiss();
                this.onBackPressed();
            }).show();
        }
    }

    private void openWebsite() {
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "SeeShopWebsite");
        if (this.mMerchant != null && !TextUtils.isEmpty((CharSequence)this.mMerchant.getWebsite())) {
            try {
                Intent intent = new Intent("android.intent.action.VIEW");
                intent.setData(Uri.parse((String)this.mMerchant.getWebsite()));
                this.startActivity(intent);
            }
            catch (ActivityNotFoundException e) {
                e.printStackTrace();
            }
        }
    }

    private Bitmap overlayBitmaps(Bitmap staticImage, Bitmap poiImage, int poiImageWidth, int poiImageHeight, float scale) {
        Bitmap resizedPoiImage;
        int poiImageWidthScale = 0;
        int poiImageHeightScale = 0;
        if (scale == 0.0f) {
            resizedPoiImage = Bitmap.createScaledBitmap((Bitmap)poiImage, (int)poiImageWidth, (int)poiImageHeight, (boolean)false);
        } else {
            poiImageWidthScale = (int)((float)poiImage.getWidth() * scale);
            poiImageHeightScale = (int)((float)poiImage.getHeight() * scale);
            resizedPoiImage = Bitmap.createScaledBitmap((Bitmap)poiImage, (int)poiImageWidthScale, (int)poiImageHeightScale, (boolean)false);
        }
        Bitmap combinedBitmap = Bitmap.createBitmap((int)staticImage.getWidth(), (int)staticImage.getHeight(), (Bitmap.Config)staticImage.getConfig());
        Canvas canvas = new Canvas(combinedBitmap);
        canvas.drawBitmap(staticImage, 0.0f, 0.0f, null);
        int left = (staticImage.getWidth() - resizedPoiImage.getWidth()) / 2;
        int top = (staticImage.getHeight() - resizedPoiImage.getHeight()) / 3;
        canvas.drawBitmap(resizedPoiImage, (float)left, (float)top, null);
        return combinedBitmap;
    }
}

