/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.Context;
import android.content.Intent;
import android.content.IntentSender;
import android.content.res.Configuration;
import android.hardware.Sensor;
import android.hardware.SensorEvent;
import android.hardware.SensorEventListener;
import android.hardware.SensorManager;
import android.location.Location;
import android.location.LocationListener;
import android.location.LocationManager;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.util.Log;
import android.view.MotionEvent;
import android.view.View;
import android.widget.EditText;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.core.app.ActivityCompat;
import androidx.core.content.ContextCompat;
import com.google.android.gms.common.api.ApiException;
import com.google.android.gms.common.api.ResolvableApiException;
import com.google.android.gms.location.LocationRequest;
import com.google.android.gms.location.LocationServices;
import com.google.android.gms.location.LocationSettingsRequest;
import com.google.android.gms.location.LocationSettingsResponse;
import com.google.android.gms.tasks.Task;
import com.google.android.material.snackbar.Snackbar;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.util.ArrayList;
import java.util.Arrays;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.TelematicsHistoryActivity;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.utils.managers.WarplyManager;
import org.jetbrains.annotations.NotNull;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class TelematicsActivity
extends Activity
implements View.OnClickListener,
SensorEventListener,
LocationListener {
    private ImageView mIvBack;
    private boolean mIsTripStarted = false;
    private LinearLayout mLlTripButton;
    private LinearLayout mLlTelematicsMain;
    private LinearLayout mLlTelematicsHistory;
    private TextView mTvTripButton;
    private TextView mTvSensorData;
    private TextView mTvVelocity;
    private TextView mTvAvgVelocity;
    private TextView mTvRecordsSaved;
    private TextView mTvOrientationCount;
    private TextView mTvTouchCount;
    private SensorManager mSensorManager;
    private Sensor mSensor;
    private Handler mHandler;
    private Handler mTouchHandler;
    private Runnable mRunnable;
    private Runnable mTouchRunnable;
    private long lastUpdate = 0L;
    private float lastX;
    private float lastY;
    private float lastZ;
    private float velocity = 0.0f;
    private ArrayList<JSONObject> mAccelerationTimestamps = new ArrayList();
    private float mAcceleration = 0.0f;
    private final float ALPHA = 0.5f;
    private final float STOP_THRESHOLD = 10.0f;
    private final int PERMISSION_REQUEST_WRITE_EXTERNAL_STORAGE = 4003;
    private final int PERMISSION_REQUEST_LOCATION_SETTINGS = 4000;
    private final int PERMISSION_REQUEST_ACCESS_FINE_LOCATION = 4001;
    private JSONArray jsonArray = new JSONArray();
    private LocationManager locationManager;
    private final int LOCATION_UPDATE_INTERVAL = 1000;
    private double mLatitude = 0.0;
    private double mLongitude = 0.0;
    private final double EARTH_RADIUS = 6371000.0;
    private double mSpeed = 0.0;
    private int orientationCount = 0;
    private int touchCount = 0;
    final long REFRESH_TIME = 100L;
    private String mStartTimestamp = "";
    private String mStopTimestamp = "";
    private final int RECORDS_INTERVAL = 5000;
    private EditText mEtLimit;
    private EditText mEtSampleTime;
    private RelativeLayout mRlMainScroll;
    private final View.OnTouchListener mTripTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (TelematicsActivity.this.mIsTripStarted && motionEvent.getAction() == 1) {
                TelematicsActivity.this.mTouchHandler.removeCallbacks(TelematicsActivity.this.mTouchRunnable);
                TelematicsActivity.this.onClick(view);
                return true;
            }
            return false;
        }
    };
    private final View.OnTouchListener mScrollTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View view, MotionEvent motionEvent) {
            if (TelematicsActivity.this.mIsTripStarted) {
                switch (motionEvent.getAction()) {
                    case 0: {
                        TelematicsActivity.this.touchCount++;
                        TelematicsActivity.this.mTvTouchCount.setText((CharSequence)String.valueOf(TelematicsActivity.this.touchCount));
                        TelematicsActivity.this.mTouchHandler.post(TelematicsActivity.this.mTouchRunnable);
                        return true;
                    }
                    case 1: {
                        TelematicsActivity.this.mTouchHandler.removeCallbacks(TelematicsActivity.this.mTouchRunnable);
                        return true;
                    }
                }
            }
            return false;
        }
    };
    private final CallbackReceiver<Integer> mTelematicsCallback = new CallbackReceiver<Integer>(){

        @Override
        public void onSuccess(Integer result) {
            Snackbar.make((View)TelematicsActivity.this.mLlTelematicsMain, (CharSequence)"Success sending data to server", (int)-1).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Snackbar.make((View)TelematicsActivity.this.mLlTelematicsMain, (CharSequence)"Error sending data to server", (int)-1).show();
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        this.getWindow().addFlags(128);
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_telematics);
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_telematics_close);
        this.mLlTripButton = (LinearLayout)this.findViewById(R.id.ll_activate_button);
        this.mLlTripButton.setOnClickListener((View.OnClickListener)this);
        this.mLlTripButton.setOnTouchListener(this.mTripTouchListener);
        this.mTvTripButton = (TextView)this.findViewById(R.id.tv_trip_button);
        this.mLlTelematicsMain = (LinearLayout)this.findViewById(R.id.ll_telematics_main);
        this.mTvSensorData = (TextView)this.findViewById(R.id.tv_sensor_data);
        this.mTvVelocity = (TextView)this.findViewById(R.id.tv_velocity);
        this.mTvAvgVelocity = (TextView)this.findViewById(R.id.tv_avg);
        this.mTvRecordsSaved = (TextView)this.findViewById(R.id.tv_records);
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mTvOrientationCount = (TextView)this.findViewById(R.id.tv_orientation);
        this.mTvTouchCount = (TextView)this.findViewById(R.id.tv_touch);
        this.mEtLimit = (EditText)this.findViewById(R.id.et_acceleration);
        this.mEtSampleTime = (EditText)this.findViewById(R.id.et_save);
        this.mRlMainScroll = (RelativeLayout)this.findViewById(R.id.rl_main_scroll);
        this.mRlMainScroll.setOnTouchListener(this.mScrollTouchListener);
        this.mLlTelematicsHistory = (LinearLayout)this.findViewById(R.id.ll_telematics_history);
        this.mLlTelematicsHistory.setOnClickListener((View.OnClickListener)this);
        this.locationManager = (LocationManager)this.getSystemService("location");
        this.initViews();
    }

    public void onResume() {
        super.onResume();
    }

    protected void onPause() {
        super.onPause();
    }

    public void onBackPressed() {
        super.onBackPressed();
        if (this.mIsTripStarted) {
            this.stopLocationUpdates();
            this.unregisterSensor();
        }
    }

    public void onSensorChanged(SensorEvent sensorEvent) {
        this.mTvSensorData.setText((CharSequence)Arrays.toString(sensorEvent.values));
        float currentX = sensorEvent.values[0];
        float currentY = sensorEvent.values[1];
        float currentZ = sensorEvent.values[2];
        long currentTime = System.currentTimeMillis();
        long timeDifference = currentTime - this.lastUpdate;
        this.lastUpdate = currentTime;
        float time = (float)timeDifference / 1000.0f;
        float filteredX = 0.5f * this.lastX + 0.5f * currentX;
        float filteredY = 0.5f * this.lastY + 0.5f * currentY;
        float filteredZ = 0.5f * this.lastZ + 0.5f * currentZ;
        float accelerationX = (filteredX - this.lastX) / time;
        float accelerationY = (filteredY - this.lastY) / time;
        float accelerationZ = (filteredZ - this.lastZ) / time;
        float acceleration = (float)Math.sqrt(accelerationX * accelerationX + accelerationY * accelerationY + accelerationZ * accelerationZ);
        this.velocity = acceleration < 10.0f ? 0.0f : acceleration * time;
        this.mAcceleration = this.velocity;
        this.mTvVelocity.setText((CharSequence)(String.format("%.1f", Float.valueOf(this.velocity)) + " m/s^2"));
        this.lastX = filteredX;
        this.lastY = filteredY;
        this.lastZ = filteredZ;
    }

    public void onAccuracyChanged(Sensor sensor, int i) {
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_telematics_close) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_telematics_history) {
            Intent intent = new Intent((Context)this, TelematicsHistoryActivity.class);
            this.startActivity(intent);
            return;
        }
        if (view.getId() == R.id.ll_activate_button) {
            if (this.mIsTripStarted) {
                this.mIsTripStarted = false;
                this.mTvTripButton.setText(R.string.cos_dlg_start_trip);
                this.mEtLimit.setEnabled(true);
                this.mEtSampleTime.setEnabled(true);
                this.stopLocationUpdates();
                this.unregisterSensor();
                this.initViews();
            } else {
                if (this.mEtLimit.getText().length() == 0) {
                    Snackbar.make((View)this.mLlTelematicsMain, (CharSequence)"Please fill the Cut off field", (int)-1).show();
                    return;
                }
                this.mEtLimit.setEnabled(false);
                this.mEtSampleTime.setEnabled(false);
                this.mTouchHandler = new Handler();
                this.mTouchRunnable = new Runnable(){

                    @Override
                    public void run() {
                        TelematicsActivity.this.mTouchHandler.postDelayed((Runnable)this, 100L);
                    }
                };
                this.requestLocationUpdates();
            }
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 4001) {
            if (grantResults.length > 0 && grantResults[0] == 0) {
                this.enableLocationSettings();
            } else {
                Snackbar.make((View)this.mLlTelematicsMain, (CharSequence)"Location Permission Denied", (int)-1).show();
            }
        }
    }

    public void onLocationChanged(Location location) {
        if (this.mIsTripStarted) {
            if (this.mLatitude != 0.0 && this.mLongitude != 0.0) {
                this.mSpeed = this.calculateSpeed(this.mLatitude, this.mLongitude, location.getLatitude(), location.getLongitude(), 1);
                this.mTvAvgVelocity.setText((CharSequence)(String.format("%.1f", Math.floor(this.mSpeed)) + " km/h"));
            }
            this.mLatitude = location.getLatitude();
            this.mLongitude = location.getLongitude();
        }
    }

    public void onStatusChanged(String provider, int status, Bundle extras) {
    }

    public void onProviderEnabled(String provider) {
    }

    public void onProviderDisabled(String provider) {
    }

    public void onConfigurationChanged(@NotNull Configuration newConfig) {
        super.onConfigurationChanged(newConfig);
        if (this.mIsTripStarted && (newConfig.orientation == 2 || newConfig.orientation == 1)) {
            ++this.orientationCount;
            this.mTvOrientationCount.setText((CharSequence)String.valueOf(this.orientationCount));
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 4000) {
            switch (resultCode) {
                case -1: {
                    this.mIsTripStarted = true;
                    this.mTvTripButton.setText(R.string.cos_dlg_stop_trip);
                    this.startLocationUpdates();
                    this.registerSensor();
                    break;
                }
                case 0: {
                    if (this.isFinishing()) break;
                    AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
                    builder.setTitle((CharSequence)this.getString(R.string.cos_telematics));
                    builder.setMessage((CharSequence)this.getString(R.string.lbl_telematics_no_location)).setCancelable(false).setNegativeButton((CharSequence)this.getString(R.string.cos_dlg_positive_button2), (dialog, id2) -> {});
                    AlertDialog alert = builder.create();
                    alert.show();
                    break;
                }
            }
        }
    }

    private void initViews() {
        this.mTvVelocity.setText((CharSequence)"0.0 m/s^2");
        this.mTvAvgVelocity.setText((CharSequence)"0.0 km/h");
        this.mTvOrientationCount.setText((CharSequence)String.valueOf(this.orientationCount));
        this.mTvTouchCount.setText((CharSequence)String.valueOf(this.touchCount));
        this.mTvRecordsSaved.setText((CharSequence)String.valueOf(this.touchCount));
    }

    private void requestLocationUpdates() {
        if (ContextCompat.checkSelfPermission((Context)this, (String)"android.permission.ACCESS_FINE_LOCATION") != 0) {
            ActivityCompat.requestPermissions((Activity)this, (String[])new String[]{"android.permission.ACCESS_FINE_LOCATION"}, (int)4001);
        } else {
            this.enableLocationSettings();
        }
    }

    private void startLocationUpdates() {
        try {
            this.locationManager.requestLocationUpdates("gps", 1000L, 0.0f, (LocationListener)this);
        }
        catch (SecurityException e) {
            e.printStackTrace();
        }
    }

    private double calculateDistance(double lat1, double lon1, double lat2, double lon2) {
        double x = Math.toRadians(lon2 - lon1) * Math.cos(Math.toRadians((lat1 + lat2) / 2.0));
        double y = Math.toRadians(lat2 - lat1);
        return Math.sqrt(x * x + y * y) * 6371000.0;
    }

    private double calculateSpeed(double lat1, double lon1, double lat2, double lon2, int timeDifferenceInSeconds) {
        double distance = this.calculateDistance(lat1, lon1, lat2, lon2);
        return distance / (double)timeDifferenceInSeconds * (double)3.6f;
    }

    private void stopLocationUpdates() {
        this.locationManager.removeUpdates((LocationListener)this);
    }

    private String getCutOffLimit() {
        if (this.mEtLimit.getText().length() != 0) {
            if (Float.valueOf(this.mEtLimit.getText().toString()).floatValue() > this.mAcceleration) {
                return "red";
            }
            return "green";
        }
        return "";
    }

    private void registerSensor() {
        this.mStartTimestamp = String.valueOf(System.currentTimeMillis());
        this.mSensorManager = (SensorManager)this.getSystemService("sensor");
        this.mSensor = this.mSensorManager.getDefaultSensor(1);
        this.mSensorManager.registerListener((SensorEventListener)this, this.mSensor, 3);
        Snackbar.make((View)this.mLlTelematicsMain, (CharSequence)"Sensor Registered", (int)-1).show();
        final int[] recordsCount = new int[]{0};
        this.mTvRecordsSaved.setText((CharSequence)String.valueOf(recordsCount[0]));
        this.mHandler = new Handler();
        this.mRunnable = new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                try {
                    JSONObject jobj = new JSONObject();
                    JSONObject jobjData = new JSONObject();
                    String timestamp = String.valueOf(System.currentTimeMillis());
                    jobjData.putOpt("acceleration", (Object)Float.valueOf(TelematicsActivity.this.mAcceleration));
                    jobjData.putOpt("speed", (Object)TelematicsActivity.this.mSpeed);
                    jobjData.putOpt("orientation_count", (Object)TelematicsActivity.this.orientationCount);
                    jobjData.putOpt("touch_count", (Object)TelematicsActivity.this.touchCount);
                    jobjData.putOpt("timestamp", (Object)timestamp);
                    jobjData.putOpt("start_time", (Object)TelematicsActivity.this.mStartTimestamp);
                    jobjData.putOpt("stop_time", (Object)TelematicsActivity.this.mStopTimestamp);
                    jobjData.putOpt("latitude", (Object)TelematicsActivity.this.mLatitude);
                    jobjData.putOpt("longitude", (Object)TelematicsActivity.this.mLongitude);
                    jobjData.putOpt("limit", (Object)TelematicsActivity.this.getCutOffLimit());
                    jobjData.putOpt("samples", (Object)(TextUtils.isEmpty((CharSequence)TelematicsActivity.this.mEtSampleTime.getText()) ? 5000 : Integer.parseInt(TelematicsActivity.this.mEtSampleTime.getText().toString())));
                    jobj.putOpt(timestamp, (Object)jobjData);
                    TelematicsActivity.this.mAccelerationTimestamps.add(jobj);
                    recordsCount[0] = recordsCount[0] + 1;
                    TelematicsActivity.this.mTvRecordsSaved.setText((CharSequence)String.valueOf(recordsCount[0]));
                }
                catch (JSONException e) {
                    try {
                        e.printStackTrace();
                        Snackbar.make((View)TelematicsActivity.this.mLlTelematicsMain, (CharSequence)"Runnable Failed", (int)-1).show();
                    }
                    catch (Throwable throwable) {
                        TelematicsActivity.this.mHandler.removeCallbacks(TelematicsActivity.this.mRunnable);
                        TelematicsActivity.this.mHandler = new Handler();
                        TelematicsActivity.this.mHandler.postDelayed((Runnable)this, TextUtils.isEmpty((CharSequence)TelematicsActivity.this.mEtSampleTime.getText()) ? 5000L : (long)Integer.parseInt(TelematicsActivity.this.mEtSampleTime.getText().toString()));
                        throw throwable;
                    }
                    TelematicsActivity.this.mHandler.removeCallbacks(TelematicsActivity.this.mRunnable);
                    TelematicsActivity.this.mHandler = new Handler();
                    TelematicsActivity.this.mHandler.postDelayed((Runnable)this, TextUtils.isEmpty((CharSequence)TelematicsActivity.this.mEtSampleTime.getText()) ? 5000L : (long)Integer.parseInt(TelematicsActivity.this.mEtSampleTime.getText().toString()));
                }
                TelematicsActivity.this.mHandler.removeCallbacks(TelematicsActivity.this.mRunnable);
                TelematicsActivity.this.mHandler = new Handler();
                TelematicsActivity.this.mHandler.postDelayed((Runnable)this, TextUtils.isEmpty((CharSequence)TelematicsActivity.this.mEtSampleTime.getText()) ? 5000L : (long)Integer.parseInt(TelematicsActivity.this.mEtSampleTime.getText().toString()));
            }
        };
        this.mHandler.post(this.mRunnable);
    }

    private void unregisterSensor() {
        this.mStopTimestamp = String.valueOf(System.currentTimeMillis());
        this.orientationCount = 0;
        this.touchCount = 0;
        this.mSensorManager.unregisterListener((SensorEventListener)this);
        this.mTvVelocity.setText((CharSequence)"0.0 m/s^2");
        this.mTvAvgVelocity.setText((CharSequence)"0.0 km/h");
        Snackbar.make((View)this.mLlTelematicsMain, (CharSequence)"Sensor Unregistered", (int)-1).show();
        if (this.mHandler != null) {
            this.mHandler.removeCallbacks(this.mRunnable);
        }
        if (this.mTouchHandler != null) {
            this.mTouchHandler.removeCallbacks(this.mTouchRunnable);
        }
        this.saveAccelerationDataToFile();
    }

    private void saveAccelerationDataToFile() {
        this.jsonArray = new JSONArray();
        for (JSONObject jsonObject : this.mAccelerationTimestamps) {
            String parent;
            JSONObject jobj;
            if (jsonObject.keys().hasNext() && (jobj = jsonObject.optJSONObject(parent = (String)jsonObject.keys().next())) != null) {
                try {
                    jobj.put("stop_time", (Object)this.mStopTimestamp);
                }
                catch (JSONException e) {
                    throw new RuntimeException(e);
                }
            }
            this.jsonArray.put((Object)jsonObject);
        }
        this.sendAccelerationDataToServer(this.jsonArray);
    }

    private void sendAccelerationDataToServer(JSONArray jsonArray) {
        WarplyManager.sendAccelerationDataToServer(jsonArray, this.mTelematicsCallback);
    }

    private void enableLocationSettings() {
        LocationRequest locationRequest = LocationRequest.create();
        locationRequest.setPriority(100);
        LocationSettingsRequest.Builder locationBuilder = new LocationSettingsRequest.Builder().addLocationRequest(locationRequest);
        Task result = LocationServices.getSettingsClient((Activity)this).checkLocationSettings(locationBuilder.build());
        result.addOnCompleteListener(task -> {
            try {
                LocationSettingsResponse response = (LocationSettingsResponse)task.getResult(ApiException.class);
                this.mIsTripStarted = true;
                this.mTvTripButton.setText(R.string.cos_dlg_stop_trip);
                this.startLocationUpdates();
                this.registerSensor();
            }
            catch (ApiException exception) {
                switch (exception.getStatusCode()) {
                    case 6: {
                        try {
                            ResolvableApiException resolvable = (ResolvableApiException)exception;
                            resolvable.startResolutionForResult((Activity)this, 4000);
                        }
                        catch (IntentSender.SendIntentException e) {
                            Log.v((String)"SendIntentException", (String)e.getMessage());
                            if (this.isFinishing()) break;
                            AlertDialog.Builder alertBuilder = new AlertDialog.Builder((Context)this);
                            alertBuilder.setTitle((CharSequence)this.getString(R.string.cos_telematics));
                            alertBuilder.setMessage((CharSequence)this.getString(R.string.lbl_telematics_generic_error)).setCancelable(false).setNegativeButton((CharSequence)this.getString(R.string.cos_dlg_positive_button2), (dialog, id2) -> {});
                            AlertDialog alert = alertBuilder.create();
                            alert.show();
                        }
                        catch (ClassCastException e) {
                            Log.v((String)"ClassCastException", (String)e.getMessage());
                            if (this.isFinishing()) break;
                            AlertDialog.Builder alertBuilder2 = new AlertDialog.Builder((Context)this);
                            alertBuilder2.setTitle((CharSequence)this.getString(R.string.cos_telematics));
                            alertBuilder2.setMessage((CharSequence)this.getString(R.string.lbl_telematics_generic_error)).setCancelable(false).setNegativeButton((CharSequence)this.getString(R.string.cos_dlg_positive_button2), (dialog, id2) -> {});
                            AlertDialog alert = alertBuilder2.create();
                            alert.show();
                        }
                        break;
                    }
                    case 8502: {
                        Log.v((String)"SETTINGS_CHANGE_UNAVAILABLE", (String)"SETTINGS_CHANGE_UNAVAILABLE");
                        if (this.isFinishing()) break;
                        AlertDialog.Builder alertBuilder3 = new AlertDialog.Builder((Context)this);
                        alertBuilder3.setTitle((CharSequence)this.getString(R.string.cos_telematics));
                        alertBuilder3.setMessage((CharSequence)this.getString(R.string.lbl_telematics_generic_error)).setCancelable(false).setNegativeButton((CharSequence)this.getString(R.string.cos_dlg_positive_button2), (dialog, id2) -> {});
                        AlertDialog alert = alertBuilder3.create();
                        alert.show();
                    }
                }
            }
        });
    }
}

