/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import androidx.recyclerview.widget.ConcatAdapter;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.material.snackbar.Snackbar;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.util.ArrayList;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.TelematicsMetricsActivity;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.TelematicsHistory;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.TelematicsHistoryAdapter;
import ly.warp.sdk.views.adapters.TelematicsHistoryHeaderAdapter;

public class TelematicsHistoryActivity
extends Activity
implements View.OnClickListener {
    private RecyclerView mRvTripHistory;
    private LinearLayout mLlTelematicsHistoryMain;
    private ArrayList<TelematicsHistory> mTelematicsHistoryData = new ArrayList();
    private TelematicsHistoryAdapter mAdapterTelematicsHistory;
    private TelematicsHistoryHeaderAdapter mAdapterTelematicsHistoryHeader;
    private boolean mTelematicsHistoryItemPressed = false;
    private ImageView mIvClose;
    private final CallbackReceiver<ArrayList<TelematicsHistory>> mTelematicsHistoryCallback = new CallbackReceiver<ArrayList<TelematicsHistory>>(){

        @Override
        public void onSuccess(ArrayList<TelematicsHistory> result) {
            TelematicsHistoryActivity.this.mTelematicsHistoryData.clear();
            TelematicsHistoryActivity.this.mTelematicsHistoryData.addAll(result);
            Snackbar.make((View)TelematicsHistoryActivity.this.mLlTelematicsHistoryMain, (CharSequence)"Success getting history", (int)-1).show();
            TelematicsHistoryActivity.this.initViews();
        }

        @Override
        public void onFailure(int errorCode) {
            Snackbar.make((View)TelematicsHistoryActivity.this.mLlTelematicsHistoryMain, (CharSequence)"Error getting history", (int)-1).show();
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_telematics_history);
        this.mRvTripHistory = (RecyclerView)this.findViewById(R.id.rv_trip_history);
        this.mLlTelematicsHistoryMain = (LinearLayout)this.findViewById(R.id.ll_telematics_history_main);
        this.mIvClose = (ImageView)this.findViewById(R.id.iv_telematics_history_close);
        this.mIvClose.setOnClickListener((View.OnClickListener)this);
        WarplyManager.getTelematicsHistory(this.mTelematicsHistoryCallback);
    }

    public void onResume() {
        super.onResume();
        this.mTelematicsHistoryItemPressed = false;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_telematics_history_close) {
            this.onBackPressed();
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        if (this.mTelematicsHistoryData != null && this.mTelematicsHistoryData.size() > 0) {
            this.mRvTripHistory.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
            this.mAdapterTelematicsHistoryHeader = new TelematicsHistoryHeaderAdapter((Context)this);
            this.mAdapterTelematicsHistory = new TelematicsHistoryAdapter((Context)this, this.mTelematicsHistoryData);
            ConcatAdapter concatAdapter = new ConcatAdapter(new RecyclerView.Adapter[]{this.mAdapterTelematicsHistoryHeader, this.mAdapterTelematicsHistory});
            this.mRvTripHistory.setAdapter((RecyclerView.Adapter)concatAdapter);
            this.mAdapterTelematicsHistory.getPositionClicks().doOnNext(historyItem -> {
                if (!this.mTelematicsHistoryItemPressed) {
                    this.mTelematicsHistoryItemPressed = true;
                    Intent intent = new Intent((Context)this, TelematicsMetricsActivity.class);
                    intent.putExtra("trip_id", historyItem.getTripId());
                    this.startActivity(intent);
                }
            }).doOnError(error -> {}).subscribe();
        }
    }
}

