/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.os.Bundle;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.cardview.widget.CardView;
import com.google.android.material.snackbar.Snackbar;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import ly.warp.sdk.R;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.TripMetrics;
import ly.warp.sdk.utils.managers.WarplyManager;

public class TelematicsMetricsActivity
extends Activity
implements View.OnClickListener {
    private LinearLayout mLlTelematicsMetricsMain;
    private ImageView mIvClose;
    private ImageView mIvRatePositive;
    private ImageView mIvRateNegative;
    private int mTripId = -1;
    private TripMetrics mTripMetrics;
    private CardView mCvAvgSpeed;
    private CardView mCvTrips;
    private CardView mCvAccScore;
    private CardView mCvFocusScore;
    private CardView mCvReadinessScore;
    private CardView mCvSmoothnessScore;
    private CardView mCvTotalDistance;
    private final CallbackReceiver<TripMetrics> mTripMetricsCallback = new CallbackReceiver<TripMetrics>(){

        @Override
        public void onSuccess(TripMetrics result) {
            TelematicsMetricsActivity.this.mTripMetrics = result;
            Snackbar.make((View)TelematicsMetricsActivity.this.mLlTelematicsMetricsMain, (CharSequence)"Success getting history", (int)-1).show();
            TelematicsMetricsActivity.this.initViews();
        }

        @Override
        public void onFailure(int errorCode) {
            Snackbar.make((View)TelematicsMetricsActivity.this.mLlTelematicsMetricsMain, (CharSequence)"Error getting history", (int)-1).show();
        }
    };
    private final CallbackReceiver<Integer> mRateTripCallback = new CallbackReceiver<Integer>(){

        @Override
        public void onSuccess(Integer result) {
            Snackbar.make((View)TelematicsMetricsActivity.this.mLlTelematicsMetricsMain, (CharSequence)"Success rate trip", (int)-1).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Snackbar.make((View)TelematicsMetricsActivity.this.mLlTelematicsMetricsMain, (CharSequence)"Error rate trip", (int)-1).show();
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_telematics_metrics);
        this.mTripId = this.getIntent().getIntExtra("trip_id", -1);
        this.mLlTelematicsMetricsMain = (LinearLayout)this.findViewById(R.id.ll_telematics_metrics_main);
        this.mIvClose = (ImageView)this.findViewById(R.id.iv_metrics_close);
        this.mIvClose.setOnClickListener((View.OnClickListener)this);
        this.mIvRatePositive = (ImageView)this.findViewById(R.id.iv_rate_positive);
        this.mIvRateNegative = (ImageView)this.findViewById(R.id.iv_rate_negative);
        this.mIvRatePositive.setOnClickListener((View.OnClickListener)this);
        this.mIvRateNegative.setOnClickListener((View.OnClickListener)this);
        this.mCvAvgSpeed = (CardView)this.findViewById(R.id.ly_avg_speed);
        this.mCvTrips = (CardView)this.findViewById(R.id.ly_trips);
        this.mCvAccScore = (CardView)this.findViewById(R.id.ly_acc_score);
        this.mCvFocusScore = (CardView)this.findViewById(R.id.ly_focus_score);
        this.mCvReadinessScore = (CardView)this.findViewById(R.id.ly_readiness_score);
        this.mCvSmoothnessScore = (CardView)this.findViewById(R.id.ly_smoothness_score);
        this.mCvTotalDistance = (CardView)this.findViewById(R.id.ly_total_distance);
        if (this.mTripId > -1) {
            WarplyManager.getTripMetrics(this.mTripId, this.mTripMetricsCallback);
        }
    }

    public void onResume() {
        super.onResume();
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_metrics_close) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.iv_rate_positive) {
            WarplyManager.rateTrip(this.mTripId, true, this.mRateTripCallback);
            return;
        }
        if (view.getId() == R.id.iv_rate_negative) {
            WarplyManager.rateTrip(this.mTripId, false, this.mRateTripCallback);
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        if (this.mTripMetrics != null) {
            TextView mCvAvgSpeedText = (TextView)this.mCvAvgSpeed.findViewById(R.id.tv_telematics_metric_title_value);
            TextView mCvAvgSpeedSubtitleText = (TextView)this.mCvAvgSpeed.findViewById(R.id.tv_telematics_metric_subtitle);
            mCvAvgSpeedText.setText((CharSequence)String.valueOf(this.mTripMetrics.getAvgSpeed()));
            mCvAvgSpeedSubtitleText.setText((CharSequence)"Average Speed");
            TextView mCvTripsText = (TextView)this.mCvTrips.findViewById(R.id.tv_telematics_metric_title_value);
            TextView mCvTripsSubtitleText = (TextView)this.mCvTrips.findViewById(R.id.tv_telematics_metric_subtitle);
            mCvTripsText.setText((CharSequence)String.valueOf(this.mTripMetrics.getNumOfTrips()));
            mCvTripsSubtitleText.setText((CharSequence)"Trips");
            TextView mCvAccScoreText = (TextView)this.mCvAccScore.findViewById(R.id.tv_telematics_metric_title_value);
            TextView mCvAccScoreSubtitleText = (TextView)this.mCvAccScore.findViewById(R.id.tv_telematics_metric_subtitle);
            mCvAccScoreText.setText((CharSequence)String.valueOf(this.mTripMetrics.getOverallScore()));
            mCvAccScoreSubtitleText.setText((CharSequence)"Acceleration Score");
            TextView mCvFocusScoreText = (TextView)this.mCvFocusScore.findViewById(R.id.tv_telematics_metric_title_value);
            TextView mCvFocusScoreSubtitleText = (TextView)this.mCvFocusScore.findViewById(R.id.tv_telematics_metric_subtitle);
            mCvFocusScoreText.setText((CharSequence)String.valueOf(this.mTripMetrics.getOverallFocus()));
            mCvFocusScoreSubtitleText.setText((CharSequence)"Focus Score");
            TextView mCvReadinessScoreText = (TextView)this.mCvReadinessScore.findViewById(R.id.tv_telematics_metric_title_value);
            TextView mCvReadinessScoreSubtitleText = (TextView)this.mCvReadinessScore.findViewById(R.id.tv_telematics_metric_subtitle);
            mCvReadinessScoreText.setText((CharSequence)String.valueOf(this.mTripMetrics.getReadinessScore()));
            mCvReadinessScoreSubtitleText.setText((CharSequence)"Readiness Score");
            TextView mCvSmoothnessScoreText = (TextView)this.mCvSmoothnessScore.findViewById(R.id.tv_telematics_metric_title_value);
            TextView mCvSmoothnessScoreSubtitleText = (TextView)this.mCvSmoothnessScore.findViewById(R.id.tv_telematics_metric_subtitle);
            mCvSmoothnessScoreText.setText((CharSequence)String.valueOf(this.mTripMetrics.getSmoothnessScore()));
            mCvSmoothnessScoreSubtitleText.setText((CharSequence)"Smoothness Score");
            TextView mCvTotalDistanceText = (TextView)this.mCvTotalDistance.findViewById(R.id.tv_telematics_metric_title_value);
            TextView mCvTotalDistanceSubtitleText = (TextView)this.mCvTotalDistance.findViewById(R.id.tv_telematics_metric_subtitle);
            mCvTotalDistanceText.setText((CharSequence)String.valueOf(this.mTripMetrics.getTotalKM()));
            mCvTotalDistanceSubtitleText.setText((CharSequence)"Total Distance");
        }
    }
}

