/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.graphics.Bitmap;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.View;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.TextView;
import androidx.appcompat.app.AlertDialog;
import androidx.core.content.ContextCompat;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import com.google.android.gms.common.GoogleApiAvailability;
import com.google.zxing.BarcodeFormat;
import com.google.zxing.common.BitMatrix;
import com.google.zxing.oned.EAN13Writer;
import io.github.inflationx.viewpump.ViewPumpContextWrapper;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Collections;
import java.util.Date;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.CouponInfoActivity;
import ly.warp.sdk.activities.ShopsActivity;
import ly.warp.sdk.activities.ShopsHuaweiActivity;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.RefreshUnifiedCouponsEventModel;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.views.adapters.ActiveCouponAdapter;
import org.greenrobot.eventbus.EventBus;

public class UnifiedCouponInfoActivity
extends Activity
implements View.OnClickListener {
    private ImageView mIvBack;
    private ImageView mIvBarcode;
    private ImageView mIvMarketExpand;
    private TextView mTvTerms;
    private TextView mTvCouponCode;
    private TextView mTvCouponDate;
    private TextView mTvMarketExpand;
    private TextView mTvTermsValue;
    private TextView mTvFullBarcode;
    private TextView mTvActiveValue;
    private LinearLayout mLlShops;
    private LinearLayout mLlBarcodeContainer;
    private LinearLayout mLlTerms;
    private LinearLayout mLlMarketCoupons;
    private LinearLayout mLlMarketExpand;
    private LinearLayout mLlCancelUnified;
    private UnifiedCoupon mCoupon;
    private boolean mIsBarcodeShown = false;
    private boolean mIsTermsShown = false;
    private boolean mIsFromWallet = false;
    private boolean mIsMarketExpand = true;
    private boolean mShopsPressed = false;
    private boolean mCouponPressed = false;
    private RecyclerView mRecyclerCoupons;
    private ActiveCouponAdapter mAdapterCoupons;
    private AlertDialog mErrorAlertDialog;
    private AlertDialog mSuccessAlertDialog;
    private AlertDialog mAskCancelUnifiedAlertDialog;
    private final CallbackReceiver<Integer> mCancelUnifiedCallback = new CallbackReceiver<Integer>(){

        @Override
        public void onSuccess(Integer result) {
            UnifiedCouponInfoActivity.this.successDialog();
        }

        @Override
        public void onFailure(int errorCode) {
            UnifiedCouponInfoActivity.this.errorDialog();
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.setContentView(R.layout.activity_unified_coupon_info);
        UnifiedCoupon tempCoupon = (UnifiedCoupon)this.getIntent().getSerializableExtra("coupon");
        if (tempCoupon != null) {
            for (UnifiedCoupon couponItem : WarplyManagerHelper.getMarketCoupons()) {
                if (!couponItem.getBarcode().equals(tempCoupon.getBarcode())) continue;
                this.mCoupon = couponItem;
                break;
            }
        }
        this.mIvBack = (ImageView)this.findViewById(R.id.iv_coupon_info_back);
        this.mTvTerms = (TextView)this.findViewById(R.id.tv_terms);
        this.mTvCouponCode = (TextView)this.findViewById(R.id.textView16);
        this.mTvCouponDate = (TextView)this.findViewById(R.id.textView17);
        this.mIvBarcode = (ImageView)this.findViewById(R.id.iv_barcode);
        this.mLlShops = (LinearLayout)this.findViewById(R.id.ll_shops);
        this.mLlBarcodeContainer = (LinearLayout)this.findViewById(R.id.ll_barcode_container_items);
        this.mLlTerms = (LinearLayout)this.findViewById(R.id.ll_terms_inner);
        this.mTvTermsValue = (TextView)this.findViewById(R.id.tv_terms_value);
        this.mTvFullBarcode = (TextView)this.findViewById(R.id.tv_full_barcode);
        this.mLlMarketCoupons = (LinearLayout)this.findViewById(R.id.ll_market_coupons);
        this.mLlMarketExpand = (LinearLayout)this.findViewById(R.id.ll_market_expand);
        this.mTvMarketExpand = (TextView)this.findViewById(R.id.tv_market_expand);
        this.mIvMarketExpand = (ImageView)this.findViewById(R.id.iv_market_expand);
        this.mRecyclerCoupons = (RecyclerView)this.findViewById(R.id.rv_active_market_coupons);
        this.mTvActiveValue = (TextView)this.findViewById(R.id.textView14);
        this.mLlCancelUnified = (LinearLayout)this.findViewById(R.id.ll_cancel_coupon);
        this.mRecyclerCoupons.setNestedScrollingEnabled(false);
        this.mRecyclerCoupons.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager((Context)this, 1, false));
        this.initViews();
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent((Context)this, "screen", "UnifiedCouponScreen");
        this.mShopsPressed = false;
        this.mCouponPressed = false;
    }

    public void onClick(View view) {
        if (view.getId() == R.id.iv_coupon_info_back) {
            this.onBackPressed();
            return;
        }
        if (view.getId() == R.id.ll_shops && !this.mShopsPressed) {
            this.mShopsPressed = true;
            WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "SeeShops");
            if (GoogleApiAvailability.getInstance().isGooglePlayServicesAvailable((Context)this) == 0) {
                Intent intent = new Intent((Context)this, ShopsActivity.class);
                this.startActivity(intent);
                return;
            }
            Intent intent = new Intent((Context)this, ShopsHuaweiActivity.class);
            this.startActivity(intent);
            return;
        }
        if (view.getId() == R.id.ll_terms_inner) {
            if (this.mIsTermsShown) {
                this.mTvTermsValue.setVisibility(8);
                ImageView termsButtonArrow = (ImageView)this.mLlTerms.findViewById(R.id.iv_terms_arrow);
                termsButtonArrow.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_down_dark_new));
                this.mIsTermsShown = false;
            } else {
                this.mTvTermsValue.setVisibility(0);
                ImageView termsButtonArrow = (ImageView)this.mLlTerms.findViewById(R.id.iv_terms_arrow);
                termsButtonArrow.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_up_dark_new));
                this.mIsTermsShown = true;
            }
            return;
        }
        if (view.getId() == R.id.ll_market_expand) {
            if (this.mIsMarketExpand) {
                this.mLlMarketCoupons.setVisibility(8);
                this.mTvMarketExpand.setText((CharSequence)this.getString(R.string.cos_show_market_coupons));
                this.mIvMarketExpand.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_down_dark_new));
                this.mIsMarketExpand = false;
            } else {
                this.mLlMarketCoupons.setVisibility(0);
                this.mTvMarketExpand.setText((CharSequence)this.getString(R.string.cos_hide_market_coupons));
                this.mIvMarketExpand.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_up_dark_new));
                this.mIsMarketExpand = true;
            }
            return;
        }
        if (view.getId() == R.id.ll_cancel_coupon) {
            this.askCancelUnifiedDialog();
        }
    }

    protected void attachBaseContext(Context newBase) {
        super.attachBaseContext((Context)ViewPumpContextWrapper.wrap((Context)newBase));
    }

    private void initViews() {
        this.mTvCouponCode.setText((CharSequence)this.mCoupon.getBarcode());
        this.mLlMarketCoupons.setVisibility(8);
        this.mTvMarketExpand.setText((CharSequence)this.getString(R.string.cos_show_market_coupons));
        this.mIvMarketExpand.setImageDrawable(ContextCompat.getDrawable((Context)this, (int)R.drawable.ic_down_dark_new));
        this.mIsMarketExpand = false;
        if (this.mCoupon.getCoupons() != null && this.mCoupon.getCoupons().size() > 0) {
            Date newDate;
            SimpleDateFormat simpleDateFormat;
            float activeValue = 0.0f;
            CouponList cpnlist = new CouponList();
            for (Coupon cpn : this.mCoupon.getCoupons()) {
                if (cpn.getStatus() == 1) {
                    activeValue += Float.parseFloat(cpn.getDiscount());
                }
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                newDate = new Date();
                try {
                    newDate = simpleDateFormat.parse(cpn.getExpiration());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                cpn.setExpirationDate(newDate);
                cpnlist.add(cpn);
            }
            this.mTvActiveValue.setText((CharSequence)this.getString(R.string.cos_unified_subtitle2));
            Collections.sort(cpnlist, (coupon1, coupon2) -> coupon2.getExpirationDate().compareTo(coupon1.getExpirationDate()));
            for (Coupon tempItem : cpnlist) {
                if (tempItem.getStatus() != 1) continue;
                simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                newDate = new Date();
                try {
                    newDate = simpleDateFormat.parse(tempItem.getExpiration());
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
                simpleDateFormat = new SimpleDateFormat("dd/MM/yyyy");
                this.mTvCouponDate.setText((CharSequence)String.format(this.getResources().getString(R.string.cos_mycoupon_date), simpleDateFormat.format(newDate != null ? newDate : "")));
                break;
            }
            this.mAdapterCoupons = new ActiveCouponAdapter((Context)this, cpnlist, false, true);
            this.mRecyclerCoupons.setAdapter((RecyclerView.Adapter)this.mAdapterCoupons);
            this.mAdapterCoupons.getPositionClicks().doOnNext(coupon -> {
                if (!this.mCouponPressed) {
                    this.mCouponPressed = true;
                    WarplyAnalyticsManager.logTrackersEvent((Context)this, "click", "MarketCoupon".concat(":").concat(coupon.getName()));
                    Intent intent = new Intent((Context)this, CouponInfoActivity.class);
                    intent.putExtra("coupon", coupon.getCoupon());
                    intent.putExtra("isFromWallet", true);
                    intent.putExtra("isUnified", true);
                    intent.putExtra("unifiedCoupon", this.mCoupon.getBarcode());
                    this.startActivity(intent);
                }
            }).doOnError(error -> {}).subscribe();
        }
        this.mIvBack.setOnClickListener((View.OnClickListener)this);
        this.mLlShops.setOnClickListener((View.OnClickListener)this);
        this.mLlTerms.setOnClickListener((View.OnClickListener)this);
        this.mLlMarketExpand.setOnClickListener((View.OnClickListener)this);
        this.mLlCancelUnified.setOnClickListener((View.OnClickListener)this);
        String tempCoupon = "";
        int result = 0;
        try {
            tempCoupon = this.mCoupon.getBarcode();
            for (int i = 0; i < 12 - this.mCoupon.getBarcode().length(); ++i) {
                tempCoupon = tempCoupon + "0";
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            for (int i = this.mCoupon.getBarcode().length() - 1; i >= 0; --i) {
                result += Integer.parseInt(String.valueOf(this.mCoupon.getBarcode().charAt(i))) * (1 + 2 * (i % 2));
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        tempCoupon = tempCoupon + (10 - result % 10) % 10;
        this.createBarcodeBitmap(this.mCoupon.getBarcode());
    }

    private void createBarcodeBitmap(String barcodeString) {
        EAN13Writer writer = new EAN13Writer();
        try {
            BitMatrix bitMatrix = writer.encode(barcodeString, BarcodeFormat.EAN_13, 1024, 512);
            int width = bitMatrix.getWidth();
            int height = bitMatrix.getHeight();
            Bitmap bmp = Bitmap.createBitmap((int)width, (int)height, (Bitmap.Config)Bitmap.Config.RGB_565);
            for (int x = 0; x < width; ++x) {
                for (int y = 0; y < height; ++y) {
                    bmp.setPixel(x, y, bitMatrix.get(x, y) ? -16777216 : -1);
                }
            }
            this.mIvBarcode.setImageBitmap(bmp);
            this.mTvFullBarcode.setText((CharSequence)barcodeString);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.mLlBarcodeContainer.setVisibility(8);
            this.mIvBarcode.setVisibility(8);
        }
    }

    private void cancelUnified() {
        if (this.mCoupon.getCoupons() != null && this.mCoupon.getCoupons().size() == 0) {
            return;
        }
        String transactionID = this.mCoupon.getCoupons().get(0).getTransactionUuid();
        if (TextUtils.isEmpty((CharSequence)transactionID)) {
            return;
        }
        WarplyManager.cancelUnifiedCoupon(transactionID, this.mCancelUnifiedCallback);
    }

    private void askCancelUnifiedDialog() {
        if (!this.isFinishing()) {
            this.mAskCancelUnifiedAlertDialog = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_cancel_unified_coupon_success_title).setMessage(R.string.cos_dlg_cancel_unified_coupon_success_subtitle2).setPositiveButton(R.string.cos_dlg_positive_button3, (dialogPositive, whichPositive) -> this.cancelUnified()).setNegativeButton(R.string.cos_dlg_negative_button4, (dialogNegative, whichNegative) -> dialogNegative.dismiss()).show();
        }
    }

    private void errorDialog() {
        if (!this.isFinishing()) {
            this.mErrorAlertDialog = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_cancel_unified_coupon_success_title).setMessage(R.string.cos_dlg_error_subtitle).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).setCancelable(false).show();
        }
    }

    private void successDialog() {
        if (!this.isFinishing()) {
            this.mSuccessAlertDialog = new AlertDialog.Builder((Context)this).setTitle(R.string.cos_dlg_cancel_unified_coupon_success_title).setMessage(R.string.cos_dlg_cancel_unified_coupon_success_subtitle).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> {
                RefreshUnifiedCouponsEventModel couponsRefreshed = new RefreshUnifiedCouponsEventModel();
                EventBus.getDefault().post((Object)new WarplyEventBusManager(couponsRefreshed));
                dialogPositive.dismiss();
                this.onBackPressed();
            }).setCancelable(false).show();
        }
    }
}

