/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.activities;

import android.content.Context;
import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.os.Handler;
import android.text.TextUtils;
import android.view.KeyEvent;
import android.view.View;
import android.view.ViewGroup;
import android.webkit.WebView;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.annotation.NonNull;
import androidx.work.Constraints;
import androidx.work.NetworkType;
import androidx.work.OneTimeWorkRequest;
import androidx.work.WorkManager;
import androidx.work.WorkRequest;
import java.security.SecureRandom;
import java.text.SimpleDateFormat;
import java.util.Date;
import java.util.Locale;
import java.util.concurrent.ThreadLocalRandom;
import java.util.concurrent.TimeUnit;
import ly.warp.sdk.Warply;
import ly.warp.sdk.activities.WarpBaseActivity;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.WarplyWebviewActivityCallbackEventModel;
import ly.warp.sdk.io.models.WarplyWebviewCallbackEventModel;
import ly.warp.sdk.io.request.PacingCalculateRequest;
import ly.warp.sdk.services.EventCampaignCouponService;
import ly.warp.sdk.services.EventQuestionnaireService;
import ly.warp.sdk.services.PushEventsClickedWorkerService;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.WarplyPreferences;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import ly.warp.sdk.utils.managers.WarplyManager;
import ly.warp.sdk.utils.managers.WarplySessionManager;
import ly.warp.sdk.views.WarpView;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;
import org.json.JSONException;
import org.json.JSONObject;

public class WarpViewActivity
extends WarpBaseActivity {
    private WarpView mWarpView;
    private static Handler metersHandler;
    private static boolean mWebviewSupermarket;
    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>(){

        @Override
        public void onSuccess(CouponList result) {
        }

        @Override
        public void onFailure(int errorCode) {
        }
    };

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        metersHandler = new Handler();
        mWebviewSupermarket = false;
        WarplySessionManager.onCreateActivity(this);
        this.initViews();
        Warply.getInitializer((Context)this).init();
        this.setPageAccordingToIntent();
    }

    protected void onNewIntent(Intent intent) {
        super.onNewIntent(intent);
        this.setIntent(intent);
        this.setPageAccordingToIntent();
    }

    protected void onStart() {
        super.onStart();
        WarplySessionManager.onStartActivity(this);
        EventBus.getDefault().register((Object)this);
        if (this.mWarpView != null && WarpViewActivity.getWebviewSupermarket()) {
            String scriptSourceInit = "webviewDidFocusRefresh(" + String.valueOf(WarpViewActivity.getWebviewSupermarket()) + ");";
            this.mWarpView.evaluateJavascript(scriptSourceInit, s -> {});
            WarpViewActivity.setWebviewSupermarket(false);
        }
    }

    protected void onStop() {
        super.onStop();
        WarplySessionManager.onStopActivity(this);
        EventBus.getDefault().unregister((Object)this);
    }

    protected void onDestroy() {
        super.onDestroy();
        if (metersHandler != null) {
            metersHandler.removeCallbacksAndMessages(null);
        }
        this.sendSteps();
        WarpUtils.setWebviewParams((Context)this, new JSONObject());
        WarpViewActivity.setWebviewSupermarket(false);
    }

    public boolean onKeyDown(int keyCode, @NonNull KeyEvent event) {
        if (keyCode == 4 && this.mWarpView.canGoBack()) {
            this.mWarpView.goBack();
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public void onRequestPermissionsResult(int requestCode, @NonNull String[] permissions, @NonNull int[] grantResults) {
        super.onRequestPermissionsResult(requestCode, permissions, grantResults);
        if (requestCode == 3001) {
            WarplyWebviewCallbackEventModel webviewCallbackEventModel = new WarplyWebviewCallbackEventModel();
            webviewCallbackEventModel.setRequestId(requestCode);
            webviewCallbackEventModel.setResponseCode(grantResults[0] == 0 ? "allow" : "deny");
            EventBus.getDefault().post((Object)new WarplyEventBusManager(webviewCallbackEventModel));
        }
    }

    protected void onActivityResult(int requestCode, int resultCode, Intent data) {
        super.onActivityResult(requestCode, resultCode, data);
        if (requestCode == 3002 || requestCode == 3003) {
            WarplyWebviewActivityCallbackEventModel webviewCallbackEventModel = new WarplyWebviewActivityCallbackEventModel();
            webviewCallbackEventModel.setRequestId(requestCode);
            webviewCallbackEventModel.setResponseCode(resultCode == -1 ? "enabled" : "disabled");
            EventBus.getDefault().post((Object)new WarplyEventBusManager(webviewCallbackEventModel));
        }
    }

    @Subscribe
    public void onMessageEvent(WarplyEventBusManager event) {
        OneTimeWorkRequest mywork;
        if (event.getQuestionnaire() != null) {
            mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventQuestionnaireService.class).build();
            WorkManager.getInstance((Context)this).enqueue((WorkRequest)mywork);
            this.setResult(-1, new Intent());
            this.finish();
        }
        if (event.getCoupon() != null) {
            mywork = (OneTimeWorkRequest)new OneTimeWorkRequest.Builder(EventCampaignCouponService.class).build();
            WorkManager.getInstance((Context)this).enqueue((WorkRequest)mywork);
        }
        if (event.getPacing() != null && !event.getPacing().isVisible()) {
            this.finish();
        }
    }

    private void initViews() {
        RelativeLayout root = new RelativeLayout((Context)this);
        root.setBackgroundColor(-1);
        final ImageView ivLogo = new ImageView((Context)this);
        RelativeLayout.LayoutParams ivLogoParams = new RelativeLayout.LayoutParams(-2, -2);
        ivLogoParams.addRule(13);
        root.addView((View)ivLogo, (ViewGroup.LayoutParams)ivLogoParams);
        ivLogo.setImageDrawable(WarplyProperty.getProgressDrawable((Context)this));
        ivLogo.startAnimation(WarpUtils.getPulseAnimation());
        this.mWarpView = new WarpView((Context)this, this, true);
        RelativeLayout.LayoutParams warpViewParams = new RelativeLayout.LayoutParams(-1, -1);
        root.setFitsSystemWindows(true);
        root.addView((View)this.mWarpView, (ViewGroup.LayoutParams)warpViewParams);
        int progressHeightDp = 7;
        final ProgressBar progressBar = new ProgressBar((Context)this, null, 16842872);
        progressBar.setProgressDrawable(WarpUtils.getHorizontalProgressDrawable(WarplyProperty.getProgressColor((Context)this)));
        RelativeLayout.LayoutParams progressBarParams = new RelativeLayout.LayoutParams(-1, (int)((float)progressHeightDp * this.getResources().getDisplayMetrics().density + 0.5f));
        this.mWarpView.setProgressChangeListener(new WarpView.ProgressChangeListener(){

            @Override
            public void onProgressChanged(WebView view, int newProgress) {
                progressBar.setProgress(newProgress);
                if (progressBar.getProgress() == 100) {
                    WarpUtils.animateVisibility((View)ivLogo, 4);
                    WarpUtils.animateVisibility((View)progressBar, 4);
                } else {
                    WarpUtils.animateVisibility((View)ivLogo, 0);
                    WarpUtils.animateVisibility((View)progressBar, 0);
                }
            }
        });
        this.setContentView((View)root);
    }

    private void setPageAccordingToIntent() {
        Intent intent = this.getIntent();
        String sessionUUID = intent.getStringExtra("sessionUUID");
        if (intent.hasExtra("source") && intent.getStringExtra("source").equalsIgnoreCase("from_notification_status")) {
            JSONObject params = new JSONObject();
            try {
                params.putOpt("web_id", (Object)WarpUtils.getWebId(Warply.getWarplyContext()));
                params.putOpt("app_uuid", (Object)WarplyProperty.getAppUuid(Warply.getWarplyContext()));
                params.putOpt("api_key", (Object)WarpUtils.getApiKey(Warply.getWarplyContext()));
                params.putOpt("session_uuid", (Object)sessionUUID);
                params.putOpt("access_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("access_token"));
                params.putOpt("refresh_token", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getAuthValue("refresh_token"));
                params.putOpt("client_id", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_id"));
                params.putOpt("client_secret", (Object)WarplyDBHelper.getInstance(Warply.getWarplyContext()).getClientValue("client_secret"));
            }
            catch (JSONException e) {
                e.printStackTrace();
            }
            WarpUtils.setWebviewParams(Warply.getWarplyContext(), params);
            this.setUpPushEvents(sessionUUID);
        }
        if (Warply.INSTANCE.getLastReceivedCampaigns() != null && Warply.INSTANCE.getLastReceivedCampaigns().containsUuid(sessionUUID)) {
            new WarplyPreferences((Context)this).clearInboxLastCachedTimeStamps();
        }
        if (!TextUtils.isEmpty((CharSequence)sessionUUID)) {
            this.mWarpView.loadWarpSessionUUID(sessionUUID);
        } else {
            this.mWarpView.loadWarpUrl(this.getIntent().getStringExtra("sessionUrl"));
        }
    }

    private void setUpPushEvents(String sessionUUID) {
        WarplyAnalyticsManager.logUserEngagedPush(WarpJSONParser.createJSONObjectFromString("session_uuid", sessionUUID));
        Constraints constraints = new Constraints.Builder().setRequiredNetworkType(NetworkType.CONNECTED).build();
        OneTimeWorkRequest sendEvent = (OneTimeWorkRequest)((OneTimeWorkRequest.Builder)((OneTimeWorkRequest.Builder)new OneTimeWorkRequest.Builder(PushEventsClickedWorkerService.class).setConstraints(constraints)).setInitialDelay((long)this.defineRandomStart(), TimeUnit.MINUTES)).build();
        WorkManager.getInstance((Context)this).enqueue((WorkRequest)sendEvent);
    }

    private int defineRandomStart() {
        if (Build.VERSION.SDK_INT >= 21) {
            return ThreadLocalRandom.current().nextInt(20, 61);
        }
        SecureRandom rand = new SecureRandom();
        return rand.nextInt(41) + 20;
    }

    public static Intent createIntentFromSessionUUID(Context context, String sessionUUID, String source) {
        Intent intent = new Intent(context, WarpViewActivity.class);
        intent.putExtra("sessionUUID", sessionUUID);
        if (!TextUtils.isEmpty((CharSequence)source)) {
            intent.putExtra("source", source);
        }
        return intent;
    }

    public static Intent createIntentFromSessionUUID(Context context, String sessionUUID) {
        return WarpViewActivity.createIntentFromSessionUUID(context, sessionUUID, null);
    }

    public static Intent createIntentFromURL(Context context, String url) {
        return new Intent(context, WarpViewActivity.class).putExtra("sessionUrl", url);
    }

    public static Handler getMetersHandler() {
        return metersHandler;
    }

    public static boolean getWebviewSupermarket() {
        return mWebviewSupermarket;
    }

    public static void setWebviewSupermarket(boolean isLoaded) {
        mWebviewSupermarket = isLoaded;
    }

    private void sendSteps() {
        String date = new SimpleDateFormat("yyyy-MM-dd hh:mm:ss", Locale.getDefault()).format(new Date());
        WarpUtils.log("SEND_STEPS: " + String.valueOf(WarpUtils.getStepsCounter((Context)this)));
        if (WarpUtils.getStepsCounter((Context)this) > 0) {
            WarplyManager.setPacingDetails(new PacingCalculateRequest().setCounter(WarpUtils.getStepsCounter((Context)this)).setDate(date), new CallbackReceiver<JSONObject>(){

                @Override
                public void onSuccess(JSONObject result) {
                    int status = result.optInt("status", 2);
                    if (status == 1) {
                        WarplyManagerHelper.mSteps = 0;
                        WarpUtils.setStepsCounter((Context)WarpViewActivity.this, 0);
                    }
                }

                @Override
                public void onFailure(int errorCode) {
                    WarpUtils.log("Warply Health Service error: " + String.valueOf(errorCode));
                }
            });
        }
    }

    static {
        mWebviewSupermarket = false;
    }
}

