/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.db;

import android.content.ContentValues;
import android.content.Context;
import android.database.SQLException;
import android.text.TextUtils;
import android.util.Log;
import androidx.annotation.Nullable;
import com.getkeepsafe.relinker.ReLinker;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;
import ly.warp.sdk.utils.constants.WarpConstants;
import net.sqlcipher.Cursor;
import net.sqlcipher.DatabaseUtils;
import net.sqlcipher.database.SQLiteDatabase;
import net.sqlcipher.database.SQLiteOpenHelper;
import net.sqlcipher.database.SQLiteStatement;
import org.json.JSONArray;
import org.json.JSONObject;

public class WarplyDBHelper
extends SQLiteOpenHelper {
    private static final String DB_NAME = "warply.db";
    private static final int DB_VERSION = 10;
    private static final String KEY_CIPHER = "tn#mpOl3v3Dy1pr@W";
    private static String TABLE_REQUESTS = "requests";
    private static String TABLE_PUSH_REQUESTS = "push_requests";
    private static String TABLE_PUSH_ACK_REQUESTS = "push_ack_requests";
    public static final String KEY_REQUESTS_ID = "_id";
    public static final String KEY_REQUESTS_MICROAPP = "microapp";
    public static final String KEY_REQUESTS_ENTITY = "entity";
    public static final String KEY_REQUESTS_DATE_ADDED = "date_added";
    public static final String KEY_REQUESTS_FORCE = "force_post";
    private static String TABLE_CLIENT = "client";
    private static String TABLE_AUTH = "auth";
    private static String TABLE_TAGS = "tags";
    private static String TABLE_TELEMATICS = "telematics";
    public static final String KEY_TAG = "tag";
    public static final String KEY_TAG_LAST_ADD_DATE = "last_add_date";
    public static final String KEY_CLIENT_ID = "client_id";
    public static final String KEY_CLIENT_SECRET = "client_secret";
    public static final String KEY_ACCESS_TOKEN = "access_token";
    public static final String KEY_REFRESH_TOKEN = "refresh_token";
    public static final String KEY_TIMESTAMP = "timestamp";
    public static final String KEY_ACCELERATION = "acceleration";
    public static final String KEY_SPEED = "speed";
    public static final String CREATE_TABLE_REQUESTS = "create table if not exists " + TABLE_REQUESTS + " (" + "_id" + " integer primary key autoincrement, " + "microapp" + " text not null, " + "entity" + " text not null, " + "force_post" + " integer default 0, " + "date_added" + " real)";
    public static final String CREATE_TABLE_PUSH_REQUESTS = "create table if not exists " + TABLE_PUSH_REQUESTS + " (" + "_id" + " integer primary key autoincrement, " + "microapp" + " text not null, " + "entity" + " text not null, " + "force_post" + " integer default 0, " + "date_added" + " real)";
    public static final String CREATE_TABLE_PUSH_ACK_REQUESTS = "create table if not exists " + TABLE_PUSH_ACK_REQUESTS + " (" + "_id" + " integer primary key autoincrement, " + "microapp" + " text not null, " + "entity" + " text not null, " + "force_post" + " integer default 0, " + "date_added" + " real)";
    public static final String CREATE_TABLE_TAGS = "create table if not exists " + TABLE_TAGS + " (" + "tag" + " text not null, " + "last_add_date" + " real, unique(" + "tag" + ") on conflict replace)";
    public static final String CREATE_TABLE_CLIENT = "create table if not exists " + TABLE_CLIENT + " (" + "client_id" + " text, " + "client_secret" + " text)";
    public static final String CREATE_TABLE_AUTH = "create table if not exists " + TABLE_AUTH + " (" + "access_token" + " text, " + "refresh_token" + " text)";
    public static final String CREATE_TABLE_TELEMATICS = "create table if not exists " + TABLE_TELEMATICS + " (" + "timestamp" + " text, " + "acceleration" + " real, " + "speed" + " real)";
    private SQLiteDatabase mDb;
    private static WarplyDBHelper mDBHelperInstance;

    public static synchronized WarplyDBHelper getInstance(Context context) {
        if (mDBHelperInstance == null) {
            SQLiteDatabase.loadLibs((Context)context, libraries -> {
                for (String library : libraries) {
                    ReLinker.loadLibrary((Context)context, (String)library);
                }
            });
            mDBHelperInstance = new WarplyDBHelper(context);
        }
        return mDBHelperInstance;
    }

    private WarplyDBHelper(Context context) {
        super(context, DB_NAME, null, 10);
        State tempDatabaseState = this.getDatabaseState(context, DB_NAME);
        if (tempDatabaseState.equals((Object)State.UNENCRYPTED)) {
            this.encrypt(context, context.getDatabasePath(DB_NAME), KEY_CIPHER.getBytes());
        }
    }

    private SQLiteDatabase getDb() {
        if (this.mDb == null) {
            this.mDb = this.getWritableDatabase(KEY_CIPHER);
        }
        return this.mDb;
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL(CREATE_TABLE_REQUESTS);
        db.execSQL(CREATE_TABLE_TAGS);
        db.execSQL(CREATE_TABLE_PUSH_REQUESTS);
        db.execSQL(CREATE_TABLE_PUSH_ACK_REQUESTS);
        db.execSQL(CREATE_TABLE_CLIENT);
        db.execSQL(CREATE_TABLE_AUTH);
        db.execSQL(CREATE_TABLE_TELEMATICS);
    }

    public void onUpgrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        if (oldVersion < 10) {
            db.execSQL("drop table if exists " + TABLE_REQUESTS);
            db.execSQL("drop table if exists " + TABLE_PUSH_REQUESTS);
            db.execSQL("drop table if exists " + TABLE_PUSH_ACK_REQUESTS);
            db.execSQL("drop table if exists " + TABLE_TAGS);
            db.execSQL("drop table if exists " + TABLE_CLIENT);
            db.execSQL("drop table if exists " + TABLE_AUTH);
            db.execSQL("drop table if exists " + TABLE_TELEMATICS);
            this.onCreate(db);
        }
    }

    public void onDowngrade(SQLiteDatabase db, int oldVersion, int newVersion) {
        db.execSQL("drop table if exists " + TABLE_REQUESTS);
        db.execSQL("drop table if exists " + TABLE_PUSH_REQUESTS);
        db.execSQL("drop table if exists " + TABLE_PUSH_ACK_REQUESTS);
        db.execSQL("drop table if exists " + TABLE_TAGS);
        db.execSQL("drop table if exists " + TABLE_CLIENT);
        db.execSQL("drop table if exists " + TABLE_AUTH);
        db.execSQL("drop table if exists " + TABLE_TELEMATICS);
        this.onCreate(db);
    }

    protected void finalize() throws Throwable {
        super.finalize();
        if (this.mDb != null && this.mDb.isOpen()) {
            this.mDb.close();
            this.mDb = null;
        }
    }

    public synchronized void clearTable(String tableName) {
        SQLiteDatabase db = this.getDb();
        db.delete(tableName, null, null);
    }

    public synchronized void insert(String tableName, ContentValues values) {
        SQLiteDatabase db = this.getDb();
        db.insert(tableName, null, values);
    }

    public synchronized void update(String tableName, ContentValues values) {
        SQLiteDatabase db = this.getDb();
        db.update(tableName, values, null, null);
    }

    public synchronized boolean isTableNotEmpty(String tableName) {
        Cursor cursor = this.getDb().rawQuery("SELECT COUNT(*) FROM " + tableName, null);
        if (cursor != null && cursor.moveToFirst()) {
            boolean isNotEmpty = cursor.getInt(0) > 0;
            cursor.close();
            return isNotEmpty;
        }
        return false;
    }

    public synchronized void saveClientAccess(String clientId, String clientSecret) {
        ContentValues values = new ContentValues();
        if (!TextUtils.isEmpty((CharSequence)clientId)) {
            values.put(KEY_CLIENT_ID, clientId);
        }
        if (!TextUtils.isEmpty((CharSequence)clientSecret)) {
            values.put(KEY_CLIENT_SECRET, clientSecret);
        }
        if (this.isTableNotEmpty(TABLE_CLIENT)) {
            this.update(TABLE_CLIENT, values);
        } else {
            this.insert(TABLE_CLIENT, values);
        }
    }

    public synchronized void saveAuthAccess(String accessToken, String refreshToken) {
        ContentValues values = new ContentValues();
        if (!TextUtils.isEmpty((CharSequence)accessToken)) {
            values.put(KEY_ACCESS_TOKEN, accessToken);
        }
        if (!TextUtils.isEmpty((CharSequence)refreshToken)) {
            values.put(KEY_REFRESH_TOKEN, refreshToken);
        }
        if (this.isTableNotEmpty(TABLE_AUTH)) {
            this.update(TABLE_AUTH, values);
        } else {
            this.insert(TABLE_AUTH, values);
        }
    }

    @Nullable
    public synchronized String getAuthValue(String columnName) {
        String columnValue = "";
        Cursor cursor = this.getDb().query(TABLE_AUTH, new String[]{columnName}, null, null, null, null, null);
        if (cursor != null && cursor.moveToFirst()) {
            cursor.moveToFirst();
            columnValue = cursor.getString(cursor.getColumnIndex(columnName));
            cursor.close();
        }
        return columnValue;
    }

    @Nullable
    public synchronized String getClientValue(String columnName) {
        String columnValue = "";
        Cursor cursor = this.getDb().query(TABLE_CLIENT, new String[]{columnName}, null, null, null, null, null);
        if (cursor != null && cursor.moveToFirst()) {
            cursor.moveToFirst();
            columnValue = cursor.getString(cursor.getColumnIndex(columnName));
            cursor.close();
        }
        return columnValue;
    }

    public synchronized void deleteClient() {
        this.clearTable(TABLE_CLIENT);
    }

    public synchronized void deleteAuth() {
        this.clearTable(TABLE_AUTH);
    }

    public synchronized android.database.Cursor getAllRequests() {
        return this.getDb().query(TABLE_REQUESTS, new String[]{KEY_REQUESTS_ID, KEY_REQUESTS_MICROAPP, KEY_REQUESTS_ENTITY}, null, null, null, null, "date_added asc", "20");
    }

    public synchronized android.database.Cursor getAllPushRequests() {
        return this.getDb().query(TABLE_PUSH_REQUESTS, new String[]{KEY_REQUESTS_ID, KEY_REQUESTS_MICROAPP, KEY_REQUESTS_ENTITY}, null, null, null, null, "date_added asc", "20");
    }

    public synchronized android.database.Cursor getAllPushAckRequests() {
        return this.getDb().query(TABLE_PUSH_ACK_REQUESTS, new String[]{KEY_REQUESTS_ID, KEY_REQUESTS_MICROAPP, KEY_REQUESTS_ENTITY}, null, null, null, null, "date_added asc", "20");
    }

    public synchronized void deleteAllRequests() {
        this.clearTable(TABLE_REQUESTS);
    }

    public synchronized void deleteAllPushRequests() {
        this.clearTable(TABLE_PUSH_REQUESTS);
    }

    public synchronized void deleteAllPushAckRequests() {
        this.clearTable(TABLE_PUSH_ACK_REQUESTS);
    }

    public synchronized long addRequest(String microapp, String entity, boolean force) {
        ContentValues values = new ContentValues();
        values.put(KEY_REQUESTS_MICROAPP, microapp);
        values.put(KEY_REQUESTS_ENTITY, entity);
        values.put(KEY_REQUESTS_FORCE, Integer.valueOf(force ? 1 : 0));
        values.put(KEY_REQUESTS_DATE_ADDED, Long.valueOf(System.currentTimeMillis()));
        this.insert(TABLE_REQUESTS, values);
        return this.getRequestsInQueueCount();
    }

    public synchronized long addPushRequest(String microapp, String entity, boolean force) {
        ContentValues values = new ContentValues();
        values.put(KEY_REQUESTS_MICROAPP, microapp);
        values.put(KEY_REQUESTS_ENTITY, entity);
        values.put(KEY_REQUESTS_FORCE, Integer.valueOf(force ? 1 : 0));
        values.put(KEY_REQUESTS_DATE_ADDED, Long.valueOf(System.currentTimeMillis()));
        this.insert(TABLE_PUSH_REQUESTS, values);
        return this.getPushRequestsInQueueCount();
    }

    public synchronized long addPushAckRequest(String microapp, String entity, boolean force) {
        ContentValues values = new ContentValues();
        values.put(KEY_REQUESTS_MICROAPP, microapp);
        values.put(KEY_REQUESTS_ENTITY, entity);
        values.put(KEY_REQUESTS_FORCE, Integer.valueOf(force ? 1 : 0));
        values.put(KEY_REQUESTS_DATE_ADDED, Long.valueOf(System.currentTimeMillis()));
        this.insert(TABLE_PUSH_ACK_REQUESTS, values);
        return this.getPushAckRequestsInQueueCount();
    }

    public synchronized long getRequestsInQueueCount() {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.getReadableDatabase(KEY_CIPHER), (String)TABLE_REQUESTS);
    }

    public synchronized long getPushRequestsInQueueCount() {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.getReadableDatabase(KEY_CIPHER), (String)TABLE_PUSH_REQUESTS);
    }

    public synchronized long getPushAckRequestsInQueueCount() {
        return DatabaseUtils.queryNumEntries((SQLiteDatabase)this.getReadableDatabase(KEY_CIPHER), (String)TABLE_PUSH_ACK_REQUESTS);
    }

    public synchronized void deleteRequests(Long ... ids) {
        StringBuilder strFilter = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                strFilter.append(" OR ");
            }
            strFilter.append(KEY_REQUESTS_ID);
            strFilter.append("=");
            strFilter.append(ids[i]);
        }
        this.getDb().delete(TABLE_REQUESTS, strFilter.toString(), null);
    }

    public synchronized void deletePushRequests(Long ... ids) {
        StringBuilder strFilter = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                strFilter.append(" OR ");
            }
            strFilter.append(KEY_REQUESTS_ID);
            strFilter.append("=");
            strFilter.append(ids[i]);
        }
        this.getDb().delete(TABLE_PUSH_REQUESTS, strFilter.toString(), null);
    }

    public synchronized void deletePushAckRequests(Long ... ids) {
        StringBuilder strFilter = new StringBuilder();
        for (int i = 0; i < ids.length; ++i) {
            if (i > 0) {
                strFilter.append(" OR ");
            }
            strFilter.append(KEY_REQUESTS_ID);
            strFilter.append("=");
            strFilter.append(ids[i]);
        }
        this.getDb().delete(TABLE_PUSH_ACK_REQUESTS, strFilter.toString(), null);
    }

    public synchronized boolean isForceRequestsExist() {
        Cursor cursor = this.getDb().query(TABLE_REQUESTS, null, "force_post=1", null, null, null, null);
        boolean result = false;
        if (cursor != null) {
            result = cursor.getCount() > 0;
            cursor.close();
        }
        return result;
    }

    public synchronized boolean isForcePushRequestsExist() {
        Cursor cursor = this.getDb().query(TABLE_PUSH_REQUESTS, null, "force_post=1", null, null, null, null);
        boolean result = false;
        if (cursor != null) {
            result = cursor.getCount() > 0;
            cursor.close();
        }
        return result;
    }

    public synchronized boolean isForcePushAckRequestsExist() {
        Cursor cursor = this.getDb().query(TABLE_PUSH_ACK_REQUESTS, null, "force_post=1", null, null, null, null);
        boolean result = false;
        if (cursor != null) {
            result = cursor.getCount() > 0;
            cursor.close();
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void saveTags(String[] tags) {
        if (tags != null && tags.length > 0) {
            try {
                this.getDb().beginTransaction();
                ContentValues values = new ContentValues();
                for (String tag : tags) {
                    values.put(KEY_TAG, tag);
                    values.put(KEY_TAG_LAST_ADD_DATE, Long.valueOf(System.currentTimeMillis()));
                    this.insert(TABLE_TAGS, values);
                }
                this.getDb().setTransactionSuccessful();
            }
            catch (SQLException e) {
                if (WarpConstants.DEBUG) {
                    e.printStackTrace();
                }
            }
            finally {
                this.getDb().endTransaction();
            }
        }
    }

    public synchronized void saveTelematics(JSONArray jsonArray) {
        if (jsonArray != null && jsonArray.length() > 0) {
            ContentValues values = new ContentValues();
            for (int i = 0; i < jsonArray.length(); ++i) {
                JSONObject jsonobject = jsonArray.optJSONObject(i);
                if (jsonobject == null) continue;
                String timestamp = (String)jsonobject.keys().next();
                values.put(KEY_TIMESTAMP, timestamp);
                JSONObject jobjData = jsonobject.optJSONObject(timestamp);
                if (jobjData != null) {
                    values.put(KEY_ACCELERATION, Double.valueOf(jobjData.optDouble(KEY_ACCELERATION)));
                    values.put(KEY_SPEED, Double.valueOf(jobjData.optDouble(KEY_SPEED)));
                }
                this.insert(TABLE_TELEMATICS, values);
            }
        }
    }

    public synchronized void removeTags(String[] tags) {
        StringBuilder strFilter = new StringBuilder();
        for (int i = 0; i < tags.length; ++i) {
            if (i > 0) {
                strFilter.append(" OR ");
            }
            strFilter.append(KEY_TAG);
            strFilter.append("=");
            strFilter.append("'");
            strFilter.append(tags[i]);
            strFilter.append("'");
        }
        this.getDb().delete(TABLE_TAGS, strFilter.toString(), null);
    }

    public synchronized void removeAllTags() {
        this.clearTable(TABLE_TAGS);
    }

    @Nullable
    public synchronized String[] getTags() {
        ArrayList<String> tags = null;
        Cursor cursor = this.getDb().query(TABLE_TAGS, null, null, null, null, null, null);
        if (cursor != null) {
            tags = new ArrayList<String>(cursor.getCount());
            while (cursor.moveToNext()) {
                tags.add(cursor.getString(cursor.getColumnIndex(KEY_TAG)));
            }
            cursor.close();
        }
        return tags != null ? tags.toArray(new String[tags.size()]) : null;
    }

    private State getDatabaseState(Context context, String dbName) {
        SQLiteDatabase.loadLibs((Context)context);
        return WarplyDBHelper.getDatabaseState(context.getDatabasePath(dbName));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static State getDatabaseState(File dbPath) {
        if (dbPath.exists()) {
            try (SQLiteDatabase db = null;){
                db = SQLiteDatabase.openDatabase((String)dbPath.getAbsolutePath(), (String)"", null, (int)1);
                db.getVersion();
                State state = State.UNENCRYPTED;
                return state;
            }
        }
        return State.DOES_NOT_EXIST;
    }

    private void encrypt(Context context, File originalFile, byte[] passphrase) {
        SQLiteDatabase.loadLibs((Context)context);
        try {
            if (!originalFile.exists()) {
                throw new FileNotFoundException(originalFile.getAbsolutePath() + " not found");
            }
            File newFile = File.createTempFile("sqlcipherutils", "tmp", context.getCacheDir());
            SQLiteDatabase db = SQLiteDatabase.openDatabase((String)originalFile.getAbsolutePath(), (String)"", null, (int)0);
            int version = db.getVersion();
            db.close();
            db = SQLiteDatabase.openDatabase((String)newFile.getAbsolutePath(), (byte[])passphrase, null, (int)0, null, null);
            SQLiteStatement st = db.compileStatement("ATTACH DATABASE ? AS plaintext KEY ''");
            st.bindString(1, originalFile.getAbsolutePath());
            st.execute();
            db.rawExecSQL("SELECT sqlcipher_export('main', 'plaintext')");
            db.rawExecSQL("DETACH DATABASE plaintext");
            db.setVersion(version);
            st.close();
            db.close();
            originalFile.delete();
            newFile.renameTo(originalFile);
        }
        catch (IOException ex) {
            Log.v((String)"WarplyDB Exception: ", (String)ex.getMessage());
        }
    }

    private static enum State {
        DOES_NOT_EXIST,
        UNENCRYPTED,
        ENCRYPTED;

    }
}

