/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.dexter;

import android.app.Activity;
import android.content.Context;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import ly.warp.sdk.dexter.AndroidPermissionService;
import ly.warp.sdk.dexter.DexterBuilder;
import ly.warp.sdk.dexter.DexterException;
import ly.warp.sdk.dexter.DexterInstance;
import ly.warp.sdk.dexter.IntentProvider;
import ly.warp.sdk.dexter.MultiplePermissionsListenerToPermissionListenerAdapter;
import ly.warp.sdk.dexter.Thread;
import ly.warp.sdk.dexter.ThreadFactory;
import ly.warp.sdk.dexter.listener.EmptyPermissionRequestErrorListener;
import ly.warp.sdk.dexter.listener.PermissionRequestErrorListener;
import ly.warp.sdk.dexter.listener.multi.BaseMultiplePermissionsListener;
import ly.warp.sdk.dexter.listener.multi.MultiplePermissionsListener;
import ly.warp.sdk.dexter.listener.single.PermissionListener;

public final class Dexter
implements DexterBuilder,
DexterBuilder.Permission,
DexterBuilder.SinglePermissionListener,
DexterBuilder.MultiPermissionListener {
    private static DexterInstance instance;
    private Collection<String> permissions;
    private MultiplePermissionsListener listener = new BaseMultiplePermissionsListener();
    private PermissionRequestErrorListener errorListener = new EmptyPermissionRequestErrorListener();
    private boolean shouldExecuteOnSameThread = false;

    private Dexter(Context activity) {
        Dexter.initialize(activity);
    }

    public static DexterBuilder.Permission withContext(Context activity) {
        return new Dexter(activity);
    }

    @Override
    public DexterBuilder.SinglePermissionListener withPermission(String permission2) {
        this.permissions = Collections.singletonList(permission2);
        return this;
    }

    @Override
    public DexterBuilder.MultiPermissionListener withPermissions(String ... permissions) {
        this.permissions = Arrays.asList(permissions);
        return this;
    }

    @Override
    public DexterBuilder.MultiPermissionListener withPermissions(Collection<String> permissions) {
        this.permissions = new ArrayList<String>(permissions);
        return this;
    }

    @Override
    public DexterBuilder withListener(PermissionListener listener) {
        this.listener = new MultiplePermissionsListenerToPermissionListenerAdapter(listener);
        return this;
    }

    @Override
    public DexterBuilder withListener(MultiplePermissionsListener listener) {
        this.listener = listener;
        return this;
    }

    @Override
    public DexterBuilder onSameThread() {
        this.shouldExecuteOnSameThread = true;
        return this;
    }

    @Override
    public DexterBuilder withErrorListener(PermissionRequestErrorListener errorListener) {
        this.errorListener = errorListener;
        return this;
    }

    @Override
    public void check() {
        try {
            Thread thread = this.getThread();
            instance.checkPermissions(this.listener, this.permissions, thread);
        }
        catch (DexterException e) {
            this.errorListener.onError(e.error);
        }
    }

    private Thread getThread() {
        Thread thread = this.shouldExecuteOnSameThread ? ThreadFactory.makeSameThread() : ThreadFactory.makeMainThread();
        return thread;
    }

    private static void initialize(Context context) {
        if (instance == null) {
            AndroidPermissionService androidPermissionService = new AndroidPermissionService();
            IntentProvider intentProvider = new IntentProvider();
            instance = new DexterInstance(context, androidPermissionService, intentProvider);
        } else {
            instance.setContext(context);
        }
    }

    static void onActivityReady(Activity activity) {
        if (instance != null) {
            instance.onActivityReady(activity);
        }
    }

    static void onActivityDestroyed() {
        if (instance != null) {
            instance.onActivityDestroyed();
        }
    }

    static void onPermissionsRequested(Collection<String> grantedPermissions, Collection<String> deniedPermissions) {
        if (instance != null) {
            instance.onPermissionRequestGranted(grantedPermissions);
            instance.onPermissionRequestDenied(deniedPermissions);
        }
    }
}

