/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.dexter;

import android.app.Activity;
import android.app.Application;
import android.content.Context;
import android.content.Intent;
import java.lang.ref.WeakReference;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.TreeSet;
import java.util.concurrent.atomic.AtomicBoolean;
import ly.warp.sdk.dexter.AndroidPermissionService;
import ly.warp.sdk.dexter.DexterException;
import ly.warp.sdk.dexter.IntentProvider;
import ly.warp.sdk.dexter.MultiplePermissionListenerThreadDecorator;
import ly.warp.sdk.dexter.MultiplePermissionsListenerToPermissionListenerAdapter;
import ly.warp.sdk.dexter.MultiplePermissionsReport;
import ly.warp.sdk.dexter.PermissionRationaleToken;
import ly.warp.sdk.dexter.PermissionsActivity;
import ly.warp.sdk.dexter.Thread;
import ly.warp.sdk.dexter.listener.DexterError;
import ly.warp.sdk.dexter.listener.PermissionDeniedResponse;
import ly.warp.sdk.dexter.listener.PermissionGrantedResponse;
import ly.warp.sdk.dexter.listener.PermissionRequest;
import ly.warp.sdk.dexter.listener.multi.BaseMultiplePermissionsListener;
import ly.warp.sdk.dexter.listener.multi.MultiplePermissionsListener;
import ly.warp.sdk.dexter.listener.single.PermissionListener;

final class DexterInstance {
    private static final int PERMISSIONS_REQUEST_CODE = 42;
    private static final MultiplePermissionsListener EMPTY_LISTENER = new BaseMultiplePermissionsListener();
    private WeakReference<Context> context;
    private final AndroidPermissionService androidPermissionService;
    private final IntentProvider intentProvider;
    private final Collection<String> pendingPermissions;
    private final MultiplePermissionsReport multiplePermissionsReport;
    private final AtomicBoolean isRequestingPermission;
    private final AtomicBoolean rationaleAccepted;
    private final AtomicBoolean isShowingNativeDialog;
    private final Object pendingPermissionsMutex = new Object();
    private Activity activity;
    private MultiplePermissionsListener listener = EMPTY_LISTENER;

    DexterInstance(Context context, AndroidPermissionService androidPermissionService, IntentProvider intentProvider) {
        this.androidPermissionService = androidPermissionService;
        this.intentProvider = intentProvider;
        this.pendingPermissions = new TreeSet<String>();
        this.multiplePermissionsReport = new MultiplePermissionsReport();
        this.isRequestingPermission = new AtomicBoolean();
        this.rationaleAccepted = new AtomicBoolean();
        this.isShowingNativeDialog = new AtomicBoolean();
        this.setContext(context);
    }

    void setContext(Context context) {
        this.context = new WeakReference<Context>(context);
    }

    void checkPermission(PermissionListener listener, String permission2, Thread thread) {
        this.checkSinglePermission(listener, permission2, thread);
    }

    void checkPermissions(MultiplePermissionsListener listener, Collection<String> permissions, Thread thread) {
        this.checkMultiplePermissions(listener, permissions, thread);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void onActivityReady(Activity activity) {
        this.activity = activity;
        PermissionStates permissionStates = null;
        Object object = this.pendingPermissionsMutex;
        synchronized (object) {
            if (activity != null) {
                permissionStates = this.getPermissionStates(this.pendingPermissions);
            }
        }
        if (permissionStates != null) {
            this.handleDeniedPermissions(permissionStates.getDeniedPermissions());
            this.updatePermissionsAsGranted(permissionStates.getGrantedPermissions());
        }
    }

    void onActivityDestroyed() {
        this.isRequestingPermission.set(false);
    }

    void onPermissionRequestGranted(Collection<String> permissions) {
        this.updatePermissionsAsGranted(permissions);
    }

    void onPermissionRequestDenied(Collection<String> permissions) {
        this.updatePermissionsAsDenied(permissions);
    }

    void onContinuePermissionRequest() {
        this.rationaleAccepted.set(true);
        this.requestPermissionsToSystem(this.pendingPermissions);
    }

    void onCancelPermissionRequest() {
        this.rationaleAccepted.set(false);
        this.updatePermissionsAsDenied(this.pendingPermissions);
    }

    private void requestPermissionsToSystem(Collection<String> permissions) {
        if (!this.isShowingNativeDialog.get()) {
            this.androidPermissionService.requestPermissions(this.activity, permissions.toArray(new String[0]), 42);
        }
        this.isShowingNativeDialog.set(true);
    }

    private PermissionStates getPermissionStates(Collection<String> pendingPermissions) {
        PermissionStates permissionStates = new PermissionStates();
        block3: for (String permission2 : pendingPermissions) {
            int permissionState = this.checkSelfPermission(this.activity, permission2);
            switch (permissionState) {
                case -1: {
                    permissionStates.addDeniedPermission(permission2);
                    continue block3;
                }
            }
            permissionStates.addGrantedPermission(permission2);
        }
        return permissionStates;
    }

    private int checkSelfPermission(Activity activity, String permission2) {
        try {
            return this.androidPermissionService.checkSelfPermission((Context)activity, permission2);
        }
        catch (RuntimeException ignored) {
            return -1;
        }
    }

    private void startTransparentActivityIfNeeded() {
        Context context = (Context)this.context.get();
        if (context == null) {
            return;
        }
        Intent intent = this.intentProvider.get(context, PermissionsActivity.class);
        if (context instanceof Application) {
            intent.addFlags(0x10000000);
        }
        context.startActivity(intent);
    }

    private void handleDeniedPermissions(Collection<String> permissions) {
        if (permissions.isEmpty()) {
            return;
        }
        LinkedList<PermissionRequest> shouldShowRequestRationalePermissions = new LinkedList<PermissionRequest>();
        for (String permission2 : permissions) {
            if (!this.androidPermissionService.shouldShowRequestPermissionRationale(this.activity, permission2)) continue;
            shouldShowRequestRationalePermissions.add(new PermissionRequest(permission2));
        }
        if (shouldShowRequestRationalePermissions.isEmpty()) {
            this.requestPermissionsToSystem(permissions);
        } else if (!this.rationaleAccepted.get()) {
            PermissionRationaleToken permissionToken = new PermissionRationaleToken(this);
            this.listener.onPermissionRationaleShouldBeShown(shouldShowRequestRationalePermissions, permissionToken);
        }
    }

    private void updatePermissionsAsGranted(Collection<String> permissions) {
        for (String permission2 : permissions) {
            PermissionGrantedResponse response = PermissionGrantedResponse.from(permission2);
            this.multiplePermissionsReport.addGrantedPermissionResponse(response);
        }
        this.onPermissionsChecked(permissions);
    }

    private void updatePermissionsAsDenied(Collection<String> permissions) {
        Iterator<String> iterator = permissions.iterator();
        while (iterator.hasNext()) {
            String permission2;
            PermissionDeniedResponse response = PermissionDeniedResponse.from(permission2, !this.androidPermissionService.shouldShowRequestPermissionRationale(this.activity, permission2 = iterator.next()));
            this.multiplePermissionsReport.addDeniedPermissionResponse(response);
        }
        this.onPermissionsChecked(permissions);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void onPermissionsChecked(Collection<String> permissions) {
        if (this.pendingPermissions.isEmpty()) {
            return;
        }
        Object object = this.pendingPermissionsMutex;
        synchronized (object) {
            this.pendingPermissions.removeAll(permissions);
            if (this.pendingPermissions.isEmpty()) {
                this.activity.finish();
                this.activity = null;
                this.isRequestingPermission.set(false);
                this.rationaleAccepted.set(false);
                this.isShowingNativeDialog.set(false);
                MultiplePermissionsListener currentListener = this.listener;
                this.listener = EMPTY_LISTENER;
                currentListener.onPermissionsChecked(this.multiplePermissionsReport);
            }
        }
    }

    private void checkNoDexterRequestOngoing() {
        if (this.isRequestingPermission.getAndSet(true)) {
            throw new DexterException("Only one Dexter request at a time is allowed", DexterError.REQUEST_ONGOING);
        }
    }

    private void checkRequestSomePermission(Collection<String> permissions) {
        if (permissions.isEmpty()) {
            throw new DexterException("Dexter has to be called with at least one permission", DexterError.NO_PERMISSIONS_REQUESTED);
        }
    }

    private void checkSinglePermission(PermissionListener listener, String permission2, Thread thread) {
        MultiplePermissionsListenerToPermissionListenerAdapter adapter = new MultiplePermissionsListenerToPermissionListenerAdapter(listener);
        this.checkMultiplePermissions(adapter, Collections.singleton(permission2), thread);
    }

    private void checkMultiplePermissions(final MultiplePermissionsListener listener, final Collection<String> permissions, Thread thread) {
        this.checkNoDexterRequestOngoing();
        this.checkRequestSomePermission(permissions);
        if (this.context.get() == null) {
            return;
        }
        this.pendingPermissions.clear();
        this.pendingPermissions.addAll(permissions);
        this.multiplePermissionsReport.clear();
        this.listener = new MultiplePermissionListenerThreadDecorator(listener, thread);
        if (this.isEveryPermissionGranted(permissions, (Context)this.context.get())) {
            thread.execute(new Runnable(){

                @Override
                public void run() {
                    MultiplePermissionsReport report = new MultiplePermissionsReport();
                    for (String permission2 : permissions) {
                        report.addGrantedPermissionResponse(PermissionGrantedResponse.from(permission2));
                    }
                    DexterInstance.this.isRequestingPermission.set(false);
                    listener.onPermissionsChecked(report);
                }
            });
        } else {
            this.startTransparentActivityIfNeeded();
        }
        thread.loop();
    }

    private boolean isEveryPermissionGranted(Collection<String> permissions, Context context) {
        for (String permission2 : permissions) {
            int permissionState = this.androidPermissionService.checkSelfPermission(context, permission2);
            if (permissionState == 0) continue;
            return false;
        }
        return true;
    }

    private final class PermissionStates {
        private final Collection<String> deniedPermissions = new LinkedList<String>();
        private final Collection<String> grantedPermissions = new LinkedList<String>();

        private PermissionStates() {
        }

        private void addDeniedPermission(String permission2) {
            this.deniedPermissions.add(permission2);
        }

        private void addGrantedPermission(String permission2) {
            this.grantedPermissions.add(permission2);
        }

        private Collection<String> getDeniedPermissions() {
            return this.deniedPermissions;
        }

        private Collection<String> getGrantedPermissions() {
            return this.grantedPermissions;
        }
    }
}

