/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.dexter;

import java.util.List;
import ly.warp.sdk.dexter.MultiplePermissionsReport;
import ly.warp.sdk.dexter.PermissionToken;
import ly.warp.sdk.dexter.listener.PermissionDeniedResponse;
import ly.warp.sdk.dexter.listener.PermissionGrantedResponse;
import ly.warp.sdk.dexter.listener.PermissionRequest;
import ly.warp.sdk.dexter.listener.multi.MultiplePermissionsListener;
import ly.warp.sdk.dexter.listener.single.PermissionListener;

final class MultiplePermissionsListenerToPermissionListenerAdapter
implements MultiplePermissionsListener {
    private final PermissionListener listener;

    public MultiplePermissionsListenerToPermissionListenerAdapter(PermissionListener listener) {
        this.listener = listener;
    }

    @Override
    public void onPermissionsChecked(MultiplePermissionsReport report) {
        List<PermissionDeniedResponse> deniedResponses = report.getDeniedPermissionResponses();
        List<PermissionGrantedResponse> grantedResponses = report.getGrantedPermissionResponses();
        if (!deniedResponses.isEmpty()) {
            PermissionDeniedResponse response = deniedResponses.get(0);
            this.listener.onPermissionDenied(response);
        } else {
            PermissionGrantedResponse response = grantedResponses.get(0);
            this.listener.onPermissionGranted(response);
        }
    }

    @Override
    public void onPermissionRationaleShouldBeShown(List<PermissionRequest> requests, PermissionToken token) {
        PermissionRequest firstRequest = requests.get(0);
        this.listener.onPermissionRationaleShouldBeShown(firstRequest, token);
    }
}

