/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.dexter.listener.single;

import java.util.Arrays;
import java.util.Collection;
import ly.warp.sdk.dexter.PermissionToken;
import ly.warp.sdk.dexter.listener.PermissionDeniedResponse;
import ly.warp.sdk.dexter.listener.PermissionGrantedResponse;
import ly.warp.sdk.dexter.listener.PermissionRequest;
import ly.warp.sdk.dexter.listener.single.PermissionListener;

public class CompositePermissionListener
implements PermissionListener {
    private final Collection<PermissionListener> listeners;

    public CompositePermissionListener(PermissionListener ... listeners) {
        this(Arrays.asList(listeners));
    }

    public CompositePermissionListener(Collection<PermissionListener> listeners) {
        this.listeners = listeners;
    }

    @Override
    public void onPermissionGranted(PermissionGrantedResponse response) {
        for (PermissionListener listener : this.listeners) {
            listener.onPermissionGranted(response);
        }
    }

    @Override
    public void onPermissionDenied(PermissionDeniedResponse response) {
        for (PermissionListener listener : this.listeners) {
            listener.onPermissionDenied(response);
        }
    }

    @Override
    public void onPermissionRationaleShouldBeShown(PermissionRequest permission2, PermissionToken token) {
        for (PermissionListener listener : this.listeners) {
            listener.onPermissionRationaleShouldBeShown(permission2, token);
        }
    }
}

