/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.fragments;

import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import android.widget.Toast;
import androidx.annotation.NonNull;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.swiperefreshlayout.widget.SwipeRefreshLayout;
import java.io.Serializable;
import java.util.ArrayList;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.ActiveCouponsActivity;
import ly.warp.sdk.activities.TelematicsActivity;
import ly.warp.sdk.activities.TelematicsHistoryActivity;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CouponList;
import ly.warp.sdk.io.models.UnifiedCoupon;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyManager;
import org.json.JSONObject;

public class HomeFragment
extends Fragment
implements View.OnClickListener,
SwipeRefreshLayout.OnRefreshListener {
    private RelativeLayout mOptionOne;
    private RelativeLayout mOptionTwo;
    private RelativeLayout mOptionThree;
    private RelativeLayout mRlDriving;
    private RelativeLayout mRlDrivingHistory;
    private LinearLayout mLlBillPayment;
    private TextView mTvUsername;
    private TextView mTvActiveCoupons;
    private ConstraintLayout mClActiveCoupons;
    private ImageView mIvStepsActivity;
    private SwipeRefreshLayout mSwipeRefresh;
    private final CallbackReceiver<ArrayList<Campaign>> mCampaignsCallback = new CallbackReceiver<ArrayList<Campaign>>(){

        @Override
        public void onSuccess(ArrayList<Campaign> result) {
            Toast.makeText((Context)HomeFragment.this.getActivity(), (CharSequence)"Campaigns Success", (int)0).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText((Context)HomeFragment.this.getActivity(), (CharSequence)"Campaigns Error", (int)0).show();
        }
    };
    private final CallbackReceiver<CouponList> mUserCouponsReceiver = new CallbackReceiver<CouponList>(){

        @Override
        public void onSuccess(CouponList result) {
            Toast.makeText((Context)HomeFragment.this.getActivity(), (CharSequence)("Coupons Success " + String.valueOf(result.size())), (int)0).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText((Context)HomeFragment.this.getActivity(), (CharSequence)"Coupons Error", (int)0).show();
        }
    };
    private final CallbackReceiver<ArrayList<UnifiedCoupon>> mUnifiedCallback = new CallbackReceiver<ArrayList<UnifiedCoupon>>(){

        @Override
        public void onSuccess(ArrayList<UnifiedCoupon> result) {
            Toast.makeText((Context)HomeFragment.this.getActivity(), (CharSequence)("Unified Coupons Success " + String.valueOf(result.size())), (int)0).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText((Context)HomeFragment.this.getActivity(), (CharSequence)"Unified Coupons Error", (int)0).show();
        }
    };
    private final CallbackReceiver<JSONObject> mLogoutReceiver = new CallbackReceiver<JSONObject>(){

        @Override
        public void onSuccess(JSONObject result) {
            Toast.makeText((Context)HomeFragment.this.getActivity(), (CharSequence)"LOGOUT SUCCESS", (int)0).show();
        }

        @Override
        public void onFailure(int errorCode) {
            Toast.makeText((Context)HomeFragment.this.getActivity(), (CharSequence)"LOGOUT ERROR", (int)0).show();
        }
    };

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_home, container, false);
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mSwipeRefresh = (SwipeRefreshLayout)view.findViewById(R.id.sw_refresh);
        this.mSwipeRefresh.setOnRefreshListener((SwipeRefreshLayout.OnRefreshListener)this);
        this.mOptionOne = (RelativeLayout)view.findViewById(R.id.info_button);
        TextView mOptionOneText = (TextView)this.mOptionOne.findViewById(R.id.option_text);
        ImageView mOptionOneImage = (ImageView)this.mOptionOne.findViewById(R.id.option_icon);
        mOptionOneText.setText((CharSequence)"2");
        mOptionOneImage.setImageResource(R.drawable.mobile_option);
        this.mOptionTwo = (RelativeLayout)view.findViewById(R.id.info_button2);
        TextView mOptionTwoText = (TextView)this.mOptionTwo.findViewById(R.id.option_text);
        ImageView mOptionTwoImage = (ImageView)this.mOptionTwo.findViewById(R.id.option_icon);
        mOptionTwoText.setText((CharSequence)"1");
        mOptionTwoImage.setImageResource(R.drawable.phone_option);
        this.mOptionThree = (RelativeLayout)view.findViewById(R.id.info_button3);
        TextView mOptionThreeText = (TextView)this.mOptionThree.findViewById(R.id.option_text);
        ImageView mOptionThreeImage = (ImageView)this.mOptionThree.findViewById(R.id.option_icon);
        mOptionThreeText.setText((CharSequence)"1");
        mOptionThreeImage.setImageResource(R.drawable.tv_option);
        this.mClActiveCoupons = (ConstraintLayout)view.findViewById(R.id.cl_coupon);
        this.mTvActiveCoupons = (TextView)this.mClActiveCoupons.findViewById(R.id.tv_active_coupons);
        this.mTvActiveCoupons.setText((CharSequence)String.format(this.getResources().getString(R.string.cos_active_coupons), String.valueOf(WarplyManagerHelper.getCouponList().size())));
        this.mClActiveCoupons.setOnClickListener((View.OnClickListener)this);
        this.mLlBillPayment = (LinearLayout)view.findViewById(R.id.ll_bill_payment);
        this.mLlBillPayment.setOnClickListener((View.OnClickListener)this);
        this.mIvStepsActivity = (ImageView)view.findViewById(R.id.iv_settings);
        this.mIvStepsActivity.setOnClickListener((View.OnClickListener)this);
        this.mTvUsername = (TextView)view.findViewById(R.id.welcome_user_txt);
        if (WarplyManagerHelper.getConsumer() != null) {
            this.mTvUsername.setText((CharSequence)String.format(this.getResources().getString(R.string.welcome_user), WarplyManagerHelper.getConsumer().getFirstName() + " " + WarplyManagerHelper.getConsumer().getLastName()));
        }
        this.mRlDriving = (RelativeLayout)view.findViewById(R.id.rl_driving);
        this.mRlDriving.setOnClickListener((View.OnClickListener)this);
        this.mRlDrivingHistory = (RelativeLayout)view.findViewById(R.id.rl_driving_history);
        this.mRlDrivingHistory.setOnClickListener((View.OnClickListener)this);
    }

    public void onDestroyView() {
        super.onDestroyView();
    }

    public void onRefresh() {
        WarplyManager.getUserCouponsWithCouponsets(this.mUserCouponsReceiver);
        WarplyManager.getCampaigns(this.mCampaignsCallback);
        WarplyManager.getUnifiedCouponsDeals(this.mUnifiedCallback);
        this.mSwipeRefresh.setRefreshing(false);
    }

    public void onClick(View view) {
        if (view.getId() == R.id.cl_coupon) {
            Intent intent = new Intent(this.getContext(), ActiveCouponsActivity.class);
            intent.putExtra("couponlist", (Serializable)WarplyManagerHelper.getCouponList());
            this.startActivity(intent);
            return;
        }
        if (view.getId() == R.id.rl_driving) {
            Intent intent = new Intent(this.getContext(), TelematicsActivity.class);
            this.startActivity(intent);
            return;
        }
        if (view.getId() == R.id.rl_driving_history) {
            Intent intent = new Intent(this.getContext(), TelematicsHistoryActivity.class);
            this.startActivity(intent);
            return;
        }
        if (view.getId() == R.id.iv_settings) {
            WarplyManager.logout(this.mLogoutReceiver);
        }
    }

    public static Fragment newInstance() {
        HomeFragment homeFragment = new HomeFragment();
        return homeFragment;
    }
}

