/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.fragments;

import android.content.Intent;
import android.os.Bundle;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ImageView;
import android.widget.TextView;
import androidx.annotation.Nullable;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import androidx.recyclerview.widget.LinearLayoutManager;
import androidx.recyclerview.widget.RecyclerView;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.GiftsForYouActivity;
import ly.warp.sdk.activities.MoreForYouActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.CampaignList;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.views.adapters.ProfileCampaignAdapter;
import org.json.JSONObject;

public class LoyaltyFragment
extends Fragment
implements View.OnClickListener {
    private RecyclerView mRecyclerDeals;
    private RecyclerView mRecyclerGifts;
    private RecyclerView mRecyclerMore;
    private ProfileCampaignAdapter mAdapterDeals;
    private ProfileCampaignAdapter mAdapterGifts;
    private ProfileCampaignAdapter mAdapterMore;
    private ImageView mIvMoreDeals;
    private ImageView mIvMoreGifts;
    private ImageView mIvMore;
    private ConstraintLayout mClRewardsWallet;
    private ConstraintLayout mClDealsOuter;
    private ConstraintLayout mClGiftsOuter;
    private ConstraintLayout mClMoreOuter;
    private TextView mTvUsername;

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_loyalty, container, false);
    }

    public void onViewCreated(View view, @Nullable Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mClRewardsWallet = (ConstraintLayout)view.findViewById(R.id.cl_rewards_wallet);
        this.mClRewardsWallet.setOnClickListener((View.OnClickListener)this);
        this.mTvUsername = (TextView)view.findViewById(R.id.tv_name);
        if (WarplyManagerHelper.getConsumer() != null) {
            this.mTvUsername.setText((CharSequence)String.format(this.getResources().getString(R.string.cos_profile_name), WarplyManagerHelper.getConsumer().getFirstName() + " " + WarplyManagerHelper.getConsumer().getLastName()));
        }
        this.mIvMoreDeals = (ImageView)view.findViewById(R.id.iv_more);
        this.mIvMoreDeals.setOnClickListener((View.OnClickListener)this);
        this.mIvMoreGifts = (ImageView)view.findViewById(R.id.iv_more2);
        this.mIvMoreGifts.setOnClickListener((View.OnClickListener)this);
        this.mIvMore = (ImageView)view.findViewById(R.id.iv_more3);
        this.mIvMore.setOnClickListener((View.OnClickListener)this);
        this.mClGiftsOuter = (ConstraintLayout)view.findViewById(R.id.cl_recycler_inner2);
        this.mRecyclerGifts = (RecyclerView)view.findViewById(R.id.rv_gifts);
        if (WarplyManagerHelper.getCampaignList() != null && WarplyManagerHelper.getCampaignList().size() > 0) {
            CampaignList gfyList = new CampaignList();
            for (Campaign camp : WarplyManagerHelper.getCampaignList()) {
                if (!camp.getOfferCategory().equals("gifts_for_you")) continue;
                gfyList.add(camp);
            }
            this.mRecyclerGifts.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
            this.mAdapterGifts = new ProfileCampaignAdapter(this.getContext(), gfyList);
            this.mRecyclerGifts.setAdapter((RecyclerView.Adapter)this.mAdapterGifts);
            this.mAdapterGifts.getPositionClicks().doOnNext(gift -> {
                try {
                    JSONObject extraFields = WarpJSONParser.getJSONFromString(gift.getExtraFields());
                    if (extraFields != null && extraFields.has("type") && extraFields.optString("type").equals("telco")) {
                        WarplyManagerHelper.openTelco(this.getContext(), gift);
                        return;
                    }
                }
                catch (Exception exception) {
                    this.startActivity(WarpViewActivity.createIntentFromURL(this.getContext(), WarplyManagerHelper.constructCampaignUrl(gift)));
                    return;
                }
                if (gift.getType().equals("coupon")) {
                    WarplyManagerHelper.openCouponset(this.getContext(), gift);
                } else {
                    this.startActivity(WarpViewActivity.createIntentFromURL(this.getContext(), WarplyManagerHelper.constructCampaignUrl(gift)));
                }
            }).doOnError(error -> {}).subscribe();
        } else {
            this.mClGiftsOuter.setVisibility(8);
        }
        this.mClMoreOuter = (ConstraintLayout)view.findViewById(R.id.cl_recycler_inner3);
        this.mRecyclerMore = (RecyclerView)view.findViewById(R.id.rv_more);
        if (WarplyManagerHelper.getCampaignList() != null && WarplyManagerHelper.getCampaignList().size() > 0) {
            CampaignList mfyList = new CampaignList();
            for (Campaign camp : WarplyManagerHelper.getCampaignList()) {
                if (!camp.getOfferCategory().equals("more_for_you")) continue;
                mfyList.add(camp);
            }
            this.mRecyclerMore.setLayoutManager((RecyclerView.LayoutManager)new LinearLayoutManager(this.getContext(), 0, false));
            this.mAdapterMore = new ProfileCampaignAdapter(this.getContext(), mfyList);
            this.mRecyclerMore.setAdapter((RecyclerView.Adapter)this.mAdapterMore);
            this.mAdapterMore.getPositionClicks().doOnNext(more -> {
                try {
                    JSONObject extraFields = WarpJSONParser.getJSONFromString(more.getExtraFields());
                    if (extraFields != null && extraFields.has("type") && extraFields.optString("type").equals("telco")) {
                        WarplyManagerHelper.openTelco(this.getContext(), more);
                        return;
                    }
                }
                catch (Exception exception) {
                    this.startActivity(WarpViewActivity.createIntentFromURL(this.getContext(), WarplyManagerHelper.constructCampaignUrl(more)));
                    return;
                }
                if (more.getType().equals("coupon")) {
                    WarplyManagerHelper.openCouponset(this.getContext(), more);
                } else {
                    this.startActivity(WarpViewActivity.createIntentFromURL(this.getContext(), WarplyManagerHelper.constructCampaignUrl(more)));
                }
            }).doOnError(error -> {}).subscribe();
        } else {
            this.mClMoreOuter.setVisibility(8);
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.cl_rewards_wallet) {
            return;
        }
        if (view.getId() == R.id.iv_more2) {
            Intent intent = new Intent(this.getContext(), GiftsForYouActivity.class);
            this.startActivity(intent);
            return;
        }
        if (view.getId() == R.id.iv_more3) {
            Intent intent = new Intent(this.getContext(), MoreForYouActivity.class);
            this.startActivity(intent);
        }
    }

    public static Fragment newInstance() {
        LoyaltyFragment loyaltyFragment = new LoyaltyFragment();
        return loyaltyFragment;
    }
}

