/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.fragments;

import android.app.Activity;
import android.content.Context;
import android.content.Intent;
import android.os.Bundle;
import android.os.Handler;
import android.os.Looper;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.HorizontalScrollView;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.RelativeLayout;
import android.widget.TextView;
import androidx.annotation.NonNull;
import androidx.appcompat.app.AlertDialog;
import androidx.cardview.widget.CardView;
import androidx.constraintlayout.widget.ConstraintLayout;
import androidx.fragment.app.Fragment;
import java.util.ArrayList;
import java.util.Collections;
import ly.warp.sdk.R;
import ly.warp.sdk.activities.ActiveCouponsActivity;
import ly.warp.sdk.activities.ActiveUnifiedCouponsActivity;
import ly.warp.sdk.activities.LoyaltyAnalysisActivity;
import ly.warp.sdk.activities.LoyaltyHistoryActivity;
import ly.warp.sdk.activities.LoyaltyMarketAnalysisActivity;
import ly.warp.sdk.activities.WarpViewActivity;
import ly.warp.sdk.io.models.ActiveBoxCouponEventModel;
import ly.warp.sdk.io.models.ActiveDFYCouponEventModel;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.LoyaltySDKFirebaseEventModel;
import ly.warp.sdk.io.models.SortTileModel;
import ly.warp.sdk.io.models.VouchersActivityEventModel;
import ly.warp.sdk.io.models.WarplyDealsAnalysisEventModel;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyManagerHelper;
import ly.warp.sdk.utils.managers.WarplyAnalyticsManager;
import ly.warp.sdk.utils.managers.WarplyEventBusManager;
import org.greenrobot.eventbus.EventBus;
import org.greenrobot.eventbus.Subscribe;

public class MyRewardsFragment
extends Fragment
implements View.OnClickListener {
    private TextView mTvUserBadge;
    private TextView mTvUserBadgeCentered;
    private TextView mTvBoxCountBadge;
    private TextView mTvDealsCountBadge;
    private TextView mTvUnifiedCountBadge;
    private TextView mTvGiftsCountBadge;
    private TextView mTvVouchersDisabledTitle;
    private TextView mTvVouchersDisabledSubtitle;
    private TextView mTvVouchersTitle;
    private TextView mTvVouchersSubtitle;
    private ConstraintLayout mLlQuestionnaireCentered;
    private ConstraintLayout mLlQuestionnaire;
    private ConstraintLayout mLlUserBadge;
    private ConstraintLayout mLlUserBadgeCentered;
    private LinearLayout mLlEmptyWallet;
    private LinearLayout mLlTilesParent;
    private LinearLayout mLlBannerInfo;
    private LinearLayout mLlVouchers;
    private LinearLayout mLlVouchersSpinner;
    private LinearLayout mLlVouchersDisabled;
    private ImageView mIvHistory;
    private AlertDialog mAlertDialogNonTelco;
    private AlertDialog mAlertDialogVouchersService;
    private int mTimer = 0;
    private Handler mSecondsHandler;
    private CardView mCvVouchers;
    private CardView mCvVouchersDisabled;
    private boolean mDfyPressed = false;
    private boolean mDealsBannerPressed = false;
    private boolean mQuestionnairePressed = false;
    private boolean mHistoryPressed = false;
    private boolean mHistoryMarketPressed = false;
    private boolean mHistoryBadgePressed = false;
    private boolean mUnifiedCountPressed = false;
    private boolean mGiftsCountPressed = false;
    private boolean mBoxCountPressed = false;
    private RelativeLayout mRlDeals;
    private RelativeLayout mRlUnified;
    private RelativeLayout mRlGifts;
    private RelativeLayout mRlBox;
    private boolean mIsDealsEmpty = false;
    private boolean mIsMarketsEmpty = false;
    private boolean mIsCouponsEmpty = false;
    private HorizontalScrollView mTilesScroll;
    private View mFirstStart;
    private View mFirstEnd;
    private View mSecondStart;
    private View mSecondEnd;
    private ArrayList<SortTileModel> mSortTileList = new ArrayList();

    public static Fragment newInstance() {
        MyRewardsFragment myRewardsFragment = new MyRewardsFragment();
        return myRewardsFragment;
    }

    public View onCreateView(LayoutInflater inflater, ViewGroup container, Bundle savedInstanceState) {
        return inflater.inflate(R.layout.fragment_my_rewards, container, false);
    }

    public void onViewCreated(@NonNull View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.mSecondsHandler = new Handler();
        this.mLlQuestionnaire = (ConstraintLayout)view.findViewById(R.id.ll_user_questionnaire);
        this.mLlQuestionnaireCentered = (ConstraintLayout)view.findViewById(R.id.ll_user_questionnaire_centered);
        this.mLlUserBadge = (ConstraintLayout)view.findViewById(R.id.ll_user_badge);
        this.mTvUserBadge = (TextView)view.findViewById(R.id.tv_type);
        this.mLlUserBadgeCentered = (ConstraintLayout)view.findViewById(R.id.ll_user_badge_centered);
        this.mTvUserBadgeCentered = (TextView)view.findViewById(R.id.tv_type_centered);
        this.mLlEmptyWallet = (LinearLayout)view.findViewById(R.id.ll_empty_wallet);
        this.mIvHistory = (ImageView)view.findViewById(R.id.iv_loyalty_history);
        this.mLlBannerInfo = (LinearLayout)view.findViewById(R.id.ll_banner_info_new);
        this.mCvVouchers = (CardView)view.findViewById(R.id.cv_vouchers);
        this.mCvVouchersDisabled = (CardView)view.findViewById(R.id.cv_vouchers_disabled);
        this.mLlVouchers = (LinearLayout)view.findViewById(R.id.ll_vouchers);
        this.mLlVouchersDisabled = (LinearLayout)view.findViewById(R.id.ll_vouchers_disabled);
        this.mLlVouchersSpinner = (LinearLayout)view.findViewById(R.id.ll_vouchers_spinner);
        this.mTvVouchersDisabledTitle = (TextView)view.findViewById(R.id.tv_vouchers_title_disabled);
        this.mTvVouchersDisabledSubtitle = (TextView)view.findViewById(R.id.tv_vouchers_info_title_disabled);
        this.mTvVouchersTitle = (TextView)view.findViewById(R.id.tv_vouchers_title);
        this.mTvVouchersSubtitle = (TextView)view.findViewById(R.id.tv_vouchers_info_title);
        this.mTilesScroll = (HorizontalScrollView)view.findViewById(R.id.scr_tiles);
        this.mLlTilesParent = (LinearLayout)view.findViewById(R.id.ll_tiles_parent);
        this.mFirstStart = view.findViewById(R.id.v_first_start);
        this.mFirstEnd = view.findViewById(R.id.v_first_end);
        this.mSecondStart = view.findViewById(R.id.v_second_start);
        this.mSecondEnd = view.findViewById(R.id.v_second_end);
        this.defineAndSortTiles();
        this.createTiles();
        this.mTilesScroll.setOnScrollChangeListener((v, scrollX, scrollY, oldScrollX, oldScrollY) -> {
            int maxScrollX = this.mTilesScroll.getChildAt(0).getWidth() - this.mTilesScroll.getWidth();
            if (scrollX == 0) {
                this.mFirstStart.setVisibility(0);
                this.mFirstEnd.setVisibility(8);
                this.mSecondStart.setVisibility(8);
                this.mSecondEnd.setVisibility(0);
            } else if (scrollX == maxScrollX) {
                this.mFirstStart.setVisibility(8);
                this.mFirstEnd.setVisibility(0);
                this.mSecondStart.setVisibility(0);
                this.mSecondEnd.setVisibility(8);
            }
        });
        if (WarpUtils.getUserNonTelco(this.getContext())) {
            this.nonTelcoDialog();
        }
    }

    public void onStart() {
        super.onStart();
        if (!EventBus.getDefault().isRegistered((Object)this)) {
            EventBus.getDefault().register((Object)this);
        }
    }

    public void onStop() {
        super.onStop();
    }

    public void onDestroy() {
        super.onDestroy();
        WarplyManagerHelper.clearShowVouchersBanner();
        EventBus.getDefault().unregister((Object)this);
    }

    public void onResume() {
        super.onResume();
        WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "screen", "LoyaltyWalletScreen");
        this.mTimer = 0;
        this.mSecondsHandler.post(new Runnable(){

            @Override
            public void run() {
                MyRewardsFragment.this.mTimer++;
                MyRewardsFragment.this.mSecondsHandler.postDelayed((Runnable)this, 1000L);
            }
        });
        this.mDfyPressed = false;
        this.mDealsBannerPressed = false;
        this.mQuestionnairePressed = false;
        this.mHistoryPressed = false;
        this.mHistoryMarketPressed = false;
        this.mHistoryBadgePressed = false;
        this.mGiftsCountPressed = false;
        this.mUnifiedCountPressed = false;
        this.mBoxCountPressed = false;
        this.initViews();
    }

    public void onPause() {
        super.onPause();
        if (this.mSecondsHandler != null) {
            this.mSecondsHandler.removeCallbacksAndMessages(null);
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("time_spent_on_loyalty_sdk");
            analyticsEvent.setParameter("name", "MyRewards");
            analyticsEvent.setParameter("seconds", String.valueOf(this.mTimer));
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
        }
    }

    public void onClick(View view) {
        if (view.getId() == R.id.ll_user_questionnaire || view.getId() == R.id.ll_user_badge || view.getId() == R.id.ll_user_badge_centered || view.getId() == R.id.ll_user_questionnaire_centered) {
            if (!WarplyManagerHelper.noInternetDialog(this.getContext(), true)) {
                if (this.getActivity() != null && !this.getActivity().isFinishing()) {
                    WarplyManagerHelper.noInternetDialog((Activity)this.getActivity());
                }
                return;
            }
            if (!this.mQuestionnairePressed) {
                this.mQuestionnairePressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "click", "LoyaltyWalletScreen".concat(":").concat("Questionnaire"));
                this.startActivityForResult(WarpViewActivity.createIntentFromURL(this.getContext(), WarplyManagerHelper.openQuestionnaire()), 1000);
            }
            return;
        }
        if (view.getId() == R.id.cl_deals_win_inner_cos) {
            if (!this.mDealsBannerPressed) {
                this.mDealsBannerPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "click", "LoyaltyWalletScreen".concat(":").concat("DealsBanner"));
                WarplyDealsAnalysisEventModel warplyDealsAnalysisEventModel = new WarplyDealsAnalysisEventModel();
                warplyDealsAnalysisEventModel.setPressed(true);
                EventBus.getDefault().post((Object)new WarplyEventBusManager(warplyDealsAnalysisEventModel));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_deals_for_you_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
            }
            return;
        }
        if (view.getId() == R.id.cl_deals_win_inner) {
            if (!this.mHistoryPressed) {
                this.mHistoryPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "click", "LoyaltyWalletScreen".concat(":").concat("LoyaltyBanner"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_gifts_for_you_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent(this.getContext(), LoyaltyAnalysisActivity.class);
                this.startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.cl_market_inner) {
            if (!this.mHistoryMarketPressed) {
                this.mHistoryMarketPressed = true;
                WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "click", "LoyaltyWalletScreen".concat(":").concat("MarketBanner"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_market_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent(this.getContext(), LoyaltyMarketAnalysisActivity.class);
                this.startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.iv_loyalty_history) {
            if (!this.mHistoryBadgePressed) {
                WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "click", "LoyaltyWalletScreen".concat(":").concat("LoyaltyHistoryBadge"));
                LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                analyticsEvent.setEventName("did_tap_history_badge");
                analyticsEvent.setParameter("screen", "Loyalty Wallet");
                EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                Intent intent = new Intent(this.getContext(), LoyaltyHistoryActivity.class);
                this.startActivity(intent);
            }
            return;
        }
        if (view.getId() == R.id.cv_vouchers || view.getId() == R.id.cv_vouchers_disabled) {
            WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "click", "LoyaltyWalletScreen".concat(":").concat("VouchersBadge"));
            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
            analyticsEvent.setEventName("did_tap_vouchers_badge");
            analyticsEvent.setParameter("screen", "Loyalty Wallet");
            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
            VouchersActivityEventModel vouchersActivity = new VouchersActivityEventModel();
            EventBus.getDefault().post((Object)new WarplyEventBusManager(vouchersActivity));
            return;
        }
    }

    public void onActivityResult(int requestCode, int resultCode, Intent data) {
        if (requestCode == 1000 && resultCode == -1) {
            if (this.mLlEmptyWallet.getVisibility() == 0) {
                if (!TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getUserTag(this.getContext()))) {
                    this.mTvUserBadgeCentered.setText((CharSequence)WarplyManagerHelper.getUserTag(this.getContext()));
                    this.mLlQuestionnaire.setVisibility(8);
                    this.mLlQuestionnaireCentered.setVisibility(8);
                    this.mLlUserBadge.setVisibility(8);
                    this.mLlUserBadgeCentered.setVisibility(0);
                } else {
                    this.mLlUserBadge.setVisibility(8);
                    this.mLlUserBadgeCentered.setVisibility(8);
                    this.mLlQuestionnaire.setVisibility(8);
                    this.mLlQuestionnaireCentered.setVisibility(0);
                }
            } else if (!TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getUserTag(this.getContext()))) {
                this.mTvUserBadge.setText((CharSequence)WarplyManagerHelper.getUserTag(this.getContext()));
                this.mLlQuestionnaire.setVisibility(8);
                this.mLlQuestionnaireCentered.setVisibility(8);
                this.mLlUserBadgeCentered.setVisibility(8);
                this.mLlUserBadge.setVisibility(0);
            } else {
                this.mLlUserBadge.setVisibility(8);
                this.mLlUserBadgeCentered.setVisibility(8);
                this.mLlQuestionnaireCentered.setVisibility(8);
                this.mLlQuestionnaire.setVisibility(0);
            }
        }
    }

    @Subscribe
    public void onMessageEvent(WarplyEventBusManager event) {
        if (event.getVouchersServiceUnavailableEventModel() != null) {
            Handler mUIHandler = new Handler(Looper.getMainLooper());
            mUIHandler.post(this::vouchersServiceUnavailableDialog);
            return;
        }
        if (event.getVouchersFetched() != null) {
            Handler mUIHandler = new Handler(Looper.getMainLooper());
            mUIHandler.post(this::checkForEmpty);
            return;
        }
        if (event.getUnifiedCouponsAdded() != null) {
            Handler mUIHandler = new Handler(Looper.getMainLooper());
            mUIHandler.post(() -> {
                if (WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() > 0) {
                    this.mTvUnifiedCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getMarketCouponsList().size()));
                } else {
                    this.mTvUnifiedCountBadge.setText((CharSequence)"0");
                }
                this.checkForEmpty();
            });
            return;
        }
        if (event.getCouponsAdded() != null || event.getRewardsCouponsEventModel() != null) {
            Handler mUIHandler = new Handler(Looper.getMainLooper());
            mUIHandler.post(() -> {
                if (WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() > 0) {
                    this.mTvGiftsCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getCouponList().size()));
                } else {
                    this.mTvGiftsCountBadge.setText((CharSequence)"0");
                }
                this.checkForEmpty();
            });
        }
    }

    private void defineAndSortTiles() {
        SortTileModel tileDeals = new SortTileModel();
        if (WarplyManagerHelper.getActiveDFYCoupons() != null && WarplyManagerHelper.getActiveDFYCoupons().size() > 0) {
            tileDeals.setCount(WarplyManagerHelper.getActiveDFYCoupons().size());
            tileDeals.setWeight(3);
        } else {
            tileDeals.setCount(0);
            tileDeals.setWeight(3);
        }
        this.mSortTileList.add(tileDeals);
        SortTileModel tileUnified = new SortTileModel();
        if (WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() > 0) {
            tileUnified.setCount(WarplyManagerHelper.getMarketCouponsList().size());
            tileUnified.setWeight(2);
        } else {
            tileUnified.setCount(0);
            tileUnified.setWeight(2);
        }
        this.mSortTileList.add(tileUnified);
        SortTileModel tileCoupons = new SortTileModel();
        if (WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() > 0) {
            tileCoupons.setCount(WarplyManagerHelper.getCouponList().size());
            tileCoupons.setWeight(1);
        } else {
            tileCoupons.setCount(0);
            tileCoupons.setWeight(1);
        }
        this.mSortTileList.add(tileCoupons);
        SortTileModel tileBoxCoupons = new SortTileModel();
        if (WarplyManagerHelper.getActiveBoxCoupons() != null && WarplyManagerHelper.getActiveBoxCoupons().size() > 0) {
            tileBoxCoupons.setCount(0);
            tileBoxCoupons.setWeight(0);
        } else {
            tileBoxCoupons.setCount(0);
            tileBoxCoupons.setWeight(0);
        }
        this.mSortTileList.add(tileBoxCoupons);
        Collections.sort(this.mSortTileList, (o1, o2) -> {
            int countComparison = Integer.compare(o2.getCount(), o1.getCount());
            if (countComparison != 0) {
                return countComparison;
            }
            return Integer.compare(o2.getWeight(), o1.getWeight());
        });
    }

    private void createTiles() {
        if ((this.getContext() != null || this.getActivity() != null && !this.getActivity().isFinishing()) && this.mSortTileList != null && this.mSortTileList.size() > 0) {
            for (SortTileModel sortModel : this.mSortTileList) {
                View view;
                if (sortModel.getWeight() == 3) {
                    view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tile_active_dfy, (ViewGroup)this.mLlTilesParent, false);
                    view.setOnClickListener(v -> {
                        if (!this.mDfyPressed) {
                            this.mDfyPressed = true;
                            WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "click", "LoyaltyWalletScreen".concat(":").concat("ActiveDealsBanner"));
                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                            analyticsEvent.setEventName("did_tap_deals_for_you_active_badge");
                            analyticsEvent.setParameter("screen", "Loyalty Wallet");
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                            ActiveDFYCouponEventModel activeCouponEventModel = new ActiveDFYCouponEventModel();
                            activeCouponEventModel.setPressed(true);
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(activeCouponEventModel));
                        }
                    });
                    this.mTvDealsCountBadge = (TextView)view.findViewById(R.id.tv_deals_count);
                    this.mLlTilesParent.addView(view);
                    continue;
                }
                if (sortModel.getWeight() == 2) {
                    view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tile_active_unified, (ViewGroup)this.mLlTilesParent, false);
                    view.setOnClickListener(v -> {
                        if (!this.mUnifiedCountPressed) {
                            this.mUnifiedCountPressed = true;
                            WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "click", "LoyaltyWalletScreen".concat(":").concat("ActiveMarketBanner"));
                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                            analyticsEvent.setEventName("did_tap_market_active_badge");
                            analyticsEvent.setParameter("screen", "Loyalty Wallet");
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                            Intent intent = new Intent(this.getContext(), ActiveUnifiedCouponsActivity.class);
                            this.startActivity(intent);
                        }
                    });
                    this.mTvUnifiedCountBadge = (TextView)view.findViewById(R.id.tv_sm_count);
                    this.mLlTilesParent.addView(view);
                    continue;
                }
                if (sortModel.getWeight() == 1) {
                    view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tile_active_coupons, (ViewGroup)this.mLlTilesParent, false);
                    view.setOnClickListener(v -> {
                        if (!this.mGiftsCountPressed) {
                            this.mGiftsCountPressed = true;
                            WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "click", "LoyaltyWalletScreen".concat(":").concat("ActiveLoyaltyBanner"));
                            LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                            analyticsEvent.setEventName("did_tap_gifts_for_you_active_badge");
                            analyticsEvent.setParameter("screen", "Loyalty Wallet");
                            EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                            Intent intent = new Intent(this.getContext(), ActiveCouponsActivity.class);
                            this.startActivity(intent);
                        }
                    });
                    this.mTvGiftsCountBadge = (TextView)view.findViewById(R.id.tv_gifts_count);
                    this.mLlTilesParent.addView(view);
                    continue;
                }
                if (sortModel.getWeight() != 0) continue;
                view = LayoutInflater.from((Context)this.getContext()).inflate(R.layout.tile_active_box, (ViewGroup)this.mLlTilesParent, false);
                view.setOnClickListener(v -> {
                    if (!this.mBoxCountPressed) {
                        this.mBoxCountPressed = true;
                        WarplyAnalyticsManager.logTrackersEvent(this.getContext(), "click", "LoyaltyWalletScreen".concat(":").concat("ActiveBoxBanner"));
                        LoyaltySDKFirebaseEventModel analyticsEvent = new LoyaltySDKFirebaseEventModel();
                        analyticsEvent.setEventName("did_tap_box_active_badge");
                        analyticsEvent.setParameter("screen", "Loyalty Wallet");
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(analyticsEvent));
                        ActiveBoxCouponEventModel activeBoxEventModel = new ActiveBoxCouponEventModel();
                        activeBoxEventModel.setPressed(true);
                        EventBus.getDefault().post((Object)new WarplyEventBusManager(activeBoxEventModel));
                    }
                });
                this.mTvBoxCountBadge = (TextView)view.findViewById(R.id.tv_box_count);
                this.mLlTilesParent.addView(view);
            }
        }
    }

    private void initViews() {
        if (WarplyManagerHelper.getActiveDFYCoupons() != null && WarplyManagerHelper.getActiveDFYCoupons().size() > 0) {
            this.mTvDealsCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getActiveDFYCoupons().size()));
        } else {
            this.mTvDealsCountBadge.setText((CharSequence)"0");
        }
        if (WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() > 0) {
            this.mTvUnifiedCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getMarketCouponsList().size()));
        } else {
            this.mTvUnifiedCountBadge.setText((CharSequence)"0");
        }
        if (WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() > 0) {
            this.mTvGiftsCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getCouponList().size()));
        } else {
            this.mTvGiftsCountBadge.setText((CharSequence)"0");
        }
        if (WarplyManagerHelper.getActiveBoxCoupons() != null && WarplyManagerHelper.getActiveBoxCoupons().size() > 0) {
            this.mTvBoxCountBadge.setText((CharSequence)String.valueOf(WarplyManagerHelper.getActiveBoxCoupons().size()));
        } else {
            this.mTvBoxCountBadge.setText((CharSequence)"0");
        }
        this.checkForEmpty();
        if (this.mLlEmptyWallet.getVisibility() == 0) {
            if (WarplyManagerHelper.getConsumer() != null) {
                if (!TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getUserTag(this.getContext()))) {
                    this.mTvUserBadgeCentered.setText((CharSequence)WarplyManagerHelper.getUserTag(this.getContext()));
                    this.mLlQuestionnaire.setVisibility(8);
                    this.mLlQuestionnaireCentered.setVisibility(8);
                    this.mLlUserBadge.setVisibility(8);
                    this.mLlUserBadgeCentered.setVisibility(0);
                } else {
                    this.mLlUserBadge.setVisibility(8);
                    this.mLlUserBadgeCentered.setVisibility(8);
                    this.mLlQuestionnaire.setVisibility(8);
                    this.mLlQuestionnaireCentered.setVisibility(0);
                }
            }
        } else if (WarplyManagerHelper.getConsumer() != null) {
            if (!TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getUserTag(this.getContext()))) {
                this.mTvUserBadge.setText((CharSequence)WarplyManagerHelper.getUserTag(this.getContext()));
                this.mLlQuestionnaire.setVisibility(8);
                this.mLlQuestionnaireCentered.setVisibility(8);
                this.mLlUserBadgeCentered.setVisibility(8);
                this.mLlUserBadge.setVisibility(0);
            } else {
                this.mLlUserBadge.setVisibility(8);
                this.mLlUserBadgeCentered.setVisibility(8);
                this.mLlQuestionnaireCentered.setVisibility(8);
                this.mLlQuestionnaire.setVisibility(0);
            }
        }
        this.mLlQuestionnaire.setOnClickListener((View.OnClickListener)this);
        this.mLlQuestionnaireCentered.setOnClickListener((View.OnClickListener)this);
        this.mLlUserBadge.setOnClickListener((View.OnClickListener)this);
        this.mLlUserBadgeCentered.setOnClickListener((View.OnClickListener)this);
        this.mIvHistory.setOnClickListener((View.OnClickListener)this);
        this.mCvVouchers.setOnClickListener((View.OnClickListener)this);
        this.mCvVouchersDisabled.setOnClickListener((View.OnClickListener)this);
    }

    private void nonTelcoDialog() {
        if (this.getActivity() != null && !this.getActivity().isFinishing()) {
            this.mAlertDialogNonTelco = new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.cos_dlg_non_telco_title).setMessage(R.string.cos_dlg_non_telco).setPositiveButton(R.string.cos_dlg_positive_button2, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).setCancelable(false).show();
        }
    }

    private void vouchersServiceUnavailableDialog() {
        if (this.getActivity() != null && !this.getActivity().isFinishing()) {
            this.mLlVouchersSpinner.setVisibility(8);
            this.mAlertDialogVouchersService = new AlertDialog.Builder((Context)this.getActivity()).setTitle(R.string.cos_dlg_try_again).setMessage(R.string.cos_dlg_service_unavailable).setPositiveButton(R.string.cos_dlg_return, (dialogPositive, whichPositive) -> dialogPositive.dismiss()).setCancelable(false).show();
        }
    }

    private void checkForEmpty() {
        if (TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getShowVouchersBanner()) || !TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getShowVouchersBanner()) && WarplyManagerHelper.getShowVouchersBanner().equals("null")) {
            this.mLlVouchers.setVisibility(8);
            if (TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getShowVouchersBanner())) {
                this.mLlVouchersSpinner.setVisibility(0);
            }
            if (!TextUtils.isEmpty((CharSequence)WarplyManagerHelper.getShowVouchersBanner()) && WarplyManagerHelper.getShowVouchersBanner().equals("null")) {
                this.mLlVouchersSpinner.setVisibility(8);
            }
            if (WarplyManagerHelper.getActiveDFYCoupons() != null && WarplyManagerHelper.getActiveDFYCoupons().size() == 0 && WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() == 0 && WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() == 0 && this.checkHistoryEmpty()) {
                this.mLlVouchers.setVisibility(8);
            } else {
                this.mLlEmptyWallet.setVisibility(8);
            }
        } else if (WarplyManagerHelper.getShowVouchersBanner().equals("true")) {
            this.mLlVouchersSpinner.setVisibility(8);
            this.mLlEmptyWallet.setVisibility(8);
            if (this.getContext() != null || this.getActivity() != null && !this.getActivity().isFinishing()) {
                if (TextUtils.isEmpty((CharSequence)WarpUtils.getLanguage(this.getContext())) || WarpUtils.getLanguage(this.getContext()).equals("el")) {
                    this.mTvVouchersTitle.setText((CharSequence)this.getContext().getString(R.string.cos_vouchers_title));
                    this.mTvVouchersSubtitle.setText((CharSequence)this.getContext().getString(R.string.cos_vouchers_info_title));
                } else {
                    this.mTvVouchersTitle.setText((CharSequence)this.getContext().getString(R.string.cos_vouchers_title_en));
                    this.mTvVouchersSubtitle.setText((CharSequence)this.getContext().getString(R.string.cos_vouchers_info_title_en));
                }
            }
            this.mLlVouchers.setVisibility(0);
            this.mLlVouchersDisabled.setVisibility(8);
            if (WarplyManagerHelper.getActiveDFYCoupons() != null && WarplyManagerHelper.getActiveDFYCoupons().size() == 0 && WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() == 0 && WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() == 0 && this.checkHistoryEmpty()) {
                // empty if block
            }
        } else if (WarplyManagerHelper.getShowVouchersBanner().equals("false")) {
            this.mLlVouchersSpinner.setVisibility(8);
            this.mLlEmptyWallet.setVisibility(8);
            this.mLlVouchers.setVisibility(8);
            if (this.getContext() != null || this.getActivity() != null && !this.getActivity().isFinishing()) {
                if (TextUtils.isEmpty((CharSequence)WarpUtils.getLanguage(this.getContext())) || WarpUtils.getLanguage(this.getContext()).equals("el")) {
                    this.mTvVouchersDisabledTitle.setText((CharSequence)this.getContext().getString(R.string.cos_vouchers_title));
                    this.mTvVouchersDisabledSubtitle.setText((CharSequence)this.getContext().getString(R.string.cos_vouchers_info_title_disabled));
                } else {
                    this.mTvVouchersDisabledTitle.setText((CharSequence)this.getContext().getString(R.string.cos_vouchers_title_en));
                    this.mTvVouchersDisabledSubtitle.setText((CharSequence)this.getContext().getString(R.string.cos_vouchers_info_title_disabled_en));
                }
            }
            this.mLlVouchersDisabled.setVisibility(0);
            if (WarplyManagerHelper.getActiveDFYCoupons() != null && WarplyManagerHelper.getActiveDFYCoupons().size() == 0 && WarplyManagerHelper.getMarketCouponsList() != null && WarplyManagerHelper.getMarketCouponsList().size() == 0 && WarplyManagerHelper.getCouponList() != null && WarplyManagerHelper.getCouponList().size() == 0 && this.checkHistoryEmpty()) {
                this.mLlEmptyWallet.setVisibility(8);
            }
        }
    }

    private boolean checkHistoryEmpty() {
        boolean bl = this.mIsDealsEmpty = WarplyManagerHelper.getDealsCouponsSum() == 0.0f;
        if (WarplyManagerHelper.getMarketCoupons() != null && WarplyManagerHelper.getMarketCoupons().size() > 0) {
            float countValue = 0.0f;
            if (WarplyManagerHelper.getCouponRedeemedList().size() > 0 && WarplyManagerHelper.getCouponsetsDeals().size() > 0) {
                block0: for (Couponset couset : WarplyManagerHelper.getCouponsetsDeals()) {
                    for (Coupon cou : WarplyManagerHelper.getCouponRedeemedList()) {
                        if (!cou.getCouponsetUuid().equals(couset.getUuid())) continue;
                        countValue += Float.parseFloat(cou.getDiscount());
                        continue block0;
                    }
                }
            }
            this.mIsMarketsEmpty = countValue == 0.0f;
        } else {
            this.mIsMarketsEmpty = true;
        }
        if (WarplyManagerHelper.getLoyaltyBadge() != null) {
            this.mIsCouponsEmpty = WarplyManagerHelper.getLoyaltyBadge().getValue() == 0.0f;
        }
        return this.mIsDealsEmpty && this.mIsMarketsEmpty && this.mIsCouponsEmpty;
    }
}

