/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.fragments;

import android.content.Context;
import android.graphics.Bitmap;
import android.graphics.Canvas;
import android.graphics.Color;
import android.graphics.Paint;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.graphics.drawable.StateListDrawable;
import android.os.Build;
import android.os.Bundle;
import android.text.TextUtils;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewTreeObserver;
import android.webkit.WebView;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.ProgressBar;
import android.widget.RelativeLayout;
import androidx.fragment.app.Fragment;
import ly.warp.sdk.Warply;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyPreferences;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.views.WarpView;

public class WarpViewFragment
extends Fragment {
    private static final String ARGS_KEY_SESSION_UUID = "args_key_session_uuid";
    private static final String ARGS_KEY_USE_PROGRESS = "args_key_use_progress";
    private static final String ARGS_KEY_SHOW_CLOSE_BTN = "args_key_show_close_btn";
    private WarpView mWarpView;
    private String mSessionUuid;
    private boolean mIsUseProgress;
    private boolean mIsShowCloseBtn;
    private ImageView mBtnClose;

    public static WarpViewFragment newInstance() {
        return WarpViewFragment.newInstance(null, false, true);
    }

    public static WarpViewFragment newInstance(String sessionUuid) {
        return WarpViewFragment.newInstance(sessionUuid, false, true);
    }

    public static WarpViewFragment newInstance(String sessionUuid, boolean isUseProgress, boolean isShowCloseBtn) {
        Bundle args = new Bundle();
        args.putString(ARGS_KEY_SESSION_UUID, sessionUuid);
        args.putBoolean(ARGS_KEY_USE_PROGRESS, isUseProgress);
        args.putBoolean(ARGS_KEY_SHOW_CLOSE_BTN, isShowCloseBtn);
        WarpViewFragment fr = new WarpViewFragment();
        fr.setArguments(args);
        return fr;
    }

    public void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        if (this.getArguments() != null) {
            this.mSessionUuid = this.getArguments().getString(ARGS_KEY_SESSION_UUID);
            this.mIsUseProgress = this.getArguments().getBoolean(ARGS_KEY_USE_PROGRESS, false);
            this.mIsShowCloseBtn = this.getArguments().getBoolean(ARGS_KEY_SHOW_CLOSE_BTN, true);
        }
    }

    public View onCreateView(LayoutInflater inflater, final ViewGroup container, Bundle savedInstanceState) {
        RelativeLayout root = new RelativeLayout(this.getContext());
        root.setBackgroundColor(Color.parseColor((String)"#A0384550"));
        root.setClickable(true);
        final FrameLayout ivLogoContainer = new FrameLayout(this.getContext());
        ivLogoContainer.setBackgroundColor(-1);
        RelativeLayout.LayoutParams ivLogoContainerParams = new RelativeLayout.LayoutParams(-2, -2);
        ivLogoContainerParams.addRule(13);
        root.addView((View)ivLogoContainer, (ViewGroup.LayoutParams)ivLogoContainerParams);
        final ImageView ivLogo = new ImageView(this.getContext());
        FrameLayout.LayoutParams ivLogoParams = new FrameLayout.LayoutParams(-2, -2);
        ivLogoParams.gravity = 17;
        ivLogoContainer.addView((View)ivLogo, (ViewGroup.LayoutParams)ivLogoParams);
        ivLogo.setImageDrawable(WarplyProperty.getProgressDrawable(this.getContext()));
        ivLogo.startAnimation(WarpUtils.getPulseAnimation());
        this.mWarpView = new WarpView(this.getContext());
        this.mWarpView.setVisibility(4);
        RelativeLayout.LayoutParams warpViewParams = new RelativeLayout.LayoutParams(-1, -1);
        root.addView((View)this.mWarpView, (ViewGroup.LayoutParams)warpViewParams);
        if (this.mIsUseProgress) {
            int progressHeightDp = 7;
            final ProgressBar progressBar = new ProgressBar(this.getContext(), null, 16842872);
            progressBar.setProgressDrawable(WarpUtils.getHorizontalProgressDrawable(WarplyProperty.getProgressColor(this.getContext())));
            RelativeLayout.LayoutParams progressBarParams = new RelativeLayout.LayoutParams(-1, (int)((float)progressHeightDp * this.getResources().getDisplayMetrics().density + 0.5f));
            this.mWarpView.setProgressChangeListener(new WarpView.ProgressChangeListener(){

                @Override
                public void onProgressChanged(WebView view, int newProgress) {
                    progressBar.setProgress(newProgress);
                    if (progressBar.getProgress() == 100) {
                        WarpUtils.animateVisibility((View)ivLogo, 4);
                        WarpUtils.animateVisibility((View)progressBar, 4);
                    } else {
                        WarpUtils.animateVisibility((View)ivLogo, 0);
                        WarpUtils.animateVisibility((View)progressBar, 0);
                    }
                }
            });
            root.addView((View)progressBar, (ViewGroup.LayoutParams)progressBarParams);
        }
        if (this.mIsShowCloseBtn) {
            this.mBtnClose = new ImageView(this.getContext());
            RelativeLayout.LayoutParams btnCloseParams = new RelativeLayout.LayoutParams(-2, -2);
            btnCloseParams.addRule(10);
            btnCloseParams.addRule(11);
            root.addView((View)this.mBtnClose, (ViewGroup.LayoutParams)btnCloseParams);
            Bitmap bmpCloseBtnNormal = WarpUtils.getWarplyCloseBtn();
            Bitmap bmpCloseBtnPressed = Bitmap.createBitmap((int)bmpCloseBtnNormal.getWidth(), (int)bmpCloseBtnNormal.getHeight(), (Bitmap.Config)Bitmap.Config.ARGB_8888);
            Canvas canvas = new Canvas(bmpCloseBtnPressed);
            Paint paint = new Paint();
            paint.setAlpha(127);
            canvas.drawBitmap(bmpCloseBtnNormal, 0.0f, 0.0f, paint);
            BitmapDrawable normalState = new BitmapDrawable(this.getResources(), bmpCloseBtnNormal);
            BitmapDrawable pressedState = new BitmapDrawable(this.getResources(), bmpCloseBtnPressed);
            pressedState.setAlpha(0);
            StateListDrawable states = new StateListDrawable();
            states.addState(new int[]{16842919}, (Drawable)pressedState);
            states.addState(new int[0], (Drawable)normalState);
            this.mBtnClose.setImageDrawable((Drawable)states);
            this.mBtnClose.setOnClickListener(new View.OnClickListener(){

                public void onClick(View v) {
                    if (WarpViewFragment.this.getActivity().getSupportFragmentManager().findFragmentById(WarpViewFragment.this.getId()) != null) {
                        WarpViewFragment.this.getActivity().getSupportFragmentManager().beginTransaction().remove((Fragment)WarpViewFragment.this).commitAllowingStateLoss();
                    } else if (WarpViewFragment.this.getParentFragment() != null && WarpViewFragment.this.getParentFragment().getChildFragmentManager().findFragmentById(WarpViewFragment.this.getId()) != null) {
                        WarpViewFragment.this.getParentFragment().getChildFragmentManager().beginTransaction().remove((Fragment)WarpViewFragment.this).commitAllowingStateLoss();
                    }
                }
            });
        }
        container.getViewTreeObserver().addOnGlobalLayoutListener(new ViewTreeObserver.OnGlobalLayoutListener(){

            public void onGlobalLayout() {
                if (container.getWidth() > 0 && container.getHeight() > 0) {
                    if (Build.VERSION.SDK_INT >= 16) {
                        container.getViewTreeObserver().removeOnGlobalLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    } else {
                        container.getViewTreeObserver().removeGlobalOnLayoutListener((ViewTreeObserver.OnGlobalLayoutListener)this);
                    }
                    int margin = WarpViewFragment.this.mBtnClose == null ? 0 : container.getWidth() / 8;
                    RelativeLayout.LayoutParams lp = (RelativeLayout.LayoutParams)WarpViewFragment.this.mWarpView.getLayoutParams();
                    lp.setMargins(margin, margin, margin, margin);
                    WarpViewFragment.this.mWarpView.setLayoutParams((ViewGroup.LayoutParams)lp);
                    lp = (RelativeLayout.LayoutParams)ivLogoContainer.getLayoutParams();
                    lp.width = -1;
                    lp.height = -1;
                    lp.setMargins(margin, margin, margin, margin);
                    ivLogoContainer.setLayoutParams((ViewGroup.LayoutParams)lp);
                    if (WarpViewFragment.this.mBtnClose != null) {
                        WarpViewFragment.this.mBtnClose.measure(0, 0);
                        WarpViewFragment.this.mBtnClose.setPadding(0, margin / 2 - WarpViewFragment.this.mBtnClose.getMeasuredHeight() / 2, margin / 2 - WarpViewFragment.this.mBtnClose.getMeasuredWidth() / 2, 0);
                    }
                }
            }
        });
        return root;
    }

    public void onViewCreated(View view, Bundle savedInstanceState) {
        super.onViewCreated(view, savedInstanceState);
        this.updatePage();
    }

    private void updatePage() {
        if (this.mWarpView != null && !TextUtils.isEmpty((CharSequence)this.mSessionUuid)) {
            if (Warply.INSTANCE.getLastReceivedCampaigns() != null && Warply.INSTANCE.getLastReceivedCampaigns().containsUuid(this.mSessionUuid)) {
                new WarplyPreferences((Context)this.getActivity()).clearInboxLastCachedTimeStamps();
            }
            if (this.mWarpView.getVisibility() != 0) {
                this.mWarpView.setVisibility(0);
            }
            this.mWarpView.loadWarpSessionUUID(this.mSessionUuid);
        }
    }
}

