/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.callbacks;

import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.CouponsetsList;
import org.json.JSONArray;
import org.json.JSONObject;

public class CouponsetsHook
implements CallbackReceiver<JSONObject> {
    private final String JSON_KEY_MAPP = "MAPP_COUPON";
    private final String JSON_KEY_CONTEXT = "context";
    private final CallbackReceiver<CouponsetsList> mListener;
    private final String mRequestSignature;

    public CouponsetsHook(CallbackReceiver<CouponsetsList> listener, String requestSignature) {
        this.mListener = listener;
        this.mRequestSignature = requestSignature;
    }

    @Override
    public void onSuccess(JSONObject result) {
        if (this.mListener != null) {
            int status = result.optInt("status", 2);
            if (status == 1) {
                JSONObject couponsetsJSONObject = result.optJSONObject("context");
                if (couponsetsJSONObject != null) {
                    JSONArray jArrayResult = couponsetsJSONObject.optJSONArray("MAPP_COUPON");
                    if (jArrayResult == null) {
                        this.mListener.onFailure(2);
                        return;
                    }
                    this.mListener.onSuccess(new CouponsetsList(couponsetsJSONObject, this.mRequestSignature));
                }
            } else {
                this.mListener.onFailure(status);
            }
        }
    }

    @Override
    public void onFailure(int errorCode) {
        if (this.mListener != null) {
            this.mListener.onFailure(errorCode);
        }
    }
}

