/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.callbacks;

import android.text.TextUtils;
import java.util.ArrayList;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.Campaign;
import ly.warp.sdk.io.models.NewCampaign;
import ly.warp.sdk.io.models.NewCampaignList;
import ly.warp.sdk.utils.WarpJSONParser;
import org.json.JSONObject;

public class NewCampaignsHook
implements CallbackReceiver<JSONObject> {
    private final CallbackReceiver<ArrayList<Campaign>> mListener;
    private final String mRequestSignature;

    public NewCampaignsHook(CallbackReceiver<ArrayList<Campaign>> listener, String requestSignature) {
        this.mListener = listener;
        this.mRequestSignature = requestSignature;
    }

    @Override
    public void onSuccess(JSONObject result) {
        if (this.mListener != null) {
            int status = result.optInt("status", 2);
            if (status == 1) {
                NewCampaignList cmpList = new NewCampaignList(result, this.mRequestSignature);
                ArrayList<Campaign> tempCampaigns = new ArrayList<Campaign>();
                for (NewCampaign newCamp : cmpList) {
                    Campaign camp = new Campaign();
                    camp.setIndexUrl(newCamp.getIndexUrl());
                    camp.setLogoUrl(newCamp.getLogoUrl());
                    camp.setMessage(newCamp.getMessage());
                    camp.setOfferCategory(newCamp.getCommunicationCategory());
                    camp.setSessionUUID(newCamp.getCommunicationUUID());
                    camp.setTitle(newCamp.getTitle());
                    camp.setSubtitle(newCamp.getSubtitle());
                    camp.setSorting(newCamp.getSorting());
                    camp.setNew(newCamp.getIsNew());
                    camp.setType(newCamp.getCampaignType());
                    try {
                        camp.setExtraFields(newCamp.getExtraFields().toString());
                        if (!TextUtils.isEmpty((CharSequence)newCamp.getExtraFields().toString())) {
                            JSONObject extraFieldsResp = WarpJSONParser.getJSONFromString(newCamp.getExtraFields().toString());
                            if (extraFieldsResp != null) {
                                if (extraFieldsResp.has("Banner_title")) {
                                    camp.setBannerTitle(extraFieldsResp.optString("Banner_title", ""));
                                }
                                if (extraFieldsResp.has("Banner_img")) {
                                    camp.setBannerImage(extraFieldsResp.optString("Banner_img", ""));
                                }
                            }
                        } else {
                            camp.setBannerImage("");
                            camp.setBannerTitle("");
                        }
                    }
                    catch (NullPointerException e) {
                        camp.setExtraFields("");
                        camp.setBannerImage("");
                        camp.setBannerTitle("");
                        e.printStackTrace();
                    }
                    try {
                        camp.setCampaignTypeSettings(newCamp.getSettings().toString());
                    }
                    catch (NullPointerException e) {
                        camp.setCampaignTypeSettings("");
                        e.printStackTrace();
                    }
                    tempCampaigns.add(camp);
                }
                this.mListener.onSuccess(tempCampaigns);
            } else {
                this.mListener.onFailure(status);
            }
        }
    }

    @Override
    public void onFailure(int errorCode) {
        if (this.mListener != null) {
            this.mListener.onFailure(errorCode);
        }
    }
}

