/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.callbacks;

import android.content.Context;
import java.util.ArrayList;
import ly.warp.sdk.Warply;
import ly.warp.sdk.db.WarplyDBHelper;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.utils.WarpUtils;
import org.json.JSONObject;

public class PostHook
implements CallbackReceiver<JSONObject> {
    private ArrayList<Long> mIds;
    private ArrayList<Long> mIdsPush;
    private ArrayList<Long> mIdsPushAck;
    private final Context mContext;
    private boolean mIsPushResponse = false;
    private boolean mIsPushAckResponse = false;

    public PostHook(Context context, ArrayList<Long> ids) {
        this.mContext = context;
        this.mIds = ids;
    }

    public PostHook(Context context, ArrayList<Long> ids, boolean isPushResponse) {
        this.mContext = context;
        this.mIdsPush = ids;
        this.mIsPushResponse = isPushResponse;
    }

    public PostHook(Context context, ArrayList<Long> ids, boolean placeholder, boolean isPushAck) {
        this.mContext = context;
        this.mIdsPushAck = ids;
        this.mIsPushAckResponse = isPushAck;
    }

    @Override
    public void onSuccess(JSONObject result) {
        WarpUtils.log("************* WARPLY Database ********************");
        WarpUtils.log("[WARP Trace] Successful Post, emptying database");
        WarpUtils.log("**************************************************");
        if (this.mIsPushResponse || this.mIsPushAckResponse) {
            if (this.mIsPushResponse) {
                WarplyDBHelper.getInstance(this.mContext).deletePushRequests(this.mIdsPush.toArray(new Long[this.mIdsPush.size()]));
                this.mIsPushResponse = false;
                WarpUtils.log("[WARP Trace] Database Push Requests cleared");
                WarpUtils.log("**************************************************");
            }
            if (this.mIsPushAckResponse) {
                WarplyDBHelper.getInstance(this.mContext).deletePushAckRequests(this.mIdsPushAck.toArray(new Long[this.mIdsPushAck.size()]));
                this.mIsPushAckResponse = false;
                WarpUtils.log("[WARP Trace] Database Push Ack Requests cleared");
                WarpUtils.log("**************************************************");
            }
        } else {
            WarplyDBHelper.getInstance(this.mContext).deleteRequests(this.mIds.toArray(new Long[this.mIds.size()]));
        }
        Warply.releasePostLock();
        Warply.tryWakingSendingTask();
    }

    @Override
    public void onFailure(int errorCode) {
        WarpUtils.log("************* WARPLY Database ********************");
        WarpUtils.log("[WARP Trace] Post to context failed with error: " + errorCode);
        WarpUtils.log("**************************************************");
        Warply.releasePostLock();
    }
}

