/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.callbacks;

import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.models.TransactionsList;
import org.json.JSONArray;
import org.json.JSONObject;

public class TransactionsHook
implements CallbackReceiver<JSONObject> {
    private final CallbackReceiver<TransactionsList> mListener;
    private final String mRequestSignature;

    public TransactionsHook(CallbackReceiver<TransactionsList> listener, String requestSignature) {
        this.mListener = listener;
        this.mRequestSignature = requestSignature;
    }

    @Override
    public void onSuccess(JSONObject result) {
        if (this.mListener != null) {
            int status = result.optInt("status", 2);
            if (status == 1) {
                JSONArray jArrayResult = result.optJSONArray("result");
                if (jArrayResult == null) {
                    this.mListener.onFailure(2);
                    return;
                }
                this.mListener.onSuccess(new TransactionsList(result, this.mRequestSignature));
            } else {
                this.mListener.onFailure(status);
            }
        }
    }

    @Override
    public void onFailure(int errorCode) {
        if (this.mListener != null) {
            this.mListener.onFailure(errorCode);
        }
    }
}

