/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.callbacks;

import ly.warp.sdk.Warply;
import ly.warp.sdk.io.callbacks.CallbackReceiver;
import ly.warp.sdk.io.volley.NoConnectionError;
import ly.warp.sdk.io.volley.ParseError;
import ly.warp.sdk.io.volley.Response;
import ly.warp.sdk.io.volley.ServerError;
import ly.warp.sdk.io.volley.TimeoutError;
import ly.warp.sdk.io.volley.VolleyError;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyProperty;
import org.json.JSONObject;

public class VolleyTransformer
implements Response.Listener<JSONObject>,
Response.ErrorListener {
    private static final String WARPLY_STATUS = "status";
    private final CallbackReceiver<JSONObject> mListener;

    public VolleyTransformer(CallbackReceiver<JSONObject> listener) {
        this.mListener = listener;
    }

    @Override
    public void onErrorResponse(VolleyError error) {
        if (this.mListener == null) {
            return;
        }
        int resultCode = -6;
        if (NoConnectionError.class.isInstance(error)) {
            resultCode = -1;
        } else if (ParseError.class.isInstance(error)) {
            resultCode = -2;
        } else if (ServerError.class.isInstance(error)) {
            try {
                resultCode = error.networkResponse.statusCode;
            }
            catch (NullPointerException e) {
                resultCode = -3;
            }
        } else if (TimeoutError.class.isInstance(error)) {
            resultCode = -5;
        } else if (error.networkResponse != null) {
            resultCode = error.networkResponse.statusCode;
        }
        WarpUtils.warn("[WARP Trace] Warply Connection Error: " + resultCode, error);
        this.mListener.onFailure(resultCode);
    }

    @Override
    public void onResponse(JSONObject response) {
        if (response != null && response.optJSONObject("context") != null) {
            if (response.optJSONObject("context").optJSONObject("device_status") != null) {
                WarpUtils.setIsWarped(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("device_status").optBoolean("warped"));
                WarpUtils.setDeviceId(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("device_status").optString("device_id"));
                WarpUtils.setIsDeviceIdSaved(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("device_status").optBoolean("device_id_saved"));
                if (response.optJSONObject("context").optJSONObject("device_status").optJSONObject("application_info") != null) {
                    WarpUtils.setAppDataObject(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("device_status").optJSONObject("application_info"));
                    WarpUtils.setSDKVersion(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("device_status").optJSONObject("application_info").optString("sdk_version"));
                    WarpUtils.setAppVersion(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("device_status").optJSONObject("application_info").optString("app_version"));
                }
                if (response.optJSONObject("context").optJSONObject("device_status").optJSONObject("device_info") != null) {
                    WarpUtils.setDeviceInfoObject(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("device_status").optJSONObject("device_info"));
                    WarpUtils.setOSVersion(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("device_status").optJSONObject("device_info").optString("os_version"));
                    WarpUtils.setDeviceBrand(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("device_status").optJSONObject("device_info").optString("manufacturer"));
                    WarpUtils.setCarrierName(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("device_status").optJSONObject("device_info").optString("carrier_name"));
                }
            }
            if (response.optJSONObject("context").optJSONObject("application_data") != null) {
                WarpUtils.setIsAPPDATAENABLED(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("application_data").optBoolean("APPLICATION_DATA_ENABLED"));
                WarpUtils.setIsDEVICEINFOENABLED(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("application_data").optBoolean("DEVICE_INFO_ENABLED"));
                WarpUtils.setIsLIFECYCLEANALYTICSENABLED(Warply.getWarplyContext(), response.optJSONObject("context").optJSONObject("application_data").optBoolean("LIFECYCLE_ANALYTICS_ENABLED", true));
            }
        }
        if (this.mListener == null) {
            return;
        }
        WarpUtils.log("**************** WARPLY Response *****************");
        WarpUtils.verbose("[WARP Trace] HTTP Web Id: " + WarpUtils.getWebId(Warply.INSTANCE.mContext));
        WarpUtils.verbose("[WARP Trace] HTTP API Key: " + WarplyProperty.getAppUuid(Warply.INSTANCE.mContext));
        if (response != null) {
            JSONObject obj;
            try {
                WarpUtils.log("[WARP Trace] Response: ");
                if (response.toString().length() > 1000) {
                    for (int i = 0; i < response.toString().length(); i += 1000) {
                        if (i + 1000 < response.toString().length()) {
                            WarpUtils.log(response.toString().substring(i, i + 1000));
                            continue;
                        }
                        WarpUtils.log(response.toString().substring(i, response.toString().length()));
                    }
                } else {
                    WarpUtils.log("[WARP Trace] Request: " + response.toString(2));
                }
            }
            catch (Exception e) {
                WarpUtils.warn("[WARP Trace] Failed conversting JSON to string", e);
            }
            WarpUtils.log("*************************************************");
            if (response.has("result") && (obj = response.optJSONObject("result")) != null) {
                if (response.has(WARPLY_STATUS) && response.optInt(WARPLY_STATUS) == 7 && obj.has(WARPLY_STATUS) && obj.optString(WARPLY_STATUS).equals("rejected")) {
                    this.mListener.onSuccess(response);
                    return;
                }
                if (obj.has(WARPLY_STATUS) && obj.optString(WARPLY_STATUS).equals("accepted")) {
                    this.mListener.onSuccess(response);
                    return;
                }
            }
            if (response.has("code")) {
                this.mListener.onSuccess(response);
                return;
            }
            if (response.has("token_type")) {
                this.mListener.onSuccess(response);
                return;
            }
            if (response.has("tokens")) {
                if (response.optInt("result") == 1) {
                    this.mListener.onSuccess(response);
                    return;
                }
                this.mListener.onFailure(response.optInt("result"));
                return;
            }
            int serverResult = response.optInt(WARPLY_STATUS);
            if (serverResult == 2 || serverResult == 3 || serverResult == 4) {
                this.mListener.onSuccess(response);
                return;
            }
            if (serverResult != 1) {
                if (serverResult == 9 && Warply.isInitialized()) {
                    Warply.resetWarplyWebId();
                }
                WarpUtils.log("************* WARPLY Request Error ********************");
                WarpUtils.log("[WARP Trace] Warply Request Error: " + serverResult);
                WarpUtils.log("*******************************************************");
                this.mListener.onFailure(serverResult);
                return;
            }
        }
        this.mListener.onSuccess(response);
    }
}

