/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.altbeacon.beacon.Beacon;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class BeaconMessage {
    private final String KEY_UUID = "uuid";
    private final String KEY_MAJOR = "major";
    private final String KEY_MINOR = "minor";
    private final String KEY_DISTANCE = "distance";
    private final String KEY_ACTION = "action";
    private final String KEY_DATA = "data";
    private final String ACTION_BEACON = "beacon";
    private String uuid;
    private String major;
    private String minor;
    private double distance;

    public BeaconMessage(Beacon beacon) {
        if (beacon != null) {
            this.uuid = beacon.getId1().toUuid().toString();
            this.major = beacon.getId2().toString();
            this.minor = beacon.getId3().toString();
            this.distance = beacon.getDistance();
        }
    }

    public JSONObject toJson() {
        JSONObject json;
        block2: {
            json = new JSONObject();
            try {
                JSONObject beaconMessageJson = new JSONObject();
                beaconMessageJson.putOpt("uuid", (Object)this.uuid);
                beaconMessageJson.putOpt("major", (Object)this.major);
                beaconMessageJson.putOpt("minor", (Object)this.minor);
                beaconMessageJson.putOpt("distance", (Object)this.distance);
                JSONArray dataJsonArray = new JSONArray();
                dataJsonArray.put((Object)beaconMessageJson);
                json.putOpt("data", (Object)dataJsonArray);
                json.putOpt("action", (Object)"beacon");
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return json;
    }

    public String getSignature() {
        String signature = this.uuid + this.major + this.minor;
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

