/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import android.os.Parcel;
import android.os.Parcelable;
import android.text.TextUtils;
import java.io.Serializable;
import java.util.ArrayList;
import ly.warp.sdk.Warply;
import ly.warp.sdk.io.models.CampaignAction;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.WarplyProperty;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class Campaign
implements Parcelable,
Serializable {
    private static final long serialVersionUID = -4754964462459705285L;
    private static final String INDEX_URL = "index_url";
    private static final String LOGO_URL = "logo_url";
    private static final String ACTION = "action";
    private static final String DELIVERED = "delivered";
    private static final String EXPIRES = "expires";
    private static final String MESSAGE = "message";
    private static final String OFFER_CATEGORY = "offer_category";
    private static final String OFFER_MESSAGE = "offer_message";
    private static final String SESSION_UUID = "session_uuid";
    private static final String STARTS = "starts";
    private static final String SUBTITLE = "subtitle";
    private static final String TITLE = "title";
    private static final String SORTING = "sorting";
    private static final String OPENED = "opened";
    private static final String IS_NEW = "is_new";
    private static final String EXTRA_FIELDS = "extra_fields";
    private static final String TYPE = "campaign_type";
    private static final String EXPIRED = "expired";
    private static final String SHOW = "show";
    private static final String DELIVERY_METHOD = "delivery_method";
    private static final String DISPLAY_TYPE = "display_type";
    private static final String ACTIONS = "actions";
    private static final String BUS_ID = "busId";
    private static final String CAMPAIGN_TYPE_SETTINGS = "campaign_type_settings";
    private static final String BANNER_IMAGE = "Banner_img";
    private static final String BANNER_TITLE = "Banner_title";
    private static final String CATEGORY_ID = "category_id";
    private static final String COUPON_AVAILABILITY = "coupon_availability";
    private int action;
    private double delivered;
    private double expires;
    private String message;
    private String offerCategory;
    private String offerMessage;
    private String sessionUUID;
    private double starts;
    private String subtitle;
    private String title;
    private int sorting;
    private int opened;
    private boolean isNew;
    private String logoUrl;
    private String extraFields;
    private String type;
    private boolean expired;
    private boolean show;
    private String deliveryMethod;
    private String displayType;
    private String indexUrl;
    private String busId;
    private ArrayList<CampaignAction> actions = new ArrayList();
    private String campaignTypeSettings;
    private String bannerImage;
    private String bannerTitle;
    private String categoryId;
    private Integer couponAvailability;
    private String endDate;
    private String startDate;
    private boolean showExpiration;
    private String couponImg;
    private String filter = "";
    public static final Parcelable.Creator<Campaign> CREATOR = new Parcelable.Creator<Campaign>(){

        public Campaign createFromParcel(Parcel source) {
            return new Campaign(source);
        }

        public Campaign[] newArray(int size) {
            return new Campaign[size];
        }
    };

    public Campaign(String json) throws JSONException {
        this(new JSONObject(json));
    }

    public Campaign() {
        this.action = 0;
        this.delivered = 0.0;
        this.expires = 0.0;
        this.message = "";
        this.offerCategory = "";
        this.offerMessage = "";
        this.sessionUUID = "";
        this.starts = 0.0;
        this.subtitle = "";
        this.title = "";
        this.sorting = 0;
        this.opened = 0;
        this.isNew = true;
        this.logoUrl = "";
        this.extraFields = "";
        this.type = "";
        this.expired = false;
        this.show = true;
        this.deliveryMethod = "";
        this.displayType = "";
        this.indexUrl = "";
        this.busId = "";
        this.actions = new ArrayList();
        this.campaignTypeSettings = "";
        this.bannerImage = "";
        this.bannerTitle = "";
        this.couponAvailability = null;
        this.categoryId = "";
        this.endDate = "";
        this.startDate = "";
        this.showExpiration = false;
        this.couponImg = "";
    }

    public Campaign(JSONObject json) {
        this.indexUrl = json.optString(INDEX_URL);
        this.logoUrl = json.optString(LOGO_URL);
        this.delivered = json.optDouble(DELIVERED);
        this.sessionUUID = json.optString(SESSION_UUID);
        this.subtitle = json.optString(SUBTITLE);
        this.starts = json.optDouble(STARTS);
        this.message = json.optString(MESSAGE);
        this.opened = json.optInt(OPENED);
        this.expires = json.optDouble(EXPIRES);
        this.offerCategory = json.optString(OFFER_CATEGORY);
        if (this.belongsInCategory("standard-offer-no-date")) {
            this.expires = 0.0;
            this.offerCategory = "standard-offer";
        }
        this.title = json.optString(TITLE);
        this.action = json.optInt(ACTION);
        this.offerMessage = json.optString(OFFER_MESSAGE);
        this.isNew = json.optBoolean(IS_NEW);
        this.sorting = json.optInt(SORTING);
        this.extraFields = json.optString(EXTRA_FIELDS);
        if (!TextUtils.isEmpty((CharSequence)this.extraFields)) {
            JSONObject extraFieldsResp = WarpJSONParser.getJSONFromString(this.extraFields);
            if (extraFieldsResp != null) {
                if (extraFieldsResp.has(BANNER_TITLE)) {
                    this.bannerTitle = extraFieldsResp.optString(BANNER_TITLE, "");
                }
                if (extraFieldsResp.has(BANNER_IMAGE)) {
                    this.bannerImage = extraFieldsResp.optString(BANNER_IMAGE, "");
                }
            }
        } else {
            this.bannerImage = "";
            this.bannerTitle = "";
        }
        this.type = json.optString(TYPE);
        this.expired = json.optBoolean(EXPIRED);
        this.show = json.optBoolean(SHOW);
        this.deliveryMethod = json.optString(DELIVERY_METHOD);
        this.displayType = json.optString(DISPLAY_TYPE);
        this.busId = json.optString(BUS_ID);
        this.campaignTypeSettings = json.optString(CAMPAIGN_TYPE_SETTINGS);
        JSONArray actions = json.optJSONArray(ACTIONS);
        if (actions != null) {
            for (int i = 0; i < actions.length(); ++i) {
                this.actions.add(new CampaignAction(actions.optJSONObject(i)));
            }
        } else {
            this.actions = null;
        }
        this.categoryId = json.optString(CATEGORY_ID);
        this.couponAvailability = json.optInt(COUPON_AVAILABILITY);
    }

    public Campaign(Parcel source) {
        this.indexUrl = source.readString();
        this.action = source.readInt();
        this.delivered = source.readDouble();
        this.expires = source.readDouble();
        this.message = source.readString();
        this.offerCategory = source.readString();
        this.offerMessage = source.readString();
        this.sessionUUID = source.readString();
        this.starts = source.readDouble();
        this.subtitle = source.readString();
        this.title = source.readString();
        this.sorting = source.readInt();
        this.opened = source.readInt();
        this.isNew = source.readInt() > 0;
        this.logoUrl = source.readString();
        this.extraFields = source.readString();
        this.type = source.readString();
        this.expired = source.readInt() > 0;
        this.show = source.readInt() > 0;
        this.deliveryMethod = source.readString();
        this.displayType = source.readString();
        this.actions = source.readArrayList(CampaignAction.class.getClassLoader());
        this.busId = source.readString();
        this.campaignTypeSettings = source.readString();
        this.categoryId = source.readString();
        this.couponAvailability = source.readInt();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.indexUrl);
        dest.writeInt(this.action);
        dest.writeDouble(this.delivered);
        dest.writeDouble(this.expires);
        dest.writeString(this.message);
        dest.writeString(this.offerCategory);
        dest.writeString(this.offerMessage);
        dest.writeString(this.sessionUUID);
        dest.writeDouble(this.starts);
        dest.writeString(this.subtitle);
        dest.writeString(this.title);
        dest.writeInt(this.sorting);
        dest.writeInt(this.opened);
        dest.writeInt(this.isNew ? 1 : 0);
        dest.writeString(this.logoUrl);
        dest.writeString(this.extraFields);
        dest.writeString(this.type);
        dest.writeInt(this.expired ? 1 : 0);
        dest.writeInt(this.show ? 1 : 0);
        dest.writeString(this.deliveryMethod);
        dest.writeString(this.displayType);
        dest.writeList(this.actions);
        dest.writeString(this.busId);
        dest.writeString(this.campaignTypeSettings);
        dest.writeInt(this.couponAvailability.intValue());
        dest.writeString(this.categoryId);
    }

    public JSONObject toJSONObject() {
        JSONObject jObj;
        block2: {
            jObj = new JSONObject();
            try {
                jObj.putOpt(INDEX_URL, (Object)this.indexUrl);
                jObj.putOpt(LOGO_URL, (Object)this.logoUrl);
                jObj.putOpt(ACTION, (Object)this.action);
                jObj.putOpt(DELIVERED, (Object)this.delivered);
                jObj.putOpt(EXPIRES, (Object)this.expires);
                jObj.putOpt(MESSAGE, (Object)this.message);
                jObj.putOpt(OFFER_CATEGORY, (Object)this.offerCategory);
                jObj.putOpt(OFFER_MESSAGE, (Object)this.offerMessage);
                jObj.putOpt(SESSION_UUID, (Object)this.sessionUUID);
                jObj.putOpt(STARTS, (Object)this.starts);
                jObj.putOpt(SUBTITLE, (Object)this.subtitle);
                jObj.putOpt(TITLE, (Object)this.title);
                jObj.putOpt(SORTING, (Object)this.sorting);
                jObj.putOpt(OPENED, (Object)this.opened);
                jObj.putOpt(IS_NEW, (Object)this.isNew);
                jObj.putOpt(SORTING, (Object)this.sorting);
                jObj.putOpt(EXTRA_FIELDS, (Object)this.extraFields);
                jObj.putOpt(TYPE, (Object)this.type);
                jObj.putOpt(EXPIRED, (Object)this.expired);
                jObj.putOpt(SHOW, (Object)this.show);
                jObj.putOpt(DELIVERY_METHOD, (Object)this.deliveryMethod);
                jObj.putOpt(DISPLAY_TYPE, (Object)this.displayType);
                jObj.put(BUS_ID, (Object)this.busId);
                jObj.put(CAMPAIGN_TYPE_SETTINGS, (Object)this.campaignTypeSettings);
                jObj.putOpt(COUPON_AVAILABILITY, (Object)this.couponAvailability);
                jObj.putOpt(CATEGORY_ID, (Object)this.categoryId);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return jObj;
    }

    public boolean belongsInCategory(String category) {
        return this.offerCategory != null && this.offerCategory.equalsIgnoreCase(category);
    }

    public boolean belongsInType(String type) {
        return type != null && type.equalsIgnoreCase(type);
    }

    public boolean belongsInCategory(String category, String delimiter) {
        String[] categories;
        if (this.offerCategory == null) {
            return false;
        }
        for (String c : categories = this.offerCategory.split(delimiter)) {
            if (!c.equalsIgnoreCase(category)) continue;
            return true;
        }
        return false;
    }

    public String toString() {
        if (this.toJSONObject() != null) {
            return this.toJSONObject().toString();
        }
        return null;
    }

    public String toHumanReadableString() {
        String humanReadableString = null;
        try {
            humanReadableString = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            WarpUtils.warn("Failed converting Campaign JSON object to String", (Exception)((Object)e));
        }
        return humanReadableString;
    }

    public String getCategoryId() {
        return this.categoryId;
    }

    public void setCategoryId(String categoryId) {
        this.categoryId = categoryId;
    }

    public Integer getCouponAvailability() {
        return this.couponAvailability;
    }

    public void setCouponAvailability(Integer couponAvailability) {
        this.couponAvailability = couponAvailability;
    }

    public int getAction() {
        return this.action;
    }

    public double getDelivered() {
        return this.delivered;
    }

    public double getExpires() {
        return this.expires;
    }

    public String getMessage() {
        return this.message;
    }

    public String getOfferCategory() {
        return this.offerCategory;
    }

    public String getOfferMessage() {
        return this.offerMessage;
    }

    public String getSessionUUID() {
        return this.sessionUUID;
    }

    public double getStarts() {
        return this.starts;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getTitle() {
        return this.title;
    }

    public int getSorting() {
        return this.sorting;
    }

    public int getOpened() {
        return this.opened;
    }

    public String getImageUrl() {
        return WarplyProperty.getBaseUrl(Warply.getWarplyContext()) + "/api/session/" + "logo/" + this.sessionUUID;
    }

    public boolean getIsNew() {
        return this.isNew;
    }

    public String getLogoUrl() {
        return this.logoUrl;
    }

    public String getIndexUrl() {
        return this.indexUrl;
    }

    public String getExtraFields() {
        return this.extraFields;
    }

    public String getType() {
        return this.type;
    }

    public boolean isExpired() {
        return this.expired;
    }

    public boolean isShow() {
        return this.show;
    }

    public String getDeliveryMethod() {
        return this.deliveryMethod;
    }

    public String getDisplayType() {
        return this.displayType;
    }

    public ArrayList<CampaignAction> getActions() {
        return this.actions;
    }

    public String getBusId() {
        return this.busId;
    }

    public void setBusId(String busId) {
        this.busId = busId;
    }

    public void setNew(boolean aNew) {
        this.isNew = aNew;
    }

    public String getCampaignTypeSettings() {
        return this.campaignTypeSettings;
    }

    public void setExpires(double expires) {
        this.expires = expires;
    }

    public void setOfferCategory(String offerCategory) {
        this.offerCategory = offerCategory;
    }

    public void setShow(boolean show) {
        this.show = show;
    }

    public void setDeliveryMethod(String deliveryMethod) {
        this.deliveryMethod = deliveryMethod;
    }

    public void setDisplayType(String displayType) {
        this.displayType = displayType;
    }

    public void setIndexUrl(String indexUrl) {
        this.indexUrl = indexUrl;
    }

    public void setActions(ArrayList<CampaignAction> actions) {
        this.actions = actions;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public void setDelivered(double delivered) {
        this.delivered = delivered;
    }

    public void setMessage(String message) {
        this.message = message;
    }

    public void setOfferMessage(String offerMessage) {
        this.offerMessage = offerMessage;
    }

    public void setSessionUUID(String sessionUUID) {
        this.sessionUUID = sessionUUID;
    }

    public void setStarts(double starts) {
        this.starts = starts;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSorting(int sorting) {
        this.sorting = sorting;
    }

    public void setOpened(int opened) {
        this.opened = opened;
    }

    public void setLogoUrl(String logoUrl) {
        this.logoUrl = logoUrl;
    }

    public void setExtraFields(String extraFields) {
        this.extraFields = extraFields;
    }

    public void setType(String type) {
        this.type = type;
    }

    public void setExpired(boolean expired) {
        this.expired = expired;
    }

    public void setCampaignTypeSettings(String campaignTypeSettings) {
        this.campaignTypeSettings = campaignTypeSettings;
    }

    public String getBannerImage() {
        return this.bannerImage;
    }

    public String getBannerTitle() {
        return this.bannerTitle;
    }

    public void setBannerImage(String bannerImage) {
        this.bannerImage = bannerImage;
    }

    public void setBannerTitle(String bannerTitle) {
        this.bannerTitle = bannerTitle;
    }

    public String getEndDate() {
        return this.endDate;
    }

    public void setEndDate(String endDate) {
        this.endDate = endDate;
    }

    public String getStartDate() {
        return this.startDate;
    }

    public void setStartDate(String startDate) {
        this.startDate = startDate;
    }

    public boolean isShowExpiration() {
        return this.showExpiration;
    }

    public void setShowExpiration(boolean showExpiration) {
        this.showExpiration = showExpiration;
    }

    public String getCouponImg() {
        return this.couponImg;
    }

    public void setCouponImg(String couponImg) {
        this.couponImg = couponImg;
    }

    public String getFilter() {
        return this.filter;
    }

    public void setFilter(String filter) {
        this.filter = filter;
    }

    public int describeContents() {
        return 0;
    }
}

