/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import android.text.TextUtils;
import androidx.annotation.NonNull;
import java.util.ArrayList;
import ly.warp.sdk.io.models.Campaign;
import org.json.JSONArray;
import org.json.JSONObject;

public class CampaignList
extends ArrayList<Campaign> {
    private static final long serialVersionUID = -188843583823948267L;
    private static final String JSON_KEY_MAPP = "MAPP_OFFER";
    private static final String JSON_KEY_CONTEXT = "context";
    private String mRequestSignature = "";

    private CampaignList(String requestSignature) {
        this.mRequestSignature = requestSignature;
    }

    public CampaignList() {
    }

    public CampaignList(JSONObject campaignListJSONObject, String requestSignature) {
        this(requestSignature);
        campaignListJSONObject = campaignListJSONObject.optJSONObject(JSON_KEY_CONTEXT);
        if (campaignListJSONObject == null) {
            return;
        }
        JSONArray jArray = campaignListJSONObject.optJSONArray(JSON_KEY_MAPP);
        if (jArray != null) {
            int lim = jArray.length();
            for (int i = 0; i < lim; ++i) {
                this.add(new Campaign(jArray.optJSONObject(i)));
            }
        }
    }

    public CampaignList filterCampaignsInCategories(String ... categories) {
        CampaignList filtered = new CampaignList(this.mRequestSignature);
        block0: for (Campaign campaign : this) {
            for (String category : categories) {
                if (!campaign.belongsInCategory(category)) continue;
                filtered.add(campaign);
                continue block0;
            }
        }
        return filtered;
    }

    public CampaignList filterCampaignsOutCategories(String ... categories) {
        CampaignList filtered = new CampaignList(this.mRequestSignature);
        for (Campaign campaign : this) {
            boolean belongToCategory = false;
            for (String category : categories) {
                if (!campaign.belongsInCategory(category)) continue;
                belongToCategory = true;
                break;
            }
            if (belongToCategory) continue;
            filtered.add(campaign);
        }
        return filtered;
    }

    public int getUnreadCampaignsCount() {
        int count = 0;
        for (int i = 0; i < this.size(); ++i) {
            if (((Campaign)this.get(i)).getOpened() != 0) continue;
            ++count;
        }
        return count;
    }

    public boolean containsUuid(String campaignUuid) {
        if (!TextUtils.isEmpty((CharSequence)campaignUuid)) {
            for (int i = 0; i < this.size(); ++i) {
                if (!campaignUuid.equals(((Campaign)this.get(i)).getSessionUUID())) continue;
                return true;
            }
        }
        return false;
    }

    @NonNull
    public String getRequestSignature() {
        return this.mRequestSignature;
    }
}

