/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class Card
implements Parcelable,
Serializable {
    private static final long serialVersionUID = -4754964462459705285L;
    private static final String ACTIVE = "active";
    private static final String CARD_ISSUER = "card_issuer";
    private static final String CARD_NUMBER = "card_number";
    private static final String CARD_HOLDER = "cardholder_name";
    private static final String CARD_EXTRA_FIELDS = "extra_fields";
    private static final String CARD_LAST_USED = "last_used";
    private static final String CARD_TOKEN = "token";
    private boolean active = false;
    private String cardIssuer = "";
    private String cardNumber = "";
    private String cardHolder = "";
    private JSONObject cardExtraFields = new JSONObject();
    private String cardLastUsed = "";
    private String cardToken = "";
    public static final Parcelable.Creator<Card> CREATOR = new Parcelable.Creator<Card>(){

        public Card createFromParcel(Parcel source) {
            return new Card(source);
        }

        public Card[] newArray(int size) {
            return new Card[size];
        }
    };

    public Card(String json) throws JSONException {
        this(new JSONObject(json));
    }

    public Card(JSONObject json) {
        if (json != null) {
            this.active = json.optBoolean(ACTIVE);
            this.cardIssuer = json.optString(CARD_ISSUER);
            this.cardNumber = json.optString(CARD_NUMBER);
            this.cardHolder = json.optString(CARD_HOLDER);
            this.cardExtraFields = json.optJSONObject(CARD_EXTRA_FIELDS);
            this.cardLastUsed = json.optString(CARD_LAST_USED);
            this.cardToken = json.optString(CARD_TOKEN);
        }
    }

    public Card(Parcel source) {
        this.active = source.readByte() != 0;
        this.cardIssuer = source.readString();
        this.cardNumber = source.readString();
        this.cardHolder = source.readString();
        this.cardLastUsed = source.readString();
        this.cardToken = source.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeByte((byte)(this.active ? 1 : 0));
        dest.writeString(this.cardIssuer);
        dest.writeString(this.cardNumber);
        dest.writeString(this.cardHolder);
        dest.writeString(this.cardLastUsed);
        dest.writeString(this.cardToken);
    }

    public JSONObject toJSONObject() {
        JSONObject jObj;
        block2: {
            jObj = new JSONObject();
            try {
                jObj.putOpt(ACTIVE, (Object)this.active);
                jObj.putOpt(CARD_ISSUER, (Object)this.cardIssuer);
                jObj.putOpt(CARD_NUMBER, (Object)this.cardNumber);
                jObj.putOpt(CARD_HOLDER, (Object)this.cardHolder);
                jObj.putOpt(CARD_EXTRA_FIELDS, (Object)this.cardExtraFields);
                jObj.putOpt(CARD_LAST_USED, (Object)this.cardLastUsed);
                jObj.putOpt(CARD_TOKEN, (Object)this.cardToken);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return jObj;
    }

    public String toString() {
        if (this.toJSONObject() != null) {
            return this.toJSONObject().toString();
        }
        return null;
    }

    public String toHumanReadableString() {
        String humanReadableString = null;
        try {
            humanReadableString = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            WarpUtils.warn("Failed converting Card JSON object to String", (Exception)((Object)e));
        }
        return humanReadableString;
    }

    public boolean isActive() {
        return this.active;
    }

    public String getCardIssuer() {
        return this.cardIssuer;
    }

    public String getCardNumber() {
        return this.cardNumber;
    }

    public String getCardHolder() {
        return this.cardHolder;
    }

    public JSONObject getCardExtraFields() {
        return this.cardExtraFields;
    }

    public String getCardLastUsed() {
        return this.cardLastUsed;
    }

    public String getCardToken() {
        return this.cardToken;
    }

    public int describeContents() {
        return 0;
    }
}

