/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Date;
import ly.warp.sdk.io.models.Couponset;
import ly.warp.sdk.io.models.Merchant;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class Coupon
implements Parcelable,
Serializable {
    private static final long serialVersionUID = -4754964462459705285L;
    private static final String BARCODE = "barcode";
    private static final String CATEGORY = "category";
    private static final String COUPON = "coupon";
    private static final String CREATED = "created";
    private static final String DESCRIPTION = "description";
    private static final String DISCOUNT = "discount";
    private static final String EXPIRATION = "expiration";
    private static final String IMAGE = "image";
    private static final String NAME = "name";
    private static final String STATUS = "status";
    private static final String TRANSACTION_DATE = "transaction_date";
    private static final String TRANSACTION_UUID = "transaction_uuid";
    private static final String CHANGES_DATES = "changes_dates";
    private static final String COUPONSET_UUID = "couponset_uuid";
    private static final String MERCHANT_UUID = "merchant_uuid";
    private static final String INNER_TEXT = "inner_text";
    private static final String FINAL_PRICE = "final_price";
    private static final String DISCOUNT_TYPE = "discount_type";
    private static final String SHORT_DESCRIPTION = "short_description";
    private static final String TERMS = "terms";
    private String barcode = "";
    private String category = "";
    private String coupon = "";
    private String created = "";
    private String description = "";
    private String discount = "";
    private String expiration = "";
    private String image = "";
    private String name = "";
    private int status = 0;
    private String transactionDate = "";
    private String transactionUuid = "";
    private JSONObject changesDates = new JSONObject();
    private String couponsetUuid = "";
    private String merchantUuid = "";
    private String innerText = "";
    private Date expirationDate = new Date();
    private Date redeemDate = new Date();
    private String discount_type = "";
    private double final_price = 0.0;
    private String short_description = "";
    private String terms = "";
    private Couponset couponsetDetails = new Couponset(true);
    private Merchant merchantDetails = new Merchant(true);
    public static final Parcelable.Creator<Coupon> CREATOR = new Parcelable.Creator<Coupon>(){

        public Coupon createFromParcel(Parcel source) {
            return new Coupon(source);
        }

        public Coupon[] newArray(int size) {
            return new Coupon[size];
        }
    };

    public Coupon() {
        this.barcode = "";
        this.category = "";
        this.coupon = "";
        this.created = "";
        this.description = "";
        this.discount = "";
        this.expiration = "";
        this.image = "";
        this.name = "";
        this.status = 0;
        this.transactionDate = "";
        this.transactionUuid = "";
        this.changesDates = new JSONObject();
        this.couponsetUuid = "";
        this.merchantUuid = "";
        this.innerText = "";
        this.expirationDate = new Date();
        this.redeemDate = new Date();
        this.discount_type = "";
        this.final_price = 0.0;
        this.short_description = "";
        this.terms = "";
    }

    public Coupon(boolean isUniversal) {
        this.barcode = "";
        this.coupon = "";
        this.discount = "";
        this.expiration = "";
        this.status = 0;
        this.changesDates = new JSONObject();
        this.couponsetUuid = "";
        this.merchantUuid = "";
        this.redeemDate = new Date();
        this.couponsetDetails = new Couponset(isUniversal);
        this.merchantDetails = new Merchant(isUniversal);
    }

    public Coupon(String json) throws JSONException {
        this(new JSONObject(json));
    }

    public Coupon(JSONObject json) {
        if (json != null) {
            this.barcode = json.optString(BARCODE);
            this.category = json.optString(CATEGORY);
            this.coupon = json.optString(COUPON);
            this.created = json.optString(CREATED);
            this.description = json.optString(DESCRIPTION);
            this.discount = json.optString(DISCOUNT);
            if (this.discount.contains(",")) {
                this.discount = this.discount.replace(",", ".");
            }
            this.expiration = json.optString(EXPIRATION);
            this.image = json.optString(IMAGE);
            this.name = json.optString(NAME);
            this.status = json.optInt(STATUS);
            this.transactionDate = json.optString(TRANSACTION_DATE);
            this.transactionUuid = json.optString(TRANSACTION_UUID);
            this.changesDates = json.optJSONObject(CHANGES_DATES);
            if (this.changesDates != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                Date newDate = new Date();
                String tempRedeemDate = this.changesDates.optString("redeemed");
                try {
                    this.redeemDate = newDate = simpleDateFormat.parse(tempRedeemDate);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            this.couponsetUuid = json.optString(COUPONSET_UUID);
            this.merchantUuid = json.optString(MERCHANT_UUID);
            this.innerText = json.optString(INNER_TEXT);
            this.discount_type = json.isNull(DISCOUNT_TYPE) ? "" : json.optString(DISCOUNT_TYPE);
            this.final_price = json.optDouble(FINAL_PRICE);
            this.short_description = json.optString(SHORT_DESCRIPTION);
            this.terms = json.optString(TERMS);
        }
    }

    public Coupon(JSONObject json, boolean isUniversal) {
        if (json != null) {
            JSONObject tempMerchantDetails;
            this.barcode = json.optString(BARCODE);
            this.changesDates = json.optJSONObject(CHANGES_DATES);
            if (this.changesDates != null) {
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy-MM-dd hh:mm");
                Date newDate = new Date();
                String tempRedeemDate = this.changesDates.optString("redeemed");
                try {
                    this.redeemDate = newDate = simpleDateFormat.parse(tempRedeemDate);
                }
                catch (ParseException e) {
                    e.printStackTrace();
                }
            }
            this.coupon = json.optString(COUPON);
            this.couponsetUuid = json.optString(COUPONSET_UUID);
            this.discount = json.optString(DISCOUNT);
            if (this.discount.contains(",")) {
                this.discount = this.discount.replace(",", ".");
            }
            this.expiration = json.optString(EXPIRATION);
            this.merchantUuid = json.optString(MERCHANT_UUID);
            this.status = json.optInt(STATUS);
            JSONObject tempCouponsetDetails = json.optJSONObject("couponset_details");
            if (tempCouponsetDetails != null) {
                this.couponsetDetails = new Couponset(tempCouponsetDetails, isUniversal);
            }
            if ((tempMerchantDetails = json.optJSONObject("merchant_details")) != null) {
                this.merchantDetails = new Merchant(tempMerchantDetails, isUniversal);
            }
        }
    }

    public Coupon(Parcel source) {
        this.barcode = source.readString();
        this.category = source.readString();
        this.coupon = source.readString();
        this.created = source.readString();
        this.description = source.readString();
        this.discount = source.readString();
        this.expiration = source.readString();
        this.image = source.readString();
        this.name = source.readString();
        this.status = source.readInt();
        this.transactionDate = source.readString();
        this.transactionUuid = source.readString();
        this.couponsetUuid = source.readString();
        this.merchantUuid = source.readString();
        this.innerText = source.readString();
        this.discount_type = source.readString();
        this.final_price = source.readDouble();
        this.short_description = source.readString();
        this.terms = source.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.barcode);
        dest.writeString(this.category);
        dest.writeString(this.coupon);
        dest.writeString(this.created);
        dest.writeString(this.description);
        dest.writeString(this.discount);
        dest.writeString(this.expiration);
        dest.writeString(this.image);
        dest.writeString(this.name);
        dest.writeInt(this.status);
        dest.writeString(this.transactionDate);
        dest.writeString(this.transactionUuid);
        dest.writeString(this.couponsetUuid);
        dest.writeString(this.merchantUuid);
        dest.writeString(this.innerText);
        dest.writeString(this.discount_type);
        dest.writeDouble(this.final_price);
        dest.writeString(this.short_description);
        dest.writeString(this.terms);
    }

    public JSONObject toJSONObject() {
        JSONObject jObj;
        block2: {
            jObj = new JSONObject();
            try {
                jObj.putOpt(BARCODE, (Object)this.barcode);
                jObj.putOpt(CATEGORY, (Object)this.category);
                jObj.putOpt(COUPON, (Object)this.coupon);
                jObj.putOpt(CREATED, (Object)this.created);
                jObj.putOpt(DESCRIPTION, (Object)this.description);
                jObj.putOpt(DISCOUNT, (Object)this.discount);
                jObj.putOpt(EXPIRATION, (Object)this.expiration);
                jObj.putOpt(IMAGE, (Object)this.image);
                jObj.putOpt(NAME, (Object)this.name);
                jObj.putOpt(STATUS, (Object)this.status);
                jObj.putOpt(TRANSACTION_DATE, (Object)this.transactionDate);
                jObj.putOpt(TRANSACTION_UUID, (Object)this.transactionUuid);
                jObj.putOpt(CHANGES_DATES, (Object)this.changesDates);
                jObj.putOpt(COUPONSET_UUID, (Object)this.couponsetUuid);
                jObj.putOpt(MERCHANT_UUID, (Object)this.merchantUuid);
                jObj.putOpt(INNER_TEXT, (Object)this.innerText);
                jObj.putOpt(DISCOUNT_TYPE, (Object)this.discount_type);
                jObj.putOpt(FINAL_PRICE, (Object)this.final_price);
                jObj.putOpt(SHORT_DESCRIPTION, (Object)this.short_description);
                jObj.putOpt(TERMS, (Object)this.terms);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return jObj;
    }

    public String toString() {
        if (this.toJSONObject() != null) {
            return this.toJSONObject().toString();
        }
        return null;
    }

    public String toHumanReadableString() {
        String humanReadableString = null;
        try {
            humanReadableString = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            WarpUtils.warn("Failed converting Coupon JSON object to String", (Exception)((Object)e));
        }
        return humanReadableString;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public String getCategory() {
        return this.category;
    }

    public String getCoupon() {
        return this.coupon;
    }

    public String getCreated() {
        return this.created;
    }

    public String getDescription() {
        return this.description;
    }

    public String getDiscount() {
        return this.discount;
    }

    public String getExpiration() {
        return this.expiration;
    }

    public String getImage() {
        return this.image;
    }

    public String getName() {
        return this.name;
    }

    public int getStatus() {
        return this.status;
    }

    public String getTransactionDate() {
        return this.transactionDate;
    }

    public String getTransactionUuid() {
        return this.transactionUuid;
    }

    public JSONObject getChangesDates() {
        return this.changesDates;
    }

    public String getCouponsetUuid() {
        return this.couponsetUuid;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public void setCoupon(String coupon) {
        this.coupon = coupon;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public void setDiscount(String discount) {
        this.discount = discount;
    }

    public void setExpiration(String expiration) {
        this.expiration = expiration;
    }

    public void setImage(String image) {
        this.image = image;
    }

    public void setName(String name) {
        this.name = name;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public void setTransactionDate(String transactionDate) {
        this.transactionDate = transactionDate;
    }

    public void setTransactionUuid(String transactionUuid) {
        this.transactionUuid = transactionUuid;
    }

    public void setChangesDates(JSONObject changesDates) {
        this.changesDates = changesDates;
    }

    public void setCouponsetUuid(String couponsetUuid) {
        this.couponsetUuid = couponsetUuid;
    }

    public String getMerchantUuid() {
        return this.merchantUuid;
    }

    public void setMerchantUuid(String merchantUuid) {
        this.merchantUuid = merchantUuid;
    }

    public String getInnerText() {
        return this.innerText;
    }

    public void setInnerText(String innerText) {
        this.innerText = innerText;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public Date getRedeemDate() {
        return this.redeemDate;
    }

    public void setRedeemDate(Date redeemDate) {
        this.redeemDate = redeemDate;
    }

    public String getDiscount_type() {
        return this.discount_type;
    }

    public void setDiscount_type(String discount_type) {
        this.discount_type = discount_type;
    }

    public double getFinal_price() {
        return this.final_price;
    }

    public void setFinal_price(double final_price) {
        this.final_price = final_price;
    }

    public String getShort_description() {
        return this.short_description;
    }

    public void setShort_description(String short_description) {
        this.short_description = short_description;
    }

    public String getTerms() {
        return this.terms;
    }

    public void setTerms(String terms) {
        this.terms = terms;
    }

    public Couponset getCouponsetDetails() {
        return this.couponsetDetails;
    }

    public void setCouponsetDetails(Couponset couponsetDetails) {
        this.couponsetDetails = couponsetDetails;
    }

    public Merchant getMerchantDetails() {
        return this.merchantDetails;
    }

    public void setMerchantDetails(Merchant merchantDetails) {
        this.merchantDetails = merchantDetails;
    }

    public int describeContents() {
        return 0;
    }
}

