/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import ly.warp.sdk.utils.WarpUtils;
import org.json.JSONException;
import org.json.JSONObject;

public class InboxStats {
    private static final String TOTAL_COUNT = "count";
    private static final String NEW_COUNT = "new";
    private static final String UNREAD_COUNT = "unread";
    private int totalCount;
    private int newCount;
    private int unreadCount;

    public InboxStats(String json) throws JSONException {
        this(new JSONObject(json));
    }

    public InboxStats(JSONObject jObj) {
        JSONObject inboxStatus = null;
        try {
            inboxStatus = jObj.getJSONObject("context").getJSONObject("MAPP_OFFER");
        }
        catch (JSONException e) {
            WarpUtils.warn("Exception on parsing Inbox Status JSON", (Exception)((Object)e));
        }
        this.totalCount = 0;
        this.newCount = 0;
        this.unreadCount = 0;
        if (inboxStatus != null) {
            if (inboxStatus.has(TOTAL_COUNT)) {
                this.totalCount = inboxStatus.optInt(TOTAL_COUNT);
            }
            if (inboxStatus.has(NEW_COUNT)) {
                this.newCount = inboxStatus.optInt(NEW_COUNT);
            }
            if (inboxStatus.has(UNREAD_COUNT)) {
                this.unreadCount = inboxStatus.optInt(UNREAD_COUNT);
            }
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj = new JSONObject();
        try {
            jObj.putOpt(TOTAL_COUNT, (Object)this.totalCount);
            jObj.putOpt(NEW_COUNT, (Object)this.newCount);
            jObj.putOpt(UNREAD_COUNT, (Object)this.unreadCount);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return jObj;
    }

    public String toString() {
        return this.toJSONObject().toString();
    }

    public String toHumanReadableString() {
        String s = null;
        try {
            s = this.toJSONObject().toString(2);
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
        return s;
    }

    public int getTotalCount() {
        return this.totalCount;
    }

    public int getNewCount() {
        return this.newCount;
    }

    public int getUnreadCount() {
        return this.unreadCount;
    }
}

