/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import ly.warp.sdk.io.models.MerchantCategory;
import org.json.JSONArray;
import org.json.JSONObject;

public class MerchantCategoriesList
extends ArrayList<MerchantCategory> {
    private static final long serialVersionUID = -188843583823948267L;
    private static final String JSON_KEY_MAPP = "MAPP_SHOPS";
    private static final String JSON_KEY_CONTEXT = "context";
    private static final String JSON_KEY_RESULT = "result";
    private String mRequestSignature = "";

    private MerchantCategoriesList(String requestSignature) {
        this.mRequestSignature = requestSignature;
    }

    public MerchantCategoriesList() {
    }

    public MerchantCategoriesList(JSONObject merchantCategoriesListJSONObject, String requestSignature) {
        this(requestSignature);
        merchantCategoriesListJSONObject = merchantCategoriesListJSONObject.optJSONObject(JSON_KEY_CONTEXT);
        if (merchantCategoriesListJSONObject == null) {
            return;
        }
        JSONObject merchantCategoriesMapp = merchantCategoriesListJSONObject.optJSONObject(JSON_KEY_MAPP);
        if (merchantCategoriesMapp == null) {
            return;
        }
        JSONArray jArray = merchantCategoriesMapp.optJSONArray(JSON_KEY_RESULT);
        if (jArray != null) {
            int lim = jArray.length();
            for (int i = 0; i < lim; ++i) {
                this.add(new MerchantCategory(jArray.optJSONObject(i)));
            }
        }
    }

    @NonNull
    public String getRequestSignature() {
        return this.mRequestSignature;
    }
}

