/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import ly.warp.sdk.io.models.Merchant;
import org.json.JSONArray;
import org.json.JSONObject;

public class MerchantList
extends ArrayList<Merchant> {
    private static final long serialVersionUID = -188843583823948267L;
    private static final String JSON_KEY_MAPP = "MAPP_SHOPS";
    private static final String JSON_KEY_CONTEXT = "context";
    private static final String JSON_KEY_RESULT = "result";
    private String mRequestSignature = "";

    private MerchantList(String requestSignature) {
        this.mRequestSignature = requestSignature;
    }

    public MerchantList() {
    }

    public MerchantList(JSONObject merchantListJSONObject, String requestSignature) {
        this(requestSignature);
        merchantListJSONObject = merchantListJSONObject.optJSONObject(JSON_KEY_CONTEXT);
        if (merchantListJSONObject == null) {
            return;
        }
        JSONObject merchantListMapp = merchantListJSONObject.optJSONObject(JSON_KEY_MAPP);
        if (merchantListMapp == null) {
            return;
        }
        JSONArray jArray = merchantListMapp.optJSONArray(JSON_KEY_RESULT);
        if (jArray != null) {
            int lim = jArray.length();
            for (int i = 0; i < lim; ++i) {
                this.add(new Merchant(jArray.optJSONObject(i)));
            }
        }
    }

    @NonNull
    public String getRequestSignature() {
        return this.mRequestSignature;
    }
}

