/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import java.util.ArrayList;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class PacingDetails {
    private static final long serialVersionUID = -4754964462459705285L;
    private static final String STEPS = "steps";
    private static final String METERS = "meters";
    private static final String RESULT = "result";
    private static final String ENABLED = "enabled";
    private static final String GOAL_REACHED = "goal_reached";
    private static final String MESSAGE = "msg";
    private static final String TITLE = "title";
    private static final String SHORTCUT_ENABLED = "shortcut_enabled";
    private static final String BUTTON = "button";
    private PacingInner steps = new PacingInner();
    private PacingInner meters = new PacingInner();
    private boolean enabled = false;
    private boolean goal_reached = false;
    private String msg = "";
    private String title = "";
    private boolean shortcut_enabled = false;
    private String buttonText = "";

    public PacingDetails(String json) throws JSONException {
        this(new JSONObject(json));
    }

    public PacingDetails(JSONObject json) {
        if (json != null) {
            JSONObject result = new JSONObject();
            result = json.optJSONObject(RESULT);
            if (result != null) {
                if (result.optJSONObject(STEPS) != null) {
                    this.steps = new PacingInner(result.optJSONObject(STEPS));
                }
                if (result.optJSONObject(METERS) != null) {
                    this.meters = new PacingInner(result.optJSONObject(METERS));
                }
                this.enabled = result.optBoolean(ENABLED);
                this.goal_reached = result.optBoolean(GOAL_REACHED);
                this.msg = result.optString(MESSAGE);
                this.shortcut_enabled = result.optBoolean(SHORTCUT_ENABLED);
                this.title = result.optString(TITLE);
                this.buttonText = result.optString(BUTTON);
            }
        }
    }

    public JSONObject toJSONObject() {
        JSONObject jObj;
        block2: {
            jObj = new JSONObject();
            try {
                jObj.putOpt(STEPS, (Object)this.steps);
                jObj.putOpt(METERS, (Object)this.meters);
                jObj.putOpt(ENABLED, (Object)this.enabled);
                jObj.putOpt(GOAL_REACHED, (Object)this.goal_reached);
                jObj.putOpt(MESSAGE, (Object)this.msg);
                jObj.putOpt(SHORTCUT_ENABLED, (Object)this.shortcut_enabled);
                jObj.putOpt(TITLE, (Object)this.title);
                jObj.putOpt(BUTTON, (Object)this.buttonText);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return jObj;
    }

    public String toString() {
        if (this.toJSONObject() != null) {
            return this.toJSONObject().toString();
        }
        return null;
    }

    public String toHumanReadableString() {
        String humanReadableString = null;
        try {
            humanReadableString = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            WarpUtils.warn("Failed converting Campaign JSON object to String", (Exception)((Object)e));
        }
        return humanReadableString;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public PacingInner getSteps() {
        return this.steps;
    }

    public void setSteps(PacingInner steps) {
        this.steps = steps;
    }

    public PacingInner getMeters() {
        return this.meters;
    }

    public void setMeters(PacingInner meters) {
        this.meters = meters;
    }

    public boolean isGoal_reached() {
        return this.goal_reached;
    }

    public String getMsg() {
        return this.msg;
    }

    public void setGoal_reached(boolean goal_reached) {
        this.goal_reached = goal_reached;
    }

    public void setMsg(String msg) {
        this.msg = msg;
    }

    public boolean isShortcut_enabled() {
        return this.shortcut_enabled;
    }

    public void setShortcut_enabled(boolean shortcut_enabled) {
        this.shortcut_enabled = shortcut_enabled;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getButtonText() {
        return this.buttonText;
    }

    public void setButtonText(String buttonText) {
        this.buttonText = buttonText;
    }

    public class PacingInner {
        private static final String TOTAL = "total";
        private static final String MONTH = "month";
        private static final String WEEK = "week";
        private static final String DAY = "day";
        private PacingDetailsInner total;
        private PacingDetailsInner month;
        private PacingDetailsInner week;
        private PacingDetailsInner day;

        public PacingInner() {
            this.total = new PacingDetailsInner();
            this.month = new PacingDetailsInner();
            this.week = new PacingDetailsInner();
            this.day = new PacingDetailsInner();
            this.total = new PacingDetailsInner();
            this.month = new PacingDetailsInner();
            this.week = new PacingDetailsInner();
            this.day = new PacingDetailsInner();
        }

        public PacingInner(JSONObject json) {
            this.total = new PacingDetailsInner();
            this.month = new PacingDetailsInner();
            this.week = new PacingDetailsInner();
            this.day = new PacingDetailsInner();
            if (json != null) {
                if (json.optJSONObject(TOTAL) != null) {
                    this.total = new PacingDetailsInner(json.optJSONObject(TOTAL));
                }
                if (json.optJSONObject(MONTH) != null) {
                    this.month = new PacingDetailsInner(json.optJSONObject(MONTH));
                }
                if (json.optJSONObject(WEEK) != null) {
                    this.week = new PacingDetailsInner(json.optJSONObject(WEEK));
                }
                if (json.optJSONObject(DAY) != null) {
                    this.day = new PacingDetailsInner(json.optJSONObject(DAY));
                }
            }
        }

        public PacingDetailsInner getTotal() {
            return this.total;
        }

        public void setTotal(PacingDetailsInner total) {
            this.total = total;
        }

        public PacingDetailsInner getMonth() {
            return this.month;
        }

        public void setMonth(PacingDetailsInner month) {
            this.month = month;
        }

        public PacingDetailsInner getWeek() {
            return this.week;
        }

        public void setWeek(PacingDetailsInner week) {
            this.week = week;
        }

        public PacingDetailsInner getDay() {
            return this.day;
        }

        public void setDay(PacingDetailsInner day) {
            this.day = day;
        }
    }

    public class PacingDetailsDay {
        private static final String DAY = "day";
        private static final String VALLUE = "value";
        private String day = "";
        private double value = 0.0;

        public PacingDetailsDay() {
            this.day = "";
            this.value = 0.0;
        }

        public PacingDetailsDay(JSONObject json) {
            if (json != null) {
                this.day = json.optString(DAY);
                this.value = json.optDouble(VALLUE, 0.0);
            }
        }

        public String getDay() {
            return this.day;
        }

        public void setDay(String day) {
            this.day = day;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }
    }

    public class PacingDetailsInner {
        private static final String GOAL = "goal";
        private static final String VALLUE = "value";
        private static final String PER_DAY = "per_day";
        private double goal = 0.0;
        private double value = 0.0;
        private ArrayList<PacingDetailsDay> per_day = new ArrayList();

        public PacingDetailsInner() {
            this.goal = 0.0;
            this.value = 0.0;
            this.per_day = new ArrayList();
        }

        public PacingDetailsInner(JSONObject json) {
            if (json != null) {
                this.goal = json.optDouble(GOAL, 0.0);
                this.value = json.optDouble(VALLUE, 0.0);
                if (json.optJSONArray(PER_DAY) != null) {
                    JSONArray perDay = new JSONArray();
                    perDay = json.optJSONArray(PER_DAY);
                    if (perDay != null) {
                        ArrayList<PacingDetailsDay> list = new ArrayList<PacingDetailsDay>();
                        for (int i = 0; i < perDay.length(); ++i) {
                            JSONObject object = perDay.optJSONObject(i);
                            if (object == null) continue;
                            list.add(new PacingDetailsDay(object));
                        }
                        this.per_day = list;
                    }
                }
            }
        }

        public double getGoal() {
            return this.goal;
        }

        public void setGoal(double goal) {
            this.goal = goal;
        }

        public double getValue() {
            return this.value;
        }

        public void setValue(double value) {
            this.value = value;
        }

        public ArrayList<PacingDetailsDay> getPer_day() {
            return this.per_day;
        }

        public void setPer_day(ArrayList<PacingDetailsDay> per_day) {
            this.per_day = per_day;
        }
    }
}

