/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import androidx.annotation.NonNull;
import java.util.ArrayList;
import ly.warp.sdk.io.models.Product;
import org.json.JSONArray;
import org.json.JSONObject;

public class ProductList
extends ArrayList<Product> {
    private static final long serialVersionUID = -188843583823948267L;
    private static final String JSON_KEY_MAPP = "MAPP_PRODUCTS";
    private static final String JSON_KEY_CONTEXT = "context";
    private static final String JSON_KEY_RESULT = "result";
    private String mRequestSignature = "";

    private ProductList(String requestSignature) {
        this.mRequestSignature = requestSignature;
    }

    public ProductList() {
    }

    public ProductList(JSONObject productListJSONObject, String requestSignature) {
        this(requestSignature);
        productListJSONObject = productListJSONObject.optJSONObject(JSON_KEY_CONTEXT);
        if (productListJSONObject == null) {
            return;
        }
        JSONObject productListMapp = productListJSONObject.optJSONObject(JSON_KEY_MAPP);
        if (productListMapp == null) {
            return;
        }
        JSONArray jArray = productListMapp.optJSONArray(JSON_KEY_RESULT);
        if (jArray != null) {
            int lim = jArray.length();
            for (int i = 0; i < lim; ++i) {
                this.add(new Product(jArray.optJSONObject(i)));
            }
        }
    }

    @NonNull
    public String getRequestSignature() {
        return this.mRequestSignature;
    }
}

