/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import android.content.Context;
import android.net.Uri;
import android.os.Bundle;
import android.text.TextUtils;
import androidx.core.app.NotificationCompat;
import java.util.ArrayList;
import java.util.List;
import ly.warp.sdk.utils.WarpJSONParser;
import ly.warp.sdk.utils.WarpUtils;
import org.json.JSONArray;
import org.json.JSONObject;

public class PushCampaign {
    public static final String NOTIFICATION_STYLE_DEFAULT = "default";
    public static final String NOTIFICATION_STYLE_BIG_PICTURE = "big_picture";
    public static final String NOTIFICATION_STYLE_BIG_TEXT = "big_text";
    public static final String NOTIFICATION_STYLE_INBOX_STYLE = "inbox_style";
    private static final String NOTIFICATION_KEY_TICKER = "alert";
    private static final String NOTIFICATION_KEY_TITLE = "alert";
    private static final String NOTIFICATION_KEY_SUBTITLE = "subtitle";
    private static final String NOTIFICATION_KEY_SESSION_UUID = "session_uuid";
    private static final String NOTIFICATION_KEY_LOYALTY_ACTION = "loyalty-action";
    private static final String NOTIFICATION_KEY_SOUND = "sound";
    private static final String NOTIFICATION_KEY_NOTIFICATION_STYLE = "notification_style";
    private static final String NOTIFICATION_KEY_LARGE_ICON = "large_icon";
    private static final String NOTIFICATION_KEY_SUMMARY_TEXT = "summary_text";
    private static final String NOTIFICATION_KEY_BIG_PICTURE_URL = "big_picture_url";
    private static final String NOTIFICATION_KEY_BIG_TEXT = "big_text";
    private static final String NOTIFICATION_KEY_COLOR = "color";
    private static final String NOTIFICATION_KEY_INBOX_LINES = "inbox_lines";
    private static final String NOTIFICATION_KEY_ACTION = "action";
    private static final String NOTIFICATION_KEY_ACTION_NAME = "action_name";
    private static final String NOTIFICATION_KEY_ACTION_INTENT = "action_intent";
    private int action;
    private String ticker;
    private String title;
    private String subtitle;
    private String sessionUUID;
    private String soundUri;
    private String notificationStyle;
    private String largeIconUrl;
    private String summaryText;
    private String bigPictureUrl;
    private String bigText;
    private String color;
    private List<String> inboxLines = new ArrayList<String>();
    private List<NotificationCompat.Action> actions = new ArrayList<NotificationCompat.Action>();

    public PushCampaign(Bundle data) {
        try {
            this.action = Integer.parseInt(data.getString(NOTIFICATION_KEY_LOYALTY_ACTION));
        }
        catch (NumberFormatException e) {
            this.action = 0;
            WarpUtils.log("Loyalty action is not a number. Reseting to 0", e);
        }
        this.ticker = data.getString("alert");
        this.title = data.getString("alert");
        this.subtitle = data.getString(NOTIFICATION_KEY_SUBTITLE);
        this.sessionUUID = data.getString(NOTIFICATION_KEY_SESSION_UUID);
        this.soundUri = data.getString(NOTIFICATION_KEY_SOUND);
        this.notificationStyle = data.getString(NOTIFICATION_KEY_NOTIFICATION_STYLE, "");
        this.largeIconUrl = data.getString(NOTIFICATION_KEY_LARGE_ICON, "");
        this.summaryText = data.getString(NOTIFICATION_KEY_SUMMARY_TEXT, "");
        this.bigPictureUrl = data.getString(NOTIFICATION_KEY_BIG_PICTURE_URL, "");
        this.bigText = data.getString("big_text", "");
        this.color = data.getString(NOTIFICATION_KEY_COLOR, "");
        try {
            this.inboxLines = WarpJSONParser.parseJsonToList(new JSONArray(data.getString(NOTIFICATION_KEY_INBOX_LINES)), String.class);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        try {
            this.actions = this.jsonArrayToAction(new JSONArray(data.getString(NOTIFICATION_KEY_ACTION)));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public PushCampaign(JSONObject json) {
        if (json != null) {
            this.action = json.optInt(NOTIFICATION_KEY_LOYALTY_ACTION);
            this.ticker = json.optString("alert");
            this.title = json.optString("alert");
            this.subtitle = json.optString(NOTIFICATION_KEY_SUBTITLE);
            this.sessionUUID = json.optString(NOTIFICATION_KEY_SESSION_UUID);
            this.soundUri = json.optString(NOTIFICATION_KEY_SOUND);
            this.notificationStyle = json.optString(NOTIFICATION_KEY_NOTIFICATION_STYLE, "");
            this.largeIconUrl = json.optString(NOTIFICATION_KEY_LARGE_ICON, "");
            this.summaryText = json.optString(NOTIFICATION_KEY_SUMMARY_TEXT, "");
            this.bigPictureUrl = json.optString(NOTIFICATION_KEY_BIG_PICTURE_URL, "");
            this.bigText = json.optString("big_text", "");
            this.color = json.optString(NOTIFICATION_KEY_COLOR, "");
            this.inboxLines = WarpJSONParser.parseJsonToList(json, NOTIFICATION_KEY_INBOX_LINES, String.class);
            this.actions = this.jsonArrayToAction(json.optJSONArray(NOTIFICATION_KEY_ACTION));
        }
    }

    public boolean isFilled() {
        return !TextUtils.isEmpty((CharSequence)this.ticker) && !TextUtils.isEmpty((CharSequence)this.title) && !TextUtils.isEmpty((CharSequence)this.sessionUUID);
    }

    public int getAction() {
        return this.action;
    }

    public String getTicker() {
        return this.ticker;
    }

    public String getTitle() {
        return this.title;
    }

    public String getSubtitle() {
        return this.subtitle;
    }

    public String getContent() {
        return null;
    }

    public String getColor() {
        return this.color;
    }

    public String getImageUrl() {
        return this.getLargeIconUrl();
    }

    public String getSessionUUID() {
        return this.sessionUUID;
    }

    public Uri getSoundUri(Context context) {
        int soundResource;
        if (this.soundUri != null && (soundResource = context.getResources().getIdentifier(this.soundUri, "raw", context.getPackageName())) != 0) {
            return Uri.parse((String)("android.resource://" + context.getPackageName() + "/raw/" + this.soundUri));
        }
        return null;
    }

    public String getNotificationStyle() {
        return this.notificationStyle;
    }

    public String getLargeIconUrl() {
        return this.largeIconUrl;
    }

    public String getSummaryText() {
        return this.summaryText;
    }

    public String getBigPictureUrl() {
        return this.bigPictureUrl;
    }

    public String getBigText() {
        return this.bigText;
    }

    public List<String> getInboxLines() {
        return this.inboxLines;
    }

    public List<NotificationCompat.Action> getActions() {
        return this.actions;
    }

    public boolean hasActions() {
        return this.actions != null && this.actions.size() > 0;
    }

    private List<NotificationCompat.Action> jsonArrayToAction(JSONArray jarr) {
        ArrayList<NotificationCompat.Action> act = new ArrayList<NotificationCompat.Action>();
        if (jarr == null) {
            return act;
        }
        if (jarr.length() == 0) {
            return act;
        }
        for (int i = 0; i < jarr.length(); ++i) {
            JSONObject jsonAction = jarr.optJSONObject(i);
            if (jsonAction == null) continue;
            act.add(new NotificationCompat.Action(0, (CharSequence)jsonAction.optString(NOTIFICATION_KEY_ACTION_NAME), null));
        }
        return act;
    }

    public void setAction(int action) {
        this.action = action;
    }

    public void setTicker(String ticker) {
        this.ticker = ticker;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public void setSubtitle(String subtitle) {
        this.subtitle = subtitle;
    }

    public void setSessionUUID(String sessionUUID) {
        this.sessionUUID = sessionUUID;
    }

    public void setSoundUri(String soundUri) {
        this.soundUri = soundUri;
    }

    public void setNotificationStyle(String notificationStyle) {
        this.notificationStyle = notificationStyle;
    }

    public void setLargeIconUrl(String largeIconUrl) {
        this.largeIconUrl = largeIconUrl;
    }

    public void setSummaryText(String summaryText) {
        this.summaryText = summaryText;
    }

    public void setBigPictureUrl(String bigPictureUrl) {
        this.bigPictureUrl = bigPictureUrl;
    }

    public void setBigText(String bigText) {
        this.bigText = bigText;
    }

    public void setColor(String color2) {
        this.color = color2;
    }

    public void setInboxLines(List<String> inboxLines) {
        this.inboxLines = inboxLines;
    }

    public void setActions(List<NotificationCompat.Action> actions) {
        this.actions = actions;
    }
}

