/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class TripMetrics
implements Parcelable,
Serializable {
    private static final long serialVersionUID = -4754964462459705285L;
    private static final String AVG_SPEED = "average_speed";
    private static final String NUM_OF_TRIPS = "num_of_trips";
    private static final String OVERALL_SCORE = "overall_acceleration_score";
    private static final String OVERALL_FOCUS = "overall_focus_score";
    private static final String READINESS_SCORE = "readiness_score";
    private static final String SMOOTHNESS_SCORE = "smoothness_score";
    private static final String TOTAL_KM = "total_km";
    private double avgSpeed = 0.0;
    private int numOfTrips = 0;
    private double overallScore = 0.0;
    private double overallFocus = 0.0;
    private double readinessScore = 0.0;
    private double smoothnessScore = 0.0;
    private double totalKM = 0.0;
    public static final Parcelable.Creator<TripMetrics> CREATOR = new Parcelable.Creator<TripMetrics>(){

        public TripMetrics createFromParcel(Parcel source) {
            return new TripMetrics(source);
        }

        public TripMetrics[] newArray(int size) {
            return new TripMetrics[size];
        }
    };

    public TripMetrics(String json) throws JSONException {
        this(new JSONObject(json));
    }

    public TripMetrics() {
        this.avgSpeed = 0.0;
        this.numOfTrips = 0;
        this.overallScore = 0.0;
        this.overallFocus = 0.0;
        this.readinessScore = 0.0;
        this.smoothnessScore = 0.0;
        this.totalKM = 0.0;
    }

    public TripMetrics(JSONObject json) {
        if (json != null) {
            this.avgSpeed = json.optDouble(AVG_SPEED);
            this.numOfTrips = json.optInt(NUM_OF_TRIPS);
            this.overallScore = json.optDouble(OVERALL_SCORE);
            this.overallFocus = json.optDouble(OVERALL_FOCUS);
            this.readinessScore = json.optDouble(READINESS_SCORE);
            this.smoothnessScore = json.optDouble(SMOOTHNESS_SCORE);
            this.totalKM = json.optDouble(TOTAL_KM);
        }
    }

    public TripMetrics(Parcel source) {
        this.avgSpeed = source.readDouble();
        this.numOfTrips = source.readInt();
        this.overallScore = source.readDouble();
        this.overallFocus = source.readDouble();
        this.readinessScore = source.readDouble();
        this.smoothnessScore = source.readDouble();
        this.totalKM = source.readDouble();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeDouble(this.avgSpeed);
        dest.writeInt(this.numOfTrips);
        dest.writeDouble(this.overallScore);
        dest.writeDouble(this.overallFocus);
        dest.writeDouble(this.readinessScore);
        dest.writeDouble(this.smoothnessScore);
        dest.writeDouble(this.totalKM);
    }

    public JSONObject toJSONObject() {
        JSONObject jObj;
        block2: {
            jObj = new JSONObject();
            try {
                jObj.putOpt(AVG_SPEED, (Object)this.avgSpeed);
                jObj.putOpt(NUM_OF_TRIPS, (Object)this.numOfTrips);
                jObj.putOpt(OVERALL_SCORE, (Object)this.overallScore);
                jObj.putOpt(OVERALL_FOCUS, (Object)this.overallFocus);
                jObj.putOpt(READINESS_SCORE, (Object)this.readinessScore);
                jObj.putOpt(SMOOTHNESS_SCORE, (Object)this.smoothnessScore);
                jObj.putOpt(TOTAL_KM, (Object)this.totalKM);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return jObj;
    }

    public String toString() {
        if (this.toJSONObject() != null) {
            return this.toJSONObject().toString();
        }
        return null;
    }

    public String toHumanReadableString() {
        String humanReadableString = null;
        try {
            humanReadableString = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            WarpUtils.warn("Failed converting Coupon JSON object to String", (Exception)((Object)e));
        }
        return humanReadableString;
    }

    public double getAvgSpeed() {
        return this.avgSpeed;
    }

    public void setAvgSpeed(double avgSpeed) {
        this.avgSpeed = avgSpeed;
    }

    public int getNumOfTrips() {
        return this.numOfTrips;
    }

    public void setNumOfTrips(int numOfTrips) {
        this.numOfTrips = numOfTrips;
    }

    public double getOverallScore() {
        return this.overallScore;
    }

    public void setOverallScore(double overallScore) {
        this.overallScore = overallScore;
    }

    public double getOverallFocus() {
        return this.overallFocus;
    }

    public void setOverallFocus(double overallFocus) {
        this.overallFocus = overallFocus;
    }

    public double getReadinessScore() {
        return this.readinessScore;
    }

    public void setReadinessScore(double readinessScore) {
        this.readinessScore = readinessScore;
    }

    public double getSmoothnessScore() {
        return this.smoothnessScore;
    }

    public void setSmoothnessScore(double smoothnessScore) {
        this.smoothnessScore = smoothnessScore;
    }

    public double getTotalKM() {
        return this.totalKM;
    }

    public void setTotalKM(double totalKM) {
        this.totalKM = totalKM;
    }

    public int describeContents() {
        return 0;
    }
}

