/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import java.io.Serializable;
import java.util.ArrayList;
import org.json.JSONArray;
import org.json.JSONObject;

public class UnifiedCampaignModel
implements Serializable {
    private String id;
    private String title;
    private String shortDescription;
    private String longDescription;
    private String logoImagePath;
    private String bigLogoImagePath;
    private String dayText;
    private String imagePath;
    private String bigImagePath;
    private String markerImagePath;
    private String details;
    private String couponsetUuid;
    private String storeId;
    private int position;
    private int affiliatedId;
    private ArrayList<String> days;
    private boolean isHot;
    private ArrayList<UnifiedCampaignLocation> locations;

    public UnifiedCampaignModel() {
        this.id = "";
        this.title = "";
        this.affiliatedId = 0;
        this.shortDescription = "";
        this.longDescription = "";
        this.logoImagePath = "";
        this.bigLogoImagePath = "";
        this.dayText = "";
        this.imagePath = "";
        this.bigImagePath = "";
        this.markerImagePath = "";
        this.details = "";
        this.position = 0;
        this.days = new ArrayList();
        this.isHot = false;
        this.locations = new ArrayList();
        this.couponsetUuid = "";
        this.storeId = "";
    }

    public UnifiedCampaignModel(JSONObject jobj) {
        if (jobj != null) {
            this.couponsetUuid = jobj.optString("COUPONSET_UUID");
            this.id = jobj.optString("id", "");
            this.title = jobj.optString("title");
            this.affiliatedId = jobj.optInt("affiliatedId", 0);
            this.shortDescription = jobj.optString("shortDescription");
            this.longDescription = jobj.optString("longDescription");
            this.logoImagePath = jobj.optString("logoImagePath");
            this.bigLogoImagePath = jobj.optString("bigLogoImagePath");
            this.dayText = jobj.optString("dayText");
            this.imagePath = jobj.optString("imagePath");
            this.bigImagePath = jobj.optString("bigImagePath");
            this.markerImagePath = jobj.optString("markerImagePath");
            this.details = jobj.optString("details");
            this.position = jobj.optInt("position");
            this.days = new ArrayList();
            JSONArray tempDays = new JSONArray();
            tempDays = jobj.optJSONArray("days");
            if (tempDays != null && tempDays.length() > 0) {
                ArrayList<String> daysList = new ArrayList<String>();
                for (int i = 0; i < tempDays.length(); ++i) {
                    daysList.add(tempDays.optString(i));
                }
                this.days.addAll(daysList);
            }
            this.isHot = jobj.optBoolean("isHot", false);
            this.locations = new ArrayList();
            JSONArray tempLocations = new JSONArray();
            tempLocations = jobj.optJSONArray("locations");
            if (tempLocations != null && tempLocations.length() > 0) {
                ArrayList<UnifiedCampaignLocation> locationsList = new ArrayList<UnifiedCampaignLocation>();
                for (int i = 0; i < tempLocations.length(); ++i) {
                    locationsList.add(new UnifiedCampaignLocation(tempLocations.optJSONObject(i)));
                }
                this.locations.addAll(locationsList);
            }
            this.storeId = jobj.optString("store_id");
        }
    }

    public String getId() {
        return this.id;
    }

    public void setId(String id2) {
        this.id = id2;
    }

    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public int getAffiliatedId() {
        return this.affiliatedId;
    }

    public void setAffiliatedId(int affiliatedId) {
        this.affiliatedId = affiliatedId;
    }

    public String getShortDescription() {
        return this.shortDescription;
    }

    public void setShortDescription(String shortDescription) {
        this.shortDescription = shortDescription;
    }

    public String getLongDescription() {
        return this.longDescription;
    }

    public void setLongDescription(String longDescription) {
        this.longDescription = longDescription;
    }

    public String getLogoImagePath() {
        return this.logoImagePath;
    }

    public void setLogoImagePath(String logoImagePath) {
        this.logoImagePath = logoImagePath;
    }

    public String getBigLogoImagePath() {
        return this.bigLogoImagePath;
    }

    public void setBigLogoImagePath(String bigLogoImagePath) {
        this.bigLogoImagePath = bigLogoImagePath;
    }

    public String getDayText() {
        return this.dayText;
    }

    public void setDayText(String dayText) {
        this.dayText = dayText;
    }

    public String getImagePath() {
        return this.imagePath;
    }

    public void setImagePath(String imagePath) {
        this.imagePath = imagePath;
    }

    public String getBigImagePath() {
        return this.bigImagePath;
    }

    public void setBigImagePath(String bigImagePath) {
        this.bigImagePath = bigImagePath;
    }

    public String getMarkerImagePath() {
        return this.markerImagePath;
    }

    public void setMarkerImagePath(String markerImagePath) {
        this.markerImagePath = markerImagePath;
    }

    public String getDetails() {
        return this.details;
    }

    public void setDetails(String details) {
        this.details = details;
    }

    public int getPosition() {
        return this.position;
    }

    public void setPosition(int position) {
        this.position = position;
    }

    public ArrayList<String> getDays() {
        return this.days;
    }

    public void setDays(ArrayList<String> days) {
        this.days = days;
    }

    public boolean isHot() {
        return this.isHot;
    }

    public void setHot(boolean hot) {
        this.isHot = hot;
    }

    public ArrayList<UnifiedCampaignLocation> getLocations() {
        return this.locations;
    }

    public void setLocations(ArrayList<UnifiedCampaignLocation> locations) {
        this.locations = locations;
    }

    public String getCouponsetUuid() {
        return this.couponsetUuid;
    }

    public void setCouponsetUuid(String couponsetUuid) {
        this.couponsetUuid = couponsetUuid;
    }

    public String getStoreId() {
        return this.storeId;
    }

    public void setStoreId(String storeId) {
        this.storeId = storeId;
    }

    public class UnifiedCampaignLocation {
        private String id;
        private String title;
        private String address;
        private String municipality;
        private String telephone;
        private String url;
        private String logoImage;
        private String pinLogoImage;
        private int roadNumber;
        private int afiliateId;
        private double latitude = 0.0;
        private double longitude = 0.0;

        public UnifiedCampaignLocation() {
            this.id = "";
            this.title = "";
            this.address = "";
            this.municipality = "";
            this.telephone = "";
            this.afiliateId = 0;
            this.url = "";
            this.logoImage = "";
            this.pinLogoImage = "";
            this.roadNumber = 0;
            this.latitude = 0.0;
            this.longitude = 0.0;
        }

        public UnifiedCampaignLocation(JSONObject jobj) {
            if (jobj != null) {
                this.id = jobj.optString("id", "");
                this.title = jobj.optString("title");
                this.address = jobj.optString("address");
                this.municipality = jobj.optString("municipality");
                this.telephone = jobj.optString("telephone");
                this.afiliateId = jobj.optInt("afiliateId");
                this.url = jobj.optString("url");
                this.logoImage = jobj.optString("logoImage");
                this.pinLogoImage = jobj.optString("pinLogoImage");
                this.roadNumber = jobj.optInt("roadNumber");
                this.latitude = jobj.optDouble("latitude", 0.0);
                this.longitude = jobj.optDouble("longitude", 0.0);
            }
        }

        public String getId() {
            return this.id;
        }

        public void setId(String id2) {
            this.id = id2;
        }

        public String getTitle() {
            return this.title;
        }

        public void setTitle(String title) {
            this.title = title;
        }

        public String getAddress() {
            return this.address;
        }

        public void setAddress(String address) {
            this.address = address;
        }

        public String getMunicipality() {
            return this.municipality;
        }

        public void setMunicipality(String municipality) {
            this.municipality = municipality;
        }

        public String getTelephone() {
            return this.telephone;
        }

        public void setTelephone(String telephone) {
            this.telephone = telephone;
        }

        public int getAfiliateId() {
            return this.afiliateId;
        }

        public void setAfiliateId(int afiliateId) {
            this.afiliateId = afiliateId;
        }

        public String getUrl() {
            return this.url;
        }

        public void setUrl(String url) {
            this.url = url;
        }

        public String getLogoImage() {
            return this.logoImage;
        }

        public void setLogoImage(String logoImage) {
            this.logoImage = logoImage;
        }

        public String getPinLogoImage() {
            return this.pinLogoImage;
        }

        public void setPinLogoImage(String pinLogoImage) {
            this.pinLogoImage = pinLogoImage;
        }

        public int getRoadNumber() {
            return this.roadNumber;
        }

        public void setRoadNumber(int roadNumber) {
            this.roadNumber = roadNumber;
        }

        public double getLatitude() {
            return this.latitude;
        }

        public void setLatitude(double latitude) {
            this.latitude = latitude;
        }

        public double getLongitude() {
            return this.longitude;
        }

        public void setLongitude(double longitude) {
            this.longitude = longitude;
        }
    }
}

