/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import android.os.Parcel;
import android.os.Parcelable;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Date;
import ly.warp.sdk.io.models.Coupon;
import ly.warp.sdk.utils.WarpUtils;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONArray;
import org.json.JSONException;
import org.json.JSONObject;

public class UnifiedCoupon
implements Parcelable,
Serializable {
    private static final long serialVersionUID = -4754964462459705285L;
    private static final String BARCODE = "barcode";
    private static final String CODE = "code";
    private static final String CREATED = "created";
    private static final String COUPONS = "coupons";
    private static final String STATUS = "status";
    private static final String DESCRIPTION = "description";
    private String barcode = "";
    private String description = "";
    private String status = "";
    private int code = 0;
    private String created = "";
    private ArrayList<Coupon> coupons = new ArrayList();
    private Date expirationDate = new Date();
    public static final Parcelable.Creator<UnifiedCoupon> CREATOR = new Parcelable.Creator<UnifiedCoupon>(){

        public UnifiedCoupon createFromParcel(Parcel source) {
            return new UnifiedCoupon(source);
        }

        public UnifiedCoupon[] newArray(int size) {
            return new UnifiedCoupon[size];
        }
    };

    public UnifiedCoupon() {
        this.barcode = "";
        this.description = "";
        this.status = "";
        this.code = 0;
        this.created = "";
        this.coupons = new ArrayList();
        this.expirationDate = new Date();
    }

    public UnifiedCoupon(String json) throws JSONException {
        this(new JSONObject(json));
    }

    public UnifiedCoupon(JSONObject json) {
        if (json != null) {
            this.barcode = json.optString(BARCODE);
            this.description = json.optString(DESCRIPTION);
            this.status = json.optString(STATUS);
            this.code = json.optInt(CODE);
            this.created = json.optString(CREATED);
            JSONArray jArray = null;
            jArray = json.optJSONArray(COUPONS);
            if (jArray != null && jArray.length() > 0) {
                for (int i = 0; i < jArray.length(); ++i) {
                    JSONObject jObj = jArray.optJSONObject(i);
                    this.coupons.add(new Coupon(jObj));
                }
            }
        }
    }

    public UnifiedCoupon(Parcel source) {
        this.barcode = source.readString();
        this.description = source.readString();
        this.status = source.readString();
        this.code = source.readInt();
        this.created = source.readString();
    }

    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(this.barcode);
        dest.writeString(this.description);
        dest.writeString(this.status);
        dest.writeInt(this.code);
        dest.writeString(this.created);
    }

    public JSONObject toJSONObject() {
        JSONObject jObj;
        block2: {
            jObj = new JSONObject();
            try {
                jObj.putOpt(BARCODE, (Object)this.barcode);
                jObj.putOpt(DESCRIPTION, (Object)this.description);
                jObj.putOpt(STATUS, (Object)this.status);
                jObj.putOpt(CODE, (Object)this.code);
                jObj.putOpt(CREATED, (Object)this.created);
                jObj.putOpt(COUPONS, this.coupons);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return jObj;
    }

    public String toString() {
        if (this.toJSONObject() != null) {
            return this.toJSONObject().toString();
        }
        return null;
    }

    public String toHumanReadableString() {
        String humanReadableString = null;
        try {
            humanReadableString = this.toJSONObject().toString(2);
        }
        catch (JSONException e) {
            WarpUtils.warn("Failed converting Unified Coupon JSON object to String", (Exception)((Object)e));
        }
        return humanReadableString;
    }

    public String getBarcode() {
        return this.barcode;
    }

    public void setBarcode(String barcode) {
        this.barcode = barcode;
    }

    public int getCode() {
        return this.code;
    }

    public void setCode(int code) {
        this.code = code;
    }

    public String getCreated() {
        return this.created;
    }

    public void setCreated(String created) {
        this.created = created;
    }

    public ArrayList<Coupon> getCoupons() {
        return this.coupons;
    }

    public void setCoupons(ArrayList<Coupon> coupons) {
        this.coupons = coupons;
    }

    public String getStatus() {
        return this.status;
    }

    public void setStatus(String status) {
        this.status = status;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public Date getExpirationDate() {
        return this.expirationDate;
    }

    public void setExpirationDate(Date expirationDate) {
        this.expirationDate = expirationDate;
    }

    public int describeContents() {
        return 0;
    }
}

