/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.models;

import org.json.JSONObject;

public class WarpGeoFence {
    private static final String KEY_ID = "id";
    private static final String KEY_LAT = "lat";
    private static final String KEY_LONG = "long";
    private static final String KEY_RADIUS = "radius";
    private double lat;
    private double lon;
    private double radius;
    private int id;

    public WarpGeoFence(JSONObject json) {
        if (json != null) {
            this.lat = json.optDouble(KEY_LAT);
            this.lon = json.optDouble(KEY_LONG);
            this.radius = json.optDouble(KEY_RADIUS);
            this.id = json.optInt(KEY_ID);
        }
    }

    public boolean isInsideFence(double lat, double lon) {
        return WarpGeoFence.distance(this.getLat(), lat, this.getLon(), lon, 0.0, 0.0) <= this.getRadius();
    }

    public double getLat() {
        return this.lat;
    }

    public double getLon() {
        return this.lon;
    }

    public double getRadius() {
        return this.radius;
    }

    public int getId() {
        return this.id;
    }

    public static double distance(double lat1, double lat2, double lon1, double lon2, double el1, double el2) {
        int R2 = 6371;
        Double latDistance = Math.toRadians(lat2 - lat1);
        Double lonDistance = Math.toRadians(lon2 - lon1);
        Double a = Math.sin(latDistance / 2.0) * Math.sin(latDistance / 2.0) + Math.cos(Math.toRadians(lat1)) * Math.cos(Math.toRadians(lat2)) * Math.sin(lonDistance / 2.0) * Math.sin(lonDistance / 2.0);
        Double c = 2.0 * Math.atan2(Math.sqrt(a), Math.sqrt(1.0 - a));
        double distance = 6371.0 * c * 1000.0;
        double height = el1 - el2;
        distance = Math.pow(distance, 2.0) + Math.pow(height, 2.0);
        return Math.sqrt(distance);
    }
}

