/*
 * Decompiled with CFR 0.152.
 */
package ly.warp.sdk.io.request;

import android.util.Base64;
import java.io.UnsupportedEncodingException;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.HashMap;
import ly.warp.sdk.utils.constants.WarpConstants;
import org.json.JSONException;
import org.json.JSONObject;

public class CosmoteCouponSharingRequest {
    private final String KEY_MAPP = "coupon";
    private final String KEY_ACTION = "action";
    private final String KEY_ACTION_VALUE = "share";
    private final String KEY_COUPON = "coupon";
    private final String KEY_SENDER = "sender_msisdn";
    private final String KEY_RECEIVER = "receiver_msisdn";
    private HashMap<String, String> mFilters;
    private long mCacheUpdateInterval = 0L;
    private String mCoupon = "";
    private String mSender = "";
    private String mReceiver = "";

    public CosmoteCouponSharingRequest() {
        this.mFilters = new HashMap();
    }

    public CosmoteCouponSharingRequest(CosmoteCouponSharingRequest copy) {
        if (copy != null) {
            this.mFilters = copy.mFilters;
            this.mCacheUpdateInterval = copy.mCacheUpdateInterval;
        }
    }

    public boolean equals(Object object) {
        if (object instanceof CosmoteCouponSharingRequest) {
            CosmoteCouponSharingRequest other = (CosmoteCouponSharingRequest)object;
            return other == this || this.mFilters == other.mFilters || this.mFilters != null && this.mFilters.equals(other.mFilters);
        }
        return false;
    }

    public int hashCode() {
        return this.mFilters.hashCode();
    }

    public CosmoteCouponSharingRequest setCoupon(String coupon) {
        this.mCoupon = coupon;
        return this;
    }

    public CosmoteCouponSharingRequest setSender(String sender) {
        this.mSender = sender;
        return this;
    }

    public CosmoteCouponSharingRequest setReceiver(String receiver) {
        this.mReceiver = receiver;
        return this;
    }

    public long getCacheUpdateInterval() {
        return this.mCacheUpdateInterval;
    }

    public CosmoteCouponSharingRequest setCacheUpdateInterval(long updateInterval) {
        this.mCacheUpdateInterval = updateInterval;
        if (this.mCacheUpdateInterval < 0L) {
            this.mCacheUpdateInterval = 0L;
        }
        return this;
    }

    public boolean isUseCache() {
        return this.mCacheUpdateInterval > 0L;
    }

    public CosmoteCouponSharingRequest setUseCache(boolean useCache) {
        this.mCacheUpdateInterval = useCache ? (this.mCacheUpdateInterval > 0L ? this.mCacheUpdateInterval : 600000L) : 0L;
        return this;
    }

    public JSONObject toJson() {
        JSONObject bodyJsonObject;
        block2: {
            bodyJsonObject = new JSONObject();
            try {
                JSONObject extraJson = new JSONObject();
                extraJson.putOpt("action", (Object)"share");
                extraJson.putOpt("coupon", (Object)this.mCoupon);
                extraJson.putOpt("sender_msisdn", (Object)this.mSender);
                extraJson.putOpt("receiver_msisdn", (Object)this.mReceiver);
                bodyJsonObject.putOpt("coupon", (Object)extraJson);
            }
            catch (JSONException e) {
                if (!WarpConstants.DEBUG) break block2;
                e.printStackTrace();
            }
        }
        return bodyJsonObject;
    }

    public String getSignature() {
        String signature = this.mFilters != null && this.mFilters.size() > 0 ? String.valueOf(this.mFilters.hashCode()) : "default_cosmote_coupon_sharing_request";
        try {
            byte[] hash = MessageDigest.getInstance("SHA-256").digest(signature.getBytes("UTF-8"));
            signature = Base64.encodeToString((byte[])hash, (int)2);
        }
        catch (UnsupportedEncodingException | NullPointerException | NoSuchAlgorithmException e) {
            e.printStackTrace();
        }
        return signature;
    }
}

